/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.messages.PingReply;
import com.limegroup.gnutella.util.BucketQueue;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public final class PongCacher {
    private static final PongCacher INSTANCE = new PongCacher();
    public static final int NUM_PONGS_PER_HOP = 1;
    public static final int NUM_HOPS = 6;
    private static final BucketQueue PONGS = new BucketQueue(6, 1);
    private static long _lastPongAddTime = 0L;

    public static PongCacher instance() {
        return INSTANCE;
    }

    private PongCacher() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getBestPongs() {
        BucketQueue bucketQueue = PONGS;
        synchronized (bucketQueue) {
            Iterator iter = PONGS.iterator();
            LinkedList<PingReply> pongs = new LinkedList<PingReply>();
            for (int i = 0; iter.hasNext() && i < 6; ++i) {
                pongs.add((PingReply)iter.next());
            }
            return pongs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPong(PingReply pr) {
        if (!RouterService.isSupernode()) {
            return;
        }
        if (pr.getHops() >= 6) {
            return;
        }
        BucketQueue bucketQueue = PONGS;
        synchronized (bucketQueue) {
            PONGS.insert(pr, pr.getHops());
            _lastPongAddTime = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean needsPongs() {
        if (!RouterService.isSupernode()) {
            return false;
        }
        if (System.currentTimeMillis() - _lastPongAddTime > 1000L) {
            return true;
        }
        BucketQueue bucketQueue = PONGS;
        synchronized (bucketQueue) {
            return PONGS.size() < 6;
        }
    }
}

