/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.Connection;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.ForMeReplyHandler;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.ManagedConnection;
import com.limegroup.gnutella.MulticastService;
import com.limegroup.gnutella.PongCacher;
import com.limegroup.gnutella.QueryUnicaster;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.RouteTable;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.UDPReplyHandler;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.UploadManager;
import com.limegroup.gnutella.guess.GUESSEndpoint;
import com.limegroup.gnutella.guess.QueryKey;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.PingReply;
import com.limegroup.gnutella.messages.PingRequest;
import com.limegroup.gnutella.messages.PushRequest;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.messages.vendor.HopsFlowVendorMessage;
import com.limegroup.gnutella.messages.vendor.LimeACKVendorMessage;
import com.limegroup.gnutella.messages.vendor.MessagesSupportedVendorMessage;
import com.limegroup.gnutella.messages.vendor.PushProxyAcknowledgement;
import com.limegroup.gnutella.messages.vendor.PushProxyRequest;
import com.limegroup.gnutella.messages.vendor.QueryStatusResponse;
import com.limegroup.gnutella.messages.vendor.TCPConnectBackVendorMessage;
import com.limegroup.gnutella.messages.vendor.UDPConnectBackVendorMessage;
import com.limegroup.gnutella.messages.vendor.VendorMessage;
import com.limegroup.gnutella.routing.PatchTableMessage;
import com.limegroup.gnutella.routing.QueryRouteTable;
import com.limegroup.gnutella.routing.ResetTableMessage;
import com.limegroup.gnutella.routing.RouteTableMessage;
import com.limegroup.gnutella.search.QueryDispatcher;
import com.limegroup.gnutella.search.QueryHandler;
import com.limegroup.gnutella.search.ResultCounter;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.statistics.ReceivedMessageStatHandler;
import com.limegroup.gnutella.statistics.RouteErrorStat;
import com.limegroup.gnutella.statistics.RoutedQueryStat;
import com.limegroup.gnutella.statistics.SentMessageStatHandler;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.util.Utilities;
import java.io.IOException;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class MessageRouter {
    protected static ConnectionManager _manager;
    private static final int OLD_CONNECTIONS_TO_USE = 15;
    protected byte[] _clientGUID;
    private final ReplyHandler FOR_ME_REPLY_HANDLER = ForMeReplyHandler.instance();
    private int MAX_ROUTE_TABLE_SIZE = 50000;
    private RouteTable _pingRouteTable = new RouteTable(120, this.MAX_ROUTE_TABLE_SIZE);
    private RouteTable _queryRouteTable = new RouteTable(300, this.MAX_ROUTE_TABLE_SIZE);
    private RouteTable _pushRouteTable = new RouteTable(420, this.MAX_ROUTE_TABLE_SIZE);
    private static final long CLEAR_TIME = 30000L;
    static int MAX_BUFFERED_REPLIES;
    private final Map _outOfBandReplies = new Hashtable();
    protected final QueryUnicaster UNICASTER = QueryUnicaster.instance();
    private final QueryDispatcher DYNAMIC_QUERIER = QueryDispatcher.instance();
    private ActivityCallback _callback;
    private static FileManager _fileManager;
    private static final boolean RECORD_STATS;
    private final QRPPropagator QRP_PROPAGATOR = new QRPPropagator();
    private QueryRouteTable _lastQueryRouteTable;
    private static final int HIGH_HOPS_RESPONSE_LIMIT = 10;

    protected MessageRouter() {
        try {
            this._clientGUID = new GUID(GUID.fromHexString(ApplicationSettings.CLIENT_ID.getValue())).bytes();
        }
        catch (IllegalArgumentException e) {
            this._clientGUID = Message.makeGuid();
        }
    }

    public void initialize() {
        _manager = RouterService.getConnectionManager();
        this._callback = RouterService.getCallback();
        _fileManager = RouterService.getFileManager();
        this.DYNAMIC_QUERIER.start();
        this.QRP_PROPAGATOR.start();
        RouterService.schedule(new Expirer(), 30000L, 30000L);
    }

    public String getPingRouteTableDump() {
        return this._pingRouteTable.toString();
    }

    public String getQueryRouteTableDump() {
        return this._queryRouteTable.toString();
    }

    public String getPushRouteTableDump() {
        return this._pushRouteTable.toString();
    }

    public void removeConnection(ReplyHandler rh) {
        this.DYNAMIC_QUERIER.removeReplyHandler(rh);
        this._pingRouteTable.removeReplyHandler(rh);
        this._queryRouteTable.removeReplyHandler(rh);
        this._pushRouteTable.removeReplyHandler(rh);
    }

    public void handleMessage(Message msg, ManagedConnection receivingConnection) {
        msg.hop();
        if (msg instanceof PingRequest) {
            if (RECORD_STATS) {
                ReceivedMessageStatHandler.TCP_PING_REQUESTS.addMessage(msg);
            }
            this.handlePingRequestPossibleDuplicate((PingRequest)msg, receivingConnection);
        } else if (msg instanceof PingReply) {
            if (RECORD_STATS) {
                ReceivedMessageStatHandler.TCP_PING_REPLIES.addMessage(msg);
            }
            this.handlePingReply((PingReply)msg, receivingConnection);
        } else if (msg instanceof QueryRequest) {
            if (RECORD_STATS) {
                ReceivedMessageStatHandler.TCP_QUERY_REQUESTS.addMessage(msg);
            }
            this.handleQueryRequestPossibleDuplicate((QueryRequest)msg, receivingConnection);
        } else if (msg instanceof QueryReply) {
            if (RECORD_STATS) {
                ReceivedMessageStatHandler.TCP_QUERY_REPLIES.addMessage(msg);
            }
            QueryReply qmsg = (QueryReply)msg;
            this.handleQueryReply(qmsg, receivingConnection);
        } else if (msg instanceof PushRequest) {
            if (RECORD_STATS) {
                ReceivedMessageStatHandler.TCP_PUSH_REQUESTS.addMessage(msg);
            }
            this.handlePushRequest((PushRequest)msg, receivingConnection);
        } else if (msg instanceof ResetTableMessage) {
            if (RECORD_STATS) {
                ReceivedMessageStatHandler.TCP_RESET_ROUTE_TABLE_MESSAGES.addMessage(msg);
            }
            this.handleResetTableMessage((ResetTableMessage)msg, receivingConnection);
        } else if (msg instanceof PatchTableMessage) {
            if (RECORD_STATS) {
                ReceivedMessageStatHandler.TCP_PATCH_ROUTE_TABLE_MESSAGES.addMessage(msg);
            }
            this.handlePatchTableMessage((PatchTableMessage)msg, receivingConnection);
        } else if (msg instanceof MessagesSupportedVendorMessage) {
            if (RECORD_STATS) {
                ReceivedMessageStatHandler.TCP_MESSAGES_SUPPORTED.addMessage(msg);
            }
            receivingConnection.handleVendorMessage((VendorMessage)msg);
        } else if (msg instanceof HopsFlowVendorMessage) {
            if (RECORD_STATS) {
                ReceivedMessageStatHandler.TCP_HOPS_FLOW.addMessage(msg);
            }
            receivingConnection.handleVendorMessage((VendorMessage)msg);
        } else if (msg instanceof TCPConnectBackVendorMessage) {
            if (RECORD_STATS) {
                ReceivedMessageStatHandler.TCP_TCP_CONNECTBACK.addMessage(msg);
            }
            this.handleTCPConnectBackRequest((TCPConnectBackVendorMessage)msg, receivingConnection);
        } else if (msg instanceof UDPConnectBackVendorMessage) {
            if (RECORD_STATS) {
                ReceivedMessageStatHandler.TCP_UDP_CONNECTBACK.addMessage(msg);
            }
            this.handleUDPConnectBackRequest((UDPConnectBackVendorMessage)msg, receivingConnection);
        } else if (msg instanceof PushProxyRequest) {
            if (RECORD_STATS) {
                // empty if block
            }
            this.handlePushProxyRequest((PushProxyRequest)msg, receivingConnection);
        } else if (msg instanceof PushProxyAcknowledgement) {
            if (RECORD_STATS) {
                // empty if block
            }
            receivingConnection.handleVendorMessage((VendorMessage)msg);
        } else if (msg instanceof QueryStatusResponse) {
            if (RECORD_STATS) {
                // empty if block
            }
            this.handleQueryStatus((QueryStatusResponse)msg, receivingConnection);
        }
    }

    public void handleUDPMessage(Message msg, DatagramPacket datagram) {
        msg.hop();
        InetAddress address = datagram.getAddress();
        int port = datagram.getPort();
        UDPReplyHandler handler = new UDPReplyHandler(address, port);
        if (msg instanceof QueryRequest) {
            if (this.hasValidQueryKey(address, port, (QueryRequest)msg)) {
                this.sendAcknowledgement(datagram, msg.getGUID());
                if (!this.handleUDPQueryRequestPossibleDuplicate((QueryRequest)msg, handler)) {
                    ReceivedMessageStatHandler.UDP_DUPLICATE_QUERIES.addMessage(msg);
                }
            }
            if (RECORD_STATS) {
                ReceivedMessageStatHandler.UDP_QUERY_REQUESTS.addMessage(msg);
            }
        } else if (msg instanceof QueryReply) {
            if (RECORD_STATS) {
                ReceivedMessageStatHandler.UDP_QUERY_REPLIES.addMessage(msg);
            }
            this.handleQueryReply((QueryReply)msg, handler);
        } else if (msg instanceof PingRequest) {
            if (RECORD_STATS) {
                ReceivedMessageStatHandler.UDP_PING_REQUESTS.addMessage(msg);
            }
            this.handleUDPPingRequestPossibleDuplicate((PingRequest)msg, handler, datagram);
        } else if (msg instanceof PingReply) {
            if (RECORD_STATS) {
                ReceivedMessageStatHandler.UDP_PING_REPLIES.addMessage(msg);
            }
            this.handleUDPPingReply((PingReply)msg, handler, address, port);
        } else if (msg instanceof PushRequest) {
            if (RECORD_STATS) {
                ReceivedMessageStatHandler.UDP_PUSH_REQUESTS.addMessage(msg);
            }
            this.handlePushRequest((PushRequest)msg, handler);
        } else if (msg instanceof LimeACKVendorMessage) {
            if (RECORD_STATS) {
                ReceivedMessageStatHandler.UDP_LIME_ACK.addMessage(msg);
            }
            this.handleLimeACKMessage((LimeACKVendorMessage)msg, datagram);
        }
    }

    public void handleMulticastMessage(Message msg, DatagramPacket datagram) {
        if (msg.getTTL() > 1) {
            return;
        }
        msg.hop();
        InetAddress address = datagram.getAddress();
        int port = datagram.getPort();
        if (NetworkUtils.isLocalAddress(address) && !ConnectionSettings.ALLOW_MULTICAST_LOOPBACK.getValue()) {
            return;
        }
        UDPReplyHandler handler = new UDPReplyHandler(address, port);
        if (msg instanceof QueryRequest) {
            if (!this.handleUDPQueryRequestPossibleDuplicate((QueryRequest)msg, handler)) {
                ReceivedMessageStatHandler.MULTICAST_DUPLICATE_QUERIES.addMessage(msg);
            }
            if (RECORD_STATS) {
                ReceivedMessageStatHandler.MULTICAST_QUERY_REQUESTS.addMessage(msg);
            }
        } else if (msg instanceof PingRequest) {
            if (RECORD_STATS) {
                ReceivedMessageStatHandler.MULTICAST_PING_REQUESTS.addMessage(msg);
            }
            this.handleUDPPingRequestPossibleDuplicate((PingRequest)msg, handler, datagram);
        } else if (msg instanceof PushRequest) {
            if (RECORD_STATS) {
                ReceivedMessageStatHandler.MULTICAST_PUSH_REQUESTS.addMessage(msg);
            }
            this.handlePushRequest((PushRequest)msg, handler);
        }
    }

    protected boolean hasValidQueryKey(InetAddress ip, int port, QueryRequest qr) {
        if (qr.getQueryKey() == null) {
            return false;
        }
        QueryKey computedQK = QueryKey.getQueryKey(ip, port);
        return qr.getQueryKey().equals(computedQK);
    }

    protected void sendAcknowledgement(DatagramPacket datagram, byte[] guid) {
        PingReply reply;
        ConnectionManager manager = RouterService.getConnectionManager();
        Endpoint host = manager.getConnectedGUESSUltrapeer();
        if (host != null) {
            try {
                reply = PingReply.createGUESSReply(guid, (byte)1, host);
            }
            catch (UnknownHostException e) {
                reply = this.createPingReply(guid);
            }
        } else {
            reply = this.createPingReply(guid);
        }
        try {
            UDPService.instance().send(reply, datagram.getAddress(), datagram.getPort());
        }
        catch (IOException ioe) {
            ErrorService.error(ioe, "ip/port: " + datagram.getAddress() + ":" + datagram.getPort());
        }
        if (RECORD_STATS) {
            SentMessageStatHandler.UDP_PING_REPLIES.addMessage(reply);
        }
    }

    private PingReply createPingReply(byte[] guid) {
        GUESSEndpoint endpoint = this.UNICASTER.getUnicastEndpoint();
        if (endpoint == null) {
            return PingReply.create(guid, (byte)1);
        }
        return PingReply.createGUESSReply(guid, (byte)1, endpoint.getPort(), endpoint.getAddress().getAddress());
    }

    final void handlePingRequestPossibleDuplicate(PingRequest request, ReplyHandler handler) {
        if (this._pingRouteTable.tryToRouteReply(request.getGUID(), handler) != null) {
            this.handlePingRequest(request, handler);
        }
    }

    final void handleUDPPingRequestPossibleDuplicate(PingRequest request, ReplyHandler handler, DatagramPacket datagram) {
        if (this._pingRouteTable.tryToRouteReply(request.getGUID(), handler) != null) {
            this.handleUDPPingRequest(request, handler, datagram);
        }
    }

    final void handleQueryRequestPossibleDuplicate(QueryRequest request, ManagedConnection receivingConnection) {
        boolean isProbeQuery = request.getTTL() == 0 && (request.getHops() == 1 || request.getHops() == 2);
        ResultCounter counter = this._queryRouteTable.tryToRouteReply(request.getGUID(), receivingConnection);
        if (counter != null) {
            if (isProbeQuery) {
                this._queryRouteTable.setTTL(counter, (byte)1);
            }
            this.handleQueryRequest(request, receivingConnection, counter, true);
        } else if (counter == null && !isProbeQuery) {
            if (this.wasProbeQuery(request)) {
                this.handleQueryRequest(request, receivingConnection, counter, false);
            } else {
                this.tallyDupQuery(request);
            }
        } else if (counter == null && isProbeQuery) {
            this.tallyDupQuery(request);
        } else {
            this.tallyDupQuery(request);
        }
    }

    private boolean wasProbeQuery(QueryRequest request) {
        return request.getTTL() > 0 && this._queryRouteTable.getAndSetTTL(request.getGUID(), (byte)1, (byte)(request.getTTL() + 1));
    }

    private void tallyDupQuery(QueryRequest request) {
        if (RECORD_STATS) {
            ReceivedMessageStatHandler.TCP_DUPLICATE_QUERIES.addMessage(request);
        }
    }

    final boolean handleUDPQueryRequestPossibleDuplicate(QueryRequest request, ReplyHandler handler) {
        ResultCounter counter = this._queryRouteTable.tryToRouteReply(request.getGUID(), handler);
        if (counter != null) {
            this.handleQueryRequest(request, handler, counter, true);
            return true;
        }
        return false;
    }

    private final void handlePingRequest(PingRequest ping, ReplyHandler handler) {
        if (ping.getHops() == 1 || handler.allowNewPings()) {
            this.respondToPingRequest(ping, handler);
        }
    }

    protected void handleUDPPingRequest(PingRequest pingRequest, ReplyHandler handler, DatagramPacket datagram) {
        if (pingRequest.isQueryKeyRequest()) {
            this.sendQueryKeyPong(pingRequest, datagram);
        } else {
            this.respondToUDPPingRequest(pingRequest, datagram, handler);
        }
    }

    protected void sendQueryKeyPong(PingRequest pr, DatagramPacket datagram) {
        boolean isSupernode = RouterService.isSupernode();
        if (isSupernode) {
            InetAddress address = datagram.getAddress();
            int port = datagram.getPort();
            QueryKey key = QueryKey.getQueryKey(address, port);
            PingReply reply = PingReply.createQueryKeyReply(pr.getGUID(), (byte)1, key);
            try {
                UDPService.instance().send(reply, datagram.getAddress(), datagram.getPort());
            }
            catch (IOException ioe) {
                ErrorService.error(ioe, "ip/port: " + datagram.getAddress() + ":" + datagram.getPort());
            }
            if (RECORD_STATS) {
                SentMessageStatHandler.UDP_PING_REPLIES.addMessage(reply);
            }
        }
    }

    protected void handleUDPPingReply(PingReply reply, ReplyHandler handler, InetAddress address, int port) {
        if (reply.getQueryKey() != null) {
            this.UNICASTER.handleQueryKeyPong(reply);
            return;
        }
        if (reply.getPort() != port || !reply.getIP().equals(address.getHostAddress())) {
            this.UNICASTER.addUnicastEndpoint(address, port);
        }
        this.handlePingReply(reply, handler);
    }

    protected void handleQueryRequest(QueryRequest request, ReplyHandler handler, ResultCounter counter, boolean locallyEvaluate) {
        if (!handler.isPersonalSpam(request)) {
            this._callback.handleQueryString(request.getQuery());
        }
        if (handler.isSupernodeClientConnection() && counter != null) {
            if (request.desiresOutOfBandReplies()) {
                String remoteAddr = handler.getInetAddress().getHostAddress();
                if (!request.getReplyAddress().equals(remoteAddr)) {
                    return;
                }
            }
            locallyEvaluate = false;
            this.respondToQueryRequest(request, this._clientGUID);
            this.multicastQueryRequest(request);
            if (handler.isGoodLeaf()) {
                this.sendDynamicQuery(QueryHandler.createHandlerForNewLeaf(request, handler, counter), handler);
            } else {
                this.sendDynamicQuery(QueryHandler.createHandlerForOldLeaf(request, handler, counter), handler);
            }
        } else if (request.getTTL() > 0 && RouterService.isSupernode()) {
            if (handler.isGoodUltrapeer()) {
                this.forwardQueryToUltrapeers(request, handler);
            } else {
                this.forwardLimitedQueryToUltrapeers(request, handler);
            }
        }
        if (locallyEvaluate) {
            this.forwardQueryRequestToLeaves(request, handler);
            if (request.isFirewalledSource() && !RouterService.acceptedIncomingConnection()) {
                return;
            }
            this.respondToQueryRequest(request, this._clientGUID);
        }
    }

    protected void handleLimeACKMessage(LimeACKVendorMessage ack, DatagramPacket datagram) {
        TimedGUID refGUID = new TimedGUID(new GUID(ack.getGUID()));
        QueryResponseBundle bundle = (QueryResponseBundle)this._outOfBandReplies.remove(refGUID);
        if (bundle != null && ack.getNumResults() > 0) {
            InetAddress addr = datagram.getAddress();
            int port = datagram.getPort();
            Iterator iterator = null;
            if (ack.getNumResults() < bundle._responses.length) {
                Response[] desired = new Response[ack.getNumResults()];
                for (int i = 0; i < desired.length; ++i) {
                    desired[i] = bundle._responses[i];
                }
                iterator = this.responsesToQueryReplies(desired, bundle._query, 1);
            } else {
                iterator = this.responsesToQueryReplies(bundle._responses, bundle._query, 1);
            }
            while (iterator.hasNext()) {
                QueryReply queryReply = (QueryReply)iterator.next();
                try {
                    UDPService.instance().send(queryReply, addr, port);
                }
                catch (IOException e) {
                    ErrorService.error(e, "ip/port: " + addr + ":" + port);
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean bufferResponsesForLaterDelivery(QueryRequest query, Response[] resps) {
        Map map = this._outOfBandReplies;
        synchronized (map) {
            if (this._outOfBandReplies.size() < MAX_BUFFERED_REPLIES) {
                this._outOfBandReplies.put(new TimedGUID(new GUID(query.getGUID())), new QueryResponseBundle(query, resps));
                return true;
            }
            return false;
        }
    }

    protected void handleUDPConnectBackRequest(UDPConnectBackVendorMessage udp, Connection source) {
        GUID guidToUse = udp.getConnectBackGUID();
        int portToContact = udp.getConnectBackPort();
        InetAddress addrToContact = null;
        try {
            addrToContact = source.getInetAddress();
        }
        catch (IllegalStateException ise) {
            return;
        }
        PingRequest pr = new PingRequest(guidToUse.bytes(), 1, 0);
        try {
            UDPService.instance().send(pr, addrToContact, portToContact);
        }
        catch (IOException e) {
            ErrorService.error(e, "invalid ip/port: " + addrToContact + ":" + portToContact);
        }
    }

    protected void handleTCPConnectBackRequest(TCPConnectBackVendorMessage tcp, Connection source) {
        int portToContact = tcp.getConnectBackPort();
        InetAddress addrToContact = null;
        try {
            addrToContact = source.getInetAddress();
        }
        catch (IllegalStateException ise) {
            return;
        }
        try {
            Socket sock = new Socket(addrToContact, portToContact);
            OutputStream os = sock.getOutputStream();
            os.write("\n\n".getBytes());
            sock.close();
        }
        catch (IOException ioe) {
        }
        catch (SecurityException se) {
            // empty catch block
        }
    }

    protected void handlePushProxyRequest(PushProxyRequest ppReq, ManagedConnection source) {
        if (source.isSupernodeClientConnection()) {
            try {
                String stringAddr = NetworkUtils.ip2string(RouterService.getAddress());
                InetAddress addr = InetAddress.getByName(stringAddr);
                PushProxyAcknowledgement ack = new PushProxyAcknowledgement(addr, RouterService.getPort(), ppReq.getClientGUID());
                source.send(ack);
                this._pushRouteTable.routeReply(ppReq.getClientGUID().bytes(), source);
            }
            catch (BadPacketException tooTerribleToIgnore) {
                ErrorService.error(tooTerribleToIgnore);
            }
            catch (UnknownHostException tooTerribleToIgnore2) {
                ErrorService.error(tooTerribleToIgnore2);
            }
        }
    }

    protected void handleQueryStatus(QueryStatusResponse resp, ManagedConnection leaf) {
        if (!leaf.isSupernodeClientConnection()) {
            return;
        }
        GUID queryGUID = resp.getQueryGUID();
        int numResults = resp.getNumResults();
        this.DYNAMIC_QUERIER.updateLeafResultsForQuery(queryGUID, numResults);
    }

    public void sendPingRequest(PingRequest request, ManagedConnection connection) {
        if (request == null) {
            throw new NullPointerException("null ping");
        }
        if (connection == null) {
            throw new NullPointerException("null connection");
        }
        this._pingRouteTable.routeReply(request.getGUID(), this.FOR_ME_REPLY_HANDLER);
        connection.send(request);
    }

    public void sendQueryRequest(QueryRequest request, ManagedConnection connection) {
        if (request == null) {
            throw new NullPointerException("null query");
        }
        if (connection == null) {
            throw new NullPointerException("null connection");
        }
        this._queryRouteTable.routeReply(request.getGUID(), this.FOR_ME_REPLY_HANDLER);
        connection.send(request);
    }

    public void broadcastPingRequest(PingRequest ping) {
        if (ping == null) {
            throw new NullPointerException("null ping");
        }
        this._pingRouteTable.routeReply(ping.getGUID(), this.FOR_ME_REPLY_HANDLER);
        this.broadcastPingRequest(ping, this.FOR_ME_REPLY_HANDLER, _manager);
    }

    public void sendDynamicQuery(QueryRequest query) {
        if (query == null) {
            throw new NullPointerException("null QueryHandler");
        }
        ResultCounter counter = this._queryRouteTable.routeReply(query.getGUID(), this.FOR_ME_REPLY_HANDLER);
        if (RouterService.isSupernode()) {
            this.sendDynamicQuery(QueryHandler.createHandler(query, this.FOR_ME_REPLY_HANDLER, counter), this.FOR_ME_REPLY_HANDLER);
        } else {
            this.originateLeafQuery(query);
        }
        this.multicastQueryRequest(QueryRequest.createMulticastQuery(query));
    }

    private void sendDynamicQuery(QueryHandler qh, ReplyHandler handler) {
        if (qh == null) {
            throw new NullPointerException("null QueryHandler");
        }
        if (handler == null) {
            throw new NullPointerException("null ReplyHandler");
        }
        this.DYNAMIC_QUERIER.addQuery(qh);
    }

    private void broadcastPingRequest(PingRequest request, ReplyHandler receivingConnection, ConnectionManager manager) {
        List list = manager.getInitializedConnections2();
        int size = list.size();
        boolean randomlyForward = false;
        if (size > 3) {
            randomlyForward = true;
        }
        for (int i = 0; i < size; ++i) {
            ManagedConnection mc = (ManagedConnection)list.get(i);
            if (!mc.isStable() || receivingConnection != this.FOR_ME_REPLY_HANDLER && (mc == receivingConnection || mc.isClientSupernodeConnection())) continue;
            double percentToIgnore = mc.supportsPongCaching() ? 0.4 : 0.9;
            if (randomlyForward && Math.random() < percentToIgnore) continue;
            mc.send(request);
        }
    }

    public final void forwardQueryRequestToLeaves(QueryRequest query, ReplyHandler handler) {
        if (!RouterService.isSupernode()) {
            return;
        }
        List list = _manager.getInitializedClientConnections2();
        List<ManagedConnection> hitConnections = new ArrayList<ManagedConnection>();
        for (int i = 0; i < list.size(); ++i) {
            ManagedConnection mc = (ManagedConnection)list.get(i);
            if (mc == handler || !mc.hitsQueryRouteTable(query)) continue;
            hitConnections.add(mc);
        }
        if (list.size() > 8 && (double)hitConnections.size() / (double)list.size() > 0.8) {
            hitConnections = hitConnections.subList(0, hitConnections.size() / 4);
        }
        int notSent = list.size() - hitConnections.size();
        RoutedQueryStat.LEAF_DROP.addData(notSent);
        for (int i = 0; i < hitConnections.size(); ++i) {
            ManagedConnection mc = (ManagedConnection)hitConnections.get(i);
            this.sendQueryRequest(query, mc, handler);
            RoutedQueryStat.LEAF_SEND.incrementStat();
        }
    }

    private boolean sendRoutedQueryToHost(QueryRequest query, ManagedConnection mc, ReplyHandler handler) {
        if (mc.hitsQueryRouteTable(query)) {
            this.sendQueryRequest(query, mc, handler);
            return true;
        }
        return false;
    }

    protected void unicastQueryRequest(QueryRequest query, ReplyHandler conn) {
        query.setTTL((byte)1);
        this.UNICASTER.addQuery(query, conn);
    }

    protected void multicastQueryRequest(QueryRequest query) {
        query.setTTL((byte)1);
        if (RECORD_STATS) {
            SentMessageStatHandler.MULTICAST_QUERY_REQUESTS.addMessage(query);
        }
        MulticastService.instance().send(query);
    }

    private void forwardQueryToUltrapeers(QueryRequest query, ReplyHandler handler) {
        List list = _manager.getInitializedConnections2();
        int limit = list.size();
        for (int i = 0; i < limit; ++i) {
            ManagedConnection mc = (ManagedConnection)list.get(i);
            this.forwardQueryToUltrapeer(query, handler, mc);
        }
    }

    private void forwardLimitedQueryToUltrapeers(QueryRequest query, ReplyHandler handler) {
        List list = _manager.getInitializedConnections2();
        int limit = list.size();
        int connectionsNeededForOld = 15;
        for (int i = 0; i < limit && connectionsNeededForOld != 0; ++i) {
            ManagedConnection mc = (ManagedConnection)list.get(i);
            if (mc.isGoodUltrapeer() && limit - i > connectionsNeededForOld) continue;
            this.forwardQueryToUltrapeer(query, handler, mc);
            --connectionsNeededForOld;
        }
    }

    private void forwardQueryToUltrapeer(QueryRequest query, ReplyHandler handler, ManagedConnection ultrapeer) {
        boolean lastHop;
        if (ultrapeer == handler) {
            return;
        }
        if (ultrapeer.isClientSupernodeConnection()) {
            return;
        }
        boolean bl = lastHop = query.getTTL() == 1;
        if (lastHop && ultrapeer.isUltrapeerQueryRoutingConnection()) {
            boolean sent = this.sendRoutedQueryToHost(query, ultrapeer, handler);
            if (sent && RECORD_STATS) {
                RoutedQueryStat.ULTRAPEER_SEND.incrementStat();
            } else if (RECORD_STATS) {
                RoutedQueryStat.ULTRAPEER_DROP.incrementStat();
            }
        } else {
            this.sendQueryRequest(query, ultrapeer, handler);
        }
    }

    private void originateLeafQuery(QueryRequest qr) {
        List list = _manager.getInitializedConnections2();
        int limit = Math.min(4, list.size());
        for (int i = 0; i < limit; ++i) {
            ManagedConnection mc = (ManagedConnection)list.get(i);
            this.sendQueryRequest(qr, mc, this.FOR_ME_REPLY_HANDLER);
        }
    }

    public void sendQueryRequest(QueryRequest request, ManagedConnection sendConnection, ReplyHandler handler) {
        if (request == null) {
            throw new NullPointerException("null query");
        }
        if (sendConnection == null) {
            throw new NullPointerException("null send connection");
        }
        if (handler == null) {
            throw new NullPointerException("null reply handler");
        }
        if (handler == this.FOR_ME_REPLY_HANDLER || MessageRouter.containsDefaultUnauthenticatedDomainOnly(sendConnection.getDomains()) || Utilities.hasIntersection(handler.getDomains(), sendConnection.getDomains())) {
            sendConnection.send(request);
        }
    }

    public void originateQuery(QueryRequest query, ManagedConnection mc) {
        if (query == null) {
            throw new NullPointerException("null query");
        }
        if (mc == null) {
            throw new NullPointerException("null connection");
        }
        mc.originateQuery(query);
    }

    private static boolean containsDefaultUnauthenticatedDomainOnly(Set domains) {
        return domains.size() == 1 && domains.contains("__DEFAULT_UNAUTHENTICATED_DOMAIN__");
    }

    protected abstract void respondToPingRequest(PingRequest var1, ReplyHandler var2);

    protected abstract void respondToUDPPingRequest(PingRequest var1, DatagramPacket var2, ReplyHandler var3);

    protected abstract boolean respondToQueryRequest(QueryRequest var1, byte[] var2);

    protected void handlePingReply(PingReply reply, ReplyHandler handler) {
        ReplyHandler replyHandler;
        boolean newAddress = RouterService.getHostCatcher().add(reply);
        if (newAddress && (handler.supportsPongCaching() || PongCacher.instance().needsPongs())) {
            PongCacher.instance().addPong(reply);
        }
        if ((replyHandler = this._pingRouteTable.getReplyHandler(reply.getGUID())) != null) {
            replyHandler.handlePingReply(reply, handler);
        } else {
            if (RECORD_STATS) {
                RouteErrorStat.PING_REPLY_ROUTE_ERRORS.incrementStat();
            }
            handler.countDroppedMessage();
        }
        boolean supportsUnicast = reply.supportsUnicast();
        if (newAddress && (reply.isUltrapeer() || supportsUnicast)) {
            List list = _manager.getInitializedClientConnections2();
            for (int i = 0; i < list.size(); ++i) {
                ManagedConnection c = (ManagedConnection)list.get(i);
                Assert.that(c != null, "null c.");
                if (c == handler || c == replyHandler || !c.allowNewPongs()) continue;
                c.handlePingReply(reply, handler);
            }
        }
    }

    public void handleQueryReply(QueryReply queryReply, ReplyHandler handler) {
        if (queryReply == null) {
            throw new NullPointerException("null query reply");
        }
        if (handler == null) {
            throw new NullPointerException("null ReplyHandler");
        }
        RouteTable.ReplyRoutePair rrp = this._queryRouteTable.getReplyHandler(queryReply.getGUID(), queryReply.getTotalLength(), queryReply.getResultCount());
        if (rrp != null) {
            queryReply.setPriority(rrp.getBytesRouted());
            this._pushRouteTable.routeReply(queryReply.getClientGUID(), handler);
            ReplyHandler rh = rrp.getReplyHandler();
            if (!this.shouldDropReply(rrp, rh, queryReply)) {
                rh.handleQueryReply(queryReply, handler);
                this.UNICASTER.handleQueryReply(queryReply);
            } else {
                if (RECORD_STATS) {
                    RouteErrorStat.HARD_LIMIT_QUERY_REPLY_ROUTE_ERRORS.incrementStat();
                }
                handler.countDroppedMessage();
            }
        } else {
            if (RECORD_STATS) {
                RouteErrorStat.NO_ROUTE_QUERY_REPLY_ROUTE_ERRORS.incrementStat();
            }
            handler.countDroppedMessage();
        }
    }

    private boolean shouldDropReply(RouteTable.ReplyRoutePair rrp, ReplyHandler rh, QueryReply qr) {
        byte ttl = qr.getTTL();
        if (rh == this.FOR_ME_REPLY_HANDLER) {
            return false;
        }
        if (ttl == 0) {
            return true;
        }
        int resultsRouted = rrp.getResultsRouted();
        if (resultsRouted > 100) {
            return true;
        }
        int bytesRouted = rrp.getBytesRouted();
        if (ttl > 2 && bytesRouted < 51200) {
            return false;
        }
        if (ttl == 1 && bytesRouted < 204800) {
            return false;
        }
        return ttl != 2 || bytesRouted >= 102400;
    }

    protected void handlePushRequest(PushRequest request, ReplyHandler handler) {
        if (request == null) {
            throw new NullPointerException("null request");
        }
        if (handler == null) {
            throw new NullPointerException("null ReplyHandler");
        }
        ReplyHandler replyHandler = this._pushRouteTable.getReplyHandler(request.getClientGUID());
        if (replyHandler != null) {
            replyHandler.handlePushRequest(request, handler);
        } else {
            if (RECORD_STATS) {
                RouteErrorStat.PUSH_REQUEST_ROUTE_ERRORS.incrementStat();
            }
            handler.countDroppedMessage();
        }
    }

    protected void sendPingReply(PingReply pong, ReplyHandler handler) {
        if (pong == null) {
            throw new NullPointerException("null pong");
        }
        if (handler == null) {
            throw new NullPointerException("null reply handler");
        }
        handler.handlePingReply(pong, null);
    }

    protected void sendQueryReply(QueryReply queryReply) throws IOException {
        if (queryReply == null) {
            throw new NullPointerException("null reply");
        }
        RouteTable.ReplyRoutePair rrp = this._queryRouteTable.getReplyHandler(queryReply.getGUID(), queryReply.getTotalLength(), queryReply.getResultCount());
        if (rrp == null) {
            throw new IOException("no route for reply");
        }
        queryReply.setPriority(rrp.getBytesRouted());
        this._pushRouteTable.routeReply(queryReply.getClientGUID(), this.FOR_ME_REPLY_HANDLER);
        rrp.getReplyHandler().handleQueryReply(queryReply, null);
    }

    public void sendPushRequest(PushRequest push) throws IOException {
        if (push == null) {
            throw new NullPointerException("null push");
        }
        ReplyHandler replyHandler = this._pushRouteTable.getReplyHandler(push.getClientGUID());
        if (replyHandler == null) {
            throw new IOException("no route for push");
        }
        replyHandler.handlePushRequest(push, null);
    }

    protected void sendMulticastPushRequest(PushRequest push) {
        if (push == null) {
            throw new NullPointerException("null push");
        }
        Assert.that(push.getTTL() == 1, "multicast push ttl not 1");
        MulticastService.instance().send(push);
        SentMessageStatHandler.MULTICAST_PUSH_REQUESTS.addMessage(push);
    }

    public Iterator responsesToQueryReplies(Response[] responses, QueryRequest queryRequest) {
        return this.responsesToQueryReplies(responses, queryRequest, 10);
    }

    private Iterator responsesToQueryReplies(Response[] responses, QueryRequest queryRequest, int REPLY_LIMIT) {
        int i;
        LinkedList queryReplies = new LinkedList();
        byte[] guid = queryRequest.getGUID();
        byte ttl = (byte)(queryRequest.getHops() + 1);
        UploadManager um = RouterService.getUploadManager();
        long speed = um.measuredUploadSpeed();
        boolean measuredSpeed = true;
        if (speed == -1L) {
            speed = ConnectionSettings.CONNECTION_SPEED.getValue();
            measuredSpeed = false;
        }
        int numResponses = responses.length;
        int index = 0;
        byte numHops = queryRequest.getHops();
        if (REPLY_LIMIT > 1 && numHops > 2 && numResponses > 10) {
            int j = (int)(Math.random() * (double)numResponses) % (numResponses - 10);
            Response[] newResponses = new Response[10];
            i = 0;
            while (i < 10) {
                newResponses[i] = responses[j];
                ++i;
                ++j;
            }
            responses = newResponses;
            numResponses = responses.length;
        }
        while (numResponses > 0) {
            boolean mcast;
            Response[] res;
            int arraySize = numResponses < REPLY_LIMIT ? numResponses : REPLY_LIMIT;
            if (index == 0 && arraySize < REPLY_LIMIT) {
                res = responses;
            } else {
                res = new Response[arraySize];
                for (i = 0; i < arraySize; ++i) {
                    res[i] = responses[index];
                    ++index;
                }
            }
            numResponses -= arraySize;
            boolean busy = !um.isServiceable();
            boolean uploaded = um.hadSuccesfulUpload();
            boolean bl = mcast = queryRequest.isMulticast() && queryRequest.getTTL() + queryRequest.getHops() == 1;
            if (mcast) {
                ttl = 1;
            }
            List replies = this.createQueryReply(guid, ttl, speed, res, this._clientGUID, busy, uploaded, measuredSpeed, mcast);
            queryReplies.addAll(replies);
        }
        return queryReplies.iterator();
    }

    protected abstract List createQueryReply(byte[] var1, byte var2, long var3, Response[] var5, byte[] var6, boolean var7, boolean var8, boolean var9, boolean var10);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleResetTableMessage(ResetTableMessage rtm, ManagedConnection mc) {
        if (!MessageRouter.isQRPConnection(mc)) {
            return;
        }
        Object object = mc.getQRPLock();
        synchronized (object) {
            mc.resetQueryRouteTable(rtm);
        }
        if (mc.isLeafConnection()) {
            this._lastQueryRouteTable = MessageRouter.createRouteTable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePatchTableMessage(PatchTableMessage ptm, ManagedConnection mc) {
        if (!MessageRouter.isQRPConnection(mc)) {
            return;
        }
        Object object = mc.getQRPLock();
        synchronized (object) {
            mc.patchQueryRouteTable(ptm);
        }
        if (mc.isLeafConnection()) {
            this._lastQueryRouteTable = MessageRouter.createRouteTable();
        }
    }

    private static boolean isQRPConnection(Connection c) {
        if (c.isSupernodeClientConnection()) {
            return true;
        }
        return c.isUltrapeerQueryRoutingConnection();
    }

    private void forwardQueryRouteTables() {
        long time = System.currentTimeMillis();
        List list = _manager.getInitializedConnections2();
        QueryRouteTable table = null;
        List patches = null;
        QueryRouteTable lastSent = null;
        for (int i = 0; i < list.size(); ++i) {
            ManagedConnection c = (ManagedConnection)list.get(i);
            if (!RouterService.isSupernode() ? !c.isClientSupernodeConnection() || !c.isQueryRoutingEnabled() : !c.isUltrapeerQueryRoutingConnection()) continue;
            if (time < c.getNextQRPForwardTime()) continue;
            c.incrementNextQRPForwardTime(time);
            if (table == null) {
                this._lastQueryRouteTable = table = MessageRouter.createRouteTable();
            }
            if (lastSent == c.getQueryRouteTableSent()) {
                if (patches == null) {
                    patches = table.encode(lastSent, true);
                }
            } else {
                lastSent = c.getQueryRouteTableSent();
                patches = table.encode(lastSent, true);
            }
            Iterator iter = patches.iterator();
            while (iter.hasNext()) {
                c.send((RouteTableMessage)iter.next());
            }
            c.setQueryRouteTableSent(table);
        }
    }

    public QueryRouteTable getQueryRouteTable() {
        return this._lastQueryRouteTable;
    }

    private static QueryRouteTable createRouteTable() {
        QueryRouteTable ret = new QueryRouteTable();
        MessageRouter.addQueryRoutingEntries(ret);
        return ret;
    }

    private static void addQueryRoutingEntries(QueryRouteTable qrt) {
        Iterator words = _fileManager.getKeyWords().iterator();
        while (words.hasNext()) {
            qrt.add((String)words.next());
        }
        Iterator indivisibleWords = _fileManager.getIndivisibleKeyWords().iterator();
        while (indivisibleWords.hasNext()) {
            qrt.addIndivisible((String)indivisibleWords.next());
        }
        if (RouterService.isSupernode()) {
            MessageRouter.addQueryRoutingEntriesForLeaves(qrt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addQueryRoutingEntriesForLeaves(QueryRouteTable qrt) {
        List leaves = _manager.getInitializedClientConnections2();
        for (int i = 0; i < leaves.size(); ++i) {
            ManagedConnection mc = (ManagedConnection)leaves.get(i);
            Object object = mc.getQRPLock();
            synchronized (object) {
                QueryRouteTable qrtr = mc.getQueryRouteTableReceived();
                if (qrtr != null) {
                    qrt.addAll(qrtr);
                }
                continue;
            }
        }
    }

    static {
        MAX_BUFFERED_REPLIES = 250;
        RECORD_STATS = !CommonUtils.isJava118();
    }

    private class Expirer
    implements Runnable {
        private Expirer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                HashSet<TimedGUID> toRemove = new HashSet<TimedGUID>();
                Map map = MessageRouter.this._outOfBandReplies;
                synchronized (map) {
                    Iterator<Object> keys = MessageRouter.this._outOfBandReplies.keySet().iterator();
                    while (keys.hasNext()) {
                        TimedGUID currQB = (TimedGUID)keys.next();
                        if (currQB == null || !currQB.shouldExpire()) continue;
                        toRemove.add(currQB);
                    }
                    keys = toRemove.iterator();
                    while (keys.hasNext()) {
                        MessageRouter.this._outOfBandReplies.remove(keys.next());
                    }
                }
            }
            catch (Throwable t) {
                ErrorService.error(t);
            }
        }
    }

    private static class QueryResponseBundle {
        public final QueryRequest _query;
        public final Response[] _responses;

        public QueryResponseBundle(QueryRequest query, Response[] responses) {
            this._query = query;
            this._responses = responses;
        }
    }

    private static class TimedGUID {
        public static final long MAX_LIFE = 25000L;
        private final GUID _guid;
        private final long _creationTime;

        public TimedGUID(GUID guid) {
            this._guid = guid;
            this._creationTime = System.currentTimeMillis();
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other instanceof TimedGUID) {
                return this._guid.equals(((TimedGUID)other)._guid);
            }
            return false;
        }

        public int hashCode() {
            return this._guid.hashCode();
        }

        public boolean shouldExpire() {
            long currTime = System.currentTimeMillis();
            return currTime - this._creationTime >= 25000L;
        }
    }

    private class QRPPropagator
    extends Thread {
        public QRPPropagator() {
            this.setName("QRPPropagator");
            this.setDaemon(true);
        }

        public void run() {
            try {
                while (true) {
                    Thread.sleep(10000L);
                    MessageRouter.this.forwardQueryRouteTables();
                }
            }
            catch (Throwable t) {
                ErrorService.error(t);
                return;
            }
        }
    }
}

