/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import java.io.Serializable;

public class MediaType
implements Serializable {
    static final long serialVersionUID = 3999062781289258389L;
    private String schema;
    private String description;
    private String[] extensions;
    private static final String SCHEMA_ANY_TYPE = "*";
    private static final String SCHEMA_DOCUMENTS = "text";
    private static final String SCHEMA_PROGRAMS = "application";
    private static final String SCHEMA_AUDIO = "audio";
    private static final String SCHEMA_VIDEO = "video";
    private static final String SCHEMA_IMAGES = "image";
    private static final String ANY_TYPE = "MEDIA_ANY_TYPE";
    private static final String DOCUMENTS = "MEDIA_DOCUMENTS";
    private static final String PROGRAMS = "MEDIA_PROGRAMS";
    private static final String AUDIO = "MEDIA_AUDIO";
    private static final String VIDEO = "MEDIA_VIDEO";
    private static final String IMAGES = "MEDIA_IMAGES";
    private static MediaType[] allMediaTypes = null;

    public MediaType(String schema, String description, String[] extensions) {
        this.schema = schema;
        this.description = description;
        this.extensions = extensions;
    }

    public boolean matches(String filename) {
        if (this.extensions == null) {
            return true;
        }
        int j = filename.lastIndexOf(".");
        if (j == -1 || j == filename.length()) {
            return false;
        }
        String suffix = filename.substring(j + 1).toLowerCase();
        for (int i = 0; i < this.extensions.length; ++i) {
            if (!suffix.equals(this.extensions[i])) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.schema;
    }

    public String getDescription() {
        return this.description;
    }

    public static final MediaType[] getDefaultMediaTypes() {
        if (allMediaTypes == null) {
            allMediaTypes = MediaType.getTypes();
        }
        return allMediaTypes;
    }

    public static boolean isDefaultType(String schema) {
        MediaType[] types = MediaType.getDefaultMediaTypes();
        int i = types.length;
        while (--i >= 0) {
            if (!schema.equals(types[i].schema)) continue;
            return true;
        }
        return false;
    }

    public static MediaType getAudioMediaType() {
        return MediaType.getDefaultMediaTypes()[3];
    }

    public static MediaType getVideoMediaType() {
        return MediaType.getDefaultMediaTypes()[4];
    }

    public static MediaType getImageMediaType() {
        return MediaType.getDefaultMediaTypes()[5];
    }

    private static MediaType[] getTypes() {
        MediaType any = new MediaType(SCHEMA_ANY_TYPE, ANY_TYPE, null);
        MediaType text = new MediaType(SCHEMA_DOCUMENTS, DOCUMENTS, new String[]{"html", "htm", "xhtml", "mht", "mhtml", "xml", "txt", "ans", "asc", "diz", "eml", "pdf", "ps", "eps", "epsf", "rtf", "wri", "doc", "mcw", "wps", "xls", "wk1", "dif", "csv", "ppt", "hlp", "chm", "tex", "texi", "latex", "info", "man"});
        MediaType programs = new MediaType(SCHEMA_PROGRAMS, PROGRAMS, new String[]{"exe", "bin", "mdb", "sh", "csh", "awk", "pl", "zip", "jar", "arj", "rar", "ace", "lzh", "lha", "cab", "rpm", "deb", "msi", "msp", "gz", "gzip", "z", "bz2", "zoo", "tar", "tgz", "taz", "shar", "hqx", "sit", "dmg", "7z"});
        MediaType audio = new MediaType(SCHEMA_AUDIO, AUDIO, new String[]{"mp3", "mpa", "mp1", "mpga", "ra", "rm", "ram", "rmj", "wma", "wav", "lqt", "ogg", "med", "aif", "aiff", "aifc", "au", "snd", "iso", "mid", "midi", "rmi", "mod"});
        MediaType video = new MediaType(SCHEMA_VIDEO, VIDEO, new String[]{"mpg", "mpeg", "mpe", "mng", "mpv", "m1v", "vob", "mp2", "mpv2", "mp2v", "m2p", "m2v", "vcd", "mp4", "dv", "dvd", "div", "divx", "dvx", "smi", "smil", "rm", "ram", "rv", "avi", "asf", "wmv", "qt", "mov", "fli", "flc", "flx", "wml", "vrml", "swf", "dcr", "jve", "nsv"});
        MediaType images = new MediaType(SCHEMA_IMAGES, IMAGES, new String[]{"gif", "png", "jpg", "jpeg", "jpe", "jif", "jiff", "jfif", "tif", "tiff", "iff", "lbm", "ilbm", "mac", "drw", "pct", "img", "bmp", "dib", "rle", "ico", "ani", "icl", "cur", "emf", "wmf", "pcx", "pcd", "tga", "pic", "psd", "wpg", "dcx", "cpt", "mic", "pbm", "pnm", "ppm", "xbm", "xpm", "xwd", "sgi", "fax", "rgb", "ras"});
        return new MediaType[]{any, text, programs, audio, video, images};
    }
}

