/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.ExtendedEndpoint;
import com.limegroup.gnutella.QueryUnicaster;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.bootstrap.BootstrapServer;
import com.limegroup.gnutella.bootstrap.BootstrapServerManager;
import com.limegroup.gnutella.messages.PingReply;
import com.limegroup.gnutella.util.BucketQueue;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.FixedsizePriorityQueue;
import com.limegroup.gnutella.util.NetworkUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class HostCatcher {
    public static final int GWEBCACHE_DELAY = 6000;
    static final int GOOD_SIZE = 1000;
    static final int NORMAL_SIZE = 400;
    static final int PERMANENT_SIZE = 1000;
    static final int GOOD_PRIORITY = 1;
    static final int NORMAL_PRIORITY = 0;
    private final BucketQueue ENDPOINT_QUEUE = new BucketQueue(new int[]{400, 1000});
    private final Set ENDPOINT_SET = new HashSet();
    private FixedsizePriorityQueue permanentHosts = new FixedsizePriorityQueue(ExtendedEndpoint.priorityComparator(), 1000);
    private Set permanentHostsSet = new HashSet();
    private BootstrapServerManager gWebCache = new BootstrapServerManager(this);
    private long nextAllowedFetchTime = Long.MAX_VALUE;
    private boolean alwaysNotifyKnownHost = false;
    private final File HOST_FILE = new File(CommonUtils.getUserSettingsDir(), "network.cache");

    public void initialize() {
        try {
            this.read(this.HOST_FILE);
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        Runnable updater = new Runnable(){

            public void run() {
                try {
                    Endpoint e;
                    if (RouterService.acceptedIncomingConnection() && RouterService.isSupernode() && !(e = new Endpoint(RouterService.getAddress(), RouterService.getPort())).isPrivateAddress()) {
                        HostCatcher.this.gWebCache.sendUpdatesAsync(e);
                    }
                }
                catch (Throwable t) {
                    ErrorService.error(t);
                }
            }
        };
        RouterService.schedule(updater, BootstrapServerManager.UPDATE_DELAY_MSEC, BootstrapServerManager.UPDATE_DELAY_MSEC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void read(File hostFile) throws FileNotFoundException, IOException {
        BufferedReader in = null;
        try {
            String line;
            in = new BufferedReader(new FileReader(hostFile));
            while ((line = in.readLine()) != null) {
                Object e;
                try {
                    e = new BootstrapServer(line);
                    this.gWebCache.addBootstrapServer((BootstrapServer)e);
                }
                catch (ParseException ignore) {
                    try {
                        e = ExtendedEndpoint.read(line);
                        this.add((ExtendedEndpoint)e, 0);
                    }
                    catch (ParseException pe) {}
                }
            }
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (IOException e) {}
    }

    public synchronized void write() throws IOException {
        this.write(this.HOST_FILE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void write(File hostFile) throws IOException {
        System.err.println("HostCatcher writing file: " + hostFile);
        this.repOk();
        FileWriter out = new FileWriter(hostFile);
        BootstrapServerManager bootstrapServerManager = this.gWebCache;
        synchronized (bootstrapServerManager) {
            Iterator iter = this.gWebCache.getBootstrapServers();
            while (iter.hasNext()) {
                BootstrapServer e = (BootstrapServer)iter.next();
                out.write(e.toString());
                out.write("\n");
            }
        }
        Iterator iter = this.permanentHosts.iterator();
        while (iter.hasNext()) {
            ExtendedEndpoint e = (ExtendedEndpoint)iter.next();
            e.write(out);
        }
        out.close();
    }

    public boolean add(PingReply pr) {
        ExtendedEndpoint endpoint = pr.getDailyUptime() != -1 ? new ExtendedEndpoint(pr.getIP(), pr.getPort(), pr.getDailyUptime()) : new ExtendedEndpoint(pr.getIP(), pr.getPort());
        if (pr.supportsUnicast()) {
            try {
                QueryUnicaster.instance().addUnicastEndpoint(InetAddress.getByName(pr.getIP()), pr.getPort());
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        if (pr.isUltrapeer()) {
            return this.add(endpoint, 1);
        }
        return this.add(endpoint, 0);
    }

    public boolean add(Endpoint e, boolean forceHighPriority) {
        ExtendedEndpoint ee = new ExtendedEndpoint(e.getHostname(), e.getPort());
        if (forceHighPriority) {
            return this.add(ee, 1);
        }
        return this.add(ee, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean add(ExtendedEndpoint e, int priority) {
        if (e.isPrivateAddress()) {
            return false;
        }
        this.repOk();
        if (NetworkUtils.isMe(e.getHostname(), e.getPort())) {
            return false;
        }
        if (RouterService.getAcceptor().isBannedIP(e.getHostname())) {
            return false;
        }
        this.addPermanent(e);
        boolean ret = false;
        boolean notifyGUI = false;
        HostCatcher hostCatcher = this;
        synchronized (hostCatcher) {
            if (!this.ENDPOINT_SET.contains(e)) {
                ret = true;
                this.ENDPOINT_SET.add(e);
                Object ejected = this.ENDPOINT_QUEUE.insert(e, priority);
                if (ejected != null) {
                    this.ENDPOINT_SET.remove(ejected);
                }
                if (ejected == null) {
                    notifyGUI = true;
                }
                this.notify();
            }
        }
        this.repOk();
        return ret;
    }

    private synchronized boolean addPermanent(ExtendedEndpoint e) {
        if (e.isPrivateAddress()) {
            return false;
        }
        if (this.permanentHostsSet.contains(e)) {
            return false;
        }
        Object removed = this.permanentHosts.insert(e);
        if (removed != e) {
            this.permanentHostsSet.add(e);
            if (removed != null) {
                this.permanentHostsSet.remove(removed);
            }
            return true;
        }
        return false;
    }

    private synchronized boolean removePermanent(ExtendedEndpoint e) {
        boolean removed2;
        boolean removed1 = this.permanentHosts.remove(e);
        Assert.that(removed1 == (removed2 = this.permanentHostsSet.remove(e)), "Queue " + removed1 + " but set " + removed2);
        return removed1;
    }

    public synchronized Endpoint getAnEndpoint() throws InterruptedException {
        while (true) {
            if (this.getNumHosts() == 0) {
                this.gWebCache.fetchEndpointsAsync();
            } else if (this.getNumUltrapeerHosts() == 0) {
                long now = System.currentTimeMillis();
                if (now < this.nextAllowedFetchTime) {
                    this.nextAllowedFetchTime = Math.min(this.nextAllowedFetchTime, now + 6000L);
                } else {
                    this.gWebCache.fetchEndpointsAsync();
                    this.nextAllowedFetchTime = Long.MAX_VALUE;
                }
            }
            try {
                return this.getAnEndpointInternal();
            }
            catch (NoSuchElementException noSuchElementException) {
                this.wait();
                continue;
            }
            break;
        }
    }

    public synchronized void doneWithConnect(Endpoint e, boolean success) {
        if (!(e instanceof ExtendedEndpoint)) {
            return;
        }
        ExtendedEndpoint ee = (ExtendedEndpoint)e;
        this.removePermanent(ee);
        if (success) {
            ee.recordConnectionSuccess();
        } else {
            ee.recordConnectionFailure();
        }
        this.addPermanent(ee);
    }

    private ExtendedEndpoint getAnEndpointInternal() throws NoSuchElementException {
        if (!this.ENDPOINT_QUEUE.isEmpty()) {
            ExtendedEndpoint e = (ExtendedEndpoint)this.ENDPOINT_QUEUE.extractMax();
            boolean ok = this.ENDPOINT_SET.remove(e);
            Assert.that(ok, "Rep. invariant for HostCatcher broken.");
            return e;
        }
        throw new NoSuchElementException();
    }

    public int getNumHosts() {
        return this.ENDPOINT_QUEUE.size();
    }

    public int getNumUltrapeerHosts() {
        return this.ENDPOINT_QUEUE.size(1);
    }

    public synchronized Iterator getHosts() {
        return new BucketQueue(this.ENDPOINT_QUEUE).iterator();
    }

    Iterator getPermanentHosts() {
        return this.permanentHosts.iterator();
    }

    public synchronized Iterator getUltrapeerHosts(int n) {
        n = Math.min(n, this.ENDPOINT_QUEUE.size(1));
        ArrayList buf = new ArrayList(n);
        Iterator iter = this.ENDPOINT_QUEUE.iterator(1, n);
        while (iter.hasNext()) {
            buf.add(iter.next());
        }
        return buf.iterator();
    }

    public synchronized void removeHost(String host, int port) {
        boolean removed2;
        Endpoint e = new Endpoint(host, port);
        boolean removed1 = this.ENDPOINT_SET.remove(e);
        Assert.that(removed1 == (removed2 = this.ENDPOINT_QUEUE.removeAll(e)), "Rep. invariant for HostCatcher broken.");
    }

    public synchronized void expire() {
        this.gWebCache.fetchBootstrapServersAsync();
    }

    public synchronized void clear() {
        this.ENDPOINT_QUEUE.clear();
        this.ENDPOINT_SET.clear();
    }

    public String toString() {
        return "[volatile:" + this.ENDPOINT_QUEUE.toString() + ", permanent:" + this.permanentHosts.toString() + "]";
    }

    public void setAlwaysNotifyKnownHost(boolean notifyKnownHost) {
        this.alwaysNotifyKnownHost = notifyKnownHost;
    }

    protected void repOk() {
    }
}

