/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.IncompleteFileDesc;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.UrnCache;
import com.limegroup.gnutella.downloader.VerifyingFile;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.util.DataUtils;
import com.limegroup.gnutella.util.FileComparator;
import com.limegroup.gnutella.util.FileUtils;
import com.limegroup.gnutella.util.Function;
import com.limegroup.gnutella.util.IntSet;
import com.limegroup.gnutella.util.KeyValue;
import com.limegroup.gnutella.util.StringComparator;
import com.limegroup.gnutella.util.StringUtils;
import com.limegroup.gnutella.util.Trie;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public abstract class FileManager {
    public static final String INDEXING_QUERY = "    ";
    public static final String BROWSE_QUERY = "*.*";
    private long _size;
    private int _numFiles;
    private int _numPendingFiles;
    private int _numIncompleteFiles;
    private List _files;
    private Map _fileToFileDesc;
    private Trie _index;
    private Map _urnIndex;
    private static Set _extensions;
    private Map _sharedDirectories;
    private IntSet _incompletesShared;
    private Thread _loadThread;
    private boolean _loadThreadInterrupted = false;
    private Object _loadThreadLock = new Object();
    public static FilenameFilter SHAREABLE_FILE_FILTER;
    public static FilenameFilter DIRECTORY_FILTER;
    public static final String DELIMETERS = " -._+/*()\\";
    private static boolean debugOn;
    private static final Response[] EMPTY_RESPONSES;
    private boolean DEBUG = false;

    private static final boolean isDelimeter(char c) {
        switch (c) {
            case ' ': 
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case '-': 
            case '.': 
            case '/': 
            case '\\': 
            case '_': {
                return true;
            }
        }
        return false;
    }

    public FileManager() {
        this.resetVariables();
    }

    private void resetVariables() {
        this._size = 0L;
        this._numFiles = 0;
        this._numIncompleteFiles = 0;
        this._numPendingFiles = 0;
        this._files = new ArrayList();
        this._index = new Trie(true);
        this._urnIndex = new HashMap();
        _extensions = new TreeSet(new StringComparator());
        this._sharedDirectories = new TreeMap(new FileComparator());
        this._incompletesShared = new IntSet();
        this._fileToFileDesc = new HashMap();
    }

    public void start() {
        this.loadSettings(false);
    }

    public int getSize() {
        return ByteOrder.long2int(this._size);
    }

    public int getNumFiles() {
        return this._numFiles;
    }

    public int getNumIncompleteFiles() {
        return this._numIncompleteFiles;
    }

    public int getNumPendingFiles() {
        return this._numPendingFiles;
    }

    public synchronized FileDesc get(int i) {
        return (FileDesc)this._files.get(i);
    }

    public synchronized boolean isValidIndex(int i) {
        return i >= 0 && i < this._files.size();
    }

    public synchronized FileDesc getFileDescForFile(File f) {
        try {
            f = FileUtils.getCanonicalFile(f);
        }
        catch (IOException ioe) {
            return null;
        }
        return (FileDesc)this._fileToFileDesc.get(f);
    }

    public synchronized FileDesc getFileDescForUrn(URN urn) {
        IntSet indeces = (IntSet)this._urnIndex.get(urn);
        if (indeces == null) {
            return null;
        }
        IntSet.IntSetIterator iter = indeces.iterator();
        FileDesc ret = null;
        while (iter.hasNext() && (ret == null || ret instanceof IncompleteFileDesc)) {
            int index = iter.next();
            ret = (FileDesc)this._files.get(index);
        }
        return ret;
    }

    public synchronized FileDesc[] getIncompleteFileDescriptors() {
        if (this._incompletesShared == null) {
            return null;
        }
        FileDesc[] ret = new FileDesc[this._incompletesShared.size()];
        IntSet.IntSetIterator iter = this._incompletesShared.iterator();
        int i = 0;
        while (iter.hasNext()) {
            FileDesc fd = (FileDesc)this._files.get(iter.next());
            Assert.that(fd != null, "Directory has null entry");
            ret[i] = fd;
            ++i;
        }
        return ret;
    }

    public synchronized FileDesc[] getAllSharedFileDescriptors() {
        FileDesc[] fds = new FileDesc[this._fileToFileDesc.size()];
        fds = this._fileToFileDesc.values().toArray(fds);
        return fds;
    }

    public synchronized FileDesc[] getSharedFileDescriptors(File directory) {
        if (directory == null) {
            throw new NullPointerException("null directory");
        }
        try {
            directory = FileUtils.getCanonicalFile(directory);
        }
        catch (IOException e) {
            return null;
        }
        IntSet indices = (IntSet)this._sharedDirectories.get(directory);
        if (indices == null) {
            return null;
        }
        FileDesc[] fds = new FileDesc[indices.size()];
        IntSet.IntSetIterator iter = indices.iterator();
        int i = 0;
        while (iter.hasNext()) {
            FileDesc fd = (FileDesc)this._files.get(iter.next());
            Assert.that(fd != null, "Directory has null entry");
            fds[i] = fd;
            ++i;
        }
        return fds;
    }

    public static File[] getFilesRecursive(File directory, String[] filter) {
        FileManager.debug("FileManager.getFilesRecursive(): entered.");
        ArrayList<File> dirs = new ArrayList<File>();
        ArrayList<File> retFileArray = new ArrayList<File>();
        File[] retArray = null;
        if (directory.exists() && directory.isDirectory()) {
            dirs.add(directory);
        }
        while (dirs.size() > 0) {
            File currDir = (File)dirs.remove(0);
            FileManager.debug("FileManager.getFilesRecursive(): currDir = " + currDir);
            String[] listedFiles = currDir.list();
            for (int i = 0; i < listedFiles.length; ++i) {
                File currFile = new File(currDir, listedFiles[i]);
                if (currFile.isDirectory()) {
                    dirs.add(currFile);
                    continue;
                }
                if (!currFile.isFile()) continue;
                boolean shouldAdd = false;
                if (filter == null) {
                    shouldAdd = true;
                } else {
                    String ext = FileUtils.getFileExtension(currFile);
                    for (int j = 0; j < filter.length && ext != null; ++j) {
                        if (!ext.equalsIgnoreCase(filter[j])) continue;
                        shouldAdd = true;
                        break;
                    }
                }
                if (!shouldAdd) continue;
                retFileArray.add(currFile);
            }
        }
        if (!retFileArray.isEmpty()) {
            retArray = new File[retFileArray.size()];
            for (int i = 0; i < retArray.length; ++i) {
                retArray[i] = (File)retFileArray.get(i);
            }
        }
        FileManager.debug("FileManager.getFilesRecursive(): returning.");
        return retArray;
    }

    public static void debug(String out) {
        if (debugOn) {
            System.out.println(out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadSettings(boolean notifyOnClear) {
        Object object = this._loadThreadLock;
        synchronized (object) {
            if (this._loadThread != null) {
                this._loadThreadInterrupted = true;
                this._loadThread.interrupt();
                try {
                    this._loadThread.join();
                }
                catch (InterruptedException e) {
                    return;
                }
            }
            final boolean notifyOnClearFinal = notifyOnClear;
            this._loadThreadInterrupted = false;
            this._loadThread = new Thread("FileManager.loadSettingsBlocking"){

                public void run() {
                    try {
                        FileManager.this.loadSettingsBlocking(notifyOnClearFinal);
                        RouterService.getCallback().fileManagerLoaded();
                    }
                    catch (Throwable t) {
                        ErrorService.error(t);
                    }
                }
            };
            this._loadThread.start();
        }
    }

    protected boolean loadThreadInterrupted() {
        return this._loadThreadInterrupted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadSettingsBlocking(boolean notifyOnClear) {
        File[] tempDirVar;
        FileManager fileManager = this;
        synchronized (fileManager) {
            this.resetVariables();
            String[] extensions = StringUtils.split(SharingSettings.EXTENSIONS_TO_SHARE.getValue(), ";");
            for (int i = 0; i < extensions.length && !this.loadThreadInterrupted(); ++i) {
                _extensions.add(extensions[i].toLowerCase());
            }
            File[] directories = SharingSettings.DIRECTORIES_TO_SHARE.getValue();
            Arrays.sort(directories, new Comparator(){

                public int compare(Object a, Object b) {
                    return a.toString().length() - b.toString().length();
                }
            });
            tempDirVar = directories;
        }
        File[] directories = tempDirVar;
        if (notifyOnClear) {
            RouterService.getCallback().clearSharedFiles();
        }
        LinkedList added = new LinkedList();
        for (int i = 0; i < directories.length && !this.loadThreadInterrupted(); ++i) {
            added.addAll(this.updateDirectories(directories[i], null));
        }
        if (!this.loadThreadInterrupted()) {
            this.updateSharedFiles(added);
        }
        if (!this.loadThreadInterrupted()) {
            this.trim();
        }
        System.err.println("FileManager: Sharing " + this.getNumFiles() + " files ");
        if (!this.loadThreadInterrupted()) {
            RouterService.getDownloadManager().getIncompleteFileManager().registerAllIncompleteFiles();
        }
        UrnCache.instance().persistCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List updateDirectories(File directory, File parent) {
        String name = directory.getName();
        if (name.equals("Incomplete") || name.equals("incomplete")) {
            return new LinkedList();
        }
        try {
            directory = FileUtils.getCanonicalFile(directory);
        }
        catch (IOException e) {
            return DataUtils.EMPTY_LIST;
        }
        if (directory.equals(SharingSettings.INCOMPLETE_DIRECTORY.getValue())) {
            return DataUtils.EMPTY_LIST;
        }
        File[] dir_list = FileUtils.listFiles(directory, DIRECTORY_FILTER);
        File[] file_list = FileUtils.listFiles(directory, SHAREABLE_FILE_FILTER);
        if (dir_list == null && file_list == null) {
            return DataUtils.EMPTY_LIST;
        }
        int numShareable = file_list.length;
        int numSubDirs = dir_list.length;
        FileManager fileManager = this;
        synchronized (fileManager) {
            if (this._sharedDirectories.get(directory) != null) {
                return DataUtils.EMPTY_LIST;
            }
            this._sharedDirectories.put(directory, new IntSet());
            RouterService.getCallback().addSharedDirectory(directory, parent);
            this._numPendingFiles += numShareable;
        }
        LinkedList<KeyValue> added = new LinkedList<KeyValue>();
        added.add(new KeyValue(directory, file_list));
        for (int i = 0; i < numSubDirs && !this.loadThreadInterrupted(); ++i) {
            added.addAll(this.updateDirectories(dir_list[i], directory));
        }
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSharedFiles(List toShare) {
        Iterator i = toShare.iterator();
        while (i.hasNext() && !this.loadThreadInterrupted()) {
            KeyValue info = (KeyValue)i.next();
            File[] shareables = (File[])info.getValue();
            for (int j = 0; j < shareables.length && !this.loadThreadInterrupted(); ++j) {
                this.addFile(shareables[j]);
                FileManager fileManager = this;
                synchronized (fileManager) {
                    --this._numPendingFiles;
                    continue;
                }
            }
            info.setValue((Object)null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileDesc addFileIfShared(File file) {
        boolean directoryShared;
        File f = null;
        try {
            f = FileUtils.getCanonicalFile(file);
            if (!f.exists()) {
                return null;
            }
        }
        catch (IOException e) {
            return null;
        }
        File dir = FileUtils.getParentFile(f);
        if (dir == null) {
            return null;
        }
        FileManager fileManager = this;
        synchronized (fileManager) {
            directoryShared = this._sharedDirectories.containsKey(dir);
            ++this._numPendingFiles;
        }
        FileDesc fd = directoryShared ? this.addFile(f) : null;
        FileManager fileManager2 = this;
        synchronized (fileManager2) {
            --this._numPendingFiles;
        }
        return fd;
    }

    public abstract FileDesc addFileIfShared(File var1, List var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileDesc addFile(File file) {
        this.repOk();
        long fileLength = file.length();
        if (!FileManager.isFileShareable(file, fileLength)) {
            return null;
        }
        Set urns = null;
        try {
            urns = FileDesc.calculateAndCacheURN(file);
        }
        catch (IOException e) {
            return null;
        }
        catch (InterruptedException e) {
            return null;
        }
        if (this.loadThreadInterrupted()) {
            return null;
        }
        if (urns.size() == 0) {
            return null;
        }
        FileManager fileManager = this;
        synchronized (fileManager) {
            this._size += fileLength;
            int fileIndex = this._files.size();
            FileDesc fileDesc = new FileDesc(file, urns, fileIndex);
            this._files.add(fileDesc);
            this._fileToFileDesc.put(file, fileDesc);
            ++this._numFiles;
            File parent = FileUtils.getParentFile(file);
            Assert.that(parent != null, "Null parent to \"" + file + "\"");
            IntSet siblings = (IntSet)this._sharedDirectories.get(parent);
            Assert.that(siblings != null, "Add directory \"" + parent + "\" not in " + this._sharedDirectories);
            boolean added = siblings.add(fileIndex);
            Assert.that(added, "File " + fileIndex + " already found in " + siblings);
            RouterService.getCallback().addSharedFile(fileDesc, parent);
            String[] keywords = StringUtils.split(fileDesc.getPath(), DELIMETERS);
            for (int i = 0; i < keywords.length; ++i) {
                String keyword = keywords[i];
                IntSet indices = (IntSet)this._index.get(keyword);
                if (indices == null) {
                    indices = new IntSet();
                    this._index.add(keyword, indices);
                }
                indices.add(fileIndex);
            }
            this.updateUrnIndex(fileDesc);
            this.repOk();
            return fileDesc;
        }
    }

    public synchronized void addIncompleteFile(File incompleteFile, Set urns, String name, int size, VerifyingFile vf) {
        try {
            incompleteFile = FileUtils.getCanonicalFile(incompleteFile);
        }
        catch (IOException ioe) {
            // empty catch block
        }
        Iterator iter = urns.iterator();
        while (iter.hasNext()) {
            IntSet shared = (IntSet)this._urnIndex.get(iter.next());
            if (shared == null) continue;
            IntSet.IntSetIterator isIter = shared.iterator();
            while (isIter.hasNext()) {
                String path;
                String incPath;
                int i = isIter.next();
                FileDesc desc = (FileDesc)this._files.get(i);
                if (desc == null || !(incPath = incompleteFile.getAbsolutePath()).equals(path = desc.getFile().getAbsolutePath())) continue;
                return;
            }
        }
        int fileIndex = this._files.size();
        this._incompletesShared.add(fileIndex);
        IncompleteFileDesc ifd = new IncompleteFileDesc(incompleteFile, urns, fileIndex, name, size, vf);
        this._files.add(ifd);
        this._fileToFileDesc.put(incompleteFile, ifd);
        this.updateUrnIndex(ifd);
        ++this._numIncompleteFiles;
        File parent = FileUtils.getParentFile(incompleteFile);
        RouterService.getCallback().addSharedFile(ifd, parent);
    }

    private synchronized void updateUrnIndex(FileDesc fileDesc) {
        Iterator iter = fileDesc.getUrns().iterator();
        while (iter.hasNext()) {
            URN urn = (URN)iter.next();
            IntSet indices = (IntSet)this._urnIndex.get(urn);
            if (indices == null) {
                indices = new IntSet();
                this._urnIndex.put(urn, indices);
            }
            indices.add(fileDesc.getIndex());
        }
    }

    public FileDesc fileChanged(File f) {
        FileDesc removed = this.removeFileIfShared(f);
        if (removed == null) {
            return null;
        }
        return this.addFileIfShared(f);
    }

    public synchronized FileDesc removeFileIfShared(File f) {
        this.repOk();
        try {
            f = FileUtils.getCanonicalFile(f);
        }
        catch (IOException e) {
            this.repOk();
            return null;
        }
        FileDesc fd = (FileDesc)this._fileToFileDesc.get(f);
        if (fd == null) {
            return null;
        }
        int i = fd.getIndex();
        Assert.that(((FileDesc)this._files.get(i)).getFile().equals(f), "invariant broken!");
        this._files.set(i, null);
        this._fileToFileDesc.remove(f);
        if (fd instanceof IncompleteFileDesc) {
            this.removeUrnIndex(fd);
            --this._numIncompleteFiles;
            boolean removed = this._incompletesShared.remove(i);
            Assert.that(removed, "File " + i + " not found in " + this._incompletesShared);
            this.repOk();
            return null;
        }
        --this._numFiles;
        this._size -= fd.getSize();
        File parent = FileUtils.getParentFile(f);
        IntSet siblings = (IntSet)this._sharedDirectories.get(parent);
        Assert.that(siblings != null, "Rem directory \"" + parent + "\" not in " + this._sharedDirectories);
        boolean removed = siblings.remove(i);
        Assert.that(removed, "File " + i + " not found in " + siblings);
        String[] keywords = StringUtils.split(fd.getPath(), DELIMETERS);
        for (int j = 0; j < keywords.length; ++j) {
            String keyword = keywords[j];
            IntSet indices = (IntSet)this._index.get(keyword);
            if (indices == null) continue;
            indices.remove(i);
        }
        this.removeUrnIndex(fd);
        this.repOk();
        return fd;
    }

    private synchronized void removeUrnIndex(FileDesc fileDesc) {
        Iterator iter = fileDesc.getUrns().iterator();
        while (iter.hasNext()) {
            URN urn = (URN)iter.next();
            IntSet indices = (IntSet)this._urnIndex.get(urn);
            Assert.that(indices != null, "Invariant broken");
            indices.remove(fileDesc.getIndex());
            if (indices.size() != 0) continue;
            this._urnIndex.remove(urn);
        }
    }

    public synchronized boolean renameFileIfShared(File oldName, File newName) {
        FileDesc fd = this.getFileDescForFile(oldName);
        if (fd == null) {
            return false;
        }
        LinkedList xmlDocs = new LinkedList();
        xmlDocs.addAll(fd.getLimeXMLDocuments());
        fd = this.removeFileIfShared(oldName);
        Assert.that(fd != null, "invariant broken.");
        fd = this.addFileIfShared(newName, xmlDocs);
        return fd != null;
    }

    private synchronized void trim() {
        this._index.trim(new Function(){

            public Object apply(Object intSet) {
                ((IntSet)intSet).trim();
                return intSet;
            }
        });
    }

    private static boolean hasExtension(String filename) {
        int begin = filename.lastIndexOf(".");
        if (begin == -1) {
            return false;
        }
        String ext = filename.substring(begin + 1).toLowerCase();
        return _extensions.contains(ext);
    }

    public static boolean isFileShareable(File file, long fileLength) {
        if (fileLength > Integer.MAX_VALUE || fileLength <= 0L) {
            return false;
        }
        if (file.isDirectory() || !file.canRead()) {
            return false;
        }
        return file.getName().toUpperCase().startsWith("LIMEWIRE") || FileManager.hasExtension(file.getName());
    }

    public List getKeyWords() {
        FileDesc[] fds = this.getAllSharedFileDescriptors();
        ArrayList<String> retList = new ArrayList<String>();
        for (int i = 0; i < fds.length; ++i) {
            retList.add(fds[i].getFile().getAbsolutePath());
        }
        return retList;
    }

    public List getIndivisibleKeyWords() {
        return new ArrayList();
    }

    public synchronized Response[] query(QueryRequest request) {
        String str = request.getQuery();
        boolean includeXML = this.shouldIncludeXMLInResponse(request);
        if (str.equals(INDEXING_QUERY) || str.equals(BROWSE_QUERY)) {
            if (this._numFiles == 0) {
                return EMPTY_RESPONSES;
            }
            Response[] ret = new Response[this._numFiles];
            int j = 0;
            for (int i = 0; i < this._files.size(); ++i) {
                FileDesc desc = (FileDesc)this._files.get(i);
                if (desc == null || desc instanceof IncompleteFileDesc) continue;
                Assert.that(j < ret.length, "_numFiles is too small");
                ret[j] = new Response(desc);
                if (includeXML) {
                    this.addXMLToResponse(ret[j], desc);
                }
                ++j;
            }
            Assert.that(j == ret.length, "_numFiles is too large");
            return ret;
        }
        IntSet matches = null;
        str = this._index.canonicalCase(str);
        matches = this.search(str, matches);
        if (request.getQueryUrns().size() > 0) {
            matches = this.urnSearch(request.getQueryUrns().iterator(), matches);
        }
        if (matches == null) {
            return EMPTY_RESPONSES;
        }
        LinkedList<Response> responses = new LinkedList<Response>();
        boolean busy = RouterService.getUploadManager().isBusy() && RouterService.getUploadManager().isQueueFull();
        IntSet.IntSetIterator iter = matches.iterator();
        while (iter.hasNext()) {
            int i = iter.next();
            FileDesc desc = (FileDesc)this._files.get(i);
            if (desc == null) {
                Assert.that(false, "unexpected null in FileManager for query:\n" + request);
            }
            if (busy && desc.getNumberOfAlternateLocations() >= 10) continue;
            desc.incrementHitCount();
            RouterService.getCallback().handleSharedFileUpdate(desc.getFile());
            Response resp = new Response(desc);
            if (includeXML) {
                this.addXMLToResponse(resp, desc);
            }
            responses.add(resp);
        }
        return responses.toArray(new Response[responses.size()]);
    }

    protected abstract boolean shouldIncludeXMLInResponse(QueryRequest var1);

    protected abstract void addXMLToResponse(Response var1, FileDesc var2);

    protected IntSet search(String query, IntSet priors) {
        IntSet ret = priors;
        int i = 0;
        while (i < query.length()) {
            int j;
            if (FileManager.isDelimeter(query.charAt(i))) {
                ++i;
                continue;
            }
            for (j = i + 1; j < query.length() && !FileManager.isDelimeter(query.charAt(j)); ++j) {
            }
            Iterator iter = this._index.getPrefixedBy(query, i, j);
            if (iter.hasNext()) {
                IntSet matches = null;
                while (iter.hasNext()) {
                    IntSet s = (IntSet)iter.next();
                    if (matches == null) {
                        if (i == 0 && j == query.length() && !iter.hasNext()) {
                            return s;
                        }
                        matches = new IntSet();
                    }
                    matches.addAll(s);
                }
                if (ret == null) {
                    ret = matches;
                } else {
                    ret.retainAll(matches);
                }
            } else {
                return null;
            }
            if (ret.size() == 0) {
                return null;
            }
            i = j;
        }
        if (ret == null || ret.size() == 0) {
            return null;
        }
        return ret;
    }

    private synchronized IntSet urnSearch(Iterator urnsIter, IntSet priors) {
        IntSet ret = priors;
        while (urnsIter.hasNext()) {
            URN urn = (URN)urnsIter.next();
            IntSet hits = (IntSet)this._urnIndex.get(urn);
            if (hits == null) continue;
            IntSet.IntSetIterator iter = hits.iterator();
            while (iter.hasNext()) {
                FileDesc fd = (FileDesc)this._files.get(iter.next());
                if (fd == null || fd instanceof IncompleteFileDesc || !fd.containsUrn(urn)) continue;
                if (ret == null) {
                    ret = new IntSet();
                }
                ret.add(fd.getIndex());
            }
        }
        return ret;
    }

    protected synchronized void repOk() {
        FileDesc fd;
        int i;
        IntSet.IntSetIterator iter2;
        if (!this.DEBUG) {
            return;
        }
        System.err.println("WARNING: running repOk()");
        IntSet indices = new IntSet();
        Iterator<Object> iter = this._index.getPrefixedBy("");
        while (iter.hasNext()) {
            IntSet set = (IntSet)iter.next();
            indices.addAll(set);
        }
        iter = indices.iterator();
        while (((IntSet.IntSetIterator)((Object)iter)).hasNext()) {
            int i2 = ((IntSet.IntSetIterator)((Object)iter)).next();
            FileDesc desc = (FileDesc)this._files.get(i2);
            Assert.that(desc != null, "Null entry for index value " + i2);
        }
        iter = this._urnIndex.keySet().iterator();
        while (iter.hasNext()) {
            URN urn = (URN)iter.next();
            IntSet indices2 = (IntSet)this._urnIndex.get(urn);
            iter2 = indices2.iterator();
            while (iter2.hasNext()) {
                i = iter2.next();
                fd = (FileDesc)this._files.get(i);
                Assert.that(fd != null, "Missing file for urn");
                Assert.that(fd.containsUrn(urn), "URN mismatch");
            }
        }
        iter = this._sharedDirectories.keySet().iterator();
        while (iter.hasNext()) {
            File directory = (File)iter.next();
            IntSet children = (IntSet)this._sharedDirectories.get(directory);
            iter2 = children.iterator();
            while (iter2.hasNext()) {
                i = iter2.next();
                Assert.that(i >= 0 && i < this._files.size(), "Bad index " + i + " in directory");
                fd = (FileDesc)this._files.get(i);
                Assert.that(fd != null, "Directory listing points to empty file");
            }
        }
        int numFilesCount = 0;
        int sizeFilesCount = 0;
        for (int i3 = 0; i3 < this._files.size(); ++i3) {
            if (this._files.get(i3) == null) continue;
            FileDesc desc = (FileDesc)this._files.get(i3);
            ++numFilesCount;
            sizeFilesCount = (int)((long)sizeFilesCount + desc.getSize());
            Assert.that(desc.getIndex() == i3, "Bad index value.  Got " + desc.getIndex() + " not " + i3);
            Assert.that(indices.contains(i3), "Index does not contain entry for " + i3);
            try {
                IntSet siblings = (IntSet)this._sharedDirectories.get(FileUtils.getCanonicalFile(FileUtils.getParentFile(desc.getFile())));
                Assert.that(siblings != null, "Directory for " + desc.getPath() + " isn't shared");
                Assert.that(siblings.contains(i3), "Index " + i3 + " not in directory");
            }
            catch (IOException e) {
                Assert.that(false);
            }
            iter = desc.getUrns().iterator();
            while (iter.hasNext()) {
                URN urn = (URN)iter.next();
                IntSet indices2 = (IntSet)this._urnIndex.get(urn);
                Assert.that(indices2 != null, "Urn not found");
                Assert.that(indices2.contains(desc.getIndex()));
            }
        }
        Assert.that(this._numFiles == numFilesCount, this._numFiles + " should be " + numFilesCount);
        Assert.that(this._size == (long)sizeFilesCount, this._size + " should be " + sizeFilesCount);
    }

    static {
        SHAREABLE_FILE_FILTER = new ShareableFileFilter();
        DIRECTORY_FILTER = new DirectoryFilter();
        debugOn = false;
        EMPTY_RESPONSES = new Response[0];
    }

    private static class DirectoryFilter
    implements FilenameFilter {
        private DirectoryFilter() {
        }

        public boolean accept(File dir, String name) {
            File f = new File(dir, name);
            return f.isDirectory();
        }
    }

    private static class ShareableFileFilter
    implements FilenameFilter {
        private ShareableFileFilter() {
        }

        public boolean accept(File dir, String name) {
            File f = new File(dir, name);
            return FileManager.isFileShareable(f, f.length());
        }
    }
}

