/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.ManagedConnection;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.messages.PingRequest;
import com.limegroup.gnutella.settings.ConnectionSettings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public final class ConnectionWatchdog
implements Runnable {
    private static final ConnectionWatchdog INSTANCE = new ConnectionWatchdog();
    private static final int EVALUATE_TIME = 10000;
    private static final int REEVALUATE_TIME = 8000;

    public static ConnectionWatchdog instance() {
        return INSTANCE;
    }

    private ConnectionWatchdog() {
    }

    public void start() {
        Thread watchdog = new Thread((Runnable)this, "ConnectionWatchdog");
        watchdog.setDaemon(true);
        watchdog.start();
    }

    private List findDuds() {
        HashMap<ManagedConnection, ConnectionState> snapshot = new HashMap<ManagedConnection, ConnectionState>();
        Iterator iter = this.allConnections();
        while (iter.hasNext()) {
            ManagedConnection c = (ManagedConnection)iter.next();
            if (!c.isKillable()) continue;
            snapshot.put(c, new ConnectionState(c));
        }
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        ArrayList<ManagedConnection> ret = new ArrayList<ManagedConnection>();
        Iterator iter2 = this.allConnections();
        while (iter2.hasNext()) {
            ConnectionState oldState;
            ConnectionState currentState;
            Object state;
            ManagedConnection c = (ManagedConnection)iter2.next();
            if (!c.isKillable() || (state = snapshot.get(c)) == null || !(currentState = new ConnectionState(c)).notProgressedSince(oldState = (ConnectionState)state)) continue;
            ret.add(c);
        }
        return ret;
    }

    private void killIfStillDud(List connections) {
        ManagedConnection c;
        HashMap<ManagedConnection, ConnectionState> snapshot = new HashMap<ManagedConnection, ConnectionState>();
        Iterator iter = connections.iterator();
        while (iter.hasNext()) {
            c = (ManagedConnection)iter.next();
            if (!c.isKillable()) continue;
            snapshot.put(c, new ConnectionState(c));
            c.setHorizonEnabled(false);
            RouterService.getMessageRouter().sendPingRequest(new PingRequest(1), c);
        }
        try {
            Thread.sleep(8000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        iter = connections.iterator();
        while (iter.hasNext()) {
            ConnectionState oldState;
            ConnectionState currentState;
            c = (ManagedConnection)iter.next();
            if (!c.isKillable()) continue;
            c.setHorizonEnabled(true);
            Object state = snapshot.get(c);
            if (state == null || !(currentState = new ConnectionState(c)).notProgressedSince(oldState = (ConnectionState)state)) continue;
            RouterService.removeConnection(c);
        }
    }

    public void run() {
        if (!ConnectionSettings.WATCHDOG_ACTIVE.getValue()) {
            return;
        }
        try {
            while (true) {
                List duds;
                if ((duds = this.findDuds()).size() <= 0) {
                    continue;
                }
                this.killIfStillDud(duds);
            }
        }
        catch (Throwable t) {
            ErrorService.error(t);
            return;
        }
    }

    private Iterator allConnections() {
        List normal = RouterService.getConnectionManager().getInitializedConnections();
        List leaves = RouterService.getConnectionManager().getInitializedClientConnections();
        ArrayList buf = new ArrayList(normal.size() + leaves.size());
        buf.addAll(normal);
        buf.addAll(leaves);
        return buf.iterator();
    }

    private static class ConnectionState {
        final long sentDropped;
        final long sent;
        final long received;

        ConnectionState(ManagedConnection c) {
            this.sentDropped = c.getNumSentMessagesDropped();
            this.sent = c.getNumMessagesSent();
            this.received = c.getNumMessagesReceived();
        }

        boolean notProgressedSince(ConnectionState old) {
            long numSent = this.sent - old.sent;
            long numSentDropped = this.sentDropped - old.sentDropped;
            long numReceived = this.received - old.received;
            if (numSent == numSentDropped && numSent != 0L) {
                return true;
            }
            return numReceived == 0L;
        }

        public String toString() {
            return "{sent: " + this.sent + ", sdropped: " + this.sentDropped + "}";
        }
    }
}

