/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ByteOrder {
    public static byte[] reverse(byte[] x) {
        int n = x.length;
        byte[] ret = new byte[n];
        for (int i = 0; i < n; ++i) {
            ret[i] = x[n - i - 1];
        }
        return ret;
    }

    public static short leb2short(byte[] x, int offset) {
        int x0 = x[offset] & 0xFF;
        int x1 = x[offset + 1] << 8;
        return (short)(x1 | x0);
    }

    public static short leb2short(InputStream is) throws IOException {
        int x0 = is.read() & 0xFF;
        int x1 = is.read() << 8;
        return (short)(x1 | x0);
    }

    public static int leb2int(byte[] x, int offset) {
        int x0 = x[offset] & 0xFF;
        int x1 = x[offset + 1] << 8 & 0xFF00;
        int x2 = x[offset + 2] << 16 & 0xFF0000;
        int x3 = x[offset + 3] << 24;
        return x3 | x2 | x1 | x0;
    }

    public static int leb2int(InputStream is) throws IOException {
        int x0 = is.read() & 0xFF;
        int x1 = is.read() << 8 & 0xFF00;
        int x2 = is.read() << 16 & 0xFF0000;
        int x3 = is.read() << 24;
        return x3 | x2 | x1 | x0;
    }

    public static int leb2int(byte[] x, int offset, int n) throws IndexOutOfBoundsException, IllegalArgumentException {
        if (n < 1 || n > 4) {
            throw new IllegalArgumentException("No bytes specified");
        }
        int x0 = x[offset] & 0xFF;
        int x1 = 0;
        int x2 = 0;
        int x3 = 0;
        if (n > 1) {
            x1 = x[offset + 1] << 8 & 0xFF00;
            if (n > 2) {
                x2 = x[offset + 2] << 16 & 0xFF0000;
                if (n > 3) {
                    x3 = x[offset + 3] << 24;
                }
            }
        }
        return x3 | x2 | x1 | x0;
    }

    public static void short2leb(short x, byte[] buf, int offset) {
        buf[offset] = (byte)(x & 0xFF);
        buf[offset + 1] = (byte)((short)(x >> 8) & 0xFF);
    }

    public static void short2leb(short x, OutputStream os) throws IOException {
        os.write((byte)(x & 0xFF));
        os.write((byte)((short)(x >> 8) & 0xFF));
    }

    public static void int2leb(int x, byte[] buf, int offset) {
        buf[offset] = (byte)(x & 0xFF);
        buf[offset + 1] = (byte)(x >> 8 & 0xFF);
        buf[offset + 2] = (byte)(x >> 16 & 0xFF);
        buf[offset + 3] = (byte)(x >> 24 & 0xFF);
    }

    public static void int2leb(int x, OutputStream os) throws IOException {
        os.write((byte)(x & 0xFF));
        os.write((byte)(x >> 8 & 0xFF));
        os.write((byte)(x >> 16 & 0xFF));
        os.write((byte)(x >> 24 & 0xFF));
    }

    public static byte[] int2minLeb(int x) throws IllegalArgumentException {
        if (x < 0) {
            throw new IllegalArgumentException();
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4);
        do {
            baos.write(x & 0xFF);
        } while ((x >>= 8) != 0);
        return baos.toByteArray();
    }

    public static int ubyte2int(byte x) {
        return x & 0xFF;
    }

    public static int ubytes2int(short x) {
        return x & 0xFFFF;
    }

    public static long ubytes2long(int x) {
        return (long)x & 0xFFFFFFFFL;
    }

    public static int long2int(long l) {
        if (l >= Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (l <= Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return (int)l;
    }
}

