/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.ByteReader;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.util.Sockets;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class BrowseHostHandler {
    private static final long EXPIRE_TIME = 9000L;
    private static final int SPECIAL_INDEX = 0;
    private static Map _pushedHosts = new HashMap();
    private ActivityCallback _callback = null;
    private GUID _guid = null;
    private GUID _serventID = null;
    private static final boolean debugOn = false;

    public BrowseHostHandler(ActivityCallback callback, GUID guid, GUID serventID) {
        this._callback = callback;
        this._guid = guid;
        this._serventID = serventID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void browseHost(String host, int port, Set proxies) {
        System.err.println("BrowseHostHandler: browseHost: " + host + ":" + port);
        int shouldPush = BrowseHostHandler.needsPush(host);
        boolean shouldTryPush = false;
        switch (shouldPush) {
            case 0: {
                try {
                    Socket socket = Sockets.connect(host, port, 0);
                    this.browseExchange(socket);
                }
                catch (IOException ioe) {
                    shouldTryPush = true;
                }
                if (!shouldTryPush) break;
            }
            case 1: {
                if (this._serventID == null) {
                    this._callback.browseHostFailed(this._guid);
                    break;
                }
                RemoteFileDesc fakeRFD = new RemoteFileDesc(host, port, 0L, "fake", 0, this._serventID.bytes(), 0, false, 0, false, null, null, false, false, "", 0L, proxies);
                Map map = _pushedHosts;
                synchronized (map) {
                    _pushedHosts.put(this._serventID, new PushRequestDetails(this));
                }
                if (RouterService.getDownloadManager().sendPush(fakeRFD)) break;
                map = _pushedHosts;
                synchronized (map) {
                    _pushedHosts.remove(this._serventID);
                }
                this._callback.browseHostFailed(this._guid);
            }
        }
    }

    private void browseExchange(Socket socket) throws IOException {
        BrowseHostHandler.debug("BHH.browseExchange(): entered.");
        String LF = "\r\n";
        String str = null;
        OutputStream oStream = socket.getOutputStream();
        BrowseHostHandler.debug("BHH.browseExchange(): got output stream.");
        str = "GET / HTTP/1.1\r\n";
        oStream.write(str.getBytes());
        str = "Host: " + NetworkUtils.ip2string(RouterService.getAddress()) + ":" + RouterService.getPort() + "\r\n";
        oStream.write(str.getBytes());
        str = "User-Agent: " + CommonUtils.getVendor() + "\r\n";
        oStream.write(str.getBytes());
        str = "Accept: application/x-gnutella-packets\r\n";
        oStream.write(str.getBytes());
        str = "Content-Length: 0\r\n";
        oStream.write(str.getBytes());
        str = "Connection: close\r\n";
        oStream.write(str.getBytes());
        str = "\r\n";
        oStream.write(str.getBytes());
        oStream.flush();
        BrowseHostHandler.debug("BHH.browseExchange(): wrote request A-OK.");
        InputStream in = socket.getInputStream();
        BrowseHostHandler.debug("BHH.browseExchange(): got input stream.");
        ByteReader br = new ByteReader(in);
        BrowseHostHandler.debug("BHH.browseExchange(): trying to get HTTP code....");
        int code = BrowseHostHandler.parseHTTPCode(br.readLine());
        if (code < 200 || code >= 300) {
            throw new IOException();
        }
        BrowseHostHandler.debug("BHH.browseExchange(): HTTP Response is " + code);
        boolean readingHTTP = true;
        String currLine = null;
        while (readingHTTP) {
            currLine = br.readLine();
            BrowseHostHandler.debug("BHH.browseExchange(): currLine = " + currLine);
            if (currLine == null || currLine.equals("")) {
                readingHTTP = false;
                continue;
            }
            if (this.indexOfIgnoreCase(currLine, "Server") > -1 || !(this.indexOfIgnoreCase(currLine, "Content-Type") > -1 ? this.indexOfIgnoreCase(currLine, "application/x-gnutella-packets") < 0 : this.indexOfIgnoreCase(currLine, "Content-Encoding") > -1)) continue;
            throw new IOException();
        }
        BrowseHostHandler.debug("BHH.browseExchange(): read HTTP seemingly OK.");
        Message m = null;
        while (true) {
            try {
                m = null;
                m = Message.read(in);
            }
            catch (BadPacketException bpe) {
            }
            catch (IOException bpe) {
                // empty catch block
            }
            if (m == null) {
                return;
            }
            if (!(m instanceof QueryReply)) continue;
            BrowseHostHandler.debug("BHH.browseExchange(): read a QR");
            QueryReply reply = (QueryReply)m;
            reply.setGUID(this._guid);
            RouterService.getSearchResultHandler().handleQueryReply(reply);
        }
    }

    private static int needsPush(String host) {
        try {
            if (ConnectionSettings.LOCAL_IS_PRIVATE.getValue() && NetworkUtils.isPrivateAddress(host)) {
                return 1;
            }
        }
        catch (UnknownHostException e) {
            return 0;
        }
        return 0;
    }

    private int indexOfIgnoreCase(String str, String section) {
        String aaa = str.toLowerCase();
        String bbb = section.toLowerCase();
        return aaa.indexOf(bbb);
    }

    private static int parseHTTPCode(String str) throws IOException {
        if (str == null) {
            return -1;
        }
        StringTokenizer tokenizer = new StringTokenizer(str, " ");
        if (!tokenizer.hasMoreTokens()) {
            throw new IOException();
        }
        String token = tokenizer.nextToken();
        if (token.toUpperCase().indexOf("HTTP") < 0) {
            throw new IOException();
        }
        if (!tokenizer.hasMoreTokens()) {
            throw new IOException();
        }
        token = tokenizer.nextToken();
        String num = token.trim();
        try {
            BrowseHostHandler.debug("BHH.parseHTTPCode(): returning " + num);
            return Integer.parseInt(num);
        }
        catch (NumberFormatException e) {
            throw new IOException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean handlePush(int index, GUID serventID, Socket socket) throws IOException {
        boolean retVal = false;
        BrowseHostHandler.debug("BHH.handlePush(): entered.");
        if (index == 0) {
            // empty if block
        }
        PushRequestDetails prd = null;
        Map map = _pushedHosts;
        synchronized (map) {
            prd = (PushRequestDetails)_pushedHosts.remove(serventID);
        }
        if (prd != null) {
            prd.bhh.browseExchange(socket);
            retVal = true;
        } else {
            BrowseHostHandler.debug("BHH.handlePush(): no matching BHH.");
        }
        BrowseHostHandler.debug("BHH.handlePush(): returning.");
        return retVal;
    }

    private static final void debug(String out) {
    }

    private static final void debug(Exception out) {
    }

    static {
        Expirer expirer = new Expirer();
        RouterService.schedule(expirer, 0L, 5000L);
    }

    private static class PushRequestDetails {
        private BrowseHostHandler bhh;
        private long timeStamp = System.currentTimeMillis();

        public PushRequestDetails(BrowseHostHandler bhh) {
            this.bhh = bhh;
        }

        public boolean isExpired() {
            return System.currentTimeMillis() - this.timeStamp > 9000L;
        }
    }

    private static class Expirer
    implements Runnable {
        private Expirer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Iterator<Object> keys = null;
                HashSet toRemove = new HashSet();
                Map map = _pushedHosts;
                synchronized (map) {
                    keys = _pushedHosts.keySet().iterator();
                    while (keys.hasNext()) {
                        Object currKey = keys.next();
                        PushRequestDetails currPRD = null;
                        currPRD = (PushRequestDetails)_pushedHosts.get(currKey);
                        if (currPRD == null || !currPRD.isExpired()) continue;
                        BrowseHostHandler.debug("Expirer.run(): expiring a badboy.");
                        toRemove.add(currKey);
                        currPRD.bhh._callback.browseHostFailed(currPRD.bhh._guid);
                    }
                    keys = toRemove.iterator();
                    while (keys.hasNext()) {
                        _pushedHosts.remove(keys.next());
                    }
                }
            }
            catch (Throwable t) {
                ErrorService.error(t);
            }
        }
    }
}

