/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.AlternateLocation;
import com.limegroup.gnutella.AlternateLocationCollector;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.http.HTTPHeaderValue;
import com.limegroup.gnutella.util.FixedsizeForgetfulHashMap;
import com.limegroup.gnutella.util.Random12;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;

public final class AlternateLocationCollection
implements HTTPHeaderValue,
AlternateLocationCollector {
    private static final int MAX_LOCATIONS = 100;
    private static final int MAX_REMOVED = 500;
    private static final long DAY = 86400000L;
    private static final long FIVEHOURS = 18000000L;
    private static final long ONEHOUR = 3600000L;
    private static final long HALFHOUR = 1800000L;
    private final Map _locations = new FixedsizeForgetfulHashMap(100);
    private final Map LOCATIONS = Collections.synchronizedMap(this._locations);
    private final Map REMOVED = Collections.synchronizedMap(new FixedsizeForgetfulHashMap(500));
    private final URN SHA1;
    private static final Random12 random12 = new Random12();
    static /* synthetic */ Class class$com$limegroup$gnutella$AlternateLocationCollection;

    public static AlternateLocationCollection createCollection(URN sha1) {
        return new AlternateLocationCollection(sha1);
    }

    public static AlternateLocationCollection createCollectionFromHttpValue(String value) {
        if (value == null) {
            throw new NullPointerException("cannot create an AlternateLocationCollection from a null value");
        }
        StringTokenizer st = new StringTokenizer(value, ",");
        AlternateLocationCollection alc = null;
        while (st.hasMoreTokens()) {
            String curTok = st.nextToken();
            try {
                AlternateLocation al = AlternateLocation.createAlternateLocation(curTok);
                if (alc == null) {
                    alc = new AlternateLocationCollection(al.getSHA1Urn());
                }
                if (!al.getSHA1Urn().equals(alc.getSHA1Urn())) continue;
                alc.addAlternateLocation(al);
            }
            catch (IOException e) {}
        }
        return alc;
    }

    private AlternateLocationCollection(URN sha1) {
        if (sha1 == null) {
            throw new NullPointerException("null URN");
        }
        if (sha1 != null && !sha1.isSHA1()) {
            throw new IllegalArgumentException("URN must be a SHA1");
        }
        this.SHA1 = sha1;
    }

    public URN getSHA1Urn() {
        return this.SHA1;
    }

    public URN getSHA1() {
        return this.SHA1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAlternateLocation(AlternateLocation al) {
        URN sha1 = al.getSHA1Urn();
        if (!sha1.equals(this.SHA1)) {
            throw new IllegalArgumentException("SHA1 does not match");
        }
        Map map = this.LOCATIONS;
        synchronized (map) {
            if (!this.isValidTime(al.getTime())) {
                return false;
            }
            if (this.wasRemoved(al)) {
                return false;
            }
            AlternateLocation toUpdate = (AlternateLocation)this.LOCATIONS.get(al);
            if (toUpdate == null || toUpdate != null && toUpdate.compareTo(al) > 0) {
                this.LOCATIONS.put(al, al);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isValidTime(long alTime) {
        Map map = this.LOCATIONS;
        synchronized (map) {
            long now = System.currentTimeMillis();
            int size = this.LOCATIONS.size() + this.REMOVED.size();
            long diff = now - alTime;
            if (size <= 25) {
                return true;
            }
            if (size <= 75) {
                return diff <= 86400000L;
            }
            if (size <= 150) {
                return diff <= 18000000L;
            }
            if (size <= 300) {
                return diff <= 3600000L;
            }
            return diff <= 1800000L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAlternateLocation(AlternateLocation al) {
        URN sha1 = al.getSHA1Urn();
        if (!sha1.equals(this.SHA1)) {
            return false;
        }
        Map map = this.LOCATIONS;
        synchronized (map) {
            this.REMOVED.put(al, al);
            return this.LOCATIONS.remove(al) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean wasRemoved(AlternateLocation al) {
        URN sha1 = al.getSHA1Urn();
        if (!sha1.equals(this.SHA1)) {
            return false;
        }
        Map map = this.LOCATIONS;
        synchronized (map) {
            AlternateLocation removed = (AlternateLocation)this.REMOVED.get(al);
            if (removed == null) {
                return false;
            }
            if (removed.compareTo(al) > 0) {
                this.REMOVED.remove(al);
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addAlternateLocationCollection(AlternateLocationCollection alc) {
        if (alc == null) {
            throw new NullPointerException("ALC is null");
        }
        if (!alc.getSHA1Urn().equals(this.SHA1)) {
            throw new IllegalArgumentException("SHA1 does not match");
        }
        int added = 0;
        Map map = alc.LOCATIONS;
        synchronized (map) {
            Iterator iter = alc.LOCATIONS.keySet().iterator();
            while (iter.hasNext()) {
                AlternateLocation curLoc = (AlternateLocation)iter.next();
                if (!this.addAlternateLocation(curLoc)) continue;
                ++added;
            }
        }
        return added;
    }

    public boolean hasAlternateLocations() {
        return !this.LOCATIONS.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AlternateLocationCollection diffAlternateLocationCollection(AlternateLocationCollection alc) {
        if (alc == null) {
            throw new NullPointerException("alc is null");
        }
        AlternateLocationCollection nalc = new AlternateLocationCollection(this.SHA1);
        Map map = alc.LOCATIONS;
        synchronized (map) {
            Iterator iter = alc.LOCATIONS.keySet().iterator();
            while (iter.hasNext()) {
                AlternateLocation value = (AlternateLocation)iter.next();
                if (this.LOCATIONS.containsKey(value) || this.wasRemoved(value) || !this.isValidTime(value.getTime())) continue;
                nalc.addAlternateLocation(value);
            }
        }
        return nalc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection values() {
        ArrayList list;
        Map map = this.LOCATIONS;
        synchronized (map) {
            list = new ArrayList(this.LOCATIONS.keySet());
        }
        Collections.shuffle(list);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String httpStringValue() {
        String commaSpace = ", ";
        StringBuffer writeBuffer = new StringBuffer();
        boolean wrote = false;
        Map map = this.LOCATIONS;
        synchronized (map) {
            int i;
            Iterator iter = this.LOCATIONS.keySet().iterator();
            int start = random12.nextInt(this.LOCATIONS.size());
            start = Math.max(0, start - 10);
            for (i = 0; i < start; ++i) {
                iter.next();
            }
            for (i = 0; i < start + 10 && iter.hasNext(); ++i) {
                writeBuffer.append(((HTTPHeaderValue)iter.next()).httpStringValue());
                writeBuffer.append(", ");
                wrote = true;
            }
        }
        if (wrote) {
            writeBuffer.setLength(writeBuffer.length() - 2);
        }
        return writeBuffer.toString();
    }

    public int getNumberOfAlternateLocations() {
        return this.LOCATIONS.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Alternate Locations: ");
        Map map = this.LOCATIONS;
        synchronized (map) {
            Iterator iter = this.LOCATIONS.keySet().iterator();
            while (iter.hasNext()) {
                AlternateLocation curLoc = (AlternateLocation)iter.next();
                sb.append(curLoc.toString());
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AlternateLocationCollection)) {
            return false;
        }
        AlternateLocationCollection alc = (AlternateLocationCollection)o;
        boolean ret = this.SHA1.equals(alc.SHA1);
        if (!ret) {
            return false;
        }
        Class clazz = class$com$limegroup$gnutella$AlternateLocationCollection == null ? (class$com$limegroup$gnutella$AlternateLocationCollection = AlternateLocationCollection.class$("com.limegroup.gnutella.AlternateLocationCollection")) : class$com$limegroup$gnutella$AlternateLocationCollection;
        synchronized (clazz) {
            ret = ((Object)this._locations).equals(alc._locations);
        }
        return ret;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

