/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.http.HTTPHeaderValue;
import com.limegroup.gnutella.util.NetworkUtils;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.StringTokenizer;
import java.util.TimeZone;

public final class AlternateLocation
implements Comparable,
HTTPHeaderValue {
    private final URL URL;
    private final String OUTPUT_DATE_TIME;
    private final long TIME;
    private final URN SHA1_URN;
    private volatile int hashCode = 0;
    private static final byte[] EMPTY_GUID = new byte[16];

    public static AlternateLocation createAlternateLocation(String location) throws IOException {
        if (location == null || location.equals("")) {
            throw new IOException("null or empty in alt loc: " + location);
        }
        URL url = AlternateLocation.createUrl(location);
        if (url == null) {
            throw new IOException("could not parse url for alt loc: " + location);
        }
        if (!NetworkUtils.isValidPort(url.getPort())) {
            throw new IOException("invalid port.");
        }
        String outputDateTime = AlternateLocation.extractTimestamp(location);
        Date date = outputDateTime == null ? new Date(0L) : AlternateLocation.createDateInstance(outputDateTime);
        URN sha1 = null;
        try {
            sha1 = URN.createSHA1UrnFromURL(url);
        }
        catch (IOException e) {
            throw new IOException("no SHA1 in url: " + url);
        }
        return new AlternateLocation(url, date, sha1);
    }

    public static AlternateLocation createAlternateLocation(URL url) throws MalformedURLException, IOException {
        if (url == null) {
            throw new NullPointerException("cannot accept null URL");
        }
        if (!NetworkUtils.isValidPort(url.getPort())) {
            throw new IllegalArgumentException("invalid port: " + url.getPort());
        }
        URL tempUrl = new URL(url.getProtocol(), url.getHost(), url.getPort(), url.getFile());
        Date date = new Date();
        URN sha1 = null;
        try {
            sha1 = URN.createSHA1UrnFromURL(tempUrl);
        }
        catch (IOException e) {
            throw new IOException("no SHA1 in url: " + url);
        }
        return new AlternateLocation(tempUrl, date, sha1);
    }

    public static AlternateLocation createAlternateLocation(RemoteFileDesc rfd) throws IOException {
        if (rfd == null) {
            throw new NullPointerException("cannot accept null RFD");
        }
        URN urn = rfd.getSHA1Urn();
        if (urn == null) {
            throw new IOException("no SHA1 in RFD");
        }
        int port = rfd.getPort();
        if (!NetworkUtils.isValidPort(port)) {
            throw new IllegalArgumentException("invalid port: " + port);
        }
        InetAddress address = InetAddress.getByName(rfd.getHost());
        if (NetworkUtils.isPrivateAddress(address.getAddress())) {
            throw new IOException("cannot accept private addresses: " + address.getAddress());
        }
        URL url = new URL("http", rfd.getHost(), port, "/uri-res/N2R?" + urn.httpStringValue());
        return new AlternateLocation(url, new Date(), urn);
    }

    public static AlternateLocation createAlternateLocation(URN urn) throws IOException {
        if (urn == null) {
            throw new NullPointerException("null sha1");
        }
        URL url = new URL("http", NetworkUtils.ip2string(RouterService.getAddress()), RouterService.getPort(), "/uri-res/N2R?" + urn.httpStringValue());
        return new AlternateLocation(url, new Date(), urn);
    }

    private AlternateLocation(URL url, Date date, URN sha1) {
        this.URL = url;
        this.TIME = date.getTime();
        this.SHA1_URN = sha1;
        this.OUTPUT_DATE_TIME = this.TIME == 0L ? null : AlternateLocation.convertDateToString(date);
    }

    public URL getUrl() {
        try {
            return new URL(this.URL.getProtocol(), this.URL.getHost(), this.URL.getPort(), this.URL.getFile());
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public URN getSHA1Urn() {
        return this.SHA1_URN;
    }

    public long getTime() {
        return this.TIME;
    }

    private static String convertDateToString(Date date) {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        cal.setTime(date);
        int[] dateInts = new int[6];
        String[] dateStrs = new String[6];
        dateInts[0] = cal.get(1);
        dateInts[1] = cal.get(2) + 1;
        dateInts[2] = cal.get(5);
        dateInts[3] = cal.get(10);
        dateInts[4] = cal.get(12);
        dateInts[5] = cal.get(13);
        for (int i = 0; i < dateInts.length; ++i) {
            dateStrs[i] = dateInts[i] < 10 ? "0" + String.valueOf(dateInts[i]) : String.valueOf(dateInts[i]);
        }
        String DASH = "-";
        String COLON = ":";
        StringBuffer sb = new StringBuffer();
        sb.append(dateStrs[0]);
        sb.append("-");
        sb.append(dateStrs[1]);
        sb.append("-");
        sb.append(dateStrs[2]);
        sb.append("T");
        sb.append(dateStrs[3]);
        sb.append(":");
        sb.append(dateStrs[4]);
        sb.append(":");
        sb.append(dateStrs[5]);
        sb.append("Z");
        return sb.toString();
    }

    private static boolean isValidTimestamp(String timestamp) {
        StringTokenizer st = new StringTokenizer(timestamp, "T");
        int numToks = st.countTokens();
        if (numToks == 1) {
            return AlternateLocation.isValidDate(timestamp);
        }
        if (numToks == 2) {
            String date = st.nextToken();
            String time = st.nextToken();
            return AlternateLocation.isValidDate(date) && AlternateLocation.isValidTime(time);
        }
        return false;
    }

    private static boolean isValidTime(String time) {
        if (!time.endsWith("Z")) {
            return false;
        }
        String timeStr = time.substring(0, time.length() - 1);
        StringTokenizer st = new StringTokenizer(timeStr, ":");
        int tokens = st.countTokens();
        if (tokens < 2 || tokens > 3) {
            return false;
        }
        try {
            String ssStr;
            int ss;
            int mm;
            int hh = Integer.parseInt(st.nextToken());
            if (hh < 0 || hh > 23) {
                return false;
            }
            if (st.hasMoreTokens() && ((mm = Integer.parseInt(st.nextToken())) < 0 || mm > 59)) {
                return false;
            }
            if (st.hasMoreTokens() && ((ss = Integer.parseInt(ssStr = st.nextToken().substring(0, 2))) < 0 || ss > 59)) {
                return false;
            }
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    private static boolean isValidDate(String date) {
        StringTokenizer dateTokenizer = new StringTokenizer(date, "-");
        if (dateTokenizer.countTokens() != 3) {
            return false;
        }
        String YYYYStr = dateTokenizer.nextToken();
        String MMStr = dateTokenizer.nextToken();
        String DDStr = dateTokenizer.nextToken();
        try {
            int YYYY = Integer.parseInt(YYYYStr);
            int MM = Integer.parseInt(MMStr);
            int DD = Integer.parseInt(DDStr);
            if (YYYY < 2001 || YYYY > 4000) {
                return false;
            }
            if (MM < 1 || MM > 12) {
                return false;
            }
            if (DD < 1 || DD > 31) {
                return false;
            }
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    private static Date createDateInstance(String dateTimeString) {
        StringTokenizer st = new StringTokenizer(dateTimeString, "T");
        int tokens = st.countTokens();
        if (tokens < 1 || tokens > 2) {
            return new Date(0L);
        }
        String YYYYMMDD = st.nextToken();
        StringTokenizer stdate = new StringTokenizer(YYYYMMDD, "-");
        if (stdate.countTokens() != 3) {
            return new Date(0L);
        }
        String YYYYStr = stdate.nextToken();
        String MMStr = stdate.nextToken();
        String DDStr = stdate.nextToken();
        int YYYY = Integer.parseInt(YYYYStr);
        try {
            int MM = Integer.parseInt(MMStr) - 1;
            int DD = Integer.parseInt(DDStr);
            if (!st.hasMoreTokens()) {
                Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
                cal.set(YYYY, MM, DD);
                return cal.getTime();
            }
            String hhmmss = st.nextToken();
            if (!hhmmss.endsWith("Z")) {
                return new Date(0L);
            }
            StringTokenizer sttime = new StringTokenizer(hhmmss = hhmmss.substring(0, hhmmss.length() - 1), ":");
            int numToks = sttime.countTokens();
            if (numToks < 2 || numToks > 3) {
                return new Date(0L);
            }
            String hhStr = sttime.nextToken();
            String mmStr = sttime.nextToken();
            int hh = Integer.parseInt(hhStr);
            int mm = Integer.parseInt(mmStr);
            Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
            if (sttime.hasMoreTokens()) {
                String ssStr = sttime.nextToken().substring(0, 2);
                int ss = Integer.parseInt(ssStr);
                cal.set(YYYY, MM, DD, hh, mm, ss);
            } else {
                cal.set(YYYY, MM, DD, hh, mm);
            }
            return cal.getTime();
        }
        catch (NumberFormatException e) {
            return new Date(0L);
        }
    }

    private static URL createUrl(String locationHeader) throws IOException {
        String test = locationHeader.toLowerCase();
        if (test.startsWith("http")) {
            InetAddress address;
            String urlStr = AlternateLocation.removeTimestamp(locationHeader);
            URL url = new URL(urlStr);
            String host = url.getHost();
            int port = url.getPort();
            if (host == null || host.equals("")) {
                throw new IOException("invalid host in alternate location: host: " + host + "header: " + locationHeader);
            }
            if (test.lastIndexOf("http://") > 4) {
                throw new IOException("messy alternate location: " + locationHeader);
            }
            if ((port & 0xFFFF0000) != 0) {
                throw new IOException("invalid port in alternate location: port: " + port + "header: " + locationHeader);
            }
            if (Character.isDigit(host.charAt(0)) && NetworkUtils.isPrivateAddress((address = InetAddress.getByName(host)).getAddress())) {
                throw new IOException("cannot include private address in alt loc: " + host);
            }
            if (url.getPort() == -1) {
                url = new URL("http", url.getHost(), 80, url.getFile());
            }
            return url;
        }
        throw new IOException("invalid start for alternate location: " + locationHeader);
    }

    private static String extractTimestamp(String location) {
        StringTokenizer st = new StringTokenizer(location);
        int numToks = st.countTokens();
        String curTok = null;
        for (int i = 0; i < numToks; ++i) {
            curTok = st.nextToken();
        }
        if (AlternateLocation.isValidTimestamp(curTok)) {
            return curTok;
        }
        return null;
    }

    private static String removeTimestamp(String locationHeader) {
        StringTokenizer st = new StringTokenizer(locationHeader);
        int numToks = st.countTokens();
        if (numToks == 1) {
            return locationHeader;
        }
        String curTok = null;
        for (int i = 0; i < numToks; ++i) {
            curTok = st.nextToken();
        }
        int tsIndex = locationHeader.indexOf(curTok);
        if (tsIndex == -1) {
            return null;
        }
        return locationHeader.substring(0, tsIndex);
    }

    public boolean isTimestamped() {
        return this.OUTPUT_DATE_TIME != null;
    }

    public int compareTo(Object obj) {
        if (obj == this) {
            return 0;
        }
        if (!(obj instanceof AlternateLocation)) {
            return -1;
        }
        AlternateLocation al = (AlternateLocation)obj;
        if (this.URL.equals(al.URL)) {
            return this.TIME < al.TIME ? 1 : (this.TIME == al.TIME ? 0 : -1);
        }
        if (this.isTimestamped() && al.isTimestamped()) {
            if (this.TIME == al.TIME) {
                return this.URL.toString().compareTo(al.URL.toString());
            }
            return this.TIME < al.TIME ? 1 : -1;
        }
        if (this.isTimestamped()) {
            return -1;
        }
        if (al.isTimestamped()) {
            return 1;
        }
        return -1;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AlternateLocation)) {
            return false;
        }
        AlternateLocation al = (AlternateLocation)obj;
        return this.URL == null ? al.URL == null : this.URL.equals(al.URL);
    }

    public RemoteFileDesc createRemoteFileDesc(int size) {
        HashSet<URN> urnSet = new HashSet<URN>();
        urnSet.add(this.getSHA1Urn());
        return new RemoteFileDesc(this.URL.getHost(), this.URL.getPort(), 0L, this.URL.getFile(), size, EMPTY_GUID, 1000, true, 3, false, null, urnSet, false, false, "ALT", this.getTime(), null);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = 37 * this.URL.hashCode();
        }
        return this.hashCode;
    }

    public String toString() {
        if (this.isTimestamped()) {
            return this.URL.toExternalForm() + " " + this.OUTPUT_DATE_TIME;
        }
        return this.URL.toExternalForm();
    }

    public String httpStringValue() {
        if (this.isTimestamped()) {
            return this.URL.toExternalForm() + " " + this.OUTPUT_DATE_TIME;
        }
        return this.URL.toExternalForm();
    }
}

