/*
 * Decompiled with CFR 0.152.
 */
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.ManagedConnection;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.Uploader;
import com.limegroup.gnutella.downloader.ManagedDownloader;
import com.limegroup.gnutella.search.HostData;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import java.io.File;
import java.io.PrintStream;
import java.util.Iterator;

public class AqEvent {
    public static boolean shouldSignalEvents = true;
    public static final String kSep = "<aq/>";
    public static final int kLWEventConnectionInitialized = 1;
    public static final int kLWEventConnectionClosed = 2;
    public static final int kLWEventUpdateConnectionStats = 3;
    public static final int kLWEventConnectionsUpdated = 14;
    public static final int kLWEventQueryResult = 5;
    public static final int kLWEventAddUpload = 6;
    public static final int kLWEventRemoveUpload = 7;
    public static final int kLWEventUpdateUploadStats = 8;
    public static final int kLWEventUploadsUpdated = 12;
    public static final int kLWEventAddDownload = 9;
    public static final int kLWEventRemoveDownload = 10;
    public static final int kLWEventUpdateDownloadStats = 11;
    public static final int kLWEventDownloadsUpdated = 13;
    public static final int kLWEventAddSharedFile = 15;
    public static final int kLWEventAddSharedDirectory = 16;

    public static String replaceStringWithString(String string, String target, String replacement) {
        int position;
        while (-1 < (position = string.indexOf(target))) {
            string = string.substring(0, position) + replacement + string.substring(position + target.length());
        }
        return string;
    }

    public static String correctedString(String string) {
        if (string == null) {
            return null;
        }
        string = AqEvent.replaceStringWithString(string, "&apos;", "'");
        string = AqEvent.replaceStringWithString(string, "apos;", "'");
        string = AqEvent.replaceStringWithString(string, "&amp;", "");
        string = AqEvent.replaceStringWithString(string, "amp;", "");
        return string;
    }

    public static void signalEvent(int type, Object obj) {
        AqEvent.signalEvent(type, obj, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void signalEvent(int type, Object obj, Object obj2) {
        if (!shouldSignalEvents) {
            return;
        }
        String event = null;
        switch (type) {
            case 1: {
                ManagedConnection c = (ManagedConnection)obj;
                String ua = c.getUserAgent();
                String connectionType = c.isClientSupernodeConnection() || c.isSupernodeConnection() ? "Ultrapeer" : (c.isSupernodeClientConnection() ? "Leaf" : (ua != null ? "Peer" : "0.4 Peer"));
                if (ua == null) {
                    ua = "";
                }
                event = type + kSep + c.getIPString() + kSep + c.getListeningPort() + kSep + ua + kSep + connectionType;
                break;
            }
            case 2: {
                ManagedConnection c = (ManagedConnection)obj;
                event = type + kSep + c.getIPString() + kSep + c.getListeningPort();
                break;
            }
            case 3: {
                ManagedConnection c = (ManagedConnection)obj;
                ConnectionManager cm = RouterService.getConnectionManager();
                int total = cm.getNumInitializedConnections() + cm.getNumInitializedClientConnections();
                int negotiating = cm.getNumConnections() - total;
                if (negotiating < 0) {
                    negotiating = 0;
                }
                event = type + kSep + c.getIPString() + kSep + c.getListeningPort() + kSep + c.getNumFiles() + kSep + negotiating;
                break;
            }
            case 14: {
                event = type + "";
                break;
            }
            case 5: {
                int bh;
                RemoteFileDesc r = (RemoteFileDesc)obj;
                HostData hd = (HostData)obj2;
                int quality = hd.getQuality();
                if (quality < 0) {
                    quality = 0;
                }
                if (quality == 3 && hd.getSpeed() > 2000 && hd.isMeasuredSpeed()) {
                    quality = 4;
                }
                int queryIndex = AqEventHandler.queries.indexOf(new GUID(hd.getMessageGUID()).toString());
                AqEventHandler.responses.add(r);
                int localIndex = AqEventHandler.responses.size() - 1;
                int bitrate = 0;
                String artist = null;
                String album = null;
                String year = null;
                String title = null;
                LimeXMLDocument xml = r.getXMLDoc();
                if (xml != null) {
                    String value = xml.getValue("audios__audio__bitrate__");
                    if (value != null) {
                        try {
                            bitrate = new Integer(value);
                        }
                        catch (Exception e) {
                            bitrate = 0;
                        }
                    }
                    artist = AqEvent.correctedString(xml.getValue("audios__audio__artist__"));
                    album = AqEvent.correctedString(xml.getValue("audios__audio__album__"));
                    year = xml.getValue("audios__audio__year__");
                    title = AqEvent.correctedString(xml.getValue("audios__audio__title__"));
                }
                if (bitrate > 1000) {
                    bitrate = 0;
                }
                if (artist == null) {
                    artist = "";
                }
                if (album == null) {
                    album = "";
                }
                if (year == null) {
                    year = "";
                }
                if (title == null) {
                    title = "";
                }
                GUID cguid = new GUID(hd.getClientGUID());
                int n = bh = hd.isBrowseHostEnabled() ? 1 : 0;
                if (!AqEventHandler.hosts.containsKey(hd.getIP() + hd.getPort())) {
                    AqEventHandler.hosts.put(hd.getIP() + hd.getPort(), cguid);
                }
                String sha1 = "";
                if (r.getSHA1Urn() != null) {
                    sha1 = r.getSHA1Urn().toString();
                }
                event = type + kSep + queryIndex + kSep + hd.getIP() + kSep + hd.getPort() + kSep + "" + kSep + quality + kSep + hd.getSpeed() + kSep + r.getIndex() + kSep + r.getSize() + kSep + r.getFileName() + kSep + sha1 + kSep + bitrate + kSep + localIndex + kSep + bh + kSep + artist + kSep + album + kSep + year + kSep + title;
                break;
            }
            case 6: {
                Uploader u = (Uploader)obj;
                String ua = u.getUserAgent();
                String p = "";
                if (u.getFileDesc() != null) {
                    p = u.getFileDesc().getPath();
                }
                if (ua == null) {
                    ua = "";
                }
                event = type + kSep + u.getHost() + kSep + u.getIndex() + kSep + u.getFileName() + kSep + ua + kSep + u.getState() + kSep + u.getAmountRequested() + kSep + p + kSep + (u.isBrowseHostEnabled() ? 1 : 0) + kSep + u.getGnutellaPort();
                break;
            }
            case 7: {
                Uploader u = (Uploader)obj;
                event = type + kSep + u.getHost() + kSep + u.getIndex() + kSep + u.getFileName() + kSep + u.getState();
                break;
            }
            case 8: {
                Uploader u = (Uploader)obj;
                float b = 0.0f;
                float b1 = 0.0f;
                try {
                    b = u.getMeasuredBandwidth() * 1024.0f;
                    b1 = u.getAverageBandwidth() * 1024.0f;
                }
                catch (Exception e) {
                    // empty catch block
                }
                event = type + kSep + u.getHost() + kSep + u.getIndex() + kSep + u.getFileName() + kSep + u.getState() + kSep + u.getFileSize() + kSep + u.getTotalAmountUploaded() + kSep + b + kSep + b1;
                break;
            }
            case 12: {
                event = type + "";
                break;
            }
            case 9: {
                ManagedDownloader d = (ManagedDownloader)obj;
                int index = AqEventHandler.downloads.indexOf(d);
                event = type + kSep + index + kSep + d.getFileName() + kSep + d.getState() + kSep + d.getContentLength() + kSep + d.getAmountRead();
                break;
            }
            case 10: {
                ManagedDownloader d = (ManagedDownloader)obj;
                int index = AqEventHandler.downloads.indexOf(d);
                event = type + kSep + index;
                break;
            }
            case 11: {
                int l;
                ManagedDownloader d = (ManagedDownloader)obj;
                int index = AqEventHandler.downloads.indexOf(d);
                String p = "";
                if (d.getDownloadFragment() != null) {
                    p = d.getDownloadFragment().getAbsolutePath();
                }
                float b = 0.0f;
                float b1 = 0.0f;
                try {
                    b = d.getMeasuredBandwidth() * 1024.0f;
                    b1 = d.getAverageBandwidth() * 1024.0f;
                }
                catch (Exception e) {
                    // empty catch block
                }
                String q = "0";
                if (d.getState() == 10) {
                    q = d.getQueuePosition();
                }
                if ((l = d.getContentLength()) < 0) {
                    l = 1;
                }
                String hosts = "";
                Iterator i = d.getHosts();
                while (i.hasNext()) {
                    Endpoint e = (Endpoint)i.next();
                    hosts = hosts + e.getHostname() + ":" + e.getPort() + ",";
                }
                event = type + kSep + index + kSep + d.getState() + kSep + l + kSep + d.getAmountRead() + kSep + b + kSep + b1 + kSep + d.numberOfDownloaders() + kSep + d.numberOfThreads() + kSep + d.numberOfBusy() + kSep + d.numberOfFiles() + kSep + d.numberOfQueued() + kSep + p + kSep + q + kSep + hosts;
                break;
            }
            case 13: {
                event = type + "";
                break;
            }
            case 15: {
                Object f = (FileDesc)obj;
                event = type + kSep + ((FileDesc)f).getSHA1Urn() + kSep + ((FileDesc)f).getName() + kSep + ((FileDesc)f).getSize();
                break;
            }
            case 16: {
                Object f = (File)obj;
                event = type + kSep + ((File)f).getAbsolutePath();
                break;
            }
        }
        if (event != null) {
            PrintStream printStream = System.out;
            synchronized (printStream) {
                System.out.println(event);
            }
        }
    }
}

