#!/usr/bin/env python
# -*- coding: utf-8 -*-

import sys
import imp
import os
import re


class Scraper:

  def __init__(self, url, basepath=None):
    self.url = url
    self.basepath = basepath
    self.site = None

    if not self.basepath:
      dir = os.path.dirname(os.path.abspath(__file__))
      self.basepath = os.path.join(dir, "sites")

  def is_supported(self):
    sites = self._load_sites()
    for site in sites:
      match = re.compile(site.player).search(self.url)
      if match:
        self.site = site
        return True
    return False

  def fetch(self):
    self.site.fetch(self.url)

  def get_html(self):
    return self.site.get_html()

  def get_title(self):
    return self.site.get_title()

  def _load_sites(self):
    sites = []
    for file in os.listdir(self.basepath):
      if file == '__init__.py':
        continue
      try:
        module = self._load_module(file.replace(".py", ""))
        sites.append(module)
      except ImportError:
        pass
    return sites

  def _load_module(self, module_name):
    file, pathname, description = imp.find_module(module_name, [self.basepath])
    return imp.load_module(module_name, file, pathname, description)

# test
if __name__ == '__main__':
  for url in sys.argv[1:]:
    scraper = Scraper(url)
    if scraper.is_supported():
      scraper.fetch()
      print "title: %s" % scraper.get_title()
    else:
      print "%s is not supported" % url
