#ifndef _PLAYER_H_
#define _PLAYER_H_

#include <vlc/vlc.h>
#include <QWidget>
#include <QFrame>
#include <QToolButton>

class QLabel;
class QHBoxLayout;
class QTimer;
class QSlider;

#define POSITION_RESOLUTION 10000

enum State {
  STATE_PLAYING,
  STATE_PAUSED,
  STATE_STOPPED,
};

class VideoFrame: public QFrame
{
public:
  VideoFrame(QWidget *parent);
  QSize sizeHint() const;
};

class IconButton: public QToolButton
{
public:
  IconButton(QWidget *parent, QIcon icon, QString title);
};

class Player: public QWidget
{
  Q_OBJECT

public:
  Player(QWidget *parent);
  ~Player();
  bool IsLoaded();
  bool IsPlaying();
  bool IsFinished();
  QLabel* GetStatusLabel();
  QLabel* GetDurationLabel();
  void ShowSeekBar(bool flag);
  void SetStatusLabel(const QString status);

public slots:
  void Load(const QString location);
  void Play(const QString location);
  void Play();
  void Stop();
  void Pause();
  void SetVolume(int volume);

private slots:
  void UpdateInterface();

signals:
  void Finished();

private:
  libvlc_exception_t e;
  libvlc_instance_t *vlc;
  libvlc_media_player_t *vlc_player;
  libvlc_media_t *vlc_media;
  State current_state;
  QTimer *poller;
  QSlider *seek_bar;
  QLabel *status_label;
  QLabel *duration_label;
  void Raise(libvlc_exception_t *e);
  void SetFrame(WId win_id);
  QHBoxLayout* CreateControls();
};

#endif /* _PLAYER_H_ */
