#ifndef _VIDEO_H_
#define _VIDEO_H_

#include <QObject>

class QUrl;
class QNetworkReply;
class QNetworkAccessManager;

class Video: public QObject
{
  Q_OBJECT

public:
  Video(const QUrl& url);
  ~Video();
  virtual void FindVideo() = 0;
  QString GetLocation();
  QString GetTitle();
  QString GetOriginalUrl();

public slots:
  virtual void ReplyFinished(QNetworkReply*) = 0;

signals:
  void Finished();

protected:
  QNetworkAccessManager *manager;
  QString orig_url;
  QString location;
  QString title;
};

class VideoFactory
{
public:
  static Video* Create(const QUrl& url);
};

class Video_Generic: public Video
{
  Q_OBJECT

public:
  Video_Generic(const QUrl& url): Video(url) {};
  void FindVideo();

public slots:
  void ReplyFinished(QNetworkReply*);
};

class Video_YouTube: public Video
{
  Q_OBJECT

public:
  Video_YouTube(const QUrl& url): Video(url) {};
  void FindVideo();

public slots:
  void ReplyFinished(QNetworkReply*);
};

class Video_Tube8: public Video
{
  Q_OBJECT

public:
  Video_Tube8(const QUrl& url): Video(url) {};
  void FindVideo();

public slots:
  void ReplyFinished(QNetworkReply*);
};

class Video_Dailymotion: public Video
{
  Q_OBJECT

public:
  Video_Dailymotion(const QUrl& url): Video(url) {};
  void FindVideo();

public slots:
  void ReplyFinished(QNetworkReply*);
};

class Video_Vimeo: public Video
{
  Q_OBJECT

public:
  Video_Vimeo(const QUrl& url): Video(url) {};
  void FindVideo();

public slots:
  void ReplyFinished(QNetworkReply*);
};

class Video_Veoh: public Video
{
  Q_OBJECT

public:
  Video_Veoh(const QUrl& url): Video(url) {};
  void FindVideo();

public slots:
  void ReplyFinished(QNetworkReply*);
};

class Video_YourFileHost: public Video
{
  Q_OBJECT

public:
  Video_YourFileHost(const QUrl& url): Video(url) {};
  void FindVideo();

public slots:
  void ReplyFinished(QNetworkReply*);

private:
  void ReplyFinished1(QNetworkReply*);
  void ReplyFinished2(QNetworkReply*);
};

#endif /* _VIDEO_H_ */
