#ifndef _PLAYLIST_H_
#define _PLAYLIST_H_

#include <QWidget>

class QListWidget;
class QListWidgetItem;

class Playlist: public QWidget
{
  Q_OBJECT

public:
  Playlist(QWidget *parent = 0);
  QString GetNext();

public slots:
  void AddEntry(const QString& url);

private slots:
  void SelectItem(QListWidgetItem*);

signals:
  void Closed();
  void ItemSelected(QString);

protected:
  void closeEvent(QCloseEvent *event);
  void dragEnterEvent(QDragEnterEvent *event);
  void dropEvent(QDropEvent *event);

private:
  QListWidget *list_widget;
};

#endif /* _PLAYLIST_H_ */
