#include <QHBoxLayout>
#include <QListWidget>
#include <QListWidgetItem>
#include <QCloseEvent>
#include <QUrl>
#include "playlist.h"

Playlist::Playlist(QWidget *parent): QWidget(parent, Qt::Tool)
{
  list_widget = new QListWidget(this);
  connect(list_widget, SIGNAL(itemDoubleClicked(QListWidgetItem*)),
          this, SLOT(SelectItem(QListWidgetItem*)));

  QHBoxLayout *layout = new QHBoxLayout(this);
  layout->setContentsMargins(0, 0, 0, 0);
  layout->addWidget(list_widget);
  setLayout(layout);

  setAcceptDrops(true);
  setWindowTitle(tr("Playlist"));
  resize(QSize(400, 200));
}

void Playlist::closeEvent(QCloseEvent *event)
{
  event->accept();
  emit Closed();
}

void Playlist::dragEnterEvent(QDragEnterEvent *event)
{
  // Accept file names or URLs.
  if (event->mimeData()->hasFormat("text/uri-list")) {
    event->acceptProposedAction();
  }
}

void Playlist::dropEvent(QDropEvent *event)
{
  QList<QUrl> urls = event->mimeData()->urls();
  if (urls.isEmpty()) {
    return;
  }

  QUrl url = urls.first();
  AddEntry(url.toString());
}

void Playlist::AddEntry(const QString& url)
{
  list_widget->addItem(url);
}

void Playlist::SelectItem(QListWidgetItem *item)
{
  emit ItemSelected(item->text());
}

QString Playlist::GetNext()
{
  list_widget->setCurrentRow(list_widget->currentRow() + 1);
  QListWidgetItem *item = list_widget->currentItem();

  if (item) {
    return item->text();
  } else  {
    return QString();
  }
}
