#include <WScom.h>
#include <WSCfunctionList.h>
#include <WSCbase.h>
//----------------------------------------------------------
//Function for the event procedure
//----------------------------------------------------------
#include "shared_func.h"
#include <WSCtextField.h>

void proc_of_args(WSCbase* object){
  WSCvariant  tmp;
  WSCstring   str, filename;
  WSCstring  *data;
  long        pos, line, encode;

  int     argc;
  char  **argv;

  /* textField ̏ */
  WSCtextField *tf = (WSCtextField *)object->cast("WSCtextField"); // -- (1)
  object->setVariantData(FILE_PATH, "");
  object->setVariantData(BACKUP, "");
  object->setProperty(WSNlabelString, "");
  //mainWindow->setProperty(WSNtitleString, "(VKt@C)");

  argc = WSGIappDev()->getArgc();
  if (argc > 1) { // -- (2)
    argv = WSGIappDev()->getArgv();
    argv++;
    str = *argv;
    line = 0;

    if (argc > 2) { // -- (3)
      if (str.isExist("+") == 0) {
        str.deleteChar(0);
        tmp = str.getString();
        line = tmp.getLong();
        argv++;
        str = *argv;
      }
    }

    str = WSGIappFileSystem()->adjustFileName(str); // -- (4)
    if ((str.isExist("/") == 0) || (str.isExist(":/") == 1)) {
      filename = str;
    } else {
      filename = WSGIappFileSelect()->getProperty(WSNdirName);
      filename << "/" << str;
      filename = WSGIappFileSystem()->adjustFileName(filename);
    }

    //encode = WS_EN_SJIS;
    encode = WS_EN_LOCALE; // -- (5)
    data = WSGFreadTextFile(filename, encode); // -- (6)
    if (data != NULL) {
      if (line == 0 || line == 1) {
        pos = 0;
        line = 1;
      } else if (line > data->getLines()) {
        pos = data->getChars();
        line = data->getLines();
      } else {
        pos = data->getWordCharPos(line - 1, "\n", encode);
      }
      object->setProperty(WSNlabelString, *data); // -- (7)
      object->setProperty(WSNcursorPos, pos);
      tf->setTopLine(line - 1);
      object->setVariantData(BACKUP, *data);
      object->setVariantData(FILE_PATH, filename);
      filename = WSGFgetFileName(filename);
      mainWindow->setProperty(WSNtitleString, filename);

      delete data; // -- (8)
    }
  } /* if (argc > 1) */
  return;


/////////////////////////////////////////////////////////////////////








}
static WSCfunctionRegister  op("proc_of_args",(void*)proc_of_args);
