/*
 * ThreadLifetime class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.util.lifetime;

/**
 * Xbh̏Iɍ킹ĐԂ肷{@link ts.util.lifetime.Lifetime
 * Lifetime}NXB
 * <br>
 * w肳ꂽ{@link java.lang.Thread Thread}IuWFNg̏ImāA
 * i[Ă{@link ts.util.lifetime.Life}IuWFNg
 * {@link ts.util.lifetime.Life#willDie() willDie()}\bhĂяoB
 *
 * @author  V.
 * @version $Revision: 1.2 $, $Date: 2007/06/25 16:20:45 $
 */
public class ThreadLifetime extends Lifetime
{
  /**
   * ftHgRXgN^B
   */
  public ThreadLifetime()
  {}

  /**
   * Ԃ肷{@link java.lang.Thread Thread}IuWFNgݒ肷B
   *
   * @param  thread Ԃ肷{@link java.lang.Thread Thread}
   *           IuWFNgB
   * @throws AssertionError k̏ꍇifobOE[ĥ݁jB
   */
  public void setLifeLong(final Thread thread)
  {
    Thread notifyThread = new Thread() {
      public void run() {
        try {
          thread.join();
          threadEnded(thread);
        }
        catch (Exception e) {
          catchThreadException(e, thread);
        }
        finally {
          kill();
        }
      }
    };
    notifyThread.start();
  }

  /**
   * XbhIɌĂяo郁\bhB
   * <br>
   * Xbh̏Iɉ炩̏sꍇ́ÃIuWFNg
   * I[o[ChB
   * <br>
   * ̃NXł͉ȂB
   *
   * @param  thread XbhEIuWFNgB
   */
  protected void threadEnded(Thread thread)
  {}

  /**
   * Xbh̏I҂ĂԂɗOꍇɁA̗O󂯎B
   * <br>
   * Oۂɉ炩̏sꍇ΁Ã\bh
   * I[o[ChB
   * <br>
   * ̃\bhł͉ȂB
   *
   * @param  exc OB
   * @param  thread XbhEIuWFNgB
   */
  protected void catchThreadException(Exception exc, Thread thread)
  {}
}

