/*
 * IdentityHashSet class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.util;

import java.io.Serializable;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.AbstractSet;
import java.util.IdentityHashMap;

/**
 * ̃NX́Avf̔rɃIuWFNg̓ꐫł͂ȂQƂ̓ꐫgp
 * nbVEZbgĂB
 * ƁAvf̔r <tt>(e1==null ? e2==null : e1.equals(e2))</tt>
 * ł͂ȂA<tt>(e1==e2)</tt>ɂĔ肵ĂB
 * <br>
 * ̃NX́A{@link java.util.IdentityHashMap IdentityHashMap}
 * ĂAɗvfIuWFNgi[B
 *
 * @param <E> ̃Zbgvf̃^CvB
 *
 * @author  V.
 * @version $Revision: 1.2 $, $Date: 2007/10/09 17:04:50 $
 * @see java.util.IdentityHashMap
 */
public class IdentityHashSet<E> extends AbstractSet<E>
  implements Set<E>, Cloneable, Serializable
{
  /** VAEo[WԍB*/
  static final long serialVersionUID = 1423360409923613700L;

  /** vfi[}bvB */
  private transient IdentityHashMap<E,Object> map_ ;

  /** vfi[}bvɐݒ肷_~[lB */
  private static final Object PRESENT = new Object();

  /**
   * ftHgRXgN^B
   * <br>
   * CX^X̏eʂ̓ftHgl(21)ƂB
   */
  public IdentityHashSet()
  {
    map_ = new IdentityHashMap<E,Object>();
  }

  /**
   * RNVɂƂRXgN^B
   * <br>
   * ̃RNV̗vfÃZbg̗vfƂăCX^X\zB
   * <br>
   * eʂ͈̃RNṼTCYƃftHgl(21)̑傫ݒ
   * B
   *
   * @param  c ̃Zbg̗vfƂȂIuWFNgi[RNVB
   * @throws AssertionError k̏ꍇifobOE[ĥ݁jB
   */
  public IdentityHashSet(Collection<? extends E> c)
  {
    map_ = new IdentityHashMap<E,Object>(Math.max(c.size(), 21));
    addAll(c);
  }

  /**
   * eʂɂƂRXgN^B
   *
   * @param  initialCapacity eʁB
   * @throws IllegalArgumentException ̏eʂ̒l̏ꍇB
   */
  public IdentityHashSet(int initialCapacity)
  {
    map_ = new IdentityHashMap<E,Object>(initialCapacity);
  }

  /**
   * ̃ZbgɊi[Ăvf擾B
   *
   * @return vfB
   */
  public int size()
  {
    return map_.size();
  }

  /**
   * ̃Zbg̗vf[ǂmFB
   *
   * @return vf[̏ꍇ<tt>true</tt>ԂB
   */
  public boolean isEmpty()
  {
    return map_.isEmpty();
  }

  /**
   * w肳ꂽvf̂̃ZbgɊ܂܂Ă邩ǂmFB
   *
   * @param  obj mFΏۂ̃IuWFNgB
   * @return ̗vf̃ZbgɊ܂܂Ăꍇ<tt>true</tt>ԂB
   */
  public boolean contains(Object obj)
  {
    return map_.containsKey(obj);
  }

  /**
   * ̃ZbgɊi[Ăvf̃Ce[^擾B
   *
   * @return ̃ZbgɊi[Ăvf̃Ce[^B
   */
  public Iterator<E> iterator()
  {
    return map_.keySet().iterator();
  }

  /**
   * w肳ꂽvf̃ZbgɒǉB
   * <br>
   * AAw肳ꂽvfɂ̃Zbgɑ݂ꍇ͒ǉȂB
   * <br>
   * ߂ĺAvf̒ǉsꂽꍇ<tt>true</tt>ԂAvfɑ
   * ĂĒǉsȂꍇ<tt>false</tt>ԂB
   *
   * @param  e ǉvfB
   * @return w肳ꂽvf܂ł̃Zbgɑ݂Aǉsꂽꍇ
   *         <tt>true</tt>ԂB
   */
  public boolean add(E e)
  {
    return (map_.put(e, PRESENT) == null);
  }

  /**
   * ̃ZbgSĂ̗vf폜B
   * <br>
   * ̃\bhsÃZbg͋ɂȂB
   */
  public void clear()
  {
    map_.clear();
  }

  /**
   * ̃Zbg̃N[EIuWFNg쐬B
   *
   * @return ̃Zbg̃N[EIuWFNgB
   */
  @SuppressWarnings("unchecked")
  public Object clone()
  {
    try {
      IdentityHashSet<E> newSet = (IdentityHashSet<E>) super.clone();
      newSet.map_ = (IdentityHashMap<E,Object>) map_.clone();
      return newSet;
    }
    catch (CloneNotSupportedException e) {
      throw new InternalError();
    }
  }

  /**
   * ̃ZbgECX^X̏ԂXg[ɏo͂B
   *
   * @param  ostream o͐̃Xg[B 
   */
  private void writeObject(ObjectOutputStream ostream) throws IOException
  {
    ostream.defaultWriteObject();
    ostream.writeInt(map_.size());

    for (E e : map_.keySet()) {
      ostream.writeObject(e);
    }
  }

  /**
   * Xg[Ef[^ZbgECX^X\zB
   *
   * @param  istream ͌̃Xg[B
   */
  @SuppressWarnings("unchecked")
  private void readObject(ObjectInputStream istream)
    throws IOException, ClassNotFoundException
  {
    istream.defaultReadObject();
    int size = istream.readInt();

    map_ = new IdentityHashMap<E,Object>(size);

    for (int i=0; i<size; i++) {
      E e = (E) istream.readObject();
      map_.put(e, PRESENT);
    }
  }
}

