/*
 * Record class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.util.table;

import java.io.Serializable;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.HashMap;

/**
 * e[ũR[h\NXB
 * <br>
 * {@link java.util.Map Map}NXpARXgN^Ŏw肳ꂽwb_
 * ێJEL[̃ZbgÃIuWFNg̃L[EZbgƂĎgp
 * B
 * <br>
 * ̃wb_͑̃R[hƂp̂ŁA{@link #remove(java.lang.Object)}
 * \bh{@link #clear()}\bhsĂAlkɐݒ肳邾
 * JEL[͍폜ȂB
 * ̌{@link #containsKey(java.lang.Object)}\bh{@link #keySet()}
 * \bhsĂʂ͕ςȂB
 *
 * @param <C> JEL[̃^CvB
 * @param <V> J̒l̃^CvB
 *
 * @author  V.
 * @version $Revision: 1.2 $, $Date: 2007/10/09 17:04:53 $
 */
public abstract class Record<C,V> implements Map<C,V>, Serializable
{
  /**
   * ftHgERXgN^B
   */
  public Record()
  {}

  /**
   * wb_擾B
   *
   * @return wb_EIuWFNgB
   */
  protected abstract Header<C> header();

  /**
   * J擾B
   *
   * @return JB
   */
  public int size()
  {
    return header().columnCount();
  }

  /**
   * J[ǂmFB
   *
   * @return J[̏ꍇ<tt>true</tt>AłȂ<tt>false</tt>
   *         ԂB
   */
  public boolean isEmpty()
  {
    return (size() == 0);
  }

  /**
   * w肳ꂽJEL[vf݂邩ǂmFB
   *
   * @param  column mFΏۂ̃JEL[B
   * @return ̃JEL[vf݂ꍇ<tt>true</tt>A
   *         łȂ<tt>false</tt>ԂB
   * @throws ClassCastException ̃JEL[̃NXÃ}bv
   *           sKȏꍇB
   * @throws NullPointerException kŁÃ}bvk̃L[
   *           ĂȂꍇB
   */
  public boolean containsKey(Object column)
  {
    return header().hasColumn(column);
  }

  /**
   * w肳ꂽlvf݂邩ǂmFB
   *
   * @param  value mFΏۂ̒lB
   * @return ̒lvf݂ꍇ<tt>true</tt>AłȂ
   *         <tt>false</tt>ԂB
   * @throws ClassCastException ̒l̃NXÃ}bvɕsKȏꍇB
   * @throws NullPointerException kŁÃ}bvk̒l
   *           ȂꍇB
   */
  public boolean containsValue(Object value)
  {
    return values().contains(value);
  }

  /**
   * w肳ꂽJEL[ɑΉtꂽl擾B
   *
   * @param  column JEL[B
   * @return ̃JEL[ɑΉtꂽlB
   * @throws ClassCastException ̃JEL[̃NXÃ}bv
   *           sKȏꍇB
   * @throws NullPointerException kŁÃ}bvk̃L[
   *           ĂȂꍇB
   */
  public V get(Object column)
  {
    if (! header().hasColumn(column)) {
      return null;
    }
    return getValue(column);
  }

  /**
   * w肳ꂽJEL[ƒl̑gÃ}bvɐݒ肷B
   *
   * @param  column JEL[B
   * @param  value  JEL[ɑΉtlB
   * @return ̃JEL[ɂ܂őΉtĂOlB
   * @throws UnsupportedOperationException ̃}bṽ\bh̏
   *           T|[gĂȂꍇB
   * @throws NullPointerException kŁÃ}bvk̃L[l 
   *           ĂȂꍇB
   */
  public V put(C column, V value)
  {
    header().addColumn(column);
    return putValue(column, value);
  }

  /**
   * w肳ꂽJEL[ɑ΂lkɐݒ肷B
   * <br>
   * JEL[̍폜͍sȂB
   *
   * @param  column JEL[B
   * @return ̃JEL[ɂ܂őΉtĂOlB
   * @throws ClassCastException ̃JEL[̃NXÃ}bv
   *           sKȏꍇB
   * @throws NullPointerException kŁÃ}bvk̃L[
   *           ĂȂꍇB
   */
  public V remove(Object column)
  {
    if (! header().hasColumn(column)) {
      removeValue(column);
      return null;
    }
    else {
      return removeValue(column);
    }
  }

  /**
   * w肳ꂽ}bvɊi[ĂL[ƒl̑gÃ}bvɃRs[B
   *
   * @param  m Rs[̃}bvB
   * @throws UnsupportedOperationException ̃}bṽ\bh̏
   *           T|[gĂȂꍇB
   * @throws NullPointerException k̏ꍇA܂͈̃}bvɃk
   *           L[l܂܂ĂāÃ}bvȂꍇB
   */
  public void putAll(Map<? extends C, ? extends V> m)
  {
    for (Map.Entry<? extends C, ? extends V> entry : m.entrySet()) {
      header().addColumn(entry.getKey());
      putValue(entry.getKey(), entry.getValue());
    }
  }

  /**
   * ̃}bv̓eNAB
   * <br>
   * ̃}bvɊi[Ăvf̒lSăkɐݒ肷B
   * JEL[̍폜͍sȂB
   *
   * @throws UnsupportedOperationException ̃}bṽ\bh̏
   *           T|[gĂȂꍇB
   */
  public void clear()
  {
    for (C column : keySet()) {
      removeValue(column);
    }
  }

  /**
   * ̃}bṽL[W擾B
   *
   * @return ̃}bṽL[WB
   */
  public Set<C> keySet()
  {
    return new AbstractSet<C>() {
      public Iterator<C> iterator() {
        return new Iterator<C>() {
          private Enumeration<C> it_ = header().columns();
          private Object column_ = this;
          public boolean hasNext() { return it_.hasMoreElements(); }
          public C next() { C c = it_.nextElement(); column_ = c; return c; }
          public void remove() { Record.this.remove(column_); }
        };
      }
      public int size() {
        return header().columnCount();
      }
    };
  }

  /**
   * ̃}bvɊi[Ăl̃RNV擾B
   *
   * @return ̃}bvɊi[Ăl̃RNVB
   */
  public Collection<V> values()
  {
    return new AbstractCollection<V>() {
      public Iterator<V> iterator() {
        return new Iterator<V>() {
          private Enumeration<C> it_ = header().columns();
          private Object column_ = this;
          public boolean hasNext() { return it_.hasMoreElements(); }
          public V next() {
            C c = it_.nextElement(); column_ = c;
            return Record.this.getValue(c);
          }
          public void remove() { Record.this.remove(column_); }
        };
      }
      public int size() {
        return header().columnCount();
      }
    };
  }

  /**
   * ̃}bvɊi[ĂL[ƒl̑g\Gg̏W擾B
   *
   * @return ̃}bvɊi[ĂL[ƒl̑g\Gg̏WB
   */
  public Set<Map.Entry<C,V>> entrySet()
  {
    return new AbstractSet<Map.Entry<C,V>>() {
      public Iterator<Map.Entry<C,V>> iterator() {
        return new Iterator<Map.Entry<C,V>>() {
          private Enumeration<C> it_ = header().columns();
          private Object column_ = this;
          public boolean hasNext() { return it_.hasMoreElements(); }
          public Map.Entry<C,V> next() {
            C c = it_.nextElement(); column_ = c;
            return new SimpleEntry<C,V>(c, Record.this.getValue(c));
          }
          public void remove() { Record.this.remove(column_); }
        };
      }
      public int size() {
        return header().columnCount();
      }
    };
  }

  /**
   * w肳ꂽ}bvƁÃ}bv̓eǂrB
   * <br>
   * ꂼ̃}bvɊi[ĂL[ƒl̑gݍ킹vꍇ
   * <tt>true</tt>ԂB
   *
   * @param  o rΏۃ}bvB
   * @return ꍇ<tt>true</tt>AȂꍇ}bvłȂ
   *         ꍇ<tt>false</tt>ԂB
   */
  @SuppressWarnings("unchecked")
  public boolean equals(Object o) 
  {
    if (o == this) {
      return true;
    }
    
    if (o == null || !(o instanceof Map)) {
      return false;
    }

    Map<C,V> m = _cast_to_map(o);
    if (m.size() != size()) {
      return false;
    }

    Enumeration<C> enm = header().columns();
    while (enm.hasMoreElements()) {
      C k = enm.nextElement();
      Object v1 = getValue(k);
      Object v2 = m.get(k);

      if (v1 == null) {
        if (v2 != null || !m.containsKey(k)) {
          return false;
        }
      }
      else {
        if (! v1.equals(v2)) {
          return false;
        }
      }
    }

    return true;
  }

  @SuppressWarnings("unchecked")
  private Map<C,V> _cast_to_map(Object o)
  {
    return (Map<C,V>) o;
  }

  /**
   * ̃}bṽnbVER[h擾B
   *
   * @return ̃}bṽnbVER[hB
   */
  public int hashCode()
  {
    int h = 0;
    Enumeration<C> enm = header().columns();
    while (enm.hasMoreElements()) {
      C k = enm.nextElement();
      Object v = getValue(k);
      h += ((k==null ? 0 : k.hashCode()) ^ (v==null ? 0 : v.hashCode()));
    }
    return h;
  }

  /**
   * ̃}bv\擾B
   * <br>
   * ́̕Ã}bvɊi[ĂL[ƒl̑g𓙍('=')Ō
   * \ȀWJ}(',')؂ŘAė[("{}")ň͂񂾌`
   * \B
   * L[ƒĺA{@link java.lang.String#valueOf(java.lang.Object)}ɂ
   * 񉻂B
   *
   * @return ̃}bv\B
   */
  public String toString()
  {
    Enumeration<C> enm = header().columns();
    if (! enm.hasMoreElements()) {
      return "{}";
    }

    StringBuilder buf = new StringBuilder();
    buf.append("{");

    C k; Object v;
    for (k=enm.nextElement(); enm.hasMoreElements(); k=enm.nextElement()) {
      v = getValue(k);
      buf.append(k == this ? "(this Map)" : String.valueOf(k));
      buf.append('=');
      buf.append(v == this ? "(this Map)" : String.valueOf(v));
      buf.append(", ");
    }

    v = getValue(k);
    buf.append(k == this ? "(this Map)" : String.valueOf(k));
    buf.append('=');
    buf.append(v == this ? "(this Map)" : String.valueOf(v));
    buf.append("}");
    return buf.toString();
  }


  /**
   * ̃R[h́Aw肳ꂽJ̒l擾B
   *
   * @param  column JEL[B
   * @return J̒lB
   * @throws ClassCastException ̃JEL[̃NXÃ}bv
   *           sKȏꍇB
   * @throws NullPointerException kŁÃ}bvk̃L[
   *           ĂȂꍇB
   */
  protected abstract V getValue(Object column);

  /**
   * w肳ꂽJEL[ƒl̑gÃ}bvɐݒ肷B
   *
   * @param  column JEL[B
   * @param  value  JEL[ɑΉtlB
   * @return ̃JEL[ɂ܂őΉtĂOlB
   * @throws UnsupportedOperationException ̃}bṽ\bh̏
   *           T|[gĂȂꍇB
   * @throws NullPointerException kŁÃ}bvk̃L[l 
   *           ĂȂꍇB
   */
  protected abstract V putValue(C column, V value);

  /**
   * w肳ꂽJEL[ɑ΂lkɐݒ肷B
   *
   * @param  column JEL[B
   * @return ̃JEL[ɂ܂őΉtĂOlB
   * @throws ClassCastException ̃JEL[̃NXÃ}bv
   *           sKȏꍇB
   * @throws NullPointerException kŁÃ}bvk̃L[
   *           ĂȂꍇB
   */
  protected abstract V removeValue(Object column);

  /**
   * ̃R[hAw肳ꂽ𖞂ǂ𔻒肷B
   * <br>
   * ł̃}bvێvf̃L[ƒl̑gݍ킹A
   * ̃R[hێgݍ킹ƈvꍇ<tt>true</tt>ԂB
   * <br>
   * ێL[̃R[h̃JEL[ɂȂꍇAL[
   * ΂lƃR[hňقȂꍇ<tt>false</tt>ԂB
   * <br>
   * ΂ɁAɂȂL[̃R[h̃JEL[ɑ݂ĂA茋
   * ɂ͉e^ȂB
   *
   * @param  condition ƂJƂ̒li[}bvEIuWFNgB
   * @return ̃R[hAw肳ꂽ𖞂ꍇ<tt>true</tt>ԂB
   * @throws AssertionError k̏ꍇifobOE[ĥ݁jB
   */
  public boolean satisfyCondition(Map<C,V> condition)
  {
    assert (condition != null) : "@param:condition is null.";

    for (Map.Entry cndEntry : condition.entrySet()) {
      Object k = cndEntry.getKey();
      Object v = cndEntry.getValue();
      if (! header().hasColumn(k)) {
        return false;
      }

      V value = getValue(k);
      if (v == null) {
        if (value != null) {
          return false;
        }
      }
      else {
        if (! v.equals(value)) {
          return false;
        }
      }
    }
    return true;
  }

  /**
   * L[ƒl̑g\{@link java.util.Map.Entry Map.Entry}NXPȎ
   * NXB
   */
  public static class SimpleEntry<C,V> implements Entry<C,V>, Serializable
  {
    /** VAEo[WԍB */
    static final long serialVersionUID = -6771737537141833033L;

    /** L[B */
    private final C key_;

    /** lB */
    private V value_;

    /**
     * L[ƒlɂƂRXgN^B
     *
     * @param  key L[B
     * @param  value lB
     */
    public SimpleEntry(C key, V value)
    {
      key_ = key;
      value_ = value;
    }

    /**
     * {@link java.util.Map.Entry Map.Entry}IuWFNgɂƂ
     * RXgN^B
     *
     * @param  entry {@link java.util.Map.Entry Map.Entry}IuWFNgB
     */
    public SimpleEntry(Entry<? extends C, ? extends V> entry)
    {
      key_ = entry.getKey();
      value_ = entry.getValue();
    }

    /**
     * L[擾B
     *
     * @return L[B
     */
    public C getKey()
    {
      return key_;
    }

    /**
     * l擾B
     *
     * @return lB
     */
    public V getValue()
    {
      return value_;
    }

    /**
     * w肳ꂽlݒ肷B
     *
     * @param  value ݒ肳VlB
     * @return ȑO̒lB
     */
    public V setValue(V value)
    {
      V oldValue = value_;
      value_ = value;
      return oldValue;
    }

    /**
     * w肳ꂽIuWFNgƓeǂ𔻒肷B
     * <br>
     * w肳ꂽIuWFNg̃NX{@link java.util.Map.Entry Map.Entry}
     * NX̔hNXŁAL[ƒlꂼꓙꍇ<tt>true</tt>
     * ԂB
     *
     * @param  o rΏۂ̃IuWFNgB
     * @return ̃IuWFNg̓eÃIuWFNg̓eƓꍇ
     *         <tt>true</tt>ԂAȊȌꍇ<tt>false</tt>ԂB
     */
    @SuppressWarnings("unchecked")
    public boolean equals(Object o)
    {
      if (! (o instanceof Map.Entry)) {
        return false;
      }

      Map.Entry e = (Map.Entry) o;

      if (key_ == e.getKey()) {
        ;
      }
      else if (key_ != null && key_.equals(e.getKey())) {
        ;
      }
      else {
        return false;
      }

      if (value_ == e.getValue()) {
        ;
      }
      else if (value_ != null && value_.equals(e.getValue())) {
        ;
      }
      else {
        return false;
      }

      return true;
    }

    /**
     * ̃IuWFNg̃nbVER[h擾B 
     *
     * @return  ̃IuWFNg̃nbVER[hB
     */
    public int hashCode()
    {
      return (key_   == null ? 0 : key_.hashCode()) ^
             (value_ == null ? 0 : value_.hashCode());
    }

    /**
     * ̃IuWFNg̓e\擾B
     * <br>
     * ̎ł́AL[ƒl𓙍("<tt>=</tt>")łȂԂB
     *
     * @return  ̃IuWFNg̓e\B
     */
    public String toString()
    {
      return key_ + "=" + value_;
    }
  }
}

