/*
 * DirectoryEmptyFilterTest class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.util.file;

import ts.tester.function.coverage.FunctionTester;
import ts.tester.function.print.*;
import java.io.*;

/**
 * {@link ts.util.file.DirectoryEmptyFilter DirectoryEmptyFilter}NX̋@\NXB
 *
 * @author  V.
 * @version $Revision: 1.2 $, $Date: 2007/05/27 16:13:07 $
 */
public class DirectoryEmptyFilterTest extends FunctionTester
{
  public static void main(String[] args)
  {
    try {
      PrinterGroup group = new PrinterGroup();
      group.addPrinter(new ConsolePrinter());
      group.addPrinter(new HtmlPrinter("SATOH Takayuki"));
      setPrinter(group);

      run(DirectoryEmptyFilterTest.class, (args.length == 0) ? null : args[0]);
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  protected void preTesting()
  {
    MSG("DirectoryEmptyFilter NX̋@\sB");
  }
  

  /* -- test case -- */

  public void constructor()
  {
    NOTNULL(new DirectoryEmptyFilter());
  }

  public void accept()
  {
    MSG("̃fBNgǂ𔻒B");

    File basedir = new File("test/data/ts/util/file/DirectoryEmptyFilter");

    File emptydir = new File(basedir, "emptydir");
    File notemptydir = new File(basedir, "notemtpydir");
    File childfile = new File(notemptydir, "childfile.txt");

    try {
      basedir.mkdirs();
      emptydir.mkdir();
      notemptydir.mkdir();
      childfile.createNewFile();
    } catch (IOException e) {
      NG(e);
    }

    DirectoryEmptyFilter filter = new DirectoryEmptyFilter();
    FALSE(filter.accept(basedir));
    TRUE(filter.accept(emptydir));
    FALSE(filter.accept(notemptydir));
    FALSE(filter.accept(childfile));

    try {
      FileOperation.deleteRecursive(basedir);
    } catch (Exception e) {
      NG(e);
    }
  }
}

