/*
 * FileTypeTest class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.util.file;

import ts.tester.function.coverage.FunctionTester;
import ts.tester.function.print.*;

/**
 * {@link ts.util.file.FileType FileType}NX̋@\NXB
 *
 * @author  V.
 * @version $Revision: 1.2 $, $Date: 2007/05/27 16:13:12 $
 */
public class FileTypeTest extends FunctionTester
{
  public static void main(String[] args)
  {
    try {
      PrinterGroup group = new PrinterGroup();
      group.addPrinter(new ConsolePrinter());
      group.addPrinter(new HtmlPrinter("SATOH Takayuki"));
      setPrinter(group);

      run(FileTypeTest.class, (args.length == 0) ? null : args[0]);
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  protected void preTesting()
  {
    MSG("FileType NX̋@\sB");
  }
  

  /* -- test case -- */

  public void _toString()
  {
    MSG("name \bh̊mFB");

    EQUAL(FileType.File.name(), "File");
    EQUAL(FileType.Directory.name(), "Directory");
  }

  protected void doSwitch(FileType type)
  {
    switch (type) {
    case File :
      EQUAL(type, FileType.File);
      break;
    case Directory :
      EQUAL(type, FileType.Directory);
      break;
    default :
      NG();
      break;
    }
  }

  public void use_switch()
  {
    MSG("switch gpꍇ̓̊mFB");
    doSwitch(FileType.File);
    doSwitch(FileType.Directory);
  }

  public void use_switch_1()
  {
    MSG("switch Ƀkw肵ꍇ̊mFB");

    try {
      doSwitch((FileType) null);
      NG();
    } catch (NullPointerException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }
}

