/*
 * Duo class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.util;

import java.io.Serializable;

/**
 * ̃IuWFNg̑g\NXB
 * <br>
 * ꂼ̒l̐ݒ擾s\bhpӂĂB
 *
 * @author  V. 
 * @version $Revision: 1.3 $, $Date: 2007/05/27 16:13:06 $
 */
public class Duo<F, S> implements Serializable
{
  /* VAԍB */
  static final long serialVersionUID = -3793037288866678719L;

  /** 1IuWFNgB */
  private F value1_ ;

  /** 2IuWFNgB */
  private S value2_ ;

  /**
   * ftHgRXgN^B
   * <br>
   * ̃IuWFNg̒ĺAƂɃkɐݒ肳B
   */
  public Duo()
  {}

  /**
   * ̃IuWFNg̒lɂƂRXgN^B
   * <br>
   * k̏ꍇ́Â܂܃kݒ肷B
   *
   * @param  first  IuWFNgB
   * @param  second IuWFNgB
   */
  public Duo(F first, S second)
  {
    set(first, second);
  }

  /**
   * ̃IuWFNg̒lݒ肷B
   * <br>
   * k̏ꍇ́Â܂܃kݒ肷B
   *
   * @param  first  IuWFNgB
   * @param  second IuWFNgB
   */
  public void set(F first, S second)
  {
    setFirst(first);
    setSecond(second);
  }

  /**
   * IuWFNgݒ肷B
   * <br>
   * k̏ꍇ́Â܂܃kݒ肷B
   *
   * @param  first IuWFNgB
   */
  public void setFirst(F first)
  {
    value1_ = first;
  }

  /**
   * IuWFNg擾B
   *
   * @return IuWFNgB
   */
  public F getFirst()
  {
    return value1_;
  }

  /**
   * IuWFNgݒ肷B
   * <br>
   * k̏ꍇ́Â܂܃kݒ肷B
   *
   * @param  second IuWFNgB
   */
  public void setSecond(S second)
  {
    value2_ = second;
  }

  /**
   * IuWFNg擾B
   *
   * @return IuWFNgB
   */
  public S getSecond()
  {
    return value2_;
  }

  /**
   * w肳ꂽIuWFNgƓeǂrB
   * <br>
   * <code>Duo</code>IuWFNg̏ꍇ́Aꂼ̑IuWFNg
   * yёIuWFNgrāAɓꍇ<tt>true</tt>A
   * łȂ<tt>false</tt>ԂB
   * k̏ꍇ<code>Duo</code>IuWFNgłȂꍇ<tt>false</tt>
   * ԂB
   *
   * @param  obj rIuWFNgB
   * @return IuWFNg̓eꍇ<tt>true</tt>ԂB
   */
  public boolean equals(Object obj)
  {
    if (obj == null || !(obj instanceof Duo))
      return false;

    Duo another = Duo.class.cast(obj);

    if (getFirst() == null) {
      if (another.getFirst() != null)
        return false;
    }
    else if (! getFirst().equals(another.getFirst())) {
      return false;
    }

    if (getSecond() == null) {
      if (another.getSecond() != null)
        return false;
    }
    else if (! getSecond().equals(another.getSecond())) {
      return false;
    }

    return true;
  }

  /**
   * nbVR[h擾B
   *
   * @return nbVR[hB
   */
  public int hashCode()
  {
    int v1 = (getFirst()  == null) ? 0 : getFirst().hashCode();
    int v2 = (getSecond() == null) ? 0 : getSecond().hashCode();
    return (v1 + v2);
  }
}
