/*
 * Decompiled with CFR 0.152.
 */
package ts.util.text;

public final class StringOperation {
    protected StringOperation() {
    }

    public static int length(String string) {
        assert (string != null) : "@param:str is null.";
        return string.codePointCount(0, string.length());
    }

    public static boolean isEmpty(String string) {
        assert (string != null) : "@param:str is null.";
        return string.length() == 0;
    }

    public static boolean isWhitespaces(String string) {
        assert (string != null) : "@param:str is null.";
        if (string.length() == 0) {
            return false;
        }
        int n = 0;
        while (n < string.length()) {
            if (!Character.isWhitespace(string.codePointAt(n))) {
                return false;
            }
            n = StringOperation.offsetByCodePoints(string, n, 1);
        }
        return true;
    }

    public static boolean isUnicodeBlock(String string, Character.UnicodeBlock unicodeBlock) {
        assert (string != null) : "@param:str is null.";
        assert (unicodeBlock != null) : "@param:unicodeBlock is null.";
        if (string.length() == 0) {
            return false;
        }
        int n = 0;
        while (n < string.length()) {
            Character.UnicodeBlock unicodeBlock2 = Character.UnicodeBlock.of(string.codePointAt(n));
            if (!unicodeBlock2.equals(unicodeBlock)) {
                return false;
            }
            n = StringOperation.offsetByCodePoints(string, n, 1);
        }
        return true;
    }

    public static boolean isDigits(String string) {
        assert (string != null) : "@param:str is null.";
        if (string.length() == 0) {
            return false;
        }
        int n = 0;
        while (n < string.length()) {
            if (!Character.isDigit(string.codePointAt(n))) {
                return false;
            }
            n = StringOperation.offsetByCodePoints(string, n, 1);
        }
        return true;
    }

    public static String characterAt(String string, int n) throws IndexOutOfBoundsException {
        assert (string != null) : "@param:str is null.";
        int n2 = StringOperation.offsetByCodePoints(string, 0, n);
        int n3 = StringOperation.offsetByCodePoints(string, n2, 1);
        return string.substring(n2, n3);
    }

    public static String substring(String string, int n) throws IndexOutOfBoundsException {
        assert (string != null) : "@param:str is null.";
        return string.substring(StringOperation.offsetByCodePoints(string, 0, n));
    }

    public static String substring(String string, int n, int n2) throws IndexOutOfBoundsException {
        assert (string != null) : "@param:str is null.";
        int n3 = n2 - n;
        int n4 = StringOperation.offsetByCodePoints(string, 0, n);
        int n5 = StringOperation.offsetByCodePoints(string, n4, n3);
        return string.substring(n4, n5);
    }

    public static int indexOf(String string, String string2) {
        return StringOperation.indexOf(string, string2, 0);
    }

    public static int indexOf(String string, String string2, int n) {
        assert (string != null) : "@param:str is null.";
        assert (string2 != null) : "@param:searched is null.";
        int n2 = Math.max(n, 0);
        try {
            int n3 = StringOperation.offsetByCodePoints(string, 0, n2);
            int n4 = string.length() - string2.length();
            int n5 = n3;
            while (n5 <= n4) {
                if (string.startsWith(string2, n5)) {
                    return n2;
                }
                n5 = StringOperation.offsetByCodePoints(string, n5, 1);
                ++n2;
            }
            return -1;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return -1;
        }
    }

    public static int lastIndexOf(String string, String string2) {
        return StringOperation.lastIndexOf(string, string2, string.length());
    }

    public static int lastIndexOf(String string, String string2, int n) {
        assert (string != null) : "@param:str is null.";
        assert (string2 != null) : "@param:searched is null.";
        int n2 = Math.min(n, Math.max(StringOperation.length(string), 0));
        try {
            int n3;
            int n4 = n3 = StringOperation.offsetByCodePoints(string, 0, n2);
            while (n4 >= 0) {
                if (string.startsWith(string2, n4)) {
                    return n2;
                }
                n4 = StringOperation.offsetByCodePoints(string, n4, -1);
                --n2;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return -1;
    }

    public static boolean startsWith(String string, String string2) {
        assert (string != null) : "@param:str is null.";
        assert (string2 != null) : "@param:prefix is null.";
        return string.startsWith(string2);
    }

    public static boolean endsWith(String string, String string2) {
        assert (string != null) : "@param:str is null.";
        assert (string2 != null) : "@param:suffix is null.";
        return string.endsWith(string2);
    }

    public static boolean contains(String string, String string2) {
        assert (string != null) : "@param:str is null.";
        assert (string2 != null) : "@param:searched is null.";
        return string.contains(string2);
    }

    protected static int offsetByCodePoints(String string, int n, int n2) throws IndexOutOfBoundsException {
        return new String(string).offsetByCodePoints(n, n2);
    }
}

