/*
 * Decompiled with CFR 0.152.
 */
package ts.util.table;

import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import ts.util.IdentityHashSet;
import ts.util.table.MapComparator;
import ts.util.table.MapIterator;
import ts.util.table.Record;
import ts.util.table.Table;
import ts.util.table.Trigger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Index<C, V>
implements Table<C, V> {
    private C[] indexKeys_;
    private IndexNodeMap rootMap_ = new IndexNodeMap();

    protected Index(C[] CArray) {
        assert (CArray != null) : "@param:indexKeys is null.";
        if (CArray.length == 0) {
            throw new IllegalArgumentException("@param:indexKeys is an empty array.");
        }
        this.indexKeys_ = CArray;
    }

    protected abstract Table<C, V> getBaseTable();

    @Override
    public int columnCount() {
        return this.getBaseTable().columnCount();
    }

    @Override
    public int recordCount() {
        return this.getBaseTable().recordCount();
    }

    protected int indexKeyCount() {
        return this.indexKeys_.length;
    }

    @Override
    public Enumeration<C> columns() {
        return this.getBaseTable().columns();
    }

    @Override
    public MapIterator<C, V> records() {
        return this.getBaseTable().records();
    }

    @Override
    public MapIterator<C, V> records(MapComparator<C, V> mapComparator) {
        return this.getBaseTable().records(mapComparator);
    }

    @Override
    public Map<C, V> recordFirst() {
        return this.getBaseTable().recordFirst();
    }

    protected Enumeration<C> indexKeys() {
        return new Enumeration<C>(){
            private int ind_ = 0;

            @Override
            public boolean hasMoreElements() {
                return this.ind_ < Index.this.indexKeys_.length;
            }

            @Override
            public C nextElement() {
                try {
                    Object object = Index.this.indexKeys_[this.ind_];
                    ++this.ind_;
                    return object;
                }
                catch (Exception exception) {
                    throw new NoSuchElementException();
                }
            }
        };
    }

    @Override
    public Index<C, V> getIndex(C ... CArray) {
        return this.getBaseTable().getIndex(CArray);
    }

    @Override
    public void addTrigger(Trigger<C, V> trigger) {
        this.getBaseTable().addTrigger(trigger);
    }

    @Override
    public void deleteAll() {
        this.getBaseTable().deleteAll();
    }

    @Override
    public Map<C, V> appendNew() {
        return this.getBaseTable().appendNew();
    }

    @Override
    public Map<C, V> appendNew(int n) {
        return this.getBaseTable().appendNew(n);
    }

    @Override
    public boolean exists(C c, V v) {
        HashMap<C, V> hashMap = new HashMap<C, V>();
        hashMap.put(c, v);
        return this.exists(hashMap);
    }

    @Override
    public Map<C, V> selectFirst(C c, V v) {
        HashMap<C, V> hashMap = new HashMap<C, V>();
        hashMap.put(c, v);
        return this.selectFirst(hashMap);
    }

    @Override
    public List<Map<C, V>> select(C c, V v) {
        HashMap<C, V> hashMap = new HashMap<C, V>();
        hashMap.put(c, v);
        return this.select(hashMap);
    }

    protected Collection<Record<C, V>> collectRecords(Map<C, V> map) {
        assert (map != null) : "@param:condition is null.";
        return this.collectRecords(this.rootMap_, 0, map);
    }

    private Collection<Record<C, V>> collectRecords(IndexNodeMap indexNodeMap, int n, Map<C, V> map) {
        C c = this.indexKeys_[n];
        V v = map.get(c);
        ++n;
        if (v == null && !map.containsKey(c)) {
            RecordSet recordSet = new RecordSet();
            for (Object v2 : indexNodeMap.values()) {
                if (v2 instanceof HashMap) {
                    recordSet.addAll(this.collectRecords((IndexNodeMap)v2, n, map));
                    continue;
                }
                if (!(v2 instanceof IdentityHashSet)) continue;
                recordSet.addAll((RecordSet)v2);
            }
            return recordSet;
        }
        Object v3 = indexNodeMap.get(v);
        if (v3 != null) {
            if (v3 instanceof HashMap) {
                return this.collectRecords((IndexNodeMap)v3, n, map);
            }
            if (v3 instanceof IdentityHashSet) {
                return (RecordSet)v3;
            }
        }
        return new RecordSet();
    }

    protected Collection<Record<C, V>> getIndexedCollection(Record<C, V> record) {
        assert (record != null) : "@param:record is null.";
        IndexNodeMap indexNodeMap = this.rootMap_;
        for (int i = 0; i < this.indexKeys_.length - 1; ++i) {
            Object v = indexNodeMap.get(record.get(this.indexKeys_[i]));
            if (v == null || !(v instanceof HashMap)) {
                return new RecordSet();
            }
            indexNodeMap = (IndexNodeMap)v;
        }
        Object v = indexNodeMap.get(record.get(this.indexKeys_[this.indexKeys_.length - 1]));
        if (v != null && v instanceof IdentityHashSet) {
            return (RecordSet)v;
        }
        return new RecordSet();
    }

    protected Collection<Record<C, V>> getIndexedCollectionByForce(Record<C, V> record) {
        RecordSet recordSet;
        Object v;
        V v2;
        assert (record != null) : "@param:record is null.";
        IndexNodeMap indexNodeMap = this.rootMap_;
        for (int i = 0; i < this.indexKeys_.length - 1; ++i) {
            v2 = record.get(this.indexKeys_[i]);
            v = indexNodeMap.get(v2);
            if (v != null && v instanceof HashMap) {
                indexNodeMap = (IndexNodeMap)v;
                continue;
            }
            IndexNodeMap indexNodeMap2 = new IndexNodeMap();
            indexNodeMap.put(v2, indexNodeMap2);
            indexNodeMap = indexNodeMap2;
        }
        v2 = record.get(this.indexKeys_[this.indexKeys_.length - 1]);
        v = indexNodeMap.get(v2);
        if (v != null && v instanceof IdentityHashSet) {
            recordSet = (RecordSet)v;
        } else {
            recordSet = new RecordSet();
            indexNodeMap.put(v2, recordSet);
        }
        recordSet.add(record);
        return recordSet;
    }

    protected void deleteAllRecordsFromIndex() {
        this.rootMap_.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class RecordSet
    extends IdentityHashSet<Record<C, V>> {
        static final long serialVersionUID = 5528842630870790522L;

        protected RecordSet() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class IndexNodeMap
    extends HashMap<V, Object> {
        static final long serialVersionUID = 8037487212928327L;

        protected IndexNodeMap() {
        }
    }
}

