/*
 * Decompiled with CFR 0.152.
 */
package ts.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentityHashSet<E>
extends AbstractSet<E>
implements Set<E>,
Cloneable,
Serializable {
    static final long serialVersionUID = 1423360409923613700L;
    private transient IdentityHashMap<E, Object> map_;
    private static final Object PRESENT = new Object();

    public IdentityHashSet() {
        this.map_ = new IdentityHashMap();
    }

    public IdentityHashSet(Collection<? extends E> collection) {
        this.map_ = new IdentityHashMap(Math.max(collection.size(), 21));
        this.addAll(collection);
    }

    public IdentityHashSet(int n) {
        this.map_ = new IdentityHashMap(n);
    }

    @Override
    public int size() {
        return this.map_.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map_.isEmpty();
    }

    @Override
    public boolean contains(Object object) {
        return this.map_.containsKey(object);
    }

    @Override
    public Iterator<E> iterator() {
        return this.map_.keySet().iterator();
    }

    @Override
    public boolean add(E e) {
        return this.map_.put(e, PRESENT) == null;
    }

    @Override
    public void clear() {
        this.map_.clear();
    }

    public Object clone() {
        try {
            IdentityHashSet identityHashSet = (IdentityHashSet)super.clone();
            identityHashSet.map_ = (IdentityHashMap)this.map_.clone();
            return identityHashSet;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.map_.size());
        for (E e : this.map_.keySet()) {
            objectOutputStream.writeObject(e);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.map_ = new IdentityHashMap(n);
        for (int i = 0; i < n; ++i) {
            Object object = objectInputStream.readObject();
            this.map_.put(object, PRESENT);
        }
    }
}

