#! /usr/bin/ruby

class NodeList
  DUMMY = %w( NODE_MEMO NODE_LAST NODE_ALLOCA NODE_CNAME
              NODE_CFUNC NODE_IFUNC NODE_RESBODY)

  def initialize(node, src = File.join(File.dirname(__FILE__), "nodeDump.c"))
    @in_dump = File.new(src).grep(/case\s+(NODE_\w+):/) {$1}
    copying = false
    @in_ruby = []
    @source = []
    IO.foreach(node) do |line|
      if copying
        case line
        when /\};/
          break
        when /^#/
          @source << line
        when /\s*(\w+)(,)?/
          @source << "\t\"#$1\"#$2"
          @source << "\#define\t #{$1} #{$1}"
          @in_ruby << $1
        end
      elsif line =~ /enum node_type/
        copying = true
      end
    end
  end

  def handle?
    inRubyNotDump = @in_ruby - @in_dump - DUMMY
    inDumpNotRuby = @in_dump - @in_ruby
    unless inRubyNotDump.empty?
      puts "\n\nNodes we don't handle:", inRubyNotDump.join(", ")
    end
    unless inDumpNotRuby.empty?
      puts "\n\nNodes we handle not in Ruby:", inDumpNotRuby.join(", ")
    end
    inRubyNotDump.empty?
  end

  # Create a node_names.h file containing enum -> name mappings
  def to_s
    <<EOS << @source.join("\n") << <<EOS
#ifndef NODE_NAMES_H
#define NODE_NAMES_H
const char *node_names[] = {
EOS

};
#endif /* NODE_NAMES_H */
EOS
  end

  def self.make(header, output = $stdout)
    nodes = NodeList.new(header)
    unless nodes.handle?
      $stderr.puts <<"_EOM_"

=================================================================

NodeDump can not be built on this system. This is probably due to
an incompatibility with Ruby versions. This version of NodeDump
only runs with Ruby 1.6 or later.

=================================================================

_EOM_
      return false
    end
    src = nodes.to_s
    if output.respond_to?(:write)
      output.write src
    elsif (IO.read(output) != src rescue true)
      open(output, "w") {|op| op.write src}
    end
    true
  end
end

if $0 == __FILE__
  # (1..2) === ARGV.size or abort "usage: #$0 node.h [node_names.h]"
  input, output = ARGV
  output = output && output != "-" ? open(output, "w") : STDOUT
  exit(NodeList.make(input, output))
end
