#!/usr/local/bin/perl
# $Id: randomenqueue.pl,v 1.5 2002/12/13 12:42:24 miyagawa Exp $

use strict;

package TricksterLite;
use vars qw($Config);

my $config_path = $ENV{TRICKSTER_LITE_CONF} || "$ENV{HOME}/.trickster-lite.conf";
$Config = TricksterLite::Config->new($config_path);

use DirHandle;
use FileHandle;
use File::Find;
use Time::HiRes qw(usleep gettimeofday);

my $Debug = 0;
my $interval = 3_000_000;

warn "now loading media files ..." if $Debug;
my $media_files = load_media_files();

$SIG{HUP} = sub {
    warn "caught SIGHUP. reloading media files." if $Debug;
    $media_files = load_media_files();
};

while (1) {
    my $base_dir = $Config->get('base_directory');
    my @queue = queue_files_in("$base_dir/queue");
    unless (@queue) {
	warn "no queue found" if $Debug;
	my $media = choose_random($media_files);
	warn "choosed $media" if $Debug;
	enqueue_media($media);
    }
    usleep $interval;
}

sub queue_files_in {
    my $dir = shift;
    my $dh  = DirHandle->new($dir) or die "$dir: $!";
    return grep !/^now_playing/ && -f "$dir/$_", $dh->read;
}

sub load_media_files {
    my $media_dir = $Config->get('media_directory');
    my @media;
    find(sub { push @media, $File::Find::name if -f $File::Find::name }, $media_dir);
    return \@media;
}

sub choose_random {
    my $media = shift;
    return $media->[rand @$media];
}

sub enqueue_media {
    my $media = shift;
    my $base_dir = $Config->get('base_directory');
    my $timestamp = gettimeofday;
    my $fh = FileHandle->new("> $base_dir/queue/$timestamp") or die $!;
    $fh->print($media, "\n");
}

#--------------------------------------------------

package TricksterLite::Config;
use base qw(Data::Properties);
use FileHandle;

sub new {
    my($class, $path) = @_;
    my $self = $class->SUPER::new;
    $self->load(FileHandle->new($path));
    return $self;
}

BEGIN {
    *get = __PACKAGE__->can('get_property');	# alias
}
