
/* Copyright(C) 2004 Toshihiro Ookubox */

#include <stdlib.h>
#include <stdio.h>   
#include <string.h>
#include <assert.h>
#include <math.h>


char* infile;
char* outfile;

int  nPos=0;
double (*pos)[3];

int nTri=0;
int (*tri)[3];

int nVertex=0;
int *frontVertex;

char buf[1024];

int i;

double   get_sign_area(double x0,double y0,
                       double x1,double y1,
                       double x2,double y2)
{
/*  
     |  xi-1 yi-1  1 |
 D=  |  xi   yi    1 |
     |  xi+1 yi+1  1 |
 D > 0  counterclockwise
 D < 0  clockwise
 D = 0 on line
 */
  return  0.5 *  (x2 - x1) * (y0 - y1) - (y2 - y1) * (x0 - x1);
}

double get_distance(double x0,double y0,
                    double x1,double y1)
{
  return sqrt( (x1 - x0) * (x1 - x0) + (y1 - y0) * (y1 - y0));
}



int triangulation()
{
  int m = nVertex;
  double min_diagonal = 0.0;
  double sign_area = 0.0;
  double diagonal = 0.0;
  int  i_min = 0;
  int  i,h,j,l;

  tri=  (int (*)[3])calloc(nPos,sizeof(int[3]));

  // i == i:   h = i - 1:  j = i + 1//

  while( m > 3){
    min_diagonal = 1.0e+15;
    
    for(i = 0; i < m ;i++){
      h = (i == 0 ? m-1:i-1); j = ( i== m-1 ? 0:i+1);

      sign_area = get_sign_area(pos[h][0],pos[h][1],pos[i][0],pos[i][1],pos[j][0],pos[j][1]);
      diagonal = get_distance(pos[h][0],pos[h][1],pos[j][0],pos[j][1]);
#if 0      
      int includeFlag = this->includeVertex(h0,i0,j0);
#endif

      if(   ( sign_area > 1.0e-10)
	    && ( diagonal < min_diagonal   ) ){
#if 0
	    && ( includeFlag == 0 ) ){
#endif	
        min_diagonal = diagonal;  i_min = i;
      }
    }

    i = i_min; h =( i ==0 ? m-1:i-1);
    j = (i==m-1 ? 0 : i+1);

    tri[nTri][0]= frontVertex[i];
    tri[nTri][1]= frontVertex[j];
    tri[nTri][2]= frontVertex[h];
    nTri++;
  
    m--;
    for(l = i; l < m; l++)
      frontVertex[l] = frontVertex[l+1];
  }

  //last triangulation//
    tri[nTri][0]= frontVertex[0];
    tri[nTri][1]= frontVertex[1];
    tri[nTri][2]= frontVertex[2];
    nTri++;

  return 0;
}




int  main(int argc,char** argv){

 if(argc != 3){
   fprintf (stderr, "Usage : \n");
   fprintf (stderr,  "%s pchFileName(in) pchFileName(out) \n",argv[0]);
   fprintf (stderr,  "--input--\n");
   fprintf (stderr,  "$vertex 4 \n");
   fprintf (stderr,  "2 1 0 \n");
   fprintf (stderr,  "..... \n");
   fprintf (stderr,  "2 3 0 \n");

    exit (-1);
  }


  infile  = argv[1];
  outfile = argv[2];


  /*  open file */
  FILE* fin = fopen(infile,"r");
  if(fin == NULL)
    exit (-1);

  FILE* fout = fopen(outfile,"w");
  if(fout == NULL)
    exit (-1);


  /*  pch read  position and loop data */
  fscanf (fin, "%d \n",&nPos);
  pos=  (double (*)[3])calloc(nPos,sizeof(double[3]));
  
  for(i = 0; i < nPos ;i++){
    fscanf (fin,    "%lf %lf %lf \n", &pos[i][0],&pos[i][1],&pos[i][2]);
  }

  nVertex=nPos;
  frontVertex=  (int*)calloc(nPos,sizeof(int));
  for(i = 0; i < nVertex ;i++){
    frontVertex[i] = i;
  }


  /******************/
  /* create 3d data */
  /******************/
  triangulation();


  fprintf(fout, "%d\n",nPos);
  
  /* write position */
  for(i = 0; i < nPos ;i++){
    fprintf(fout, "%f %f %f\n",pos[i][0],pos[i][1],pos[i][2]);
  }

  fprintf(fout, "%d \n",nTri);

  for(i = 0; i < nTri  ;i++){
    fprintf (fout, "%d %d %d \n", tri[i][0],tri[i][1],tri[i][2]);
  }

  /*  clsoe file */
  fclose(fin);
  fclose(fout);

  return 0;

}















