#include <stdlib.h>  
#include <stdio.h>
#include <string.h>
#include <math.h>

/*
       v0
       /\
      /  \
   m0/    \ m2
    /      \ 
   /        \
   ----------
  v1  m1    v2
*/

/*********************
 tri model info
**********************/
/* point info */

int  nPos;
double (*pos)[3]; 


/* tri info */
int  nTri = 0;
/* 0,1,2 of array is  vertex id
   3,4,5 of array is  edge id
*/

int (*tri)[6];

static int  TRI_EDGE_MAP[3][2] = {
  { 0, 1 },{ 1, 2 },{ 2, 0 }
};

/* half edge info */
int  nEdge;
/* 0 and 1 of array is number of half edge.
   2 of array is  orent flag.( 0 is true)
   3 of array   connected face id.
   4 of array is  edge id of face.
   5 of array is vertex id (new middle point)
*/
int (*edge)[6];


/*********************
    function 
**********************/
int  compare(const void* x, const void* y)
{
  int* a = (int*)x;
  int* b = (int*)y;

  /* a < b */
  if(a[0] < b[0]){
    return -1;
  }
  if(a[0] == b[0])
    if(a[1] < b[1])
      return -1;

  if(a[0] == b[0] && a[1] == b[1])
    return 0;

  return 1;
}

void subdiv()
{
  int i,j,w,middleVertexId;
  int numEdeg = 0;

  nEdge = nTri * 3;

  edge=  (int (*)[6])calloc(nEdge,sizeof(int[6]));

  /* make edge list */
  for(i = 0; i < nTri ;i++){
    for(j = 0; j < 3 ;j++){
      edge[numEdeg][0] = tri[i][TRI_EDGE_MAP[j][0]];
      edge[numEdeg][1] = tri[i][TRI_EDGE_MAP[j][1]];
      if(edge[numEdeg][0] > edge[numEdeg][1]){
        w = edge[numEdeg][0];
        edge[numEdeg][0] = edge[numEdeg][1];
        edge[numEdeg][1] = w;
        edge[numEdeg][2] = 1;
      }
      edge[numEdeg][3] = i;
      edge[numEdeg][4] = j;
      numEdeg++;
    }     
  }

  /* sort edge  */
  qsort(edge,nEdge,sizeof(int)*6,compare);


  /*  associate  edge and face  */
  /*  face has id of three edge. */

   for(i = 0; i < nEdge ;i+=2){
     tri[edge[i][3]][edge[i][4]+3]   = i;
     tri[edge[i+1][3]][edge[i+1][4]+3] =  i;
   }


  middleVertexId = nPos;
  for(i = 0; i < nEdge ;i+=2){
    edge[i][5] = middleVertexId;
    middleVertexId++;
  }

#if 0
  for(i = 0; i < nEdge ;i++)
  printf("%d) edge =(%d,%d,%d,%d,%d,%d)\n",i,edge[i][0],edge[i][1],edge[i][2],
                                       edge[i][3],edge[i][4],edge[i][5]);

#endif

#if 0
  for(i = 0; i < nTri ;i++)
  printf("tri =(%d,%d,%d,%d,%d,%d)\n",tri[i][0],tri[i][1],tri[i][2],
                                      tri[i][3],tri[i][4],tri[i][5]);
#endif

   
}

int  pch_read(char* infile)
{
  int i;  
  FILE* fin = fopen(infile,"r");
  if(fin == NULL){
    fprintf(stderr,"### ERR file not found (%s)\n",infile);
    exit (-1);
  }

  fscanf (fin, "%d \n", &nPos);
  pos=     (double (*)[3])calloc(nPos,sizeof(double[3]));
 
  for(i = 0; i < nPos ;i++){
    fscanf (fin,"%lf %lf %lf \n", &pos[i][0],&pos[i][1],&pos[i][2]);
  }

  fscanf (fin, "%d \n",&nTri);
  tri=  (int (*)[6])calloc(nTri,sizeof(int[6]));

  for(i = 0; i < nTri ;i++){
    fscanf (fin, "%d %d %d", &tri[i][0],&tri[i][1],&tri[i][2]);
  }

  fclose(fin);
  return 0;

}

int  pch_write(char* outfile)
{

  int i;

  /*  open file */
  FILE* fout = fopen(outfile,"w");
  if(fout == NULL){
    fprintf(stderr,"#ERR open file(%s)\n",outfile);  
    exit (-1);
  }

  fprintf(fout, "%d\n",nPos+nEdge/2);
  
  /* write position */
  for(i = 0; i < nPos ;i++){
    fprintf(fout, "%f %f %f\n",pos[i][0],pos[i][1],pos[i][2]);
  }

  for(i = 0; i < nEdge ;i+=2){
      fprintf(fout, "%f %f %f\n",(pos[edge[i][0]][0] + pos[edge[i][1]][0]) * 0.5,
                                 (pos[edge[i][0]][1] + pos[edge[i][1]][1]) * 0.5,
                                 (pos[edge[i][0]][2] + pos[edge[i][1]][2]) * 0.5);
  }

  /* write tri */
  fprintf(fout, "%d\n",nTri*4);

  for(i = 0; i < nTri ;i++){
    fprintf(fout, "%d %d %d\n",tri[i][0],edge[tri[i][3]][5],edge[tri[i][5]][5]);
    fprintf(fout, "%d %d %d\n",edge[tri[i][3]][5],edge[tri[i][4]][5],edge[tri[i][5]][5]);
    fprintf(fout, "%d %d %d\n",edge[tri[i][3]][5],tri[i][1],edge[tri[i][4]][5]);
    fprintf(fout, "%d %d %d\n",edge[tri[i][5]][5],edge[tri[i][4]][5],tri[i][2]);
  }
  
  fclose(fout);
  return 0;

}



int  main(int argc,char** argv)
{
  char infile[256];
  char outfile[256];


  if(argc != 3){
    fprintf (stderr, "Usage : \n");
    fprintf (stderr, "%s pchFileName(in) pchFileName(out)\n",argv[0]);
    exit (-1);
  }


  strcpy(infile,argv[1]);
  strcpy(outfile,argv[2]);
  
  /* read pch file*/  
  pch_read(infile);


  /* sub divide */
  subdiv();

  /* write pch file*/  
  pch_write(outfile);


  if(pos!=NULL) free(pos);
  if(tri!=NULL) free(tri);
  if(edge!=NULL) free(edge);

  return 0;
}




