#include <stdlib.h>
#include <stdio.h>   
#include <string.h>

#define  STL_ACSII 0

typedef struct stl_tri{
  double p[3][3];
  struct stl_tri  *next;
} STL_TRI;

STL_TRI *obj;
STL_TRI *pre;
STL_TRI *next;
STL_TRI *head;
int nTri=0;



int stl_type(char *fileName);
int stl_read_binary(char *fileName); 
int stl_read_ascii(char *fileName); 
int stl_get_little_int32(FILE* in_stream);
float stl_get_little_float32(FILE* in_stream);


int   stl_get_little_int32(FILE* in_stream)
{
  int int32_value = 0;
  int32_value = fgetc(in_stream) & 0xFF;
  int32_value  |= ( (fgetc(in_stream) & 0xFF) << 0x08 );
  int32_value  |= ( (fgetc(in_stream) & 0xFF) << 0x10 );
  int32_value  |= ( (fgetc(in_stream) & 0xFF) << 0x18 );
  
  return int32_value;
}


float  stl_get_little_float32(FILE* in_stream)
{
  union{
    int   int32_value;
    float float32_value;
  } stl_data_value;

  stl_data_value.int32_value = fgetc(in_stream) & 0xFF;
  stl_data_value.int32_value  |= ( (fgetc(in_stream) & 0xFF) << 0x08 );
  stl_data_value.int32_value  |= ( (fgetc(in_stream) & 0xFF) << 0x10 );
  stl_data_value.int32_value  |= ( (fgetc(in_stream) & 0xFF) << 0x18 );

  return stl_data_value.float32_value;
}


int stl_type(char *fileName)
{
  unsigned char data[128];
  int binary = 0;
  int i;
  FILE* in_stream = fopen(fileName,"r");

  if(in_stream == NULL){
    fprintf(stderr,"---  err stl load (fopen) ---\n");
    return -1;
  }

  fread(data,128,1,in_stream);

  for(i = 0; i < sizeof(data);i++){
    /* ascii code check */
    if(data[i] > 127){
      binary  = 1;
    }
  }

  fclose(in_stream);

  return binary;
}


int stl_read_ascii(char *fileName) 
{

  char buf[1024];
  double x,y,z;
  int first = 0;
  int i;
  FILE* fin = fopen(fileName,"r");
  
  while(fscanf(fin,"%s",buf) != EOF ){

    if(!strcmp("endsolid",buf))
      break;

    /* facet */
    if(!strcmp("facet",buf)){
      fscanf (fin, "%s ", buf); /* normal string */ 
      fscanf (fin, "%lf %lf %lf", &x,&y,&z); /* normal */ 

      fscanf (fin, "%s ", buf); /* outer string */ 
      fscanf (fin, "%s ", buf); /* loop string */ 

      nTri++;
      obj = (STL_TRI*)malloc(sizeof(STL_TRI)); 

      if(!first){
        first = 1;
        head = obj; 
      }else{
        pre->next = obj;
      }

      for( i = 0 ; i < 3;i++){
        fscanf (fin, "%s", buf); /* vertex string */ 
        fscanf (fin, "%lf %lf %lf \n", &x,&y,&z);
        obj->p[i][0] = x;  obj->p[i][1] = y;   obj->p[i][2] = z;
      }

      obj->next = NULL;
      pre = obj;


      fscanf (fin, "%s ", buf); /* endloop string */ 
      fscanf (fin, "%s ", buf); /* endfacet string */ 
    }
  }

  fclose(fin);

  return 0;
}

int stl_read_binary(char *fileName) 
{
  char header_record[256];
  int i,j;
  int first = 0;

  //open stl file
  FILE* in_stream = fopen(fileName,"r");


  //read  header 
  fread(header_record,80,1,in_stream);

  header_record[80] = '\0';

  //print header//
  fprintf(stderr,"%s\n",header_record);

  nTri = stl_get_little_int32(in_stream);

  fprintf(stderr,"size %d\n",nTri);

  for(i = 0; i < nTri;i++){
    obj = (STL_TRI*)malloc(sizeof(STL_TRI)); 

    if(!first){
      first = 1;
      head = obj; 
    }else{
      pre->next = obj;
    }

    /* normal */
    stl_get_little_float32(in_stream);
    stl_get_little_float32(in_stream);
    stl_get_little_float32(in_stream);

    /* coordnate */
    for(j = 0; j < 3;j++){
      obj->p[j][0] = stl_get_little_float32(in_stream);
      obj->p[j][1] = stl_get_little_float32(in_stream);
      obj->p[j][2] = stl_get_little_float32(in_stream);
    }

    obj->next = NULL;
    pre = obj;

    fseek(in_stream,2,SEEK_CUR);
  } 


  fclose(in_stream);

  return 0;
}


int  main(int argc,char** argv)
{

  char* infile;
  char* outfile;
  int i;
  int type;

  if(argc != 3){
    fprintf (stderr, "Usage : \n");
    fprintf (stderr, "%s stlFileName(in) pchFileName(out) \n",argv[0]);
    exit (-1);
  }
   

  infile  = argv[1];
  outfile = argv[2];



  /*  stl read */
  type = stl_type(infile);
  if(type ==  -1)
    return -1;

 
  if(type == STL_ACSII){
    stl_read_ascii(infile);
  }else{
    stl_read_binary(infile);
  }


  
  /*  pch write */

  FILE* fout = fopen(outfile,"w");
  if(fout == NULL)
    exit (-1);

  fprintf(fout,"%d \n",nTri * 3);

  obj = head; 
  while(obj != NULL){
    for( i = 0; i < 3; i++){
      fprintf(fout,"%f %f %f \n",obj->p[i][0],obj->p[i][1],obj->p[i][2]);
    }
    obj = obj->next;
  }

  fprintf(fout,"%d \n",nTri);

  for( i = 0; i < nTri; i++){
    fprintf(fout,"%d %d %d \n",i*3,i*3+1,i*3+2);
  }

  fclose(fout);



  /* free obj */
  obj = head; 
  while(obj != NULL){
    next = obj->next;
    free(obj);
    obj = next;
  }



  return 0;

}









