#include <stdlib.h>  
#include <stdio.h>
#include <string.h>
#include <math.h>   

/*********************
 tri model info
**********************/
/* point info */

int  nPos;
int nfVertex = 0;
/* from 0 to 2 of array is  positon */
double (*pos)[3]; 
/* 0 of array is connected  one of  half edge id */
/* 1 of array is feature vertex flg */
int (*posAtt)[2]; 


/* tri info */
int  nTri = 0;
int  nfFace = 0;
/* 0,1,2 of array is  vertex id
   3,4,5 of array is  neighborhood face id
   6 of araay is feature face id
*/
int (*tri)[7];

static int  TRI_EDGE_MAP[3][2] = {
  { 0, 1 },{ 1, 2 },{ 2, 0 }
};

/* half edge info */
int  nEdge;
int nfEdge = 0;
/* 0 and 1 of array is number of half edge.
   2 of array is  swap flag.
   3 of array   connected face id.
   4 of array is  edge id of face.
*/
int (*edge)[5];

/*********************
    utility
**********************/
typedef struct _iarray{
  int    maxSize;
  int    num;
  int*   e;
}iarray;

int iarray_initialize(iarray* a,int numMax)
{
  a->e =  (int*)malloc(sizeof(int) * numMax);
  if(a->e == NULL)
    return -1;
  a->maxSize = numMax;
  a->num = 0;
  return 0;
}
int iarray_push_back(iarray* a,int p)
{
  int growSize = 100;
  int* w;
  int i;

  if(a->maxSize > a->num){
    a->e[a->num] = p;
    a->num++;
  }else{
    w =  (int*)malloc(sizeof(int) * (a->maxSize + growSize));
    if(a->e == NULL)
      return -1;

    a->maxSize += growSize;

    for(i = 0; i < a->num;i++)
      w[i] = a->e[i];

    free(a->e);
    w[a->num] = p;
    a->e = w;
    a->num++;
  }
  return 0;

}
int iarray_unique_add(iarray* a,int p)
{
  int i;

  for(i = 0; i < a->num;i++)
    if(a->e[i] == p)
      return i;

  if(iarray_push_back(a,p))
    return -2;

  return -1;

}
int iarray_pop_back(iarray* a)
{
  a->num--;
  return a->e[a->num];
}
void iarray_clear(iarray* a)
{
  a->maxSize = 0;
  a->num = 0;
  free(a->e);
}

/*********************
    function 
**********************/


void  tri_get_unit_normal(double p0[3],double p1[3],double p2[3],double retNormal[3])
{
  double a[3];
  double b[3];
  double c[3];
  double norm;
  /* create vector */
  a[0] = p1[0] - p0[0]; a[1] = p1[1] - p0[1]; a[2] = p1[2] - p0[2];
  b[0] = p2[0] - p0[0]; b[1] = p2[1] - p0[1]; b[2] = p2[2] - p0[2];
  /* cross product */
  c[0] = a[1] * b[2] - a[2] * b[1];
  c[1] = a[2] * b[0] - a[0] * b[2];
  c[2] = a[0] * b[1] - a[1] * b[0];

  /* make unit vector */
  norm = sqrt(c[0]*c[0] + c[1]*c[1] + c[2]*c[2]);
  retNormal[0] = c[0] / norm;
  retNormal[1] = c[1] / norm;
  retNormal[2] = c[2] / norm;
}
double  vector_get_angle_between(double vec01[3],double vec02[3])
{
  double norm1 = sqrt(vec01[0]*vec01[0] + vec01[1]*vec01[1] + vec01[2]*vec01[2]);
  double norm2 = sqrt(vec02[0]*vec02[0] + vec02[1]*vec02[1] + vec02[2]*vec02[2]);

  if(norm1 == 0.0 || norm2 == 0.0) return -1;

  double temp = vec01[0] * vec02[0] + vec01[1] * vec02[1] + vec01[2] * vec02[2];

  if(temp == 0.0)  return  90.0;

  double norm = norm1 * norm2;
  double c = temp/norm;

  if(1.0 < c)  return 0.0;
  if(-1.0 > c) return 180.0;

  c = acos(c); 
  /* change to degree */
  return (c * (180 / M_PI));
}

int  compare(const void* x, const void* y)
{
  int* a = (int*)x;
  int* b = (int*)y;

  /* a < b */
  if(a[0] < b[0]){
    return -1;
  }
  if(a[0] == b[0])
    if(a[1] < b[1])
      return -1;

  if(a[0] == b[0] && a[1] == b[1])
    return 0;

  return 1;
}

void edge_create()
{
  int i,j,w;
  int numEdeg = 0;

  nEdge = nTri * 3;

  edge=  (int (*)[5])calloc(nEdge,sizeof(int[5]));

  /* make edge list */
  for(i = 0; i < nTri ;i++){
    for(j = 0; j < 3 ;j++){
      edge[numEdeg][0] = tri[i][TRI_EDGE_MAP[j][0]];
      edge[numEdeg][1] = tri[i][TRI_EDGE_MAP[j][1]];
      if(edge[numEdeg][0] > edge[numEdeg][1]){
        w = edge[numEdeg][0];
        edge[numEdeg][0] = edge[numEdeg][1];
        edge[numEdeg][1] = w;
        edge[numEdeg][2] = 1;
      }
      edge[numEdeg][3] = i;
      edge[numEdeg][4] = j;
      numEdeg++;
    }     
  }

  /* sort edge  */
  qsort(edge,nEdge,sizeof(int)*5,compare);

#if 0
  for(i = 0; i < nEdge ;i++)
  printf("edge =(%d,%d,%d,%d,%d)\n",edge[i][0],edge[i][1],edge[i][2],
                                    edge[i][3],edge[i][4]);
#endif

  /*  associate half edge and face  */
  /*  set from tri[i][3]  to tri[i][4]*/

   for(i = 0; i < nEdge ;i+=2){
     tri[edge[i][3]][edge[i][4]+3]   = edge[i+1][3];
     tri[edge[i+1][3]][edge[i+1][4]+3]   = edge[i][3];
   }

  /*  associate half edge and vertex  */
   for(i = 0; i < nEdge ;i++){
     posAtt[edge[i][0]][0] = i;
     posAtt[edge[i][1]][0] = i;
   }

#if 0
   for(i = 0; i < nPos ;i++)
     printf("pos = (%d,%d)\n",posAtt[i][0],posAtt[i][1]);
#endif
  
   
}

void   feature_create(double defaultAngle)
{
  double currentUnitNormal[3]; 
  double neighborUnitNormal[3];
  double angle;

  int nearTri,i;
  iarray array;
  iarray* faces;
  
  iarray_initialize(&array,100);


  /*************************
   create feature face 
  **************************/
  /* clear feature face id */
  for(i = 0; i < nTri;i++){
    tri[i][6]=-1;
  }
  
  for(i = 0; i < nTri;i++){    
    if(tri[i][6] == -1){
      tri[i][6] = nfFace;
      nfFace++;
      tri_get_unit_normal(pos[tri[i][0]],pos[tri[i][1]],pos[tri[i][2]],
                          currentUnitNormal);
      iarray_push_back(&array,i);


      iarray_push_back(&array,tri[i][3]);
      iarray_push_back(&array,tri[i][4]);
      iarray_push_back(&array,tri[i][5]);

      
      while(array.num != 0){
        nearTri = iarray_pop_back(&array);
	  
        if(tri[nearTri][6] == -1){
          tri_get_unit_normal(pos[tri[nearTri][0]],
                              pos[tri[nearTri][1]],
                              pos[tri[nearTri][2]],
                              neighborUnitNormal);
	  
           angle  = vector_get_angle_between(currentUnitNormal,
                                             neighborUnitNormal);


          if(angle > 180.0 - angle)
            angle = 180.0 - angle;
  
	  
          /* check angle */
          if(angle < defaultAngle){
            tri[nearTri][6] = tri[i][6];
            iarray_push_back(&array,tri[nearTri][3]);
            iarray_push_back(&array,tri[nearTri][4]);
            iarray_push_back(&array,tri[nearTri][5]);
          }
        }
      } 
    }
  }
  iarray_clear(&array);

#if 0
  for( i = 0; i < nTri;i++)
    printf("nTri(%d) = (%d,%d,%d,%d,%d,%d,%d)\n",i,tri[i][0],tri[i][1],
                                             tri[i][2],tri[i][3],
                                             tri[i][4],tri[i][5],
                                             tri[i][6]);
#endif

  /*************************
   search feature vertex 
  **************************/

  /* search faces around a vertex. 
  if number of faces around a vertex is more than 2,it is feature vertex.
  */
  faces =  (iarray*)calloc(nPos,sizeof(iarray));
  for(i = 0; i < nPos;i++){
    iarray_initialize(&(faces[i]),20);
    posAtt[i][1] = 0;
  }

  for(i = 0; i < nTri;i++){
    iarray_unique_add(&(faces[tri[i][0]]),tri[i][6]);
    iarray_unique_add(&(faces[tri[i][1]]),tri[i][6]);
    iarray_unique_add(&(faces[tri[i][2]]),tri[i][6]);
  }

  for(i = 0; i < nPos;i++){
    if(faces[i].num > 2){
      posAtt[i][1] = 1;
      nfVertex++;
    }
  }

  for(i = 0; i < nPos;i++){
   iarray_clear(&(faces[i]));

  }

  free(faces);

  /*************************
   search feature edge 
  **************************/

  /* search feature edge.
   if number of feature faces around a edge is more than 1,it is feature edge.
  */
  
  for(i = 0; i < nEdge;i+=2){
    if(tri[edge[i][3]][6] != tri[edge[i+1][3]][6]) {
      nfEdge++;
    }
  }


  
}

#if 0
void   boundBox_check()
{
  int i;

  minimum[0] = pos[0][0]; minimum[1] = pos[0][1]; minimum[2] = pos[0][2]; 
  maximum[0] = pos[0][0]; maximum[1] = pos[0][1]; maximum[2] = pos[0][2]; 

  for(i = 1; i < nPos ;i++){
    if(minimum[0] > pos[i][0]) minimum[0] = pos[i][0];
    if(maximum[0] < pos[i][0]) maximum[0] = pos[i][0];
    if(minimum[1] > pos[i][1]) minimum[1] = pos[i][1];
    if(maximum[1] < pos[i][1]) maximum[1] = pos[i][1];
    if(minimum[2] > pos[i][2]) minimum[2] = pos[i][2];
    if(maximum[2] < pos[i][2]) maximum[2] = pos[i][2];
  }
}  

#endif
int  pch_read(char* infile)
{
  int i;  
  FILE* fin = fopen(infile,"r");
  if(fin == NULL){
    fprintf(stderr,"### ERR file not found (%s)\n",infile);
    exit (-1);
  }

  fscanf (fin, "%d \n", &nPos);
  pos=     (double (*)[3])calloc(nPos,sizeof(double[3]));
  posAtt=  (int (*)[2])calloc(nPos,sizeof(int[2]));
 
  for(i = 0; i < nPos ;i++){
    fscanf (fin,"%lf %lf %lf \n", &pos[i][0],&pos[i][1],&pos[i][2]);
  }

  fscanf (fin, "%d \n",&nTri);
  tri=  (int (*)[7])calloc(nTri,sizeof(int[7]));

  for(i = 0; i < nTri ;i++){
    fscanf (fin, "%d %d %d", &tri[i][0],&tri[i][1],&tri[i][2]);
  }

  fclose(fin);
  return 0;

}

int  pcg_write(char* outfile)
{
  int i,j;  
  iarray* faces; 
  FILE* fout = fopen(outfile,"w");

  /* write feature vertex */
  fprintf(fout,"#mainVertexInfo\n");  
  fprintf(fout,"mainVertexN  %d\n",nfVertex); 
  for(i = 0; i < nPos;i++){
    if( posAtt[i][1] == 1){
      fprintf(fout,"  %d\n",i); 
    }
  }

  /* write feature edge */
  fprintf(fout,"#edgeGroupInfo\n");  
  fprintf(fout,"edgeGroupN %d\n",nfEdge);  

  for(i = 0; i < nEdge;i+=2){
    if(tri[edge[i][3]][6] != tri[edge[i+1][3]][6]) {
      fprintf(fout,"  edgeGroup 2\n");
      fprintf(fout,"  %d\n",edge[i][0]);
      fprintf(fout,"  %d\n",edge[i][1]);
    }
  }

  /* write feature face */
  fprintf(fout,"#faceGroupInfo\n");  
  fprintf(fout,"faceGroupN %d\n",nfFace);  

  faces =  (iarray*)calloc(nfFace,sizeof(iarray));
  for(i = 0; i < nfFace;i++){
    iarray_initialize(&(faces[i]),1000);
  }

  for(i = 0; i < nTri;i++){
    iarray_push_back(&(faces[tri[i][6]]),i);
  }
    
  for(i = 0; i < nfFace;i++){
    fprintf(fout,"  faceGroup %d\n", faces[i].num);
    for(j = 0; j < faces[i].num;j++){
      fprintf(fout,"  %d\n", faces[i].e[j]);
    }
  }

  for(i = 0; i < nfFace;i++){
   iarray_clear(&(faces[i]));
  }

  free(faces);


  fclose(fout);
  return 0;
}

int  main(int argc,char** argv)
{
  char infile[256];
  char outfile[256];
  double  angle = 45.0;


  if(argc != 3){
    fprintf (stderr, "Usage : \n");
    fprintf (stderr, "%s pchFileName(in) pcgFileName(out)\n",argv[0]);
    exit (-1);
  }


  strcpy(infile,argv[1]);
  strcpy(outfile,argv[2]);
  
  /* read pch file*/  
  pch_read(infile);
  edge_create();

  /* create feature */
  feature_create(angle);


  /* write pcg */
  pcg_write(outfile);

  /* free */
  if(pos!=NULL) free(pos);
  if(tri!=NULL) free(tri);
  if(edge!=NULL) free(edge);

  return 0;
}




