#include <stdlib.h>  
#include <stdio.h>   
#include <string.h>   
#include <math.h>   

/* file name info */
char infile[256];
char outfile[256];

char option[256];


/* affine matrix */

double  mat[4][4];

/* point info */
int  nPos;

/* tri info */
int  nTri;


char buf[1024];

void matrix_print(double mat[4][4])
{
  int i;
  
  printf("-----------------------\n");
  for(i=0; i < 4;i++)
    printf("%f %f %f %f\n",mat[i][0],mat[i][1],mat[i][2],mat[i][3]);
  printf("-----------------------\n");
}



void matrix_translation(double x,double y,double z)
{
  mat[0][0] = 1.0;  mat[0][1] = 0.0;  mat[0][2] = 0.0; mat[0][3] = 0.0;
  mat[1][0] = 0.0;  mat[1][1] = 1.0;  mat[1][2] = 0.0; mat[1][3] = 0.0;
  mat[2][0] = 0.0;  mat[2][1] = 0.0;  mat[2][2] = 1.0; mat[2][3] = 0.0;
  mat[3][0] = x;    mat[3][1] = y;    mat[3][2] = z;   mat[3][3] = 1.0;
}

void matrix_scaling(double xScale,double yScale,double zScale)
{
  mat[0][0] = xScale;  mat[0][1] = 0.0;  mat[0][2] = 0.0; mat[0][3] = 0.0;
  mat[1][0] = 0.0;  mat[1][1] = yScale;  mat[1][2] = 0.0; mat[1][3] = 0.0;
  mat[2][0] = 0.0;  mat[2][1] = 0.0;  mat[2][2] = zScale; mat[2][3] = 0.0;
  mat[3][0] = 0.0;  mat[3][1] = 0.0;    mat[3][2] = 0.0;   mat[3][3] = 1.0;
}




void  matrix_xAxis_rotaion(double t)
{
  mat[0][0] = 1.0;  mat[0][1] = 0.0;  mat[0][2] = 0.0; mat[0][3] = 0.0;
  mat[1][0] = 0.0;  mat[1][1] = cos(t);  mat[1][2]= sin(t); mat[1][3] = 0.0;
  mat[2][0] = 0.0;  mat[2][1] = -sin(t); mat[2][2] =cos(t); mat[2][3] = 0.0;
  mat[3][0] = 0.0;  mat[3][1] = 0.0;    mat[3][2] = 0.0;   mat[3][3] = 1.0;
}

void  matrix_yAxis_rotaion(double t)
{
  mat[0][0] = cos(t);  mat[0][1] = 0.0;  mat[0][2] = -sin(t); mat[0][3] = 0.0;
  mat[1][0] = 0.0;  mat[1][1] = 1.0;  mat[1][2] = 0.0; mat[1][3] = 0.0;
  mat[2][0] = sin(t);  mat[2][1] = 0.0;  mat[2][2] = cos(t); mat[2][3] = 0.0;
  mat[3][0] = 0.0;  mat[3][1] = 0.0;  mat[3][2] = 0.0;   mat[3][3] = 1.0;
}

void  matrix_zAxis_rotaion(double t)
{
  mat[0][0] = cos(t);  mat[0][1] = sin(t);  mat[0][2] = 0.0; mat[0][3] = 0.0;
  mat[1][0] = -sin(t);  mat[1][1] = sin(t);  mat[1][2] = 0.0; mat[1][3] = 0.0;
  mat[2][0] = 0.0;  mat[2][1] = 0.0;  mat[2][2] = 1.0; mat[2][3] = 0.0;
  mat[3][0] = 0.0;    mat[3][1] = 0.0;    mat[3][2] = 0.0;   mat[3][3] = 1.0;
}



void matrix_mul(double org[3],double mat[4][4],double ret[3])
{

  
  ret[0] =  mat[0][0] * org[0] + mat[1][0]  * org[1]
             + mat[2][0] * org[2] + mat[3][0];

  ret[1] =  mat[0][1] * org[0] + mat[1][1]  * org[1]
             + mat[2][1] * org[2] + mat[3][1];
  
  ret[2] =  mat[0][2] * org[0] + mat[1][2]  * org[1]
             + mat[2][2] * org[2] + mat[3][2];

}


void transration_set(char* option)
{
  double xLen,yLen,zLen;
  int len,i;
  int count = 0;

  len = strlen(option);
  for(i = 0; i < len;i++){
    if((option[i] == 'x')||(option[i] == 'X')){
      option[i]=' ';
      count++;
    }
  }

  if(count < 1){
    printf("#ERR The option is not enough\n");
    exit(1);
  }

  sscanf(option,"%lf %lf %lf",&xLen,&yLen,&zLen);
  matrix_translation(xLen,yLen,zLen);
  printf("translation=(%f,%f,%f)\n",xLen,yLen,zLen);

}

void scale_set(char* option)
{
  double xScale,yScale,zScale;
  int len,i;
  int count = 0;

  len = strlen(option);
  for(i = 0; i < len;i++){
    if((option[i] == 'x')||(option[i] == 'X')){
      option[i]=' ';
      count++;
    }
  }

  if(count < 2){
    printf("#ERR The option is not enough\n");
    exit(1);
  }

  sscanf(option,"%lf %lf %lf",&xScale,&yScale,&zScale);
  matrix_scaling(xScale,yScale,zScale);
  printf("scale=(%f,%f,%f)\n",xScale,yScale,zScale);

}

void rotate_set(char* option)
{
  double degree;
  double theta;
  int len,i;
  int count = 0;
  char  axis;

  len = strlen(option);
  for(i = 1; i < len;i++){
    if((option[i] == 'x')||(option[i] == 'X')){
      option[i]=' ';
      count++;
    }
  }

  if(count < 1 ){
    printf("#ERR The option is not enough\n");
    exit(1);
  }

  sscanf(option,"%c %lf",&axis,&degree);
  
  theta = (degree * M_PI) / 180;
  printf("%c axis rotation(degree) =%f\n",axis,degree);

  

  if(axis == 'x' || axis == 'X'){
    matrix_xAxis_rotaion(theta);
    return ;
  }
  if(axis == 'y' || axis == 'Y'){
    matrix_yAxis_rotaion(theta);
    return ;
  }
  if(axis == 'z' || axis == 'Z'){
    matrix_zAxis_rotaion(theta);
    return ;
  }

  printf("### ERR bad axis\n");
  return;


}



int  main(int argc,char** argv)
{
  double pos[3];
  double ret[3];
  int  i,v0,v1,v2;

  if(argc < 5){
    fprintf (stderr, "Usage : \n");
    fprintf (stderr, "%s pchFileName(in) pchFileName(out) option \n",argv[0]);
    fprintf (stderr, "-trans  displacement of x X displacement of y X displacement of z\n");
    fprintf (stderr, "ex) -trans  3.0x4.0x5.0\n");
    fprintf (stderr, "-scale  scale factor (x) X scale factor (y) X scale factor (z)\n");
    fprintf (stderr, "ex) -scale  5.0x5.0x5.0\n");
    fprintf (stderr, "-rotate  axis X degree\n");
    fprintf (stderr, "ex) -roate  xX45.0\n");


    return -1;
  }



  strcpy(infile,argv[1]);
  strcpy(outfile,argv[2]);

  if(!strcmp("-trans",argv[3])){
    strcpy(option,argv[4]);
    transration_set(option);
  }else{
    if(!strcmp("-scale",argv[3])){
      strcpy(option,argv[4]);
      scale_set(option);
    }else{
      if(!strcmp("-rotate",argv[3])){
        strcpy(option,argv[4]);
        rotate_set(option);
      }else{
        printf("#ERR The option is not enough\n");
        exit(1);
      }
    }
  }


  FILE* fout = fopen(outfile,"w");
  if(fout == NULL){
    printf("#ERR file not open  (%s)\n",outfile);
    return -1;
  }

  FILE* fin = fopen(infile,"r");
  if(fin == NULL){
    printf("#ERR file not found (%s)\n",infile);
    return -1;
  }


  fscanf (fin, "%d\n", &nPos);
  
  fprintf(fout, "%d\n",nPos);

  for(i = 0; i < nPos;i++){
    fscanf (fin,  "%lf %lf %lf \n", &(pos[0]),&(pos[1]),&(pos[2]));
    matrix_mul(pos,mat,ret);
    fprintf(fout, "%f %f %f\n",ret[0],ret[1],ret[2]);
  }


  fscanf (fin, "%d \n", &nTri);
  fprintf(fout, "%d\n",nTri);

  for(i = 0; i < nTri;i++){
    fscanf (fin,  "%d %d %d", &v0,&v1,&v2);
    fprintf(fout,  "%d %d %d\n",v0,v2,v1);
  }

 
  fclose(fin);
  fclose(fout);

  return 0;

}









