/*******************************************************************************
  TPI - flexible but useless plug-in framework.
  Copyright (C) 2002-2009 Silky

  This library is free software; you can redistribute it and/or modify it under
  the terms of the GNU Lesser General Public License as published by the Free
  Software Foundation; either version 2.1 of the License, or (at your option)
  any later version.

  This library is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
  for more details.

  You should have received a copy of the GNU Lesser General Public License along
  with this library; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

  $Id: functions.cpp,v 1.11 2009/08/16 03:17:36 sirakaba Exp $
*******************************************************************************/

//******************************************************************************
//    t@Cǂݍ
//******************************************************************************

#include "frontend-wx.h"
#include "frm_main.h"
#include "dlg_make.h"
#include "functions.h"

//******************************************************************************
//    Rg[n֐
//******************************************************************************

bool TreeView_CheckNewerItem(wxTreeCtrl * tree_ctrl, wxTreeItemId idParent, const wxString & szDirPath)
{
	// ŏ̎qACe擾B
	wxTreeItemIdValue idv;
	wxTreeItemId idChild = tree_ctrl->GetFirstChild(idParent, idv);
	if (idChild.IsOk())
	{
		do
		{
			// ACeƖOȂOKB
			if (tree_ctrl->GetItemText(idChild) == szDirPath.BeforeFirst(wxT('/')))
			{
				// ȉ̊KwꍇB
				if (szDirPath.Find(wxT('/')) == wxNOT_FOUND)
				{
					return true;
				}

				// ܂KwLꍇAċAB
				return TreeView_CheckNewerItem(tree_ctrl, idChild, szDirPath.AfterFirst(wxT('/')));
			}

			idChild = tree_ctrl->GetNextSibling(idChild);
		}
		while (idChild.IsOk());
	}

	// Ώۂꍇɂ͍쐬B
	if (! szDirPath.IsEmpty())
	{
		// 2Kwȏ[ꍇɂΉB
		wxString szTemp = szDirPath;
		wxTreeItemId idTemp = idParent;
		do
		{
			// WJĂ쐬B
			idTemp = tree_ctrl->AppendItem(idTemp, szTemp.BeforeFirst(wxT('/')), 1, -1);
			szTemp = szTemp.AfterFirst(wxT('/'));
		}
		while (szTemp.Find(wxT('/')) != wxNOT_FOUND);

		// ŌɋłȂꍇɂ͂1Kw쐬B
		if (! szTemp.IsEmpty())
		{
			tree_ctrl->AppendItem(idTemp, szTemp, 1, -1);
		}
	}

	return false;
}

wxString TreeView_GetItemPath(wxTreeCtrl * tree_ctrl, wxTreeItemId idItem)
{
	wxString szItemName, szNodePath = wxEmptyString;

	// ACe̖O擾B
	while ((szItemName = tree_ctrl->GetItemText(idItem)))
	{
		if (szItemName == wxT("-----"))
		{
			break;
		}

		// pXɒǉB
		szNodePath = szItemName + wxFileName::GetPathSeparator() + szNodePath;

		// eACeɑkB
		idItem = tree_ctrl->GetItemParent(idItem);
		if (idItem == tree_ctrl->GetRootItem())
		{
			// ɂ̂͏ɓS\B
			szNodePath = wxT("*");
			break;
		}
	}

	return (szNodePath.Find(wxFileName::GetPathSeparator()) == wxNOT_FOUND) ? szNodePath : szNodePath.BeforeLast(wxFileName::GetPathSeparator());
}

//******************************************************************************
//    ֐
//******************************************************************************

// fBNgVKɍ쐬B
wxFileName MakeDirPath(wxFileName fnPath, wxString szBase, bool bAct)
{
	// Ƃ肠Ă݂B
	wxFileName fnDir = fnPath;
	fnDir.AppendDir(szBase);
	if (! fnDir.DirExists() && ! ::wxFileExists(fnDir.GetPath()))
	{
		if (! bAct || fnDir.Mkdir())
		{
			return fnDir;
		}
	}

	// _Ȃ"_%d"tĎsB
	for (int i = 0; i < 255; i++)
	{
		wxString s;
		s.Printf(wxT("_%d"), i);
		fnDir = fnPath;
		fnDir.AppendDir(szBase + s);
		if (! fnDir.DirExists() && ! ::wxFileExists(fnDir.GetPath()))
		{
			if (! bAct || fnDir.Mkdir())
			{
				return fnDir;
			}
		}
	}

	// G[IB
	fnDir.Clear();
	return fnDir;
}

wxArrayString MakeTargetFileList(MainFrame * frm, bool fOnlyOneFile)
{
	wxArrayString as;
	for (int i = 0; i < frm->list_ctrl->GetItemCount(); i++)
	{
		if ((as.GetCount() < (unsigned) frm->list_ctrl->GetSelectedItemCount()) && (frm->list_ctrl->GetItemState(i, wxLIST_STATE_SELECTED) & wxLIST_STATE_SELECTED) || frm->list_ctrl->GetSelectedItemCount() == 0)
		{
			as.Add(frm->list_ctrl->showFileInfo[i].szStoredName);
			if (fOnlyOneFile)
			{
				return as;
			}
		}
	}

	return as;
}

bool WillMakeDirByArcName(MainFrame * frm, MakeDialog * mk)
{
	if (mk->chDirMake->GetSelection() != 2)
	{
		return mk->chDirMake->GetSelection() == 1;
	}

	// [gɃfBNgƃt@C킹2ȏ゠ƂAfBNg쐬B
	switch (frm->tree_ctrl->GetChildrenCount(frm->tree_ctrl->GetLastChild(frm->tree_ctrl->GetRootItem()), false))
	{
	case 0:
	{
		// fBNgȂ̂ŁA[gɃt@C2ȏ゠邩ǂ𔻒B
		bool fFlag = false;
		for (size_t i = 0; i < frm->fileinfo.GetCount(); i++)
		{
			if (frm->fileinfo[i].fnFileName.GetPath().IsEmpty())
			{
				// t@C̓[gɂB
				if (fFlag)
				{
					return true;
				}

				fFlag = true;
			}
		}
		break;
	}
	case 1:
		// fBNg1Ȃ̂ŁA[gɃt@CȂǂ𔻒B
		for (size_t i = 0; i < frm->fileinfo.GetCount(); i++)
		{
			if (frm->fileinfo[i].fnFileName.GetPath().IsEmpty())
			{
				return true;
			}
		}
		break;
	default:
		// fBNg2ȏ゠̂ŁAIɓWJfBNg쐬B
		return true;
	}

	return false;
}

wxString GetFileTypeName(wxFileName fn)
{
	wxString szExt = fn.GetExt().MakeUpper();
	wxString sz = szExt + (szExt.IsEmpty() ? wxT("file") : wxT(" file"));
	wxMimeTypesManager mimeFile;
	wxFileType * ftFile = mimeFile.GetFileTypeFromExtension(szExt);
	if (ftFile)
	{
		ftFile->GetDescription(& sz);
	}
	return sz;
}

wxIcon GetFileTypeIcon(wxFileName fn)
{
	wxMimeTypesManager mimeFile;
	wxIconLocation ilFile;
	wxFileType * ftFile = mimeFile.GetFileTypeFromExtension(fn.GetExt());
	wxIcon icon;
	if (ftFile && ftFile->GetIcon(& ilFile))
	{
		if (! ::wxFileExists(ilFile.GetFileName()))
		{
			icon.CopyFromBitmap(wxBitmap((ilFile.GetFileName() == wxT("%1") || ilFile.GetFileName() == wxT("\"%1\"")) ? FE_DIR_S_ICO wxT("exe.png") : FE_DIR_S_ICO wxT("file.png"), wxBITMAP_TYPE_ANY));
		}
		else
		{
			wxIcon i(ilFile);
			icon = i;
		}
	}
	else
	{
		icon.CopyFromBitmap(wxBitmap(FE_DIR_S_ICO wxT("file.png"), wxBITMAP_TYPE_ANY));
	}
	return icon;
}
