<?php
/*----------------------------------------------------

  TextAuthDatabaseץ饰 For ThreadWiki
   ƥȥեѤWikiǧڥǡ١ץ饰

------------------------------------------------------*/

require_once( 'Wiki/TwAuthDatabase.php' );
require_once( 'FLATz/FileControlLib.php' );


class TextAuthDatabase extends TwAuthDatabase
{

var $auth_db_dir;

/*----------------------------------------------------
  󥹥ȥ饯
------------------------------------------------------*/
function TextAuthDatabase(&$config)
{
	parent::TwAuthDatabase($config);
	$this->auth_db_dir = $config->get( 'txt_auth_database_dir' );
}
//-----------------------------------------------------


/*----------------------------------------------------

  get_user_name_list()
    桼̾ꥹȤɤ߹

  return       array

------------------------------------------------------*/
function get_user_name_list()
{
	$filelist = FileControlLib::search_dir($this->auth_db_dir);
	
	$user_name_list = array();
	for( $i=0;$i<count($filelist);$i++ )
	{
		if( preg_match("/([^\/]+?)\.user$/",$filelist[$i],$hitdata) )
		{
			array_push($user_name_list,$hitdata[1]);
		}
	}
	return $user_name_list;
}

//-----------------------------------------------------





/*----------------------------------------------------

  add_user(&$user_data)桼ɲ

  $user_data   񤭹UserDataClass֥
  
  return       true  : 
                 false : 

------------------------------------------------------*/
function add_user(&$user_data)
{
	if( $user_data->check_valid() != "ok" )
	{
		return false;
	}
	
	if($this->check_user_exists($user_data->user_name))
	{
		return false;
	}
	
	$filename = $this->get_file_name($user_data->user_name,"user");
	$stream   = $this->encode_filestream_user_data($user_data);
	
	return FileControlLib::create_file( $filename,$stream );
}
//-----------------------------------------------------


/*----------------------------------------------------

  check_user_exists($user_name) оݥ桼¸ߤ뤫å

  $user_name   оݥ桼̾
  
  return       true  : ¸ߤ
                 false : ¸ߤʤ

------------------------------------------------------*/
function check_user_exists($user_name)
{
	$filename = $this->get_file_name($user_name,"user");
	return file_exists($filename);
}
//-----------------------------------------------------


/*----------------------------------------------------

  delete_user($user_name)桼

  $user_name   оݥ桼̾
  
  return       true  : 
                 false : 

------------------------------------------------------*/
function delete_user($user_name)
{
	return unlink( $this->get_file_name($user_name,"user") );
}
//-----------------------------------------------------


/*----------------------------------------------------

  get_user_data($user_name,&$user_data)
    桼ǡ

  $user_name   оݥ桼̾
  $user_data   ɹUserDataClass֥

  return       true  : 
                 false : 

------------------------------------------------------*/
function get_user_data($user_name,&$user_data)
{
	if( $this->check_user_exists($user_name) )
	{
		$filename = $this->get_file_name($user_name,"user");
		$stream = "";
		
		if( FileControlLib::load_target_file($filename,$stream) )
		{
			$this->decode_filestream_user_data($stream,$user_data);
			return true;
		}
	}
	return false;
}
//-----------------------------------------------------


/*----------------------------------------------------

  modify_user_data($user_name,&$user_data)
    桼ǡ

  $user_name   оݥ桼̾
  $user_data   񤭹GroupDataClass֥

  return       true  : 
                 false : 

------------------------------------------------------*/
function modify_user_data($user_name,&$user_data)
{
	if( $this->check_user_exists($user_name) )
	{
		$filename = $this->get_file_name($user_name,"user");
		$stream   = $this->encode_filestream_user_data($user_data);
		
		return FileControlLib::target_file_update($filename,$stream);
	}
	return false;
}
//-----------------------------------------------------


/*----------------------------------------------------

  get_group_name_list()
    롼̾ꥹȤɤ߹

  return       array

------------------------------------------------------*/
function get_group_name_list()
{
	$filelist = FileControlLib::search_dir($this->auth_db_dir);
	
	$user_name_list = array();
	for( $i=0;$i<count($filelist);$i++ )
	{
		if( preg_match("/([^\/]+?)\.group$/",$filelist[$i],$hitdata) )
		{
			array_push($user_name_list,$hitdata[1]);
		}
	}
	return $user_name_list;
}

//-----------------------------------------------------


/*----------------------------------------------------

  add_group(&$group_data)롼ɲ

  $group_data   񤭹GroupDataClass֥
  
  return       true  : 
                 false : 

------------------------------------------------------*/
function add_group(&$group_data)
{
	if($this->check_group_exists($group_data->group_name))
	{
		return false;
	}

	$filename = $this->get_file_name($user_data->user_name,"group");
	$stream   = $this->encode_filestream_group_data($user_data);
	
	return FileControlLib::create_file( $filename,$stream );
}
//-----------------------------------------------------


/*----------------------------------------------------

  check_group_exists($user_group_namename) оݥ롼פ¸ߤ뤫å

  $group_name   оݥ롼̾
  
  return       true  : ¸ߤ
                 false : ¸ߤʤ

------------------------------------------------------*/
function check_group_exists($group_name)
{
	$filename = $this->get_file_name($group_name,"group");
	return file_exists($filename);
}
//-----------------------------------------------------


/*----------------------------------------------------

  delete_group($group_name)롼׺

  $group_name   оݥ롼̾
  
  return       true  : 
                 false : 

------------------------------------------------------*/
function delete_group($group_name)
{
	return unlink( $this->get_file_name($group_name,"group") );
}
//-----------------------------------------------------


/*----------------------------------------------------

  get_group_data($group_name,&$group_data)
    롼ץǡ

  $group_name   оݥ롼̾
  $group_data   ɹGroupDataClass֥

  return       true  : 
                 false : 

------------------------------------------------------*/
function get_group_data($group_name,&$group_data)
{
	if( $this->check_group_exists($group_name) )
	{
		$filename = $this->get_file_name($group_name,"group");
		$stream = "";
		
		if( FileControlLib::load_target_file($filename,$stream) )
		{
			$this->decode_filestream_group_data($stream,$user_data);
			return true;
		}
	}
	return false;
}
//-----------------------------------------------------


/*----------------------------------------------------

  modify_group_data($group_name,&$group_data)
    롼ץǡ

  $group_name   оݥ롼̾
  $group_data   񤭹GroupDataClass֥

  return       true  : 
                 false : 

------------------------------------------------------*/
function modify_group_data($group_name,&$group_data)
{
	if( $this->check_group_exists($group_name) )
	{
		$filename = $this->get_file_name($group_name,"group");
		$stream   = $this->encode_filestream_group_data($group_data);
		
		return FileControlLib::target_file_update($filename,$stream);
	}
	return false;
}
//-----------------------------------------------------


/*----------------------------------------------------

  get_file_name($name ,$type="user")
    ե̾
  
  $name         оݥ桼̾롼̾
  $type         usergroup

------------------------------------------------------*/
function get_file_name($name ,$type="user")
{
	return $this->auth_db_dir ."/" . $name .".".$type;
}
//-----------------------------------------------------


/*----------------------------------------------------

  encode_filestream_user_data( $user_data )
    оݥ桼ǡ񤭹ߥեޥåȤ˥󥳡

------------------------------------------------------*/
function encode_filestream_user_data( &$user_data )
{
	$stream = "";
	$stream .= "user_name:"    .$user_data->user_name ."\n";
	$stream .= "admin_flag:"   .$user_data->admin_flag ."\n";
	$stream .= "password_hash:".$user_data->password_hash ."\n";
	$stream .= "mail_address:" .$user_data->mail_address ."\n";
	
	$stream .= "\n";
	
	for($i=0;$i<count($user_data->comment);$i++){
		$stream .= $user_data->comment[$i] . "\n";
		
	}
	return $stream;
}
//-----------------------------------------------------

/*----------------------------------------------------

  decode_filestream_user_data( $stream , &$user_data )
    оݥȥ꡼桼ǡ饹֥Ȥ˥ǥ

------------------------------------------------------*/
function decode_filestream_user_data( $stream , &$user_data )
{
	$user_data->clear();
	$row_data_array = split("\r?\n",$stream);
	array_pop($row_data_array);
	$comment_flag = false;
	for( $i=0; $i<count($row_data_array); $i++ )
	{
		if($comment_flag == false)
		{
			if($row_data_array[$i] == "")
			{
				$comment_flag = true;
				continue;
			}
		}
		else
		{
			array_push($user_data->comment,$row_data_array[$i]);
			continue;
		}
		
		if( preg_match("/(^[^\:]+)\:(.*)$/",$row_data_array[$i],$match_data) )
		{
			switch($match_data[1])
			{
			case('user_name'):
				$user_data->user_name = $match_data[2];
				break;
			case('admin_flag'):
				$user_data->admin_flag = $match_data[2];
				break;
			case('password_hash'):
				$user_data->password_hash = $match_data[2];
				break;
			case('mail_address'):
				$user_data->mail_address = $match_data[2];
				break;
			}
			
		}
	}

}
//-----------------------------------------------------

/*----------------------------------------------------

  encode_filestream_group_data( $group_data )
    оݥ롼ץǡ񤭹ߥեޥåȤ˥󥳡

------------------------------------------------------*/
function encode_filestream_group_data( &$group_data )
{
	$stream = "";
	$stream .= "group_name:"  .$group_data->group_name ."\n";
	$stream .= "user_list:"   .join(",",$group_data->user_list) ."\n";
	$stream .= "admin_list"   .join(",",$group_data->admin_user_list) ."\n";
	
	$stream .= "\n";
	
	for($i=0;$i<count($group_data->comment);$i++){
		$stream .= $group_data->comment[$i] . "\n";
		
	}
	return $stream;
}
//-----------------------------------------------------


/*----------------------------------------------------

  decode_filestream_group_data( $stream , &$group_data )
    оݥȥ꡼򥰥롼ץǡ饹֥Ȥ˥ǥ

------------------------------------------------------*/
function decode_filestream_group_data( $stream ,&$group_data )
{
	$group_data->clear();
	$row_data_array = split("\r?\n",$stream);
	array_pop($row_data_array);
	$comment_flag = false;
	for( $i=0; $i<count($row_data_array); $i++ )
	{
		if($comment_flag == false)
		{
			if($row_data_array[$i] == "")
			{
				$comment_flag = true;
				continue;
			}
		}
		else
		{
			array_push($group_data->comment,$row_data_array[$i]);
			continue;
		}
		
		if( preg_match("/(^[^\:]+)\:(.*)$/",$row_data_array[$i],$match_data) )
		{
			switch($match_data[1])
			{
			case('group_name'):
				$group_data->group_name = $match_data[2];
				break;
			case('user_list'):
				$group_data->user_list = split(",",$match_data[2]);
				break;
			case('admin_user_list'):
				$group_data->admin_user_list = split(",",$match_data[2]);
				break;
			}
			
		}
	}

}
//-----------------------------------------------------

}


?>
