/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.util;

import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Map;

import jp.terasoluna.utlib.LogUTUtil;
import jp.terasoluna.utlib.PropertyTestCase;
import jp.terasoluna.utlib.UTUtil;

/**
 * DateUtil ubN{bNXeXgB<br>
 * O<br>
 * Etest.propertiesNXpXɐݒ肳ĂKv<br>
 * EvpeBt@CɈȉ̂悤ȐݒĂ<br>
 * @wareki.gengo.0.name = <br>
 * @wareki.gengo.0.roman = H<br>
 * @wareki.gengo.0.startDate = 1989/01/08<br>
 * @wareki.gengo.1.name = a<br>
 * @wareki.gengo.1.roman = S<br>
 * @wareki.gengo.1.startDate = 1926/12/25<br>
 * @wareki.gengo.2.name = 吳<br>
 * @wareki.gengo.2.roman = T<br>
 * @wareki.gengo.2.startDate = 1912/07/30<br>
 * @wareki.gengo.3.name = <br>
 * @wareki.gengo.3.roman = M<br>
 * @wareki.gengo.3.startDate = 1868/09/04<br>
 * @wareki.gengo.4.name = <br>
 * @wareki.gengo.4.roman = H<br>
 * @wareki.gengo.5.name = <br>
 * @wareki.gengo.5.roman = H<br>
 * @wareki.gengo.5.startDate = asdf<br>
 *
 */
@SuppressWarnings("unused")
public class DateUtilTest extends PropertyTestCase {

    /**
     * ݒ肷邽߂̃tB[h
     */
    private SimpleDateFormat df = null;

    /**
     * ݒ肷邽߂̃tB[h
     */
    private Date date = null;

    /**
     * Constructor for DateUtilTest.
     * @param arg0
     */
    public DateUtilTest(String arg0) {
        super(arg0);
    }

    @Override
    protected void setUpData() throws Exception {
        addProperty("wareki.gengo.0.name", "");
        addProperty("wareki.gengo.0.roman", "H");
        addProperty("wareki.gengo.0.startDate", "1989/01/08");
        addProperty("wareki.gengo.1.name", "a");
        addProperty("wareki.gengo.1.roman", "S");
        addProperty("wareki.gengo.1.startDate", "1926/12/25");
        addProperty("wareki.gengo.2.name", "吳");
        addProperty("wareki.gengo.2.roman", "T");
        addProperty("wareki.gengo.2.startDate", "1912/07/30");
        addProperty("wareki.gengo.3.name", "");
        addProperty("wareki.gengo.3.roman", "M");
        addProperty("wareki.gengo.3.startDate", "1868/09/04");
        addProperty("wareki.gengo.4.name", "");
        addProperty("wareki.gengo.4.roman", "H");
        addProperty("wareki.gengo.5.name", "");
        addProperty("wareki.gengo.5.roman", "H");
        addProperty("wareki.gengo.5.startDate", "asdf");
        addProperty("wareki.gengo.6.name", "v");
        addProperty("wareki.gengo.6.roman", "K");
        addProperty("wareki.gengo.6.startDate", "1706/01/01");
    }

    @Override
    protected void cleanUpData() throws Exception {
        clearProperty();
    }

    /**
     * testStatic01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() vpeB:wareki.gengo.0.name = <br>
     *                 @@wareki.gengo.0.roman = H<br>
     *                 @@wareki.gengo.0.startDate = 1989/01/08<br>
     *                 @@wareki.gengo.1.name = a<br>
     *                 @@wareki.gengo.1.roman = S<br>
     *                 @@wareki.gengo.1.startDate = 1926/12/25<br>
     *                 @@wareki.gengo.2.name = 吳<br>
     *                 @@wareki.gengo.2.roman = T<br>
     *                 @@wareki.gengo.2.startDate = 1912/07/30<br>
     *                 @@wareki.gengo.3.name = <br>
     *                 @@wareki.gengo.3.roman = M<br>
     *                 @@wareki.gengo.3.startDate = 1868/09/04<br>
     *                 @@wareki.gengo.4.name = <br>
     *                 @@wareki.gengo.4.roman = H<br>
     *                 @@wareki.gengo.5.name = <br>
     *                 @@wareki.gengo.5.roman = H<br>
     *                 @@wareki.gengo.5.startDate = asdf<br>
     *
     * <br>
     * ҒlF(ԕω) vCx[gtB[h:vCx[gtB[hłuGENGO_NAMEvuGENGO_ROMANvuGENGO_BEGIN_DATESvuGENGO_BEGIN_YEARSṽTCYSł邱ƁB<br>
     *         (ԕω) O:<errorx><br>
     *                    bZ[WFwareki.gengo.4.startDate not found<br>
     *                    <errorx><br>
     *                    bZ[WFUnparseable date: "asdf"<br>
     *
     * <br>
     * ׂẴp^[ԗeXg
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testStatic01() throws Exception {

        // ʊmF
        //vCx[gtB[ȟ4ł邱ƂmFB
        Map GENGO_NAME
            = (Map) UTUtil.getPrivateField(DateUtil.class, "GENGO_NAME");
        Map GENGO_ROMAN
            = (Map) UTUtil.getPrivateField(DateUtil.class, "GENGO_ROMAN");
        Date[] GENGO_BEGIN_DATES
            = (Date[]) UTUtil.getPrivateField(DateUtil.class, "GENGO_BEGIN_DATES");
        int[] GENGO_BEGIN_YEARS
            = (int[]) UTUtil.getPrivateField(DateUtil.class, "GENGO_BEGIN_YEARS");
        assertEquals(5, GENGO_NAME.size());
        assertEquals(5, GENGO_ROMAN.size());
        assertEquals(5, GENGO_BEGIN_DATES.length);
        assertEquals(5, GENGO_BEGIN_YEARS.length);
        assertTrue(LogUTUtil.checkError("wareki.gengo.4.startDate not found"));
        assertTrue(LogUTUtil.checkError("Unparseable date: \"asdf\""));
    }

    /**
     * testGetSystemTime01B<br>
     *
     * (n)<br>
     * ϓ_FA<br>
     *
     * ͒lFȂ<br>
     * ҒlFeXgs̃VXe<br>
     *
     * EVXe擾ł邱ƂmFB<br>
     * @ʊmFł̓eXgΏۂ̓eƓƂĂB<br>
     * @throws Exception O
     */
    public void testGetSystemTime01() throws Exception {
        // ͒l̐ݒ
        // VXe̎擾̂߁A͂Ȃ

        // eXgΏۂ̎s
        Date result = DateUtil.getSystemTime();

        // ʊmF
        Date hope = Calendar.getInstance().getTime();
        assertEquals(hope, result);
    }

    // ************************************************************************
    //  aϊp\bhɊւmF
    // ************************************************************************

    // ************************************************************************
    //  ̃tH[}bguGvɊւmF
    // ************************************************************************

    /**
     * testDateToWarekiString01B<br>
     *
     * (n)<br>
     * ϓ_FA<br>
     *
     * ͒lFformat="G"<br>
     *         date="2001.01.01 00:00:00"<br>
     *
     * ҒlFdate="H"<br>
     *
     * ẼtH[}bguGv1ɂȀo͌`mFB<br>
     * @throws Exception O
     */
    public void testDateToWarekiString01() throws Exception {
        // ͒l̐ݒ
        String format = "G";
        // ̐ݒ
        df = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
        date = new Date(df.parse("2001.01.01 00:00:00").getTime());

        // eXgΏۂ̎s
        String str = DateUtil.dateToWarekiString(format, date);

        // ʊmF
        assertEquals("H", str);
    }

    /**
     * testDateToWarekiString02B<br>
     *
     * (n)<br>
     * ϓ_FA<br>
     *
     * ͒lFformat="G"<br>
     * @@@@currentTime="1980N11 000b"<br>
     * ҒlF"S"<br>
     *
     * ẼtH[}bguGv1ɂȀo͌`mFB<br>
     * @throws Exception O
     */
    public void testDateToWarekiString02() throws Exception {
        // ͒l̐ݒ
        String format = "G";
        // ̐ݒ
        df = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
        date = new Date(df.parse("1980.01.01 00:00:00").getTime());

        // eXgΏۂ̎s
        String str = DateUtil.dateToWarekiString(format, date);

        // ʊmF
        assertEquals("S", str);
    }

    /**
     * testDateToWarekiString03B<br>
     *
     * (n)<br>
     * ϓ_FA<br>
     *
     * ͒lFformat="GGG"<br>
     * @@@@currentTime="2001N11 000b"<br>
     * ҒlF"H"<br>
     *
     * ẼtH[}bguGGGv3ɂȀo͌`mFB<br>
     * @throws Exception O
     */
    public void testDateToWarekiString03() throws Exception {
        // ͒l̐ݒ
        String format = "GGG";
        // ̐ݒ
        df = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
        date = new Date(df.parse("2001.01.01 00:00:00").getTime());

        // eXgΏۂ̎s
        String str = DateUtil.dateToWarekiString(format, date);

        // ʊmF
        assertEquals("H", str);
    }

    /**
     * testDateToWarekiString04B<br>
     *
     * (n)<br>
     * ϓ_FA<br>
     *
     * ͒lFformat="GGGG"<br>
     * @@@@currentTime="2001N11 000b"<br>
     * ҒlF""<br>
     *
     * ẼtH[}bguGGGGv4ɂȀo͌`mFB<br>
     * @throws Exception O
     */
    public void testDateToWarekiString04() throws Exception {
        // ͒l̐ݒ
        String format = "GGGG";
        // ̐ݒ
        df = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
        date = new Date(df.parse("2001.01.01 00:00:00").getTime());

        // eXgΏۂ̎s
        String str = DateUtil.dateToWarekiString(format, date);

        // ʊmF
        assertEquals("", str);
    }

    /**
     * testDateToWarekiString05B<br>
     *
     * (n)<br>
     * ϓ_FA<br>
     *
     * ͒lFformat="GGGGGGGGGG"<br>
     * @@@@currentTime="2001N11 000b"<br>
     * ҒlF""<br>
     *
     * ẼtH[}bguGGGGGGGGGGv10ɂA
     * ̏o͌`mFB<br>
     * @throws Exception O
     */
    public void testDateToWarekiString05() throws Exception {
        // ͒l̐ݒ
        String format = "GGGGGGGGGG";
        // ̐ݒ
        df = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
        date = new Date(df.parse("2001.01.01 00:00:00").getTime());

        // eXgΏۂ̎s
        String str = DateUtil.dateToWarekiString(format, date);

        // ʊmF
        assertEquals("", str);
    }

    // ************************************************************************
    //  ÑtH[}bguyvɊւmF
    // ************************************************************************

    /**
     * testDateToWarekiString06B<br>
     *
     * (n)<br>
     * ϓ_FA<br>
     *
     * ͒lFformat="y"<br>
     * @@@@currentTime="2001N11 000b"<br>
     * ҒlF"13"<br>
     *
     * ẼtH[}bguyv1ɂAaNo͂邱ƂmFB<br>
     * @throws Exception O
     */
    public void testDateToWarekiString06() throws Exception {
        // ͒l̐ݒ
        String format = "y";
        // ̐ݒ
        df = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
        date = new Date(df.parse("2001.01.01 00:00:00").getTime());

        // eXgΏۂ̎s
        String str = DateUtil.dateToWarekiString(format, date);

        // ʊmF
        assertEquals("13", str);
    }

    /**
     * testDateToWarekiString07B<br>
     *
     * (n)<br>
     * ϓ_FA<br>
     *
     * ͒lFformat="y"<br>
     * @@@@currentTime="1869N11 000b"<br>
     * ҒlF"2"<br>
     *
     * ẼtH[}bguyv1ɂAaNo͂邱ƂmFB<br>
     * @throws Exception O
     */
    public void testDateToWarekiString07() throws Exception {
        // ͒l̐ݒ
        String format = "y";
        // ̐ݒ
        df = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
        date = new Date(df.parse("1869.01.01 00:00:00").getTime());

        // eXgΏۂ̎s
        String str = DateUtil.dateToWarekiString(format, date);

        // ʊmF
        assertEquals("2", str);
    }

    /**
     * testDateToWarekiString08B<br>
     *
     * (n)<br>
     * ϓ_FA<br>
     *
     * ͒lFformat="yy"<br>
     * @@@@currentTime="2001N11 000b"<br>
     * ҒlF"13"<br>
     *
     * ẼtH[}bguyyv2ɂAaNo͂邱ƂmFB<br>
     * @throws Exception O
     */
    public void testDateToWarekiString08() throws Exception {
        // ͒l̐ݒ
        String format = "yy";
        // ̐ݒ
        df = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
        date = new Date(df.parse("2001.01.01 00:00:00").getTime());

        // eXgΏۂ̎s
        String str = DateUtil.dateToWarekiString(format, date);

        // ʊmF
        assertEquals("13", str);
    }

    /**
     * testDateToWarekiString09B<br>
     *
     * (n)<br>
     * ϓ_FA<br>
     *
     * ͒lFformat="yyyyyyyyyy"<br>
     * @@@@currentTime="2001N11 000b"<br>
     * ҒlF"13"<br>
     *
     * ẼtH[}bguyyyyyyyyyyv10ɂAaNo͂邱ƂmFB<br>
     * @throws Exception O
     */
    public void testDateToWarekiString09() throws Exception {
        // ͒l̐ݒ
        String format = "yyyyyyyyyy";
        // ̐ݒ
        df = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
        date = new Date(df.parse("2001.01.01 00:00:00").getTime());

        // eXgΏۂ̎s
        String str = DateUtil.dateToWarekiString(format, date);

        // ʊmF
        assertEquals("0000000013", str);
    }

    // ************************************************************************
    //  j̃tH[}bguEvɊւmF
    // ************************************************************************

    /**
     * testDateToWarekiString10B<br>
     *
     * (n)<br>
     * ϓ_FA<br>
     *
     * ͒lFformat="E"<br>
     * @@@@currentTime="2001N11 000b"<br>
     * ҒlF""<br>
     *
     * Ej̃tH[}bguEv1ɂꍇmFB<br>
     * @throws Exception O
     */
    public void testDateToWarekiString10() throws Exception {
        // ͒l̐ݒ
        String format = "E";
        // ̐ݒ
        df = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
        date = new Date(df.parse("2001.01.01 00:00:00").getTime());

        // eXgΏۂ̎s
        String str = DateUtil.dateToWarekiString(format, date);

        // ʊmF
        assertEquals("", str);
    }

    /**
     * testDateToWarekiString11B<br>
     *
     * (n)<br>
     * ϓ_FA<br>
     *
     * ͒lFformat="E"<br>
     * @@@@currentTime="1868N93 000b"<br>
     * ҒlF""<br>
     *
     * Ej̃tH[}bguEv1ɂA͂t<br>
     * ŏ̓̑ȌꍇmFB<br>
     * @throws Exception O
     */
    public void testDateToWarekiString11() throws Exception {
        // ͒l̐ݒ
        String format = "E";
        // ̐ݒ
        df = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
        date = new Date(df.parse("1868.09.03 00:00:00").getTime());

        // eXgΏۂ̎s
        String str = DateUtil.dateToWarekiString(format, date);

        // ʊmF
        assertEquals("", str);
    }

    /**
     * testDateToWarekiString12B<br>
     *
     * (n)<br>
     * ϓ_FA<br>
     *
     * ͒lFformat="EEE"<br>
     * @@@@currentTime="2001N11 000b"<br>
     * ҒlF""<br>
     *
     * Ej̃tH[}bguEEEv3ɂꍇmFB<br>
     * @throws Exception O
     */
    public void testDateToWarekiString12() throws Exception {
        // ͒l̐ݒ
        String format = "EEE";
        // ̐ݒ
        df = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
        date = new Date(df.parse("2001.01.01 00:00:00").getTime());

        // eXgΏۂ̎s
        String str = DateUtil.dateToWarekiString(format, date);

        // ʊmF
        assertEquals("", str);
    }

    /**
     * testDateToWarekiString13B<br>
     *
     * (n)<br>
     * ϓ_FA<br>
     *
     * ͒lFformat="EEEE"<br>
     * @@@@currentTime="2001N11 000b"<br>
     * ҒlF"j"<br>
     *
     * Ej̃tH[}bguEEEEv4ɂꍇmFB<br>
     * @throws Exception O
     */
    public void testDateToWarekiString13() throws Exception {
        // ͒l̐ݒ
        String format = "EEEE";
        // ̐ݒ
        df = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
        date = new Date(df.parse("2001.01.01 00:00:00").getTime());

        // eXgΏۂ̎s
        String str = DateUtil.dateToWarekiString(format, date);

        // ʊmF
        assertEquals("j", str);
    }

    /**
     * testDateToWarekiString14B<br>
     *
     * (n)<br>
     * ϓ_FA<br>
     *
     * ͒lFformat="EEEEEEEEEE"<br>
     * @@@@currentTime="2001N12 000b"<br>
     * ҒlF"Ηj"<br>
     *
     * Ej̃tH[}bguEEEEEEEEEEv10ɂꍇmFB<br>
     * @throws Exception O
     */
    public void testDateToWarekiString14() throws Exception {
        // ͒l̐ݒ
        String format = "EEEEEEEEEE";
        // ̐ݒ
        df = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
        date = new Date(df.parse("2001.01.02 00:00:00").getTime());

        // eXgΏۂ̎s
        String str = DateUtil.dateToWarekiString(format, date);

        // ʊmF
        assertEquals("Ηj", str);
    }

    // ************************************************************************
    //  ƔN̏o͏ɊւmF
    // ************************************************************************

    /**
     * testDateToWarekiString15B<br>
     *
     * (n)<br>
     * ϓ_FA<br>
     *
     * ͒lFformat="Gy"<br>
     * @@@@currentTime="2001N11 000b"<br>
     * ҒlF"H13"<br>
     *
     * EtH[}bguGyvƂA([}){N̏ɏo͂邱ƂmFB<br>
     * @throws Exception O
     */
    public void testDateToWarekiString15() throws Exception {
        // ͒l̐ݒ
        String format = "Gy";
        // ̐ݒ
        df = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
        date = new Date(df.parse("2001.01.01 00:00:00").getTime());

        // eXgΏۂ̎s
        String str = DateUtil.dateToWarekiString(format, date);

        // ʊmF
        assertEquals("H13", str);
    }

    /**
     * testDateToWarekiString16B<br>
     *
     * (n)<br>
     * ϓ_FA<br>
     *
     * ͒lFformat="yG"<br>
     * @@@@currentTime="2001N11 000b"<br>
     * ҒlF"13H"<br>
     *
     * EtH[}bguyGvƂAN{([})̏ɏo͂邱ƂmFB<br>
     * @throws Exception O
     */
    public void testDateToWarekiString16() throws Exception {
        // ͒l̐ݒ
        String format = "yG";
        // ̐ݒ
        df = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
        date = new Date(df.parse("2001.01.01 00:00:00").getTime());

        // eXgΏۂ̎s
        String str = DateUtil.dateToWarekiString(format, date);

        // ʊmF
        assertEquals("13H", str);
    }

    /**
     * testDateToWarekiString17B<br>
     *
     * (n)<br>
     * ϓ_FA<br>
     *
     * ͒lFformat="GGGGy"<br>
     * @@@@currentTime="2001N11 000b"<br>
     * ҒlF"13"<br>
     *
     * EtH[}bguGGGGyvƂA(){N̏ɏo͂邱ƂmFB<br>
     * @throws Exception O
     */
    public void testDateToWarekiString17() throws Exception {
        // ͒l̐ݒ
        String format = "GGGGy";
        // ̐ݒ
        df = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
        date = new Date(df.parse("2001.01.01 00:00:00").getTime());

        // eXgΏۂ̎s
        String str = DateUtil.dateToWarekiString(format, date);

        // ʊmF
        assertEquals("13", str);
    }

    /**
     * testDateToWarekiString18B<br>
     *
     * (n)<br>
     * ϓ_FA<br>
     *
     * ͒lFformat="yGGGG"<br>
     * @@@@currentTime="2001N11 000b"<br>
     * ҒlF"13"<br>
     *
     * EtH[}bguyGGGGvƂAN{()̏ɏo͂邱ƂmFB<br>
     * @throws Exception O
     */
    public void testDateToWarekiString18() throws Exception {
        // ͒l̐ݒ
        String format = "yGGGG";
        // ̐ݒ
        df = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
        date = new Date(df.parse("2001.01.01 00:00:00").getTime());

        // eXgΏۂ̎s
        String str = DateUtil.dateToWarekiString(format, date);

        // ʊmF
        assertEquals("13", str);
    }

    /**
     * testDateToWarekiString19B<br>
     *
     * (n)<br>
     * ϓ_FA<br>
     *
     * ͒lFformat="G GGGG"<br>
     * @@@@currentTime="2001N11 000b"<br>
     * ҒlF"H "<br>
     *
     * EtH[}bguG GGGGvƂA([}){()̏<br>
     * o͂邱ƂmFB<br>
     * @throws Exception O
     */
    public void testDateToWarekiString19() throws Exception {
        // ͒l̐ݒ
        String format = "G GGGG";
        // ̐ݒ
        df = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
        date = new Date(df.parse("2001.01.01 00:00:00").getTime());

        // eXgΏۂ̎s
        String str = DateUtil.dateToWarekiString(format, date);

        // ʊmF
        assertEquals("H ", str);
    }

    /**
     * testDateToWarekiString20B<br>
     *
     * (n)<br>
     * ϓ_FA<br>
     *
     * ͒lFformat="GGGG G"<br>
     * @@@@currentTime="2001N11 000b"<br>
     * ҒlF" H"<br>
     *
     * EtH[}bguGGGG GvƂA(){([})̏<br>
     * o͂邱ƂmFB<br>
     * @throws Exception O
     */
    public void testDateToWarekiString20() throws Exception {
        // ͒l̐ݒ
        String format = "GGGG G";
        // ̐ݒ
        df = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
        date = new Date(df.parse("2001.01.01 00:00:00").getTime());

        // eXgΏۂ̎s
        String str = DateUtil.dateToWarekiString(format, date);

        // ʊmF
        assertEquals(" H", str);
    }

    /**
     * testDateToWarekiString21B<br>
     *
     * (n)<br>
     * ϓ_FA<br>
     *
     * ͒lFformat="GGGGG E"<br>
     * @@@@currentTime="2001N11 000b"<br>
     * ҒlF" "<br>
     *
     * EtH[}bguGGGGG EvƂA(){j̏<br>
     * o͂邱ƂmFB<br>
     * @throws Exception O
     */
    public void testDateToWarekiString21() throws Exception {
        // ͒l̐ݒ
        String format = "GGGGG E";
        // ̐ݒ
        df = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
        date = new Date(df.parse("2001.01.01 00:00:00").getTime());

        // eXgΏۂ̎s
        String str = DateUtil.dateToWarekiString(format, date);

        // ʊmF
        assertEquals(" ", str);
    }

    /**
     * testDateToWarekiString22B<br>
     *
     * (n)<br>
     * ϓ_FA<br>
     *
     * ͒lFformat="MM.dd HH:mm:ss z"<br>
     * @@@@currentTime="2001N21 345b"<br>
     * ҒlF"02.01 03:04:05 JST"<br>
     *
     * Ey,G,E܂܂ȂtH[}bg̏ꍇmFB<br>
     * @throws Exception O
     */
    public void testDateToWarekiString22() throws Exception {
        // ͒l̐ݒ
        String format = "MM.dd HH:mm:ss z";
        // ̐ݒ
        df = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
        date = new Date(df.parse("2001.02.01 03:04:05").getTime());

        // eXgΏۂ̎s
        String str = DateUtil.dateToWarekiString(format, date);

        // ʊmF
        assertEquals("02.01 03:04:05 " + this.getTimeZoneName(date), str);
    }

    /**
     * ^C][̗擾B SimpleDateFormatNXƓl̕@Ń^C][̗擾ĂB
     *
     * @param dt f[^
     * @return ^C][̗
     * @throws Exception O
     */
    private String getTimeZoneName(Date dt) throws Exception {
        Calendar calender = Calendar.getInstance();
        calender.setTime(dt);

        // DateFormatSymbols ́AAjA^C][f[^ȂǁA
        // nΉ\ȓt/tH[}bgf[^JvZ邽߂ public NXB
        DateFormatSymbols formatData = new DateFormatSymbols(Locale
                .getDefault());
        // ^C][̎擾
        String zoneStrings[][] = formatData.getZoneStrings();

        // zoneIndex̎擾
        int zoneIndex = -1;
        String zoneID = calender.getTimeZone().getID();
        for (int index = 0; index < zoneStrings.length; index++) {
            if (zoneID.equalsIgnoreCase(zoneStrings[index][0])) {
                zoneIndex = index;
                break;
            }
        }

        // ʂ̗݂͑Ȃ
        if (zoneIndex == -1) {
            return zoneID;
        }

        // ̃CfbNX̎擾
        int index = -1;
        if(calender.get(Calendar.DST_OFFSET) == 0 ){
            index = 2;
        } else {
            index = 4;
        }

        return zoneStrings[zoneIndex][index];
    }

    // ************************************************************************
    //  ͂sȏꍇ̊mF
    // ************************************************************************

    /**
     * testDateToWarekiString23B<br>
     *
     * (n)<br>
     * ϓ_FA,C<br>
     *
     * ͒lFformat=""<br>
     * @@@@currentTime="2001N11 000b"<br>
     * ҒlF""<br>
     *
     * EtH[}bg󕶎ɂA󕶎o͂邱ƂmFB<br>
     * @throws Exception O
     */
    public void testDateToWarekiString23() throws Exception {
        // ͒l̐ݒ
        String format = "";
        // ̐ݒ
        df = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
        date = new Date(df.parse("2001.01.01 00:00:00").getTime());

        // eXgΏۂ̎s
        String str = DateUtil.dateToWarekiString(format, date);

        // ʊmF
        assertEquals("", str);
    }

    /**
     * testDateToWarekiString24B<br>
     *
     * (n)<br>
     * ϓ_FA<br>
     *
     * ͒lFformat="#!--0"<br>
     * @@@@currentTime="2001N11 000b"<br>
     * ҒlF"#!--0"<br>
     *
     * EtH[}bgp^[ȊOɂA<br>
     * ̂܂܏o͂邱ƂmFB<br>
     * @throws Exception O
     */
    public void testDateToWarekiString24() throws Exception {
        // ͒l̐ݒ
        String format = "#!--0";
        // ̐ݒ
        df = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
        date = new Date(df.parse("2001.01.01 00:00:00").getTime());

        // eXgΏۂ̎s
        String str = DateUtil.dateToWarekiString(format, date);

        // ʊmF
        assertEquals("#!--0", str);
    }

    /**
     * testDateToWarekiString25B<br>
     *
     * (n)<br>
     * ϓ_FA<br>
     *
     * ͒lFformat="'GGGG' G 'dd' dd"<br>
     * @@@@currentTime="2001N11 000b"<br>
     * ҒlF"GGGG H dd 01"<br>
     *
     * EtH[}bgLN^VONH[e[Vň͂񂾏ꍇA<br>
     * ƂăGXP[v邱ƂmFB<br>
     * @throws Exception O
     */
    public void testDateToWarekiString25() throws Exception {
        // ͒l̐ݒ
        String format = "'GGGG' G 'dd' dd";
        // ̐ݒ
        df = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
        date = new Date(df.parse("2001.01.01 00:00:00").getTime());

        // eXgΏۂ̎s
        String str = DateUtil.dateToWarekiString(format, date);

        // ʊmF
        assertEquals("GGGG H dd 01", str);
    }

    /**
     * testDateToWarekiString26B<br>
     *
     * (n)<br>
     * ϓ_FA<br>
     *
     * ͒lFformat="'y' y 'E' E"<br>
     * @@@@currentTime="2001N11 000b"<br>
     * ҒlFy 13 E <br>
     *
     * EtH[}bgLN^VONH[e[Vň͂񂾏ꍇA<br>
     * "y""E"͕ƂăGXP[v邱ƂmFB<br>
     * @throws Exception O
     */
    public void testDateToWarekiString26() throws Exception {
        // ͒l̐ݒ
        String format = "'y' y 'E' E";
        // ̐ݒ
        df = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
        date = new Date(df.parse("2001.01.01 00:00:00").getTime());

        // eXgΏۂ̎s
        String str = DateUtil.dateToWarekiString(format, date);

        // ʊmF
        assertEquals("y 13 E ", str);
    }

    /**
     * testDateToWarekiString27B<br>
     *
     * (ُn)<br>
     * ϓ_FG<br>
     *
     * ͒lFformat="A"<br>
     * @@@@currentTime="2001N11 000b"<br>
     * ҒlFIllegalArgumentExceptionX[<br>
     *
     * EtH[}bgɂȂuAvw肵ꍇA<br>
     * IllegalArgumentExceptionX[邱ƂmFB<br>
     * @throws Exception O
     */
    public void testDateToWarekiString27() throws Exception {
        // ͒l̐ݒ
        String format = "A";
        // ̐ݒ
        df = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
        date = new Date(df.parse("2001.01.01 00:00:00").getTime());

        // eXgΏۂ̎s
        try {
            String str = DateUtil.dateToWarekiString(format, date);
            fail();
        } catch (IllegalArgumentException e) {
            return;
        }
    }

    /**
     * testDateToWarekiString28B<br>
     *
     * (ُn)<br>
     * ϓ_FG<br>
     *
     * ͒lFformat="G"<br>
     * @@@@currentTime="1705N1231 000b"<br>
     * ҒlFIllegalArgumentExceptionX[<br>
     *
     * EvpeBt@CŎw肳ꂽŌÓtȑO̓tdateœnꍇA<br>
     * tH[}bg"G"w肷IllegalArgumentExceptionX[邱ƂmFB<br>
     * @throws Exception O
     */
    public void testDateToWarekiString28() throws Exception {
        // ͒l̐ݒ
        String format = "G";
        // ̐ݒ
        df = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
        date = new Date(df.parse("1705.12.31 00:00:00").getTime());

        // eXgΏۂ̎s
        try {
            String str = DateUtil.dateToWarekiString(format, date);
            fail();
        } catch (IllegalArgumentException e) {
            return;
        }
    }

    /**
     * testDateToWarekiString29B<br>
     *
     * (ُn)<br>
     * ϓ_FG<br>
     *
     * ͒lFformat="y"<br>
     * @@@@currentTime="1700N93 000b"<br>
     * ҒlFIllegalArgumentExceptionX[<br>
     *
     * EvpeBt@CŎw肳ꂽŌÓtȑO̓tdateœnꍇA<br>
     * tH[}bg"y"w肷IllegalArgumentExceptionX[邱ƂmFB<br>
     * @throws Exception O
     */
    public void testDateToWarekiString29() throws Exception {
        // ͒l̐ݒ
        String format = "y";
        // ̐ݒ
        df = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
        date = new Date(df.parse("1700.09.03 00:00:00").getTime());

        // eXgΏۂ̎s
        try {
            String str = DateUtil.dateToWarekiString(format, date);
            fail();
        } catch (IllegalArgumentException e) {
            return;
        }
    }

    /**
     * testDateToWarekiString30B<br>
     *
     * (ُn)<br>
     * ϓ_FC,G<br>
     *
     * ͒lFformat=null<br>
     * @@@@currentTime=*<br>
     * ҒlFNullPointerExceptionX[<br>
     *
     * EtH[}bgnullw肵ꍇA<br>
     * NullPointerExceptionX[邱ƂmFB<br>
     * @throws Exception O
     */
    public void testDateToWarekiString30() throws Exception {
        // ͒l̐ݒ
        String format = null;
        // ̐ݒ
        df = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
        date = new Date(df.parse("2001.01.01 00:00:00").getTime());

        // eXgΏۂ̎s
        try {
            String str = DateUtil.dateToWarekiString(format, date);
            fail();
        } catch (NullPointerException e) {
            return;
        }
    }

    /**
     * testDateToWarekiString31B<br>
     *
     * (ُn)<br>
     * ϓ_FC,G<br>
     *
     * ͒lFformat=not null<br>
     * @@@@currentTime=null<br>
     * ҒlFNullPointerExceptionX[<br>
     *
     * Etnullw肵ꍇA<br>
     * NullPointerExceptionX[邱ƂmFB<br>
     * @throws Exception O
     */
    public void testDateToWarekiString31() throws Exception {
        // ͒l̐ݒ
        String format = "G";
        date = null;

        // eXgΏۂ̎s
        try {
            String str = DateUtil.dateToWarekiString(format, date);
            fail();
        } catch (NullPointerException e) {
            return;
        }
    }

    /**
     * testDateToWarekiString32B<br>
     *
     * (n)<br>
     * ϓ_FA<br>
     *
     * ͒lFformat="G 'G' ''G'' '''G''' ''''G'''' y 'y' ''y'' '''y''' ''''y'''' E 'E' ''E'' '''E''' ''''E''''"<br>
     * @@@@currentTime="2001N11 000b"<br>
     * ҒlFH G 'H' 'G' ''H'' 13 y '13' 'y' ''13''  E '' 'E' ''''<br>
     *
     * EtH[}bgLN^VONH[e[Vň͂񂾏ꍇA<br>
     * GXP[v邱ƂmFB<br>
     * EtH[}bgLN^VONH[e[V2ň͂񂾏ꍇA<br>
     * VONI[e[V̂\邱ƂmFB<br>
     * EaEjȗ\L̏ꍇ<br>
     * @throws Exception O
     */
    public void testDateToWarekiString32() throws Exception {
        // ͒l̐ݒ
        String format = "G 'G' ''G'' '''G''' ''''G'''' y 'y' ''y'' '''y''' ''''y'''' E 'E' ''E'' '''E''' ''''E''''";
        // ̐ݒ
        df = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
        date = new Date(df.parse("2001.01.01 00:00:00").getTime());

        // eXgΏۂ̎s
        String str = DateUtil.dateToWarekiString(format, date);

        // ʊmF
        assertEquals("H G 'H' 'G' ''H'' 13 y '13' 'y' ''13''  E '' 'E' ''''", str);
    }

    /**
     * testDateToWarekiString33B<br>
     *
     * (n)<br>
     * ϓ_FA<br>
     *
     * ͒lFformat="GGGG 'GGGG' ''GGGG'' '''GGGG''' ''''GGGG'''' yyyy 'yyyy' ''yyyy'' '''yyyy''' ''''y'''' EEEE 'EEEE' ''EEEE'' '''EEEE''' ''''EEEE''''"<br>
     * @@@@currentTime="2001N11 000b"<br>
     * ҒlF GGGG '' 'GGGG' '''' 13 yyyy '13' 'yyyy' ''13'' j EEEE 'j' 'EEEE' ''j''<br>
     *
     * EtH[}bgLN^VONH[e[Vň͂񂾏ꍇA<br>
     * GXP[v邱ƂmFB<br>
     * EtH[}bgLN^VONH[e[V2ň͂񂾏ꍇA<br>
     * VONI[e[V̂\邱ƂmFB<br>
     * EaEjS\L̏ꍇ<br>
     * @throws Exception O
     */
    public void testDateToWarekiString33() throws Exception {
        // ͒l̐ݒ
        String format = "GGGG 'GGGG' ''GGGG'' '''GGGG''' ''''GGGG'''' yyyy 'yyyy' ''yyyy'' '''yyyy''' ''''y'''' EEEE 'EEEE' ''EEEE'' '''EEEE''' ''''EEEE''''";
        // ̐ݒ
        df = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
        date = new Date(df.parse("2001.01.01 00:00:00").getTime());

        // eXgΏۂ̎s
        String str = DateUtil.dateToWarekiString(format, date);

        // ʊmF
        assertEquals(" GGGG '' 'GGGG' '''' 0013 yyyy '0013' 'yyyy' ''13'' j EEEE 'j' 'EEEE' ''j''", str);
    }

    /**
     * testDateToWarekiString34B<br>
     *
     * (n)<br>
     * ϓ_FA<br>
     *
     * ͒lFformat="'MM.dd HH:mm:ss z'"<br>
     * @@@@currentTime="2001N21 345b"<br>
     * ҒlF"MM.dd HH:mm:ss z"<br>
     *
     * Ey,G,E܂܂ȂtH[}bgVONH[e[Vň͂񂾏ꍇmFB<br>
     * @throws Exception O
     */
    public void testDateToWarekiString34() throws Exception {
        // ͒l̐ݒ
        String format = "'MM.dd HH:mm:ss z'";
        // ̐ݒ
        df = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
        date = new Date(df.parse("2001.02.01 03:04:05").getTime());

        // eXgΏۂ̎s
        String str = DateUtil.dateToWarekiString(format, date);

        // ʊmF
        assertEquals("MM.dd HH:mm:ss z", str);
    }

    // ************************************************************************
    //  aÑ[peBO̊mF
    // ************************************************************************

    /**
     * testDateToWarekiString35B<br>
     *
     * (n)<br>
     * ϓ_FA<br>
     *
     * ͒lFformat="Gy"<br>
     * @@@@currentTime="1990N11 000b"<br>
     * @@@@currentTime="1998N11 000b"<br>
     * @@@@currentTime="1805N11 000b"<br>
     * ҒlF"H02"<br>
     * @@@@"H10"<br>
     * @@@@"K100"<br>
     * 
     * ẼtH[}bguGyvƂAaN[pfBOȂŏo͂邱ƂmFB<br>
     * @throws Exception O
     */
    public void testDateToWarekiString35() throws Exception {
        // ͒l̐ݒ
        String format = "Gy";
        // ̐ݒ
        df = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
        date = new Date(df.parse("1990.01.01 00:00:00").getTime()); // 1
        Date date2 = new Date(df.parse("1998.01.01 00:00:00").getTime()); // 2
        Date date3 = new Date(df.parse("1805.01.01 00:00:00").getTime()); // 3

        // eXgΏۂ̎s
        String str = DateUtil.dateToWarekiString(format, date);
        String str2 = DateUtil.dateToWarekiString(format, date2);
        String str3 = DateUtil.dateToWarekiString(format, date3);

        // ʊmF
        assertEquals("H2", str);
        assertEquals("H10", str2);
        assertEquals("K100", str3);
    }

    /**
     * testDateToWarekiString36B<br>
     *
     * (n)<br>
     * ϓ_FA<br>
     *
     * ͒lFformat="Gyy"<br>
     * @@@@currentTime="1990N11 000b"<br>
     * @@@@currentTime="1998N11 000b"<br>
     * @@@@currentTime="1805N11 000b"<br>
     * ҒlF"H2"<br>
     * @@@@"H10"<br>
     * @@@@"K100"<br>
     * 
     * ẼtH[}bguGyyvƂAaN1̏ꍇ̓[pfBOŏo͂邱ƂmFB<br>
     * @throws Exception O
     */
    public void testDateToWarekiString36() throws Exception {
        // ͒l̐ݒ
        String format = "Gyy";
        // ̐ݒ
        df = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
        date = new Date(df.parse("1990.01.01 00:00:00").getTime()); // 1
        Date date2 = new Date(df.parse("1998.01.01 00:00:00").getTime()); // 2
        Date date3 = new Date(df.parse("1805.01.01 00:00:00").getTime()); // 3

        // eXgΏۂ̎s
        String str = DateUtil.dateToWarekiString(format, date);
        String str2 = DateUtil.dateToWarekiString(format, date2);
        String str3 = DateUtil.dateToWarekiString(format, date3);

        // ʊmF
        assertEquals("H02", str);
        assertEquals("H10", str2);
        assertEquals("K100", str3);
    }


    /**
     * testDateToWarekiString37B<br>
     *
     * (n)<br>
     * ϓ_FA<br>
     *
     * ͒lFformat="Gyyy"<br>
     * @@@@currentTime="1990N11 000b"<br>
     * @@@@currentTime="1998N11 000b"<br>
     * @@@@currentTime="1805N11 000b"<br>
     * ҒlF"H002"<br>
     * @@@@"H010"<br>
     * @@@@"K100"<br>
     *
     * ẼtH[}bguGyyyvƂAaN2܂ł̏ꍇ̓[pfBOŏo͂邱ƂmFB<br>
     * @throws Exception O
     */
    public void testDateToWarekiString37() throws Exception {
        // ͒l̐ݒ
        String format = "Gyyy";
        // ̐ݒ
        df = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
        date = new Date(df.parse("1990.01.01 00:00:00").getTime()); // 1
        Date date2 = new Date(df.parse("1998.01.01 00:00:00").getTime()); // 2
        Date date3 = new Date(df.parse("1805.01.01 00:00:00").getTime()); // 3

        // eXgΏۂ̎s
        String str = DateUtil.dateToWarekiString(format, date);
        String str2 = DateUtil.dateToWarekiString(format, date2);
        String str3 = DateUtil.dateToWarekiString(format, date3);

        // ʊmF
        assertEquals("H002", str);
        assertEquals("H010", str2);
        assertEquals("K100", str3);
    }

    /**
     * testDateToWarekiString38B<br>
     *
     * (n)<br>
     * ϓ_FA<br>
     *
     * ͒lFformat="GyMMdd"<br>
     * @@@@currentTime="1990N11 000b"<br>
     * @@@@currentTime="1998N11 000b"<br>
     * @@@@currentTime="1805N11 000b"<br>
     * ҒlF"H20101"<br>
     * @@@@"H100101"<br>
     * @@@@"K1000101"<br>
     * 
     * ẼtH[}bguGyMMddvƂAaN[pfBOȂŏo͂邱ƂmFB<br>
     * @throws Exception O
     */
    public void testDateToWarekiString38() throws Exception {
        // ͒l̐ݒ
        String format = "GyMMdd";
        // ̐ݒ
        df = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
        date = new Date(df.parse("1990.01.01 00:00:00").getTime()); // 1
        Date date2 = new Date(df.parse("1998.01.01 00:00:00").getTime()); // 2
        Date date3 = new Date(df.parse("1805.01.01 00:00:00").getTime()); // 3

        // eXgΏۂ̎s
        String str = DateUtil.dateToWarekiString(format, date);
        String str2 = DateUtil.dateToWarekiString(format, date2);
        String str3 = DateUtil.dateToWarekiString(format, date3);

        // ʊmF
        assertEquals("H20101", str);
        assertEquals("H100101", str2);
        assertEquals("K1000101", str3);
    }

    /**
     * testDateToWarekiString39B<br>
     *
     * (n)<br>
     * ϓ_FA<br>
     *
     * ͒lFformat="GyyMMdd"<br>
     * @@@@currentTime="1990N11 000b"<br>
     * @@@@currentTime="1998N11 000b"<br>
     * @@@@currentTime="1805N11 000b"<br>
     * ҒlF"H020101"<br>
     * @@@@"H100101"<br>
     * @@@@"K1000101"<br>
     * 
     * ẼtH[}bguGyyMMddvƂAaN1̏ꍇ̓[pfBOŏo͂邱ƂmFB<br>
     * @throws Exception O
     */
    public void testDateToWarekiString39() throws Exception {
        // ͒l̐ݒ
        String format = "GyyMMdd";
        // ̐ݒ
        df = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
        date = new Date(df.parse("1990.01.01 00:00:00").getTime()); // 1
        Date date2 = new Date(df.parse("1998.01.01 00:00:00").getTime()); // 2
        Date date3 = new Date(df.parse("1805.01.01 00:00:00").getTime()); // 3

        // eXgΏۂ̎s
        String str = DateUtil.dateToWarekiString(format, date);
        String str2 = DateUtil.dateToWarekiString(format, date2);
        String str3 = DateUtil.dateToWarekiString(format, date3);

        // ʊmF
        assertEquals("H020101", str);
        assertEquals("H100101", str2);
        assertEquals("K1000101", str3);
    }


    /**
     * testDateToWarekiString40B<br>
     *
     * (n)<br>
     * ϓ_FA<br>
     *
     * ͒lFformat="GyyyMMdd"<br>
     * @@@@currentTime="1990N11 000b"<br>
     * @@@@currentTime="1998N11 000b"<br>
     * @@@@currentTime="1805N11 000b"<br>
     * ҒlF"H0020101"<br>
     * @@@@"H0100101"<br>
     * @@@@"K1000101"<br>
     *
     * ẼtH[}bguGyyyMMddvƂAaN2܂ł̏ꍇ̓[pfBOŏo͂邱ƂmFB<br>
     * @throws Exception O
     */
    public void testDateToWarekiString40() throws Exception {
        // ͒l̐ݒ
        String format = "GyyyMMdd";
        // ̐ݒ
        df = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
        date = new Date(df.parse("1990.01.01 00:00:00").getTime()); // 1
        Date date2 = new Date(df.parse("1998.01.01 00:00:00").getTime()); // 2
        Date date3 = new Date(df.parse("1805.01.01 00:00:00").getTime()); // 3

        // eXgΏۂ̎s
        String str = DateUtil.dateToWarekiString(format, date);
        String str2 = DateUtil.dateToWarekiString(format, date2);
        String str3 = DateUtil.dateToWarekiString(format, date3);

        // ʊmF
        assertEquals("H0020101", str);
        assertEquals("H0100101", str2);
        assertEquals("K1000101", str3);
    }

    // ************************************************************************
    //  getWarekiGengoName
    // ************************************************************************

    /**
     * testGetWarekiGengoName01B<br>
     *
     * (n)<br>
     * ϓ_FA<br>
     *
     * ͒lFdate=1989N18000b<br>
     * ҒlF""<br>
     *
     * Eŏ̓̌ߑO0傤ǂmFB<br>
     * @throws Exception O
     */
    public void testGetWarekiGengoName01() throws Exception {
        // ͒l̐ݒ
        df = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
        date = new Date(df.parse("1989.01.08 00:00:00").getTime());

        // eXgΏۂ̎s
        String str = DateUtil.getWarekiGengoName(date);

        // ʊmF
        assertEquals("", str);
    }

    /**
     * testGetWarekiGengoName02B<br>
     *
     * (n)<br>
     * ϓ_FA<br>
     *
     * ͒lFdate=1989N17235959b<br>
     * ҒlF"a"<br>
     *
     * Eŏ̓̌ߑO01bOmFB<br>
     * @throws Exception O
     */
    public void testGetWarekiGengoName02() throws Exception {
        // ͒l̐ݒ
        df = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
        date = new Date(df.parse("1989.01.07 23:59:59").getTime());

        // eXgΏۂ̎s
        String str = DateUtil.getWarekiGengoName(date);

        // ʊmF
        assertEquals("a", str);
    }

    /**
     * testGetWarekiGengoName03B<br>
     *
     * (n)<br>
     * ϓ_FA<br>
     *
     * ͒lFdate=1989N18001b<br>
     * ҒlF""<br>
     *
     * Eŏ̓̌ߑO01bmFB<br>
     * @throws Exception O
     */
    public void testGetWarekiGengoName03() throws Exception {
        // ͒l̐ݒ
        df = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
        date = new Date(df.parse("1989.01.08 00:00:01").getTime());

        // eXgΏۂ̎s
        String str = DateUtil.getWarekiGengoName(date);

        // ʊmF
        assertEquals("", str);
    }

    /**
     * testGetWarekiGengoName04B<br>
     *
     * (ُn)<br>
     * ϓ_FG<br>
     *
     * ͒lFdate=1868N93<br>
     * ҒlFIllegalArgumentException<br>
     *
     * E͂tŏ̓̑ȌꍇmFB<br>
     * @throws Exception O
     */
    public void testGetWarekiGengoName04() throws Exception {
        // ͒l̐ݒ
        df = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
        date = new Date(df.parse("1705.12.31 00:00:00").getTime());

        // eXgΏۂ̎s
        try {
            String str = DateUtil.getWarekiGengoName(date);
            fail();
        } catch (IllegalArgumentException e) {
            assertEquals("Wareki Gengo Name not found for "
                    + date, e.getMessage());
            return;
        }
    }

    /**
     * testGetWarekiGengoName05B<br>
     *
     * (ُn)<br>
     * ϓ_FG<br>
     *
     * ͒lFdate=null<br>
     * ҒlFNullPointerExceptionX[<br>
     *
     * E͂tnull̎ANullPointerExceptionB<br>
     * @throws Exception O
     */
    public void testGetWarekiGengoName05() throws Exception {
        // ͒l̐ݒ
        date = null;

        // eXgΏۂ̎s
        try {
            String str = DateUtil.getWarekiGengoName(date);
            fail();
        } catch (NullPointerException e) {
            return;
        }
    }

    // ************************************************************************
    //  getWarekiGengoRoman
    // ************************************************************************

    /**
     * testGetWarekiGengoRoman01B<br>
     *
     * (n)<br>
     * ϓ_FA<br>
     *
     * ͒lFdate=1989N18000b<br>
     * ҒlF""<br>
     *
     * Eŏ̓̌ߑO0傤ǂmFB<br>
     * @throws Exception O
     */
    public void testGetWarekiGengoRoman01() throws Exception {
        // ͒l̐ݒ
        df = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
        date = new Date(df.parse("1989.01.08 00:00:00").getTime());

        // eXgΏۂ̎s
        String str = DateUtil.getWarekiGengoRoman(date);

        // ʊmF
        assertEquals("H", str);
    }

    /**
     * testGetWarekiGengoRoman02B<br>
     *
     * (n)<br>
     * ϓ_FA<br>
     *
     * ͒lFdate=1989N17235959b<br>
     * ҒlF"a"<br>
     *
     * Eŏ̓̌ߑO01bOmFB<br>
     * @throws Exception O
     */
    public void testGetWarekiGengoRoman02() throws Exception {
        // ͒l̐ݒ
        df = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
        date = new Date(df.parse("1989.01.07 23:59:59").getTime());

        // eXgΏۂ̎s
        String str = DateUtil.getWarekiGengoRoman(date);

        // ʊmF
        assertEquals("S", str);
    }

    /**
     * testGetWarekiGengoRoman03B<br>
     *
     * (n)<br>
     * ϓ_FA<br>
     *
     * ͒lFdate=1989N18001b<br>
     * ҒlF""<br>
     *
     * Eŏ̓̌ߑO01bmFB<br>
     * @throws Exception O
     */
    public void testGetWarekiGengoRoman03() throws Exception {
        // ͒l̐ݒ
        df = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
        date = new Date(df.parse("1989.01.08 00:00:01").getTime());

        // eXgΏۂ̎s
        String str = DateUtil.getWarekiGengoRoman(date);

        // ʊmF
        assertEquals("H", str);
    }

    /**
     * testGetWarekiGengoRoman04B<br>
     *
     * (ُn)<br>
     * ϓ_FG<br>
     *
     * ͒lFdate=1868N93<br>
     * ҒlFIllegalArgumentExceptionX[<br>
     *
     * E͂tŏ̓̑ȌꍇmFB<br>
     * @throws Exception O
     */
    public void testGetWarekiGengoRoman04() throws Exception {
        // ͒l̐ݒ
        df = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
        date = new Date(df.parse("1705.12.31 00:00:00").getTime());

        // eXgΏۂ̎s
        try {
            String str = DateUtil.getWarekiGengoRoman(date);
            fail();
        } catch (IllegalArgumentException e) {
            assertEquals("Wareki Gengo Roman not found for "
                    + date, e.getMessage());
            return;
        }
    }

    /**
     * testGetWarekiGengoRoman05B<br>
     *
     * (ُn)<br>
     * ϓ_FG<br>
     *
     * ͒lFdate=null<br>
     * ҒlFNullPointerExceptionX[<br>
     *
     * E͂tNull̎ANullPointerException<br>
     * @throws Exception O
     */
    public void testGetWarekiGengoRoman05() throws Exception {
        // ͒l̐ݒ
        date = null;

        // eXgΏۂ̎s
        try {
            String str = DateUtil.getWarekiGengoRoman(date);
            fail();
        } catch (NullPointerException e) {
            return;
        }
    }

    // ************************************************************************
    //  getWarekiGengoYear
    // ************************************************************************

    /**
     * testGetWarekiYear01B<br>
     *
     * (n)<br>
     * ϓ_FA<br>
     *
     * ͒lFdate=1989N18000b<br>
     * ҒlF1<br>
     *
     * Eŏ̓̌ߑO0傤ǂmFB<br>
     * @throws Exception O
     */
    public void testGetWarekiYear01() throws Exception {
        // ͒l̐ݒ
        df = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
        date = new Date(df.parse("1989.01.08 00:00:00").getTime());

        // eXgΏۂ̎s
        int year = DateUtil.getWarekiYear(date);

        // ʊmF
        assertEquals(1, year);
    }

    /**
     * testGetWarekiYear02B<br>
     *
     * (n)<br>
     * ϓ_FA<br>
     *
     * ͒lFdate=1989N17235959b<br>
     * ҒlF64<br>
     *
     * Eŏ̓̌ߑO01bOmFB<br>
     * @throws Exception O
     */
    public void testGetWarekiYear02() throws Exception {
        // ͒l̐ݒ
        df = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
        date = new Date(df.parse("1989.01.07 23:59:59").getTime());

        // eXgΏۂ̎s
        int year = DateUtil.getWarekiYear(date);

        // ʊmF
        assertEquals(64, year);
    }

    /**
     * testGetWarekiYear03B<br>
     *
     * (n)<br>
     * ϓ_FA<br>
     *
     * ͒lFdate=1989N18001b<br>
     * ҒlF1<br>
     *
     * Eŏ̓̌ߑO01bmFB<br>
     * @throws Exception O
     */
    public void testGetWarekiYear03() throws Exception {
        // ͒l̐ݒ
        df = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
        date = new Date(df.parse("1989.01.08 00:00:01").getTime());

        // eXgΏۂ̎s
        int year = DateUtil.getWarekiYear(date);

        // ʊmF
        assertEquals(1, year);
    }

    /**
     * testGetWarekiYear04B<br>
     *
     * (ُn)<br>
     * ϓ_FG<br>
     *
     * ͒lFdate=1868N93<br>
     * ҒlFIllegalArgumentExceptionX[<br>
     *
     * E͂tŏ̓̑ȌꍇmFB<br>
     * @throws Exception O
     */
    public void testGetWarekiYear04() throws Exception {
        // ͒l̐ݒ
        df = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
        date = new Date(df.parse("1705.12.31 00:00:00").getTime());

        // eXgΏۂ̎s
        try {
            int year = DateUtil.getWarekiYear(date);
            fail();
        } catch (IllegalArgumentException e) {
            assertEquals("Wareki Gengo not found for "
                    + date, e.getMessage());
            return;
        }
    }

    /**
     * testGetWarekiYear05B<br>
     *
     * (ُn)<br>
     * ϓ_FG<br>
     *
     * ͒lFdate=null<br>
     * ҒlFNullPointerExceptionX[<br>
     *
     * ENullPointerException<br>
     * @throws Exception O
     */
    public void testGetWarekiYear05() throws Exception {
        // ͒l̐ݒ

        try {
            // eXgΏۂ̎s
            int year = DateUtil.getWarekiYear(null);
            fail();
        } catch (NullPointerException e) {
            return;
        }

    }

}
