/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.controlbreak;

import java.util.LinkedHashMap;
import java.util.List;
import jp.terasoluna.fw.batch.controlbreak.ControlBreakChunk;
import jp.terasoluna.fw.batch.controlbreak.ControlBreakProcessor;
import jp.terasoluna.fw.batch.controlbreak.ControlBreakRowObject;
import jp.terasoluna.fw.batch.core.BLogicExecutor;
import jp.terasoluna.fw.batch.core.JobStatus;
import jp.terasoluna.fw.batch.openapi.JobContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlBreakBLogicExecutor
implements BLogicExecutor {
    private BLogicExecutor blogicExecutor = null;
    private static ThreadLocal<ControlBreakRowObject> previousData = new ThreadLocal();
    private ControlBreakProcessor controlBreakProcessor = null;

    @Override
    public void executeBLogic(Object blogicInputData, JobContext jobContext, JobStatus jobStatus, List<LinkedHashMap<String, Object>> batchUpdateMapList) {
        ControlBreakRowObject lastData = null;
        ControlBreakRowObject controlBreakRowObject = (ControlBreakRowObject)blogicInputData;
        if (previousData.get() == null) {
            previousData.set(controlBreakRowObject);
            return;
        }
        if (!jobStatus.isContinue()) {
            return;
        }
        if (previousData.get().getControlBreakKeyList().size() > 0) {
            this.controlBreakProcessor.doControlBreak(previousData.get(), jobContext, jobStatus, batchUpdateMapList);
        }
        if (!jobStatus.isContinue()) {
            return;
        }
        this.blogicExecutor.executeBLogic(previousData.get().getRowObject(), jobContext, jobStatus, batchUpdateMapList);
        if (controlBreakRowObject.getRowObject() == ControlBreakChunk.CHUNK_BREAK_MARK) {
            if (!jobStatus.isContinue()) {
                return;
            }
            if (controlBreakRowObject.getControlBreakKeyList().size() > 0) {
                this.controlBreakProcessor.doControlBreak(controlBreakRowObject, jobContext, jobStatus, batchUpdateMapList);
            }
            previousData.set(null);
        } else {
            previousData.set(controlBreakRowObject);
        }
        if (controlBreakRowObject.getRowObject() == ControlBreakChunk.END_MARK) {
            lastData = new ControlBreakRowObject(previousData.get().getRowObject(), controlBreakRowObject.getControlBreakKeyList(), controlBreakRowObject.getControlBreakMap());
            this.controlBreakProcessor.doAllChunkInternalControlBreak(lastData, jobContext, jobStatus, batchUpdateMapList);
            previousData.set(null);
            return;
        }
    }

    public void setBlogicExecutor(BLogicExecutor blogicExecutor) {
        this.blogicExecutor = blogicExecutor;
    }

    public void setControlBreakProcessor(ControlBreakProcessor controlBreakProcessor) {
        this.controlBreakProcessor = controlBreakProcessor;
    }
}

