/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.beans.jxpath;

import java.util.Locale;

import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

import org.apache.commons.jxpath.DynamicPropertyHandler;
import org.apache.commons.jxpath.MapDynamicPropertyHandler;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.model.NodePointer;

/**
 * {@link jp.terasoluna.fw.beans.jxpath.DynamicPointerEx} NX̃ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * nulll߂Map|C^gNXB<br>
 * OF
 * <p>
 * 
 * @see jp.terasoluna.fw.beans.jxpath.DynamicPointerEx
 */
public class DynamicPointerExTest extends TestCase {


    /**
     * sB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * IsB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * 
     * @param name ̃eXgP[X̖OB
     */
    public DynamicPointerExTest(String name) {
        super(name);
    }

    /**
     * testDynamicPointerExQname01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() name:not null<br>
     *         () bean:new Object()<br>
     *         () handler:not null<br>
     *         () locale:Locale("ja")<br>
     *         () this.handler:null<br>
     *         
     * <br>
     * ҒlF(ԕω) this.handler:Őݒ肳ꂽlB<br>
     *         
     * <br>
     * RXgN^ĂяoeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDynamicPointerExQname01() throws Exception {
        // O
    	QName qName = new QName("name");
    	Object bean = new Object();
    	DynamicPropertyHandler handler = new MapDynamicPropertyHandler();
    	Locale locale = new Locale("ja");

        // eXg{
    	DynamicPointerEx result = new DynamicPointerEx(qName, bean, handler,locale);

        // 
    	assertSame(handler, UTUtil.getPrivateField(result, "handler"));
    }

    /**
     * testDynamicPointerExNodePointer01()
     * <br><br>
     * 
     * (n) 
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() parent:not null<br>
     *         () name:not null<br>
     *         () bean:new Object()<br>
     *         () handler:not null<br>
     *         () this.handler:null<br>
     *         
     * <br>
     * ҒlF(ԕω) this.handler:Őݒ肳ꂽlB<br>
     *         
     * <br>
     * RXgN^ĂяoeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDynamicPointerExNodePointer01() throws Exception {
        // O
    	QName qName = new QName("name");
    	Object bean = new Object();
    	DynamicPropertyHandler handler = new MapDynamicPropertyHandler();
    	Locale locale = new Locale("ja");
    	NodePointer nodePointer = NodePointer.newNodePointer(qName, bean, locale);

        // eXg{
    	DynamicPointerEx result = new DynamicPointerEx(nodePointer, qName, bean, handler);

        // 
    	assertSame(handler, UTUtil.getPrivateField(result, "handler"));
    }

    /**
     * testGetPropertyPointer01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() this.handler:not null<br>
     *         
     * <br>
     * ҒlF(߂l) PropertyPointer:new DynamicPropertyPointerEx{<br>
     *                      parent=this<br>
     *                      handler=Ohandler<br>
     *                  }<br>
     *         
     * <br>
     * vpeB|C^擾郁\bh̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetPropertyPointer01() throws Exception {
        // O
    	QName qName = new QName("name");
    	Object bean = new Object();
    	DynamicPropertyHandler handler = new MapDynamicPropertyHandler();
    	Locale locale = new Locale("ja");
    	DynamicPointerEx pointer = new DynamicPointerEx(qName, bean, handler,locale);

        // eXg{
    	Object result = pointer.getPropertyPointer();

        // 
    	assertSame(DynamicPropertyPointerEx.class, result.getClass());
    	assertSame(pointer, ((DynamicPropertyPointerEx) result).getParent());
    	assertSame(handler, UTUtil.getPrivateField(result, "handler"));
    }

}
