/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.validation;

import java.lang.reflect.InvocationTargetException;

import jp.terasoluna.fw.util.ClassLoadException;
import jp.terasoluna.utlib.LogUTUtil;
import junit.framework.TestCase;

import org.apache.commons.validator.Field;
import org.apache.commons.validator.ValidatorAction;
import org.apache.commons.validator.Var;

/**
 * {@link FieldChecks} NX̃eXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * TERASOLUNA̓̓`FbN@\ŋʂɎgp錟؃[NXB
 * <p>
 * 
 * @see jp.terasoluna.fw.validation.FieldChecks
 */
public class FieldChecksTest11 extends TestCase {
    
    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     * 
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(FieldChecksTest11.class);
    }

    /**
     * sB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        LogUTUtil.flush();
        FieldChecks_MultiFieldValidatorImpl01.result = false;
        FieldChecks_MultiFieldValidatorImpl01.validateCalledCount = 0;
        FieldChecks_MultiFieldValidatorImpl01.value = null;
        FieldChecks_MultiFieldValidatorImpl01.fields = null;
    }

    /**
     * IsB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * 
     * @param name ̃eXgP[X̖OB
     */
    public FieldChecksTest11(String name) {
        super(name);
    }

    /**
     * testValidateMultiField01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC, F, I
     * <br><br>
     * ͒lF() bean:null<br>
     *         () va:ValidatorActionnNX̃CX^X<br>
     *         () field:FieldNX̃CX^X<br>
     *                <br>
     *                Msg("message, "message")<br>
     *         () errors:MockValidationErrorsNX̃CX^X<br>
     *         
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:tB[herrorMessagenullł邱ƂmFB<br>
     *         (ԕω) O:OxFERROR<br>
     *                    bZ[WF"bean is null."<br>
     *         
     * <br>
     * beannull̏ꍇɃG[Oo͂āATRUEԋp邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testValidateMultiField01() throws Exception {
        // O
        Object bean = null;
        ValidatorAction va = new ValidatorAction();
        Field field = new Field();
        FieldChecks_ValidationErrorsImpl03 errors = new FieldChecks_ValidationErrorsImpl03();

        // eXg{
        FieldChecks fieldChecks = new FieldChecks();
        boolean result = 
            fieldChecks.validateMultiField(bean, va, field, errors);

        // 
        assertTrue(result);
        assertNull(errors.errorMessage);
        assertTrue(LogUTUtil.checkError("bean is null."));
    }

    /**
     * testValidateMultiField02()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FC, F, G, I
     * <br><br>
     * ͒lF() bean:""i󕶎j<br>
     *         () va:ValidatorActionnNX̃CX^X<br>
     *         () field:ȉ̃tB[hݒ肵FieldNX̃CX^X<br>
     *                <br>
     *                varFmultiFieldValidator=null<br>
     *         () errors:MockValidationErrorsNX̃CX^X<br>
     *         
     * <br>
     * ҒlF(ԕω) errors:tB[herrorMessagenullł邱ƂmFB<br>
     *         (ԕω) O:OFIllegalArgumentException<br>
     *                    bZ[WF
     *                    "var value[multiFieldValidator] is required."<br>
     *         (ԕω) O:OxFERROR<br>
     *                    bZ[WF
     *                    "var value[multiFieldValidator] is required."<br>
     *         
     * <br>
     * field́Avar-nameFmultiFieldValidatorɑΉvar-valuenull̏ꍇɁA
     * G[Oo͂āAIllegalArgumentExceptionX[邱ƂmFeXgB<br>
     * <br>
     * bean󕶎̏ꍇɃ`FbNs邱ƂmFeXg܂B
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testValidateMultiField02() throws Exception {
        // O
        Object bean = "";
        ValidatorAction va = new ValidatorAction();
        Field field = new Field();
        Var var = new Var("multiFieldValidator", null, null);
        field.addVar(var);
        FieldChecks_ValidationErrorsImpl03 errors = new FieldChecks_ValidationErrorsImpl03();

        // eXg{
        FieldChecks fieldChecks = new FieldChecks();
        try {
            fieldChecks.validateMultiField(bean, va, field, errors);
            fail("IllegalArgumentExceptionX[ȂB");
        } catch (IllegalArgumentException e) {
            // 
            assertNull(errors.errorMessage);
            assertEquals(IllegalArgumentException.class.getName(), 
                        e.getClass().getName());
            assertEquals("var value[multiFieldValidator] is required.", 
                        e.getMessage());
            assertTrue(LogUTUtil.checkError(
                        "var value[multiFieldValidator] is required."));
        }
    }

    /**
     * testValidateMultiField03()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FC, F, G, I
     * <br><br>
     * ͒lF() bean:"bean"<br>
     *         () va:ValidatorActionnNX̃CX^X<br>
     *         () field:ȉ̃tB[hݒ肵FieldNX̃CX^X<br>
     *                <br>
     *                varFmultiFieldValidator=""i󕶎j<br>
     *         () errors:MockValidationErrorsNX̃CX^X<br>
     *         
     * <br>
     * ҒlF(ԕω) errors:tB[herrorMessagenullł邱ƂmFB<br>
     *         (ԕω) O:OFIllegalArgumentException<br>
     *                    bZ[WF
     *                    "var value[multiFieldValidator] is required."<br>
     *         (ԕω) O:OxFERROR<br>
     *                    bZ[WF
     *                    "var value[multiFieldValidator] is required."<br>
     *         
     * <br>
     * field́Avar-nameFmultiFieldValidatorɑΉvar-value󕶎̏ꍇɁA
     * G[Oo͂āAIllegalArgumentExceptionX[邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testValidateMultiField03() throws Exception {
        // O
        Object bean = "bean";
        ValidatorAction va = new ValidatorAction();
        Field field = new Field();
        Var var = new Var("multiFieldValidator", "", null);
        field.addVar(var);
        FieldChecks_ValidationErrorsImpl03 errors = new FieldChecks_ValidationErrorsImpl03();

        // eXg{
        FieldChecks fieldChecks = new FieldChecks();
        try {
            fieldChecks.validateMultiField(bean, va, field, errors);
            fail("IllegalArgumentExceptionX[ȂB");
        } catch (IllegalArgumentException e) {
            // 
            assertNull(errors.errorMessage);
            assertEquals(IllegalArgumentException.class.getName(), 
                        e.getClass().getName());
            assertEquals("var value[multiFieldValidator] is required.", 
                        e.getMessage());
            assertTrue(LogUTUtil.checkError(
                        "var value[multiFieldValidator] is required."));
        }
    }

    /**
     * testValidateMultiField04()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FF, G, I
     * <br><br>
     * ͒lF() bean:"bean"<br>
     *         () va:ValidatorActionnNX̃CX^X<br>
     *         () field:ȉ̃tB[hݒ肵FieldNX̃CX^X<br>
     *                <br>
     *                varFmultiFieldValidator="not.Exist"<br>
     *         () errors:MockValidationErrorsNX̃CX^X<br>
     *         
     * <br>
     * ҒlF(ԕω) errors:tB[herrorMessagenullł邱ƂmFB<br>
     *         (ԕω) O:OFIllegalArgumentException<br>
     *                    bZ[WF"var value[multiFieldValidator] is invalid."<br>
     *                    bvꂽOFClassLoadException<br>
     *         (ԕω) O:OxFERROR<br>
     *                    bZ[WF"var value[multiFieldValidator] is invalid."<br>
     *                    bvꂽOFClassLoadException<br>
     *         
     * <br>
     * field́Avar-nameFmultiFieldValidatorɑΉvar-valueNXpX
     * ݂ȂNX̏ꍇɁAG[Oo͂āAIllegalArgumentException
     * X[邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testValidateMultiField04() throws Exception {
        // O
        Object bean = "bean";
        ValidatorAction va = new ValidatorAction();
        Field field = new Field();
        Var var = new Var("multiFieldValidator", "not.Exist", null);
        field.addVar(var);
        FieldChecks_ValidationErrorsImpl03 errors = new FieldChecks_ValidationErrorsImpl03();

        // eXg{
        FieldChecks fieldChecks = new FieldChecks();
        try {
            fieldChecks.validateMultiField(bean, va, field, errors);
            fail("IllegalArgumentExceptionX[ȂB");
        } catch (IllegalArgumentException e) {
            // 
            assertNull(errors.errorMessage);
            assertEquals(IllegalArgumentException.class.getName(), 
                        e.getClass().getName());
            assertEquals("var value[multiFieldValidator] is invalid.", 
                        e.getMessage());
            assertTrue(e.getCause() instanceof ClassLoadException);
            assertTrue(LogUTUtil.checkError(
                        "var value[multiFieldValidator] is invalid.", 
                        new ClassLoadException(new RuntimeException())));
        }
    }

    /**
     * testValidateMultiField05()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FF, G, I
     * <br><br>
     * ͒lF() bean:"bean"<br>
     *         () va:ValidatorActionnNX̃CX^X<br>
     *         () field:ȉ̃tB[hݒ肵FieldNX̃CX^X<br>
     *                <br>
     *                varFmultiFieldValidator="java.lang.String"<br>
     *         () errors:MockValidationErrorsNX̃CX^X<br>
     *         
     * <br>
     * ҒlF(ԕω) errors:tB[herrorMessagenullł邱ƂmFB<br>
     *         (ԕω) O:OFIllegalArgumentException<br>
     *                    bZ[WF"var value[multiFieldValidator] is invalid."<br>
     *                    bvꂽOFClassCastException<br>
     *         (ԕω) O:OxFERROR<br>
     *                    bZ[WF"var value[multiFieldValidator] is invalid."<br>
     *                    bvꂽOFClassCastException<br>
     *         
     * <br>
     * field́Avar-nameFmultiFieldValidatorɑΉvar-value
     * MultiFieldValidatorĂȂNX̏ꍇɁAG[Oo͂āA
     * IllegalArgumentExceptionX[邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testValidateMultiField05() throws Exception {
        // O
        Object bean = "bean";
        ValidatorAction va = new ValidatorAction();
        Field field = new Field();
        Var var = new Var("multiFieldValidator", "java.lang.String", null);
        field.addVar(var);
        FieldChecks_ValidationErrorsImpl03 errors = new FieldChecks_ValidationErrorsImpl03();

        // eXg{
        FieldChecks fieldChecks = new FieldChecks();
        try {
            fieldChecks.validateMultiField(bean, va, field, errors);
            fail("IllegalArgumentExceptionX[ȂB");
        } catch (IllegalArgumentException e) {
            // 
            assertNull(errors.errorMessage);
            assertEquals(IllegalArgumentException.class.getName(), 
                        e.getClass().getName());
            assertEquals("var value[multiFieldValidator] is invalid.", 
                        e.getMessage());
            assertTrue(e.getCause() instanceof ClassCastException);
            assertTrue(LogUTUtil.checkError(
                    "var value[multiFieldValidator] is invalid.", 
                    new ClassCastException()));
        }
    }

    /**
     * testValidateMultiField06()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:"bean"<br>
     *         () va:ValidatorActionnNX̃CX^X<br>
     *         () field:ȉ̃tB[hݒ肵FieldNX̃CX^X<br>
     *                <br>
     *         varFmultiFieldValidator=
     *         "jp.terasoluna.fw.validation.
     *         FieldChecks_MultiFieldValidatorImpl01"<br>
     *                varFfields=null<br>
     *         () errors:MockValidationErrorsNX̃CX^X<br>
     *         () MultiFieldValidator#validate̖߂l:TRUEɐݒ<br>
     *         
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:tB[herrorMessagenullł邱ƂmFB<br>
     *         (ԕω) MultiFieldValidator:tB[hvalidateCalledCount
     *         1ł邱ƂmFB<br>
     *                    <br>
     *                    tB[hvalue"bean"ł邱ƂmFB<br>
     *                    <br>
     *                    tB[hfields̔z񒷂0ł邱ƂmFB<br>
     *         
     * <br>
     * fieldvar-nameFfieldsɑΉvar-valuenull̏ꍇA
     * MultiFieldValidator#validatȇɋ̔z񂪓n邱ƂmFeXgB<br>
     * <br>
     * bean̏ꍇɁAMultiFieldValidator#validate
     * ɂ̕񂪓n邱ƂmFeXg܂B
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testValidateMultiField06() throws Exception {
        // O
        Object bean = "bean";
        ValidatorAction va = new ValidatorAction();
        Field field = new Field();
        Var var1 = new Var("multiFieldValidator", 
                "jp.terasoluna.fw.validation."
                + "FieldChecks_MultiFieldValidatorImpl01", null);
        Var var2 = new Var("fields", null, null);
        field.addVar(var1);
        field.addVar(var2);
        FieldChecks_ValidationErrorsImpl03 errors = new FieldChecks_ValidationErrorsImpl03();
        FieldChecks_MultiFieldValidatorImpl01.result = true;

        // eXg{
        FieldChecks fieldChecks = new FieldChecks();

        boolean result = 
            fieldChecks.validateMultiField(bean, va, field, errors);
    
        // 
        assertTrue(result);
        assertNull(errors.errorMessage);
        assertEquals(1, FieldChecks_MultiFieldValidatorImpl01.
                validateCalledCount);
        assertEquals("bean", FieldChecks_MultiFieldValidatorImpl01.value);
        assertNotNull(FieldChecks_MultiFieldValidatorImpl01.fields);
        assertEquals(0, 
                FieldChecks_MultiFieldValidatorImpl01.fields.length);
    }

    /**
     * testValidateMultiField07()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:"bean"<br>
     *         () va:ValidatorActionnNX̃CX^X<br>
     *         () field:ȉ̃tB[hݒ肵FieldNX̃CX^X<br>
     *                <br>
     *                varFmultiFieldValidator=
     *                "jp.terasoluna.fw.validation.
     *                FieldChecks_MultiFieldValidatorImpl01"<br>
     *                varFfields=""i󕶎j<br>
     *         () errors:MockValidationErrorsNX̃CX^X<br>
     *         () MultiFieldValidator#validate̖߂l:TRUEɐݒ<br>
     *         
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:tB[herrorMessagenullł邱ƂmFB<br>
     *         (ԕω) MultiFieldValidator:tB[hvalidateCalledCount1
     *         邱ƂmFB<br>
     *                    <br>
     *                    tB[hvalue"bean"ł邱ƂmFB<br>
     *                    <br>
     *                    tB[hfields̔z񒷂0ł邱ƂmFB<br>
     *         
     * <br>
     * fieldvar-nameFfieldsɑΉvar-value󕶎̏ꍇA
     * MultiFieldValidator#validatȇɋ̔z񂪓n邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testValidateMultiField07() throws Exception {
        // O
        Object bean = "bean";
        ValidatorAction va = new ValidatorAction();
        Field field = new Field();
        Var var1 = new Var("multiFieldValidator", 
                "jp.terasoluna.fw.validation."
                + "FieldChecks_MultiFieldValidatorImpl01", null);
        Var var2 = new Var("fields", "", null);
        field.addVar(var1);
        field.addVar(var2);
        FieldChecks_ValidationErrorsImpl03 errors = new FieldChecks_ValidationErrorsImpl03();
        FieldChecks_MultiFieldValidatorImpl01.result = true;

        // eXg{
        FieldChecks fieldChecks = new FieldChecks();

        boolean result = 
            fieldChecks.validateMultiField(bean, va, field, errors);
    
        // 
        assertTrue(result);
        assertNull(errors.errorMessage);
        assertEquals(1, FieldChecks_MultiFieldValidatorImpl01.
                validateCalledCount);
        assertEquals("bean", FieldChecks_MultiFieldValidatorImpl01.value);
        assertNotNull(FieldChecks_MultiFieldValidatorImpl01.fields);
        assertEquals(0, 
                FieldChecks_MultiFieldValidatorImpl01.fields.length);
    }

    /**
     * testValidateMultiField08()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:ȉ̃tB[hݒ肵FieldChecksExtend_BeanStub01NX̃CX^X<br>
     *                <br>
     *                field1=ObjectNX̃C^X1<br>
     *                field2=ObjectNX̃C^X2<br>
     *         () va:ValidatorActionnNX̃CX^X<br>
     *         () field:ȉ̃tB[hݒ肵FieldNX̃CX^X<br>
     *                <br>
     *                property="field1"<br>
     *                varFmultiFieldValidator=
     *                "jp.terasoluna.fw.validation.
     *                FieldChecks_MultiFieldValidatorImpl01"<br>
     *                varFfields="field2"<br>
     *         () errors:MockValidationErrorsNX̃CX^X<br>
     *         () MultiFieldValidator#validate̖߂l:TRUEɐݒ<br>
     *         
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:tB[herrorMessagenullł邱ƂmFB<br>
     *         (ԕω) MultiFieldValidator:tB[hvalidateCalledCount
     *         1ł邱ƂmFB<br>
     *                    <br>
     *                    tB[hvalueAݒ肳ꂽObjectNX̃C^X1
     *                    CX^Xł邱ƂmFB<br>
     *                    <br>
     *                    tB[hfields̔z񒷂1ł邱ƂmFB<br>
     *                    <br>
     *                    tB[hfieldsȉ1vfƂmFB<br>
     *                    fields[0]=ObjectNX̃C^X2ƓCX^X<br>
     *         
     * <br>
     * fieldvar-nameFfieldsɑΉvar-valueɁAJ}؂薳̕
     * w肳ĂꍇA̖OɑΉvpeBlbean擾A
     * 1̔zƂMultiFieldValidatoȓɓn邱ƂmFeXgB<br>
     * <br>
     * beanJavaBean̏ꍇɁAfield̃vpeBɑΉvpeBl
     * bean擾AꂪMultiFieldValidator#validatȇɓn
     * ƂmFeXg܂B
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testValidateMultiField08() throws Exception {
        // O
        FieldChecks_JavaBeanStub02 bean = new FieldChecks_JavaBeanStub02();
        Object testValue1 = new Object();
        Object testValue2 = new Object();
        bean.field1 = testValue1;
        bean.field2 = testValue2;
        ValidatorAction va = new ValidatorAction();
        Field field = new Field();
        field.setProperty("field1");
        Var var1 = new Var("multiFieldValidator", 
                "jp.terasoluna.fw.validation."
                + "FieldChecks_MultiFieldValidatorImpl01", null);
        Var var2 = new Var("fields", "field2", null);
        field.addVar(var1);
        field.addVar(var2);
        FieldChecks_ValidationErrorsImpl03 errors = new FieldChecks_ValidationErrorsImpl03();
        FieldChecks_MultiFieldValidatorImpl01.result = true;

        // eXg{
        FieldChecks fieldChecks = new FieldChecks();

        boolean result = 
            fieldChecks.validateMultiField(bean, va, field, errors);
    
        // 
        assertTrue(result);
        assertNull(errors.errorMessage);
        assertEquals(1, FieldChecks_MultiFieldValidatorImpl01.
                validateCalledCount);
        assertSame(testValue1, 
                FieldChecks_MultiFieldValidatorImpl01.value);
        assertNotNull(FieldChecks_MultiFieldValidatorImpl01.fields);
        assertEquals(1, 
                FieldChecks_MultiFieldValidatorImpl01.fields.length);
        assertSame(testValue2, 
                FieldChecks_MultiFieldValidatorImpl01.fields[0]);
    }

    /**
     * testValidateMultiField09()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA, D, F, I
     * <br><br>
     * ͒lF() bean:ȉ̃tB[hݒ肵FieldChecksExtend_BeanStub01NX̃CX^X<br>
     *                <br>
     *                field1=ObjectNX̃C^X1<br>
     *                field2=ObjectNX̃C^X2<br>
     *                field3=ObjectNX̃C^X3<br>
     *         () va:ValidatorActionnNX̃CX^X<br>
     *         () field:ȉ̃tB[hݒ肵FieldNX̃CX^X<br>
     *                <br>
     *                property="invalidProperty"<br>
     *                varFmultiFieldValidator=
     *                "jp.terasoluna.fw.validation.
     *                FieldChecks_MultiFieldValidatorImpl01"<br>
     *                varFfields="field1 ,,invalidProperty,field2,field3"<br>
     *         () errors:MockValidationErrorsNX̃CX^X<br>
     *         () MultiFieldValidator#validate̖߂l:FALSEɐݒ<br>
     *         
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:tB[herrorMessage"errorMessage"ł邱ƂmFB<br>
     *         (ԕω) MultiFieldValidator:tB[hvalidateCalledCount
     *         1ł邱ƂmFB<br>
     *                    <br>
     *                    tB[hvalueAnullł邱ƂmFB<br>
     *                    <br>
     *                    tB[hfields̔z񒷂3ł邱ƂmFB<br>
     *                    <br>
     *                    tB[hfieldsȉ1vfƂmFB<br>
     *                    fields[0]=ObjectNX̃C^X1ƓCX^X<br>
     *                    fields[1]=ObjectNX̃C^X2ƓCX^X<br>
     *                    fields[2]=ObjectNX̃C^X3ƓCX^X<br>
     *         (ԕω) O:OxFERROR<br>
     *                    bZ[WF"Unknown property 'invalidProperty'"<br>  
     *                    bvꂽOFNoSuchMethodException<br>
     *                    <br>
     *                    OxFERROR<br>
     *                    bZ[WF"Unknown property 'invalidProperty'"<br>
     *                    bvꂽOFNoSuchMethodException<br>
     *         
     * <br>
     * fieldvar-nameFfieldsɑΉvar-valueɁAJ}؂̕
     * w肳ĂꍇAJ}ŋ؂ꂽSĂ̖OɑΉSvpeBl
     * bean擾A3̔zƂMultiFieldValidatoȓ
     * n邱ƂmFeXgB<br>
     * <br>
     * MultiFieldValidator#validate̕ԋplfalsȅꍇAG[bZ[W
     * ǉfalseԋp邱ƂmFeXg܂B<br>
     * <br>
     * փ`FbNΏۃtB[hlbean擾ۂɁA
     * PropertyUtils#getPropertyɂĔNoSuchMethodExceptionbv
     * G[Oo͂ă`FbNs邱ƂmFeXg܂B<br>
     * <br>
     * փ`FbNˑtB[hlbean擾ۂɁA
     * PropertyUtils#getPropertyɂĔNoSuchMethodExceptionbv
     * G[Oo͂ă`FbNs邱ƂmFeXg܂B
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testValidateMultiField09() throws Exception {
        // O
        FieldChecks_JavaBeanStub02 bean = new FieldChecks_JavaBeanStub02();
        Object testValue1 = new Object();
        Object testValue2 = new Object();
        Object testValue3 = new Object();
        bean.field1 = testValue1;
        bean.field2 = testValue2;
        bean.field3 = testValue3;
        ValidatorAction va = new ValidatorAction();
        Field field = new Field();
        field.setProperty("invalidProperty");
        Var var1 = new Var("multiFieldValidator", 
                "jp.terasoluna.fw.validation."
                + "FieldChecks_MultiFieldValidatorImpl01", null);
        Var var2 = new Var(
                "fields", "field1 ,,invalidProperty,field2,field3", null);
        field.addVar(var1);
        field.addVar(var2);
        FieldChecks_ValidationErrorsImpl03 errors = new FieldChecks_ValidationErrorsImpl03();
        FieldChecks_MultiFieldValidatorImpl01.result = false;

        // eXg{
        FieldChecks fieldChecks = new FieldChecks();

        boolean result = 
            fieldChecks.validateMultiField(bean, va, field, errors);
    
        // 
        assertFalse(result);
        assertEquals("errorMessage", errors.errorMessage);
        assertEquals(1, FieldChecks_MultiFieldValidatorImpl01.
                validateCalledCount);
        assertNull(FieldChecks_MultiFieldValidatorImpl01.value);
        assertNotNull(FieldChecks_MultiFieldValidatorImpl01.fields);
        assertEquals(3, 
                FieldChecks_MultiFieldValidatorImpl01.fields.length);
        assertSame(testValue1, 
                FieldChecks_MultiFieldValidatorImpl01.fields[0]);
        assertSame(testValue2, 
                FieldChecks_MultiFieldValidatorImpl01.fields[1]);
        assertSame(testValue3, 
                FieldChecks_MultiFieldValidatorImpl01.fields[2]);
        assertTrue(LogUTUtil.checkError("Unknown property 'invalidProperty' on class 'class jp.terasoluna.fw.validation.FieldChecks_JavaBeanStub02'",
                new NoSuchMethodException()));
        assertTrue(LogUTUtil.checkError("Unknown property 'invalidProperty' on class 'class jp.terasoluna.fw.validation.FieldChecks_JavaBeanStub02'",
                new NoSuchMethodException()));
    }

    /**
     * testValidateMultiField10()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA, F, I
     * <br><br>
     * ͒lF() bean:ȉFieldChecksExtend_BeanStub03NX̃CX^X<br>
     *                <br>
     *                field1getterRuntimeExceptionbv
     *                InvocationTargetExceptionX[B<br>
     *                field2getterRuntimeExceptionbv
     *                InvocationTargetExceptionX[B<br>
     *         () va:ValidatorActionnNX̃CX^X<br>
     *         () field:ȉ̃tB[hݒ肵FieldNX̃CX^X<br>
     *                <br>
     *                property="field1"<br>
     *                varFmultiFieldValidator=
     *                "jp.terasoluna.fw.validation.
     *                FieldChecks_MultiFieldValidatorImpl01"<br>
     *                varFfields="field2"<br>
     *         () errors:MockValidationErrorsNX̃CX^X<br>
     *         () MultiFieldValidator#validate̖߂l:TRUEɐݒ<br>
     *         
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:tB[herrorMessagenullł邱ƂmFB<br>
     *         (ԕω) MultiFieldValidator:tB[hvalidateCalledCount
     *         1ł邱ƂmFB<br>
     *                    <br>
     *                    tB[hvaluenullł邱ƂmFB<br>
     *                    <br>
     *                    tB[hfields̔z񒷂0ł邱ƂmFB<br>
     *         (ԕω) O:OxFERROR<br>
     *                    bvꂽOFInvocationTargetException<br>
     *                    <br>
     *                    OxFERROR<br>
     *                    bvꂽOFInvocationTargetException<br>
     *         
     * <br>
     * փ`FbNΏۃtB[hlbean擾ۂɁA
     * PropertyUtils#getPropertyɂĔInvocationTargetExceptionbv
     * G[Oo͂ă`FbNs邱ƂmFeXgB<br>
     * <br>
     * փ`FbNˑtB[hlbean擾ۂɁA
     * PropertyUtils#getPropertyɂĔInvocationTargetExceptionbv
     * G[Oo͂ă`FbNs邱ƂmFeXg܂B
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testValidateMultiField10() throws Exception {
        // O
        FieldChecks_JavaBeanStub03 bean = new FieldChecks_JavaBeanStub03();
        ValidatorAction va = new ValidatorAction();
        Field field = new Field();
        field.setProperty("field1");
        Var var1 = new Var("multiFieldValidator", 
                "jp.terasoluna.fw.validation."
                + "FieldChecks_MultiFieldValidatorImpl01", null);
        Var var2 = new Var("fields", "field2", null);
        field.addVar(var1);
        field.addVar(var2);
        FieldChecks_ValidationErrorsImpl03 errors = new FieldChecks_ValidationErrorsImpl03();
        FieldChecks_MultiFieldValidatorImpl01.result = true;

        // eXg{
        FieldChecks fieldChecks = new FieldChecks();

        boolean result = 
            fieldChecks.validateMultiField(bean, va, field, errors);
    
        // 
        assertTrue(result);
        assertNull(errors.errorMessage);
        assertEquals(1, FieldChecks_MultiFieldValidatorImpl01.
                validateCalledCount);
        assertNull(FieldChecks_MultiFieldValidatorImpl01.value);
        assertNotNull(FieldChecks_MultiFieldValidatorImpl01.fields);
        assertEquals(0, 
                FieldChecks_MultiFieldValidatorImpl01.fields.length);
        assertTrue(LogUTUtil.checkError(null, 
                new InvocationTargetException(new RuntimeException())));
        assertTrue(LogUTUtil.checkError(null, 
                new InvocationTargetException(new RuntimeException())));
    }

}
