/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * tEEJ_[֘Ã[eBeBNXB
 *
 */
public class DateUtil {

    /**
     * ONX
     */
    private static Log log = LogFactory.getLog(DateUtil.class);

    /**
     * VXe擾B
     *
     * <p>WebT[oAPT[o𕪗NX^\ɂꍇ́A}V
     * VXetقȂ\B邽߁AVXet
     * 擾ɂ͕K̃\bh𗘗pAKvɉē}V̓t擾
     * Ȃǂ̑[uƂ悤ɂĂB</p>
     *
     * @return VXe
     */
    public static java.util.Date getSystemTime() {
        Calendar calendar = Calendar.getInstance();
        return calendar.getTime();
    }

    /**
     * java.util.DateCX^XaƂĎw̃tH[}bg
     * ϊB
     *
     * <p>
     *  ApplicationResources.properties
     *  Ŏw肳ꂽttH[}bgpāAAa̕ϊ
     *  sƂłB<br>
     *  ĹAa̋EƂȂtAaAAt@xbg
     *  ݒłB
     *  <strong> ApplicationResources.properties ɂ
     *  a̐ݒ</strong><br>
     *  <code><pre>
     *  wareki.gengo.0.name = 
     *  wareki.gengo.0.roman = H
     *  wareki.gengo.0.startDate = 1989/01/08
     *  wareki.gengo.1.name = a
     *  wareki.gengo.1.roman = S
     *  wareki.gengo.1.startDate = 1926/12/25
     *  wareki.gengo.2.name = 吳
     *  wareki.gengo.2.roman = T
     *  wareki.gengo.2.startDate = 1912/07/30
     *  wareki.gengo.3.name = 
     *  wareki.gengo.3.roman = M
     *  wareki.gengo.3.startDate = 1868/09/04
     *  </pre></code>
     * </p>
     *
     * <strong>tH[}bg</strong><br>
     * <p>tH[}bǵAjava.text.SimpleDateFormat NX
     * <i>p^[</i> Ƃĉ߂邪Aȉ̃p^[̉߂
     * iftHgP[́j SimpleDateFormat NXƈقȂB
     * </p>
     *
     * <div width="90%" align="center">
     *  <table border="1">
     *   <tr>
     *    <th>L</th>
     *    <th><code>&nbsp;SimpleDateFormat</code>&nbsp;</th>
     *    <th><code>&nbsp;dateToWarekiString()</code>&nbsp;</th>
     *   </tr>
     *   <tr>
     *    <td>G</td>
     *    <td align="left">I<br><br>F<br>AD</td>
     *    <td align="left">a<br><br>
     *                     F<br>
     *                    i4ȏ̘Ap^[j<br>
     *                     A吳AaA<br>
     *                     i3ȉ̘Ap^[j<br>
     *                     MATASAH</td>
     *   </tr>
     *   <tr>
     *    <td>y</td>
     *    <td align="left">Nij<br><br>F<br>2002</td>
     *    <td align="left">Niaj<br><br>F<br>14</td>
     *   </tr>
     *   <tr>
     *    <td>E</td>
     *    <td align="left">j<br><br>F<br>Tuesday</td>
     *    <td align="left">ji{\Lj<br><br>
     *                     F<br>
     *                    i4ȏ̘Ap^[j<br>
     *                     jAΗjAj<br>
     *                     i3ȉ̘Ap^[j<br>
     *                     A΁A</td>
     *   </tr>
     * </table>
     * </div>
     *
     * <p>̂AjiEjɂĂ SimpleDateFotmat
     * ̃CX^X쐬ɁAP[ &quot;ja&quot;
     * Ɏw肷邱ƂŕϊB</p>
     *
     * <p>܂ANiajɂẮAp^[̐ɏ]āA[pfBOlɕϊB</p>
     *
     * <p>aAјaNɂẮAgetWarekiGengoName()A
     * getWarekiGengoRoman()AgetWarekiYear() \bhɂĎ擾B
     * ̃\bhŎQƂa̐ݒ́AAplicationResources t@C
     * ȉ̏ōsB</p>
     *
     * <p><code><pre>
     * wareki.gengo.<i>ID</i>.name=<i></i>
     * wareki.gengo.<i>ID</i>.roman=<i>̃[}\L</i>
     * wareki.gengo.<i>ID</i>.startDate=<i>@{si:yyyy/MM/dd`j</i>
     * </pre></code></p>
     *
     * <p>ID́AL̎O̐ݒ֘At邽߂̂̂łACӂ̕
     * włB</p>
     *
     * @param format tH[}bg
     * @param date ɕϊ鎞f[^
     * @return aƂătH[}bgꂽ
     */
    public static String dateToWarekiString(String format,
                                            java.util.Date date) {

        // SimpleDateFormatɂtH[}bg̑OɌ'G'AєN'y'
        // p^[aɒu
        StringBuilder sb = new StringBuilder();
        boolean inQuote = false; // VONH[g̒ł邩ǂ
        char prevCh = 0;
        int count = 0;
        for (int i = 0; i < format.length(); i++) {
            char ch = format.charAt(i);
            if (ch != prevCh && count > 0) {
                if (prevCh == 'G' && count >= 4) {
                    sb.append(getWarekiGengoName(date));
                } else if (prevCh == 'G') {
                    // ̃[}\L̏ꍇ́ANH[gĂ
                    sb.append('\'');
                    sb.append(getWarekiGengoRoman(date));
                    sb.append('\'');
                } else if (prevCh == 'y') {
                    // aN񌅈ȏ̏ꍇ̓[peBOB
                    sb.append(padding(getWarekiYear(date), count));
                }
                count = 0;
            }

            if (ch == '\'') {
                sb.append('\'');
                inQuote = !inQuote;
            } else if (!inQuote && (ch == 'G' || ch == 'y')) {
                // ch͘aϊœƎɉ߂tH[}bgłꍇ́A
                // JԂ񐔂JEgB
                prevCh = ch;
                ++count;
            } else {
                // ̑́̕Afʂ
                sb.append(ch);
            }
        }

        // tH[}bg̍Ō̃ACeB
        if (count > 0) {
            if (prevCh == 'G' && count >= 4) {
                sb.append(getWarekiGengoName(date));
            } else if (prevCh == 'G') {
                sb.append('\'');
                sb.append(getWarekiGengoRoman(date));
                sb.append('\'');
            } else if (prevCh == 'y') {
                sb.append(padding(getWarekiYear(date), count));
            }
        }

        SimpleDateFormat sdf = new SimpleDateFormat(sb.toString(),
                                                    Locale.JAPAN);

        sdf.getCalendar().setLenient(false);
        sdf.setLenient(false);
        return sdf.format(date);
    }

    /**
     * [pfBO{B
     *
     * @param intValue pfBOΏۂ̐l
     * @param size tH[}bg
     */
    private static String padding(int intValue, int size) {
        final String strValue = Integer.toString(intValue);
        if (size < 2) {
            return strValue;
        }
        final int pads = size - strValue.length();
        if (pads <= 0) {
            // pfBOsv
            return strValue;
        }
        final char[] buf = new char[size];
        for (int i = pads - 1; i >= 0; i--) {
            buf[i] = '0';
        }
        strValue.getChars(0, strValue.length(), buf, pads);
        return new String(buf);
    }

    /**
     * ApplicationResources t@CɂĘa֘A̐ݒ
     * 擾ۂ̃L[̃vtBbNXB
     */
    private static final String GENGO_KEY = "wareki.gengo.";

    /**
     * {s猳ւ̃}bvB
     */
    private static final Map<Date, String> GENGO_NAME
            = new HashMap<Date, String>();

    /**
     * {s猳̃[}\LiZk`jւ̃}bvB
     */
    private static final Map<Date, String> GENGO_ROMAN =
            new HashMap<Date, String>();

    /**
     * åe{sꂽt̃XgBXg̐擪A
     * ÂɕׂB
     */
    private static final Date[] GENGO_BEGIN_DATES;

    /**
     * åe{sꂽÑXgBXg̐擪A
     * ÂɕׂB
     */
    private static final int[] GENGO_BEGIN_YEARS;

    /**
     * NX[hɁAApplicationResources t@CŎw肳ꂽ
     * Ƃɘaf[^B
     */
    static {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");

        // vpeBůJnvƁuṽ}bv쐬
        Enumeration<String> enumaration =
            PropertyUtil.getPropertyNames(GENGO_KEY);
        Set<String> ids = new HashSet<String>();

        GENGO_LOOP:
        while (enumaration.hasMoreElements()) {
            String key = enumaration.nextElement();
            String id = key.substring(GENGO_KEY.length(),
                                        key.lastIndexOf("."));
            if (!ids.contains(id)) {
                String name
                    = PropertyUtil.getProperty(GENGO_KEY + id + ".name", "");
                String roman
                    = PropertyUtil.getProperty(GENGO_KEY + id + ".roman", "");

                String start
                    = PropertyUtil.getProperty(GENGO_KEY + id + ".startDate");
                if (start == null) {
                    log.error(GENGO_KEY + id + ".startDate not found");
                    continue GENGO_LOOP;
                }

                try {
                    Date date = sdf.parse(start);

                    GENGO_NAME.put(date, name);
                    GENGO_ROMAN.put(date, roman);
                    log.info("registerd: "
                                + date + ", " + name + ", " + roman);
                } catch (ParseException e) {
                    log.error(e.getMessage());
                }

                ids.add(id);
            }
        }

        // ̊Jn̔z쐬A\[gĂ
        Set<Date> keySet = GENGO_NAME.keySet();
        int size = keySet.size();
        GENGO_BEGIN_DATES = keySet.toArray(new Date[size]);
        Arrays.sort(GENGO_BEGIN_DATES);

        // ůJn̔zvƑΉ悤Ɍ̊JnN̔z쐬
        GENGO_BEGIN_YEARS = new int[size];
        Calendar calendar = Calendar.getInstance();
        for (int i = 0; i < GENGO_BEGIN_DATES.length; i++) {
            calendar.setTime(GENGO_BEGIN_DATES[i]);
            GENGO_BEGIN_YEARS[i] = calendar.get(Calendar.YEAR);
        }
    }

    /**
     * w肳ꂽt̘a擾B
     *
     * <p>
     * a́AApplicationResources t@CŎw肷B
     * </p>
     *
     * @param date t
     * @return a
     */
    public static String getWarekiGengoName(Date date) {
        for (int i = GENGO_BEGIN_DATES.length - 1; i >= 0; i--) {
            if (!date.before(GENGO_BEGIN_DATES[i])) {
                return GENGO_NAME.get(GENGO_BEGIN_DATES[i]);
            }
        }
        throw new IllegalArgumentException("Wareki Gengo Name not found for "
                                            + date);
    }

    /**
     * w肳ꂽt̘a̃[}\LiZk`j擾B
     *
     * <p>a̃[}\ĹAApplicationResourcest@CŎw肷B</p>
     *
     * @param date t
     * @return a̃[}\L
     */
    public static String getWarekiGengoRoman(Date date) {
        for (int i = GENGO_BEGIN_DATES.length - 1; i >= 0; i--) {
            if (!date.before(GENGO_BEGIN_DATES[i])) {
                return GENGO_ROMAN.get(GENGO_BEGIN_DATES[i]);
            }
        }
        throw new IllegalArgumentException("Wareki Gengo Roman not found for "
                                            + date);
    }

    /**
     * w肳ꂽt̘aN擾B
     *
     * @param date t
     * @return aN
     */
    public static int getWarekiYear(Date date) {
        for (int i = GENGO_BEGIN_DATES.length - 1; i >= 0; i--) {
            if (!date.before(GENGO_BEGIN_DATES[i])) {
                Calendar calendar = Calendar.getInstance();

                calendar.setTime(date);
                int year = calendar.get(Calendar.YEAR);

                return year - GENGO_BEGIN_YEARS[i] + 1;
            }
        }
        throw new IllegalArgumentException("Wareki Gengo not found for "
                                            + date);
    }

}
