/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.taglib;

import java.net.MalformedURLException;
import java.util.Arrays;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;

import jp.terasoluna.utlib.LogUTUtil;
import jp.terasoluna.utlib.TagUTUtil;
import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

import org.apache.struts.Globals;
import org.apache.struts.taglib.logic.IterateTag;

/**
 * LinkTag ubN{bNXeXgB<br>
 * O<br>
 * Ȃ<br>
 * <br>
 */
public class LinkTagTest extends TestCase {

    // eXgΏ
    LinkTag tag = null;

    /**
     * Constructor for LinkTagTest.
     * @param arg0
     */
    public LinkTagTest(String arg0) {
        super(arg0);
    }

    /*
     * @see TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        tag = (LinkTag) TagUTUtil.create(LinkTag.class);
    }

    /*
     * @see TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * testCalculateURL01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() IterateTag:ݒ肠A<br>
     *                started=true<br>
     *                lengthCount=6<br>
     *         () href:not null("/href.do")<br>
     *         () indexed:true<br>
     *         () indexId:not null("number")<br>
     *         
     * <br>
     * ҒlF(߂l) string:u/href.do?r=[_Ȑl]&amp;number=5v<br>
     *         
     * <br>
     * IterateTagnot nullAindexedtrueAindexId"number"̏ꍇAURLɃLbVp_IDAp[^"number"ŃCfbNXԍt^Ă邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testCalculateURL01() throws Exception {

        IterateTag iterateTag = new IterateTag();

        // IterateTag̃CfbNXԍݒ肷
        UTUtil.setPrivateField(iterateTag, "started", Boolean.TRUE);
        UTUtil.setPrivateField(iterateTag, "lengthCount", Integer.valueOf("6"));

        // IterateTagݒ
        tag.setParent(iterateTag);

        // LinkTagݒ
        tag.setHref("/href.do");
        tag.setIndexed(true);
        tag.setIndexId("number");

        // eXgs
        String url = tag.calculateURL();
        // URL̃AT[g
        String[] urlComposition = url.split("\\?");
        assertEquals("/href.do", urlComposition[0]);
        String[] urlParamaters = urlComposition[1].split("&amp;");
        // LinkTagURLp[^̐HashMapgpĂAۏ؂Ȃ߁A\[gĂAT[g
        Arrays.sort(urlParamaters);
        assertEquals("number=5", urlParamaters[0]);
        assertTrue(urlParamaters[1].startsWith("r="));

    }

    /**
     * testCalculateURL02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() IterateTag:ݒ肠A<br>
     *                started=true<br>
     *                lengthCount=6<br>
     *         () href:not null("/href.do")<br>
     *         () indexed:true<br>
     *         () indexId:null<br>
     *         
     * <br>
     * ҒlF(߂l) string:u/href.do?index=5&amp;r=[_Ȑl]v<br>
     *         
     * <br>
     * IterateTagnot nullAindexedtrueAindexIdnull̏ꍇAURLɃLbVp_IDAp[^"index"ŃCfbNXԍt^Ă邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testCalculateURL02() throws Exception {

        IterateTag iterateTag = new IterateTag();

        // IterateTag̃CfbNXԍݒ肷
        UTUtil.setPrivateField(iterateTag, "started", Boolean.TRUE);
        UTUtil.setPrivateField(iterateTag, "lengthCount", Integer.valueOf("6"));

        // IterateTagݒ
        tag.setParent(iterateTag);

        // LinkTagݒ
        tag.setHref("/href.do");
        tag.setIndexed(true);
        tag.setIndexId(null);

        // eXgs
        String url = tag.calculateURL();
        // URL̃AT[g
        String[] urlComposition = url.split("\\?");
        assertEquals("/href.do", urlComposition[0]);
        String[] urlParamaters = urlComposition[1].split("&amp;");
        // LinkTagURLp[^̐HashMapgpĂAۏ؂Ȃ߁A\[gĂAT[g
        Arrays.sort(urlParamaters);
        assertEquals("index=5", urlParamaters[0]);
        assertTrue(urlParamaters[1].startsWith("r="));

    }

    /**
     * testCalculateURL03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() IterateTag:ݒȂB<br>
     *         () href:not null("/href.do")<br>
     *         () indexed:false<br>
     *         () indexId:null<br>
     *         
     * <br>
     * ҒlF(߂l) string:u/href.do?r=[_Ȑl]v<br>
     *         
     * <br>
     * IterateTag̐ݒȂAindexedfalseAindexIdnull̏ꍇAURLɃLbVp_IDt^Ă邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testCalculateURL03() throws Exception {

        // LinkTagݒ
        tag.setHref("/href.do");
        tag.setIndexed(false);
        tag.setIndexId(null);

        // eXgs
        String url = tag.calculateURL();
        assertEquals(
            "/href.do?r=",
            url.substring(0, url.indexOf("r=") + 2));
        assertNotNull(url.substring(url.indexOf("r=")));

    }

    /**
     * testCalculateURL04()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() IterateTag:ݒȂB<br>
     *         () href:not null("/href.do")<br>
     *         () indexed:true<br>
     *         
     * <br>
     * ҒlF(ԕω) O:JspException<br>
     *                    bZ[WF"indexed="true"̎witerate^Oň͂܂ꂽł̂ݗLł"<br>
     *         (ԕω) O:O<br>
     *                    G[OF"iterateTag is null."<br>
     *         
     * <br>
     * IterateTag̐ݒȂAindexedtruȅꍇAJspExceptionAG[bZ[Wi[Ă邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testCalculateURL04() throws Exception {

        // LinkTagݒ
        tag.setHref("/href.do");
        tag.setIndexed(true);

        // eXgs
        try {
            tag.calculateURL();
            fail();
        } catch (JspException e) {
            assertEquals(e.getMessage(),
                    "indexed=\"true\"̎witerate^Oň͂܂ꂽł̂ݗLł");
            PageContext pageContext = (PageContext) UTUtil.getPrivateField(tag,
                    "pageContext");
            Throwable throwable = (Throwable) pageContext.getAttribute(
                    Globals.EXCEPTION_KEY, PageContext.REQUEST_SCOPE);
            assertEquals(JspException.class.getName(), throwable.getClass()
                    .getName());
            assertTrue(LogUTUtil.checkError("iterateTag is null."));
        }

    }

    /**
     * testCalculateURL05()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() IterateTag:ݒȂB<br>
     *         () href:null<br>
     *         () indexId:null<br>
     *         
     * <br>
     * ҒlF(ԕω) O:JspException<br>
     *                    bZ[WF"CgURL𐶐ł܂: java.net.MalformedURLException:  "forward","href","page","action"̂̈w肷Kv܂"<br>
     *         (ԕω) O:O<br>
     *                    G[OF"Malformed URL has occurred."<br>
     *         
     * <br>
     * forwardAhrefApageAactionݒ肵ĂȂꍇAJspExceptionAG[bZ[Wi[Ă邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testCalculateURL05() throws Exception {

        // eXgs
        try {
            tag.calculateURL();
            fail();
        } catch (JspException e) {
            assertEquals(e.getMessage(), "CgURL𐶐ł܂: "
                    + "java.net.MalformedURLException: "
                    + "\"forward\", \"href\",\"page\",\"action\""
                    + " ̂̈w肷Kv܂");
            PageContext pageContext = (PageContext) UTUtil.getPrivateField(tag,
                    "pageContext");
            Throwable throwable = (Throwable) pageContext.getAttribute(
                    Globals.EXCEPTION_KEY, PageContext.REQUEST_SCOPE);
            assertEquals(MalformedURLException.class.getName(), throwable
                    .getClass().getName());
            LogUTUtil.checkError("Malformed URL has occurred.");
        }

    }

    /**
     * testCalculateURL06()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() href:"/href.do"<br>
     *         () action:"/action.do"<br>
     *         
     * <br>
     * ҒlF(ԕω) O:JspException<br>
     *                    bZ[WF"CgURL𐶐ł܂: java.net.MalformedURLException:  "forward","href","page","action"̂̈w肷Kv܂"<br>
     *         (ԕω) O:O<br>
     *                    G[OF"Malformed URL has occurred."<br>
     *         
     * <br>
     * forwardAhrefApageAactionݒ肵ĂꍇA<br>
     * JspException邱ƁAG[bZ[Wi[Ă邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testCalculateURL06() throws Exception {

        // LinkTagݒ
        tag.setHref("/href.do");
        tag.setAction("/action.do");

        // eXgs
        try {
            tag.calculateURL();
            fail();
        } catch (JspException e) {
            assertEquals(e.getMessage(), "CgURL𐶐ł܂: "
                    + "java.net.MalformedURLException: "
                    + "\"forward\", \"href\",\"page\",\"action\""
                    + " ̂̈w肷Kv܂");
            PageContext pageContext = (PageContext) UTUtil.getPrivateField(tag,
                    "pageContext");
            Throwable throwable = (Throwable) pageContext.getAttribute(
                    Globals.EXCEPTION_KEY, PageContext.REQUEST_SCOPE);
            assertEquals(MalformedURLException.class.getName(), throwable
                    .getClass().getName());
            LogUTUtil.checkError("Malformed URL has occurred.");
        }

    }

}
