/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.utlib;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;


/**
 * f[^x[XANZXp̒ۃNXB
 * 
 */
abstract class DBObject {

    /**
     * p[^i[p̃nbV}bvB
     */
    protected Map params = new HashMap();

    /**
     * SQLB
     */
    protected String sql = null;
    
    /**
     * SQL̐ݒB
     * 
     * @param sql SQL̕
     */
    public void setSQL(String sql) {
        this.sql = sql;
    }

    /**
     * SQLɓnp[^̐ݒB
     * ŒlZbgBʏAt^ȊǑ^̏ꍇɗpB
     * 
     * @param index p[^̃CfbNXl(1`n)
     * @param param p[^l
     */
    public void setString(int index, String param) {
        params.put(
            Integer.toString(index),
            new DBParam(param, java.sql.Types.VARCHAR));
    }

    /**
     * SQLɓnp[^̐ݒB
     * IntegerŒlZbgB
     * 
     * @param index p[^̃CfbNXl(1`n)
     * @param param p[^l
     */
    public void setInt(int index, Integer param) {
        params.put(
            Integer.toString(index),
            new DBParam(param, java.sql.Types.NUMERIC ));
    }
    
    /**
     * SQLɓnp[^̐ݒB
     * ^CX^vŒlZbgBʏAt^̏ꍇɗpB
     * 
     * @param index p[^̃CfbNXl(1`n)
     * @param param p[^l
     */
    public void setTimestamp(int index, Timestamp param) {
        params.put(
            Integer.toString(index),
            new DBParam(param, java.sql.Types.TIMESTAMP));
    }

    /**
     * R~bgB
     * 
     * @throws SQLException
     */    
    public void commit() throws SQLException {
        getConnection().commit();
    }

    /**
     * [obNB
     * 
     * @throws SQLException
     */    
    public void rollback() throws SQLException {
        getConnection().rollback();
    }

    /**
     * ڑIuWFNg̎擾B
     * 
     * @return ڑIuWFNg
     */
    protected Connection getConnection() throws SQLException {
        return DBConnectionWrapper.getInstance();
    }

    /**
     * SQLp[^̃oChB
     * qNX̃[eBeB\bhIȎgB
     * 
     * @param pstmt Xe[gg
     * @throws SQLException
     */
    protected void bindParams(PreparedStatement pstmt) throws SQLException {

        // Xe[ggւ̃p[^ݒ
        for (int i = 1;; i++) {
            // iԖڂ̃p[^l擾B
            // iԖڂ̃p[^݂Ȃ΃p[^ݒ芮B
            DBParam param = (DBParam) params.get(Integer.toString(i));
            if (param == null) {
                break;
            }
            
            // p[^̌^ɉăXe[ggɃoChB
            Object value = param.getValue();
            int type = param.getSQLType();
            if (value == null) {
                pstmt.setNull(i, type);
            } else if (value instanceof Timestamp) {
                pstmt.setTimestamp(i, (Timestamp) value);
            } else if(value instanceof Integer){
                pstmt.setInt(i,((Integer)value).intValue());
            }else {
                pstmt.setString(i, (String) value);
            }
        }
    }

}
