/*
 * Copyright (c) 2012 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.beans.jxpath;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

/**
 * commons-JXPath̃oO(JXPATH-152)pHashMapB
 * <p>
 * commons-JXPath-1.3
 * JXPathIntrospector̎ɍ킹āA
 * putget̂݁AXbhZ[tĂB<br>
 * ɂ́AReadWriteLock𗘗pĂA
 * put̎śÃXbhputgetsłȂ(ꎞIɑ҂ԂƂȂ)A
 * put̎słȂ΁ÃXbhœgets邱ƂłB
 * </p>
 * @see JXPATH152PatchActivator
 */
public class HashMapForJXPathIntrospector<K, V> extends HashMap<K, V> {

    /**
     * VAo[WIDB
     */
    private static final long serialVersionUID = 1944915046869984094L;

    /**
     * ǂݍ݃bNƏ݃bÑyA𐧌䂷ReadWriteLockB
     */
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();

    /**
     * ǂݍ݃bNB
     */
    private final Lock readLock = readWriteLock.readLock();

    /**
     * ݃bNB
     */
    private final Lock writeLock = readWriteLock.writeLock();

    /**
     * w肳ꂽ Map Ɠ}bsOŐVK HashMapForJXPathIntrospector 쐬B
     * @param m }bsOێ}bv(JXPathIntrospector擾}bv)
     * @throws NullPointerException w肳ꂽ}bv null ̏ꍇ
     */
    public HashMapForJXPathIntrospector(Map<? extends K, ? extends V> m) {
        super(m);
    }

    /**
     * L[Ƀ}bsOĂlԂB
     * <p>
     * ̃\bh́Aǂݍ݃bNlԂŁA{@link HashMap#get(Object)}ɈϏB<br>
     * </p>
     * @param key L[
     * @see HashMap#get(Object)
     */
    @Override
    public V get(Object key) {
        readLock.lock();
        try {
            return super.get(key);
        } finally {
            readLock.unlock();
        }
    }

    /**
     * w肳ꂽL[Ŏw肳ꂽl}bsOB
     * <p>
     * ̃\bh́A݃bNlԂŁA{@link HashMap#put(Object, Object)}ɈϏB<br>
     * </p>
     * @param key L[
     * @param value l
     * @see HashMap#put(Object, Object)
     */
    @Override
    public V put(K key, V value) {
        writeLock.lock();
        try {
            return super.put(key, value);
        } finally {
            writeLock.unlock();
        }
    }
}
