/*
 * Copyright (c) 2012 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.ex.web.struts.action;

import java.util.Map;

import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

import org.apache.struts.action.ActionMapping;

public class FlowCallbackInfoMappingTest extends TestCase {

    public FlowCallbackInfoMappingTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * testRegisterFlowCallbackInfo01B
     * EcallBackInfoMaptB[hMapɁAʉʃt[L[ɁAFlowCallbackInfoCX^Xi[邱ƂmFB
     */
    @SuppressWarnings("unchecked")
    public void testRegisterFlowCallbackInfo01() throws Exception {
        FlowCallbackInfoMapping callBackInfoMapping = new FlowCallbackInfoMapping();
        ActionMapping mapping1 = new FlowInvokeActionMapping();
        DefaultFlowCallbackInfo callBackInfo1 = new DefaultFlowCallbackInfo(mapping1);
        ActionMapping mapping2 = new FlowInvokeActionMapping();
        DefaultFlowCallbackInfo callBackInfo2 = new DefaultFlowCallbackInfo(mapping2);

        callBackInfoMapping.registerFlowCallbackInfo("flow1", callBackInfo1);
        callBackInfoMapping.registerFlowCallbackInfo("flow2", callBackInfo2);
        
        Map<String, FlowCallbackInfo> callBackInfoMap = (Map<String, FlowCallbackInfo>) UTUtil.getPrivateField(callBackInfoMapping, "callBackInfoMap");
        assertEquals(2, callBackInfoMap.size());
        assertSame(callBackInfo1, callBackInfoMap.get("flow1"));
        assertSame(callBackInfo2, callBackInfoMap.get("flow2"));
    }

    /**
     * testFindFlowCallbackInfo01B
     * EregisterFlowCallbackInfo\bhœo^FlowCallbackInfoCX^X擾ł邱ƂmFB
     */
    public void testFindFlowCallbackInfo01() throws Exception {
        FlowCallbackInfoMapping callBackInfoMapping = new FlowCallbackInfoMapping();
        ActionMapping mapping1 = new FlowInvokeActionMapping();
        DefaultFlowCallbackInfo callBackInfo1 = new DefaultFlowCallbackInfo(mapping1);
        ActionMapping mapping2 = new FlowInvokeActionMapping();
        DefaultFlowCallbackInfo callBackInfo2 = new DefaultFlowCallbackInfo(mapping2);
        callBackInfoMapping.registerFlowCallbackInfo("flow1", callBackInfo1);
        callBackInfoMapping.registerFlowCallbackInfo("flow2", callBackInfo2);
        
        assertSame(callBackInfo1, callBackInfoMapping.findFlowCallbackInfo("flow1"));
        assertSame(callBackInfo2, callBackInfoMapping.findFlowCallbackInfo("flow2"));
    }

}
