/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.utlib;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * DBƂ̃ANZX֘Ã[eBeBNXB
 * 
 */
class DBAccessUtil {

    /**
     * DBVPX@\NX̃L[ 
     */
    private static final String DBSEQUENCE_KEY = "unittest.dbsequence.class";
    
    /**
     * DBVPX@\C^tF[XDBSequencẽCX^XiSingletonp^[j
     */
    private static DBSequence dbSequenceInstance = null; 
    
    /**
     * R~bg؂邩ۂ̃L[
     */
    private static final String DB_COMMIT_KEY = "unittest.dbmethods.commit";

    /**
     * sZNg̃WbN
     * 
     * @param tableName e[u
     * @param condition ߂̕
     * @param order ߂̕
     * @return ʃZbg̒li[ꂽz
     * @throws SQLException
     */
    public static Map[] select(String tableName, String condition,
            String order)
            throws SQLException {
        
        List resultList = selectRows(tableName, condition, order);
        Map[] resultArray = new Map[resultList.size()];
        resultList.toArray(resultArray);
        
        return resultArray;
    }

    /**
     * sZNg̃WbN
     * 
     * @param tableName e[u
     * @param condition ߂̕
     * @param order ߂̕
     * @return ʃZbg̒li[ꂽXg
     * @throws SQLException
     */
    public static List selectRows(String tableName, String condition,
            String order)
            throws SQLException {
    
        //`FbN
        if (tableName == null || "".equals(tableName)) {
            String msg = "e[uw肳Ă܂B";
            throw new IllegalArgumentException(msg);
        }
    
        //SQL񐶐
        String sql = "SELECT * FROM " + tableName;
        if (condition != null && !"".equals(condition)) {
            sql += " WHERE " + condition;
        }
        if (order != null && !"".equals(order)) {
            sql += " ORDER BY " + order;
        }
    
        //SQL̎s
        DBQueryObject q = new DBQueryObject();
        List result = q.query(sql);
        return result;
    }


    /**
     * f[^}̃WbN
     * 
     * @param tableName e[u
     * @param data Jf[^̓񎟌z
     * @throws SQLException
     */
    public static void insertData(String tableName, String[][] data)
        throws SQLException {
    
        // `FbN
        if (tableName == null || tableName.equals("")) {
            String msg = "e[uw肳Ă܂B";
            throw new IllegalArgumentException(msg);
        }
        if (data == null || data.length == 0) {
            String msg = "}f[^w肳Ă܂B";
            throw new IllegalArgumentException(msg);
        }
    
        // e[u啶ň悤ɂB
        String tableNameUpper = tableName.toUpperCase();
    
        // ͂ꂽJ擾AJƃCfbNXl̃}bv쐬B
        String[] columnNames = new String[data[0].length];
        Map columnName2Index = new HashMap();
        for (int i = 0; i < data[0].length; i++) {
            if (data[0][i] == null || data[0][i].equals("")) {
                String msg = "Jw肳Ă܂B";
                throw new IllegalArgumentException(msg);
            }
            columnNames[i] = data[0][i].toUpperCase(); // 啶ɕϊ
            columnName2Index.put(columnNames[i], new Integer(i));
        }
    
        // Ye[ȗSJ̏擾B
        DBColumnInfo[] columnInfos = DBAccessUtil.getColumnInfoList(tableName);
        for (int i = 0; i < columnNames.length; i++) {
            boolean existColumn = false;
            for (int j = 0; j < columnInfos.length; j++) {
                if (columnNames[i].equals(columnInfos[j].getName())) {
                    existColumn = true;
                    break;
                }
            }
            if (!existColumn) {
                String msg = "J'" + columnNames[i] + "'݂͑܂B";
                throw new IllegalArgumentException(msg);
            }
        }
    
        //SQL񐶐
        StringBuffer buf = new StringBuffer();
        buf.append("INSERT INTO ");
        buf.append(tableNameUpper);
        buf.append("(");
        for (int i = 0; i < columnInfos.length; i++) {
            buf.append(columnInfos[i].getName());
            buf.append((i < columnInfos.length - 1) ? "," : ")");
        }
        buf.append(" VALUES (");
        for (int i = 0; i < columnInfos.length; i++) {
            buf.append("?");
            buf.append((i < columnInfos.length - 1) ? "," : ")");
        }
        String sql = buf.toString();
    
        //SQL̎s
        DBUpdateObject u = new DBUpdateObject();
        u.setSQL(sql);
        for (int i = 1; i < data.length; i++) {
            for (int j = 0; j < columnInfos.length; j++) {
                if (columnName2Index.containsKey(columnInfos[j].getName())) {
                    // ͒lJ͓͒lZbgB
                    Integer indexObj = (Integer) columnName2Index.get(
                        columnInfos[j].getName());
                    int index = indexObj.intValue();
                    u.setParam(j + 1, data[i][index],
                        columnInfos[j].getSqlType());                    
                } else {
                    // ͒lȂJ̓ftHglZbgB
                    u.setParam(j + 1, columnInfos[j].getDefaultValue(),
                        columnInfos[j].getSqlType());
                }
            }
            u.update();
        }
        if (shouldCommit()) {
            u.commit();
        }
    }

    /**
     * Ss폜̃WbN
     * 
     * @param tableName e[u
     * @throws SQLException
     */
    public static void deleteAll(String tableName) throws SQLException {
        // `FbN
        if (tableName == null || tableName.equals("")) {
            String msg = "e[uw肳Ă܂B";
            throw new IllegalArgumentException(msg);
        }
    
        // WbN
        String sql = "DELETE FROM " + tableName;
        DBUpdateObject u = new DBUpdateObject();
        u.setSQL(sql);
        u.update();
        if (shouldCommit()) {
            u.commit();
        }
    }

    /**
     * SQLs̃WbŃB
     * 
     * @param sql sSQL
     * @throws SQLException
     */
    public static void executeSQL(String sql) throws SQLException {
        // `FbN
        if (sql == null || sql.equals("")) {
            String msg = "SQLw肳Ă܂B";
            throw new IllegalArgumentException(msg);
        }
    
        // WbN
        DBUpdateObject u = new DBUpdateObject();
        u.setSQL(sql);
        u.update();
        if (shouldCommit()) {
            u.commit();
        }
    }

    /**
     * w肵VPX̌ݒl擾B
     * 
     * @param sequenceName VPX
     * @return@VPX̌ݒl
     * 
     * @throws SQLException@DBANZXɗOꍇ
     */
    public static int getSequenceValue(String sequenceName) throws SQLException{    
        
        DBSequence dbSequence = getDBSequenceImpl();
        
        return dbSequence.getSequenceValue(sequenceName);
        
    }
    
    /**
     * w肵VPXɒlݒ肷B
     * 
     * @param sequenceName@VPX
     * @param value@VPXɐݒ肷l
     * 
     * @throws SQLException@DBANZXɗOꍇ
     */
    public static void setSequenceValue(String sequenceName,int value) throws SQLException{
        
        DBSequence dbSequence = getDBSequenceImpl();
        
        dbSequence.setSequenceValue(sequenceName,value);
        
    }
    
    /**
     * C^tF[XDBSequence̎NX̃CX^X擾B
     * 
     * @return 
     */
    private synchronized static DBSequence getDBSequenceImpl(){
        
        if(dbSequenceInstance != null){
            return dbSequenceInstance;
        }
        
        //utlib.conft@CDBSequence̎NX擾
        String implClassName = UTLibConfig.getProperty(DBSEQUENCE_KEY);
        if(implClassName == null || "".equals(implClassName)){
            throw new RuntimeException("DBVPX̎NX񂪎w肳Ă܂B");
        }
        
        //DBSequence̎NX̃CX^X𐶐
        try {
            Class implClass = Class.forName(implClassName );
            return (DBSequence) implClass.newInstance();
            
        } catch (ClassNotFoundException e) {
           
            throw new RuntimeException(e);

        } catch (InstantiationException e) {
            
            throw new RuntimeException(e);
            
        } catch (IllegalAccessException e) {
            
            throw new RuntimeException(e);
        } 
        
    }
    
    /**
     * e[ȗSJ̎擾
     * @param tableName e[u
     * @return we[ũJ񂪊i[ꂽz
     * @throws SQLException
     */
    private static DBColumnInfo[] getColumnInfoList(String tableName)
        throws SQLException {
    
        // e[u啶ɂB
        String tableNameUpper = tableName.toUpperCase();
    
        // _~[SQL̎s
        String sql = "SELECT * FROM " + tableNameUpper;
        Statement stmt = null;
        ResultSet rs = null;
        List columnInfoList = new ArrayList();
        try {
            stmt = DBConnectionWrapper.getInstance().createStatement();
            stmt.executeQuery(sql);
    
            // J̖OA^Akۂ擾
            rs = stmt.getResultSet();
            ResultSetMetaData rsmd = rs.getMetaData();
            int columnCount = rsmd.getColumnCount();
            for (int i = 1; i <= columnCount; i++) {
                DBColumnInfo columnInfo =
                    new DBColumnInfo(
                        rsmd.getColumnName(i).toUpperCase(),
                        rsmd.getColumnType(i),
                        (rsmd.isNullable(i)
                            == ResultSetMetaData.columnNullable));
                columnInfoList.add(columnInfo);
            }
        } finally {
            if (rs != null) {
                try {
                    rs.close();
                } catch (SQLException e) {
                    // Ȃ
                }
            }
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                    // Ȃ
                }
            }
        }
        
        // J񃊃Xgԋp
        DBColumnInfo[] columnInfos = new DBColumnInfo[columnInfoList.size()];
        columnInfoList.toArray(columnInfos);
        return columnInfos;
    }

    /**
     * R~bg邩ۂ̃tOԂB
     * @return R~bgꍇtrueAȂꍇfalseB
     */
    private static boolean shouldCommit() {
        String commit = UTLibConfig.getProperty(DB_COMMIT_KEY);
        return ("on".equals(commit));
    }

}
