/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.utlib.spring;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.sql.Types;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

import jp.terasoluna.utlib.DBSequence;

import org.springframework.jdbc.InvalidResultSetAccessException;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.jdbc.support.rowset.SqlRowSetMetaData;
import org.springframework.test.AbstractTransactionalDataSourceSpringContextTests;

/**
 * f[^x[XANZXsNX̃eXgP[XNX̌pNXB
 *
 * 
 */
public abstract class DaoTestCase extends
        AbstractTransactionalDataSourceSpringContextTests {
    
    /**
     * DBVPX̒lݒƎ擾Bean
     */
    private DBSequence dbSequence;


    /**
     * RXgN^
     * 
     */
    public DaoTestCase() {
        super();
    }


    /**
     * RXgN^
     * 
     * @param name JUnit name
     */
    public DaoTestCase(String name) {
        super(name);
    }


    /**
     * w肳ꂽe[usf[^擾B
     *  
     * @param tableName e[u
     * @param condition (WHERE)
     * @param order (ORDER BY)
     * @return sf[^̃Xg
     */
    protected Map[] select(String tableName, String condition, String order) {
    	return select(tableName, condition, order, null);
    }


    /**
     * w肳ꂽe[usf[^擾B
     *  
     * @param tableName e[u
     * @param condition (WHERE)
     * @param order (ORDER BY)
     * @param columns J̔z
     * @return sf[^̃Xg
     */
    @SuppressWarnings("unchecked")
    protected Map[] select(String tableName, String condition,
           String order, String[] columns) {

        //`FbN
        if (tableName == null || "".equals(tableName)) {
            String msg = "e[uw肳Ă܂B";
            throw new IllegalArgumentException(msg);
        }
    
        //SQL񐶐 e[u͑啶ňƂƂ
        //String sql = "SELECT * FROM " + tableName.toUpperCase();
        String sql = createDummySqlFromColumns(tableName.toUpperCase(), columns);
        if (condition != null && !"".equals(condition)) {
            sql += " WHERE " + condition;
        }
        if (order != null && !"".equals(order)) {
            sql += " ORDER BY " + order;
        }
    	
        SqlRowSet sqlRowSet = jdbcTemplate.queryForRowSet(sql);
        
        //YR[hȂꍇA̔zԂ
        if(!sqlRowSet.first()){
            return new Map[0];
        }
        
        //R[h̃[^f[^擾
        SqlRowSetMetaData sqlRowMetaData = sqlRowSet.getMetaData(); 
        
        //J̐ƃJ擾
        int columnNumber = sqlRowMetaData.getColumnCount();
        String[] columnNames = sqlRowMetaData.getColumnNames();
        
        List resultList = new ArrayList();
        
        int i = 0;
        while(true){
            Map row = new TreeMap();
            for (int j = 1; j <= columnNumber; j++) {
            	int sqlType = sqlRowMetaData.getColumnType(j);
            	
                if (sqlType == java.sql.Types.DATE
                        || sqlType == java.sql.Types.TIME
                        || sqlType == java.sql.Types.TIMESTAMP) {

                		//modified by liu, 2007/07/26, for oracle timestamp
//                        Timestamp ts = sqlRowSet.getTimestamp(j);
//                        String data = (ts != null) ? ts.toString() : null;
//                        row.put(columnNames[j -1], data);
                		Timestamp ts = null;
                		if (sqlRowSet.getObject(j) != null && 
                			"oracle.sql.TIMESTAMP".equals(sqlRowSet.getObject(j).getClass().getName())){
                			try {
                				//modified by liu, 2007/07/31
                				//oracle jdbc bug
                				if (((oracle.sql.TIMESTAMP)sqlRowSet.getObject(j)).shareBytes() != null) {
                					ts = ((oracle.sql.TIMESTAMP)sqlRowSet.getObject(j)).timestampValue();
                				}
                        	} catch (InvalidResultSetAccessException e) {
                        		//do nothing
                        	} catch (SQLException e) {
                        		//do nothing
                        	}
                		} else {
                			ts = sqlRowSet.getTimestamp(j);
                		}

                		String data = (ts != null) ? ts.toString() : null;
                        row.put(columnNames[j -1], data);
                        
                    } else {
                    	row.put(columnNames[j -1], sqlRowSet.getString(j));
                    }
            }        	
            resultList.add(row);
            
        	//̍sɈړ
            if(!sqlRowSet.next()){
            	break;
            }
            i++;
        }
        
        Map[] resultArray = new Map[resultList.size()];
        resultList.toArray(resultArray);
        
        return resultArray;

    }

    
    /**
     * f[^x[XɃf[^}B
     *
     * @param tableName }Ώۂ̃e[u
     * @param data }f[^BJƒl̓񎟌z
     */
    protected void insertData(String tableName, String[][] data) {
        
        // `FbN
        if (tableName == null || tableName.equals("")) {
            String msg = "e[uw肳Ă܂B";
            throw new IllegalArgumentException(msg);
        }
        if (data == null || data.length < 2) {
            String msg = "}f[^w肳Ă܂B";
            throw new IllegalArgumentException(msg);
        }

        // e[u啶ň悤ɂB
        String tableNameUpper = tableName.toUpperCase();
        
        //J̃^Cv擾
        int[] columnType = getColumnSQLType(tableNameUpper,data[0]);
        
        StringBuilder buf = new StringBuilder();
        buf.append("INSERT INTO ");
        buf.append(tableNameUpper);
        buf.append("(");

        //SQL񐶐
        for (int i = 0; i < data[0].length; i++) {
            buf.append(data[0][i].toUpperCase());
            buf.append((i < data[0].length - 1) ? "," : ")");
        }
        buf.append(" VALUES (");
        for (int i = 0; i < data[1].length; i++) {
            buf.append("?");
            buf.append((i < data[1].length - 1) ? "," : ")");
        }
        String sql = buf.toString();

        //SQL̎s
        for(int i= 1; i < data.length;i++) {
        	//JDBC_SQL^Aۂ̃f[^IuWFNg𐶐
        	Object[] realData = convertData(data[i],columnType);
        	jdbcTemplate.update(sql, realData,columnType);	
        }
        
    }

    /**
     * w肵e[ũf[^Sč폜B
     *
     * @param tableName e[u
     */
    protected void deleteAllData(String tableName) {
        // f[^x[X̃f[^Sč폜
        super.deleteFromTables(new String[]{tableName});
    }


    /**
     * w肵VPX̌ݒl擾B
     * <BR><BR>
     * ̃\bh𗘗pꍇAC^tF[XDBSequence̎NX̏<BR>
     * uDaoTestCase.xml vt@CɋLqĂKvB
     * <BR><BR>
     * <b>ӁFDB֐ڑɁAgetSequenceValueĂяoOɁAsetSequenceValue<br>
     * Ă΂ȂƁASQLExceptionB̓VPXIuWFNg̐ɂ̂łB</b>
     * 
     * @param sequenceName VPX
     * @return@VPX̌ݒl
     * 
     * @throws Exception@DBANZXɗOꍇ
     */
    protected int getSequenceValue(String sequenceName) throws Exception{
    	
        return dbSequence.getSequenceValue(sequenceName);
    }
    
    
    /**
     * w肵VPXɒlݒ肷B
     * <BR><BR>
     * ̃\bh𗘗pꍇAC^tF[XDBSequence̎NX̏<BR>
     * uDaoTestCase.xmlvt@CɋLqĂKvB
     * <BR><BR>
     * @param sequenceName@VPX
     * @param value@VPXɐݒ肷l
     * 
     * @throws Exception@DBANZXɗOꍇ
     */
    protected void setSequenceValue(String sequenceName,int value) throws Exception{
        
        dbSequence.setSequenceValue(sequenceName, value);	
    }
    
    /**
     * \bhBTuNXŒ`{@link #setUpData()}ĂяoB
     */
    @Override
    protected void onSetUpInTransaction() throws Exception {
        setUpData();
    }

    /**
     * I\bhBTuNXŒ`{@link #cleanUpData()}ĂяoB
     */
    @Override
    protected void onTearDownInTransaction() {
        try {
            cleanUpData();
        } catch (Exception e) {
            throw new RuntimeException(
                    "failure at onTearDownInTransaction()", e);
        }
    }

    /**
     * \bhBsvł΋邱ƁB
     * 
     * @throws Exception O
     */
    protected abstract void setUpData() throws Exception;

    /**
     * I\bhBsvł΋邱ƁB
     * 
     * @throws Exception IO
     */
    protected abstract void cleanUpData() throws Exception;

    /**
     * Bean`t@Cݒ肷B
     * TuNXŐݒ肳ꂽBean`t@CɉAJDBC̐ݒLq
     * DaoTestCase.xmlݒ肷B
     * 
     * @return Bean`t@C
     */
    @Override
    protected String[] getConfigLocations() {
        String[] subLocations = doGetConfigLocations();
        String[] locations = new String[subLocations.length + 1];
        locations[0] = "jp/terasoluna/utlib/spring/DaoTestCase.xml";
        for (int i = 0; i < subLocations.length; i++) {
            locations[i + 1] = subLocations[i];
        }
        return locations;
    }

    /**
     * Bean`t@Cݒ肷B
     * eXgɕKvBean`t@Cݒ肷BJDBC̐ݒ͕svłB
     * 
     * @return Bean`t@C
     */
    protected abstract String[] doGetConfigLocations();

    /**
     * JDBC_SQLAۂ̃f[^IuWFNg𐶐
     * @param inData ŕ\ꂽf[^̔z
     * @param sqlType@ef[^JDBC_SQL^̔z
     * @return@JDBC_SQL^ϊIuWFNg̔z
     */
    private Object[] convertData(String[] inData,int[] sqlType){
    	
    	Object[] outData = new Object[inData.length];
    	for(int i = 0; i < inData.length;i++){
    		outData[i] = convertData(inData[i],sqlType[i]);
    	}
    	
    	return outData;
    }
    
    /**
     * ŕ\ꂽf[^ۂ̃f[^^ɕϊB
     * 
     * @param inData ŕ\ꂽf[^
     * @param sqlType@f[^JDBC_SQL^
     * @return@JDBC_SQL^ϊIuWFNg
     */
    private Object convertData(String inData,int sqlType){
    	
    	//"null"nullƉ߂
    	if("null".equals(inData) || inData == null){
    		return null;
    	}
    	
    	switch(sqlType){
    	
    	case Types.TIME:
    	case Types.DATE:
    	case Types.TIMESTAMP:
        	//added by liu, 2008/02/05, 
        	//for DB2̑ΉAimb܂őΉł悤ɏC
        	try {
        		Timestamp timeStamp = Timestamp.valueOf(inData);
        		return timeStamp;
        	} catch (IllegalArgumentException e) {
        		//do nothing
        	}
        	
            Date date = null;
            date = parseDate("yyyy-MM-dd HH:mm:ss", inData);
            if (date == null) {
                date = parseDate("yyyy-MM-dd", inData);
            }
            if (date == null) {
                date = parseDate("HH:mm:ss", inData);
            }
            if (date == null) {
                String msg = "t܂͎ɒlϊł܂:" + inData;
                throw new IllegalArgumentException(msg);
            }
        	return new Timestamp(date.getTime());
        	
    	case Types.DECIMAL:
    	case Types.NUMERIC:
    		return new BigDecimal(inData);
    	case  Types.BIT:
    		return Boolean.valueOf(inData);
    	
    	case Types.TINYINT:
    		return Byte.valueOf(inData);
    		
    	case Types.SMALLINT:
    		return Short.valueOf(inData);
    		
    	case Types.INTEGER:
    		return Integer.valueOf(inData );

    	case Types.BIGINT:
    		return Long.valueOf(inData );

    	case Types.REAL:
    		return Float.valueOf(inData );

    	case Types.FLOAT:
    	case Types.DOUBLE:
    		return Double.valueOf(inData );
    		
    	default:
            //ȊOƂď    		
    		return inData;
    	
    	}

    }

    /**
     * tẼp[XB
     * 
     * @param format ϊtH[}bg
     * @param value ϊ
     * @return ϊꂽtBϊłȂꍇnullԂB
     */
    private java.util.Date parseDate(String format, String value) {
        java.util.Date date = null;
        try {
            SimpleDateFormat f = new SimpleDateFormat(format);
            date = f.parse(value);
        } catch (ParseException e) {
            // Ȃ
        }
        return date;
    }

    /**
     * w肵e[u̎w肵JJDBC_SQL^擾B
     * @param tableName@e[u
     * @param namesAssigned w肵J̔z
     * @return@w肵JJDBC_SQL^ō\ꂽz
     */
    private int[] getColumnSQLType(String tableName,String namesAssigned[]){
    	
    
        //_~[SQL̎sāAR[h̃[^f[^擾
        //String sql = "SELECT * FROM " + tableName;
        String sql = createDummySqlFromColumns(tableName, namesAssigned);
        SqlRowSet sqlRowSet = jdbcTemplate.queryForRowSet(sql);
        SqlRowSetMetaData sqlRowMetaData = sqlRowSet.getMetaData(); 
        
        //J̐ƃJ擾
        int columnNumber = sqlRowMetaData.getColumnCount();
        String[] columnNames = sqlRowMetaData.getColumnNames();
        
        //JƃJCfbNX̃}bv J͑啶ň
        Map<String,Integer> columnMap = new HashMap<String,Integer>();
        for(int i = 0; i < columnNumber; i++ ){
       	    columnMap.put(columnNames[i].toUpperCase(),i);
        }
        
        int[] columnType = new int[namesAssigned.length];
        
        for(int i = 0;i < namesAssigned.length;i++){
        	//w肵JYCfBNX擾@w肵J͑啶ň
        	Integer index = columnMap.get(namesAssigned[i].toUpperCase());
        	if(index == null){
                String msg =  "e[u" + tableName +"ɃJ'"  + 
                    namesAssigned[i] + "'݂͑܂B";
                throw new IllegalArgumentException(msg);

        	}
        	//YJJDBC_SQL^擾
        	columnType[i] = sqlRowMetaData.getColumnType(index.intValue() + 1);        	
        }
        
        return columnType;
    }
    
    /**
     * Jw肵_~[psql𐶐ĕԋpB
     * ̃J̔z null ͋̏ꍇ́A
     * J u*vw肷B
     * @param tableName e[u
     * @param columns J̔z
     * @return sql
     */
    private String createDummySqlFromColumns(
    		String tableName, String[] columns) {
    	
        StringBuilder sql = new StringBuilder("SELECT * FROM " + tableName);
        if (columns == null || columns.length <= 0) {
        	return sql.toString();
        }
    	
        StringBuilder columnPart = new StringBuilder();
        for (String column : columns) {
        	columnPart.append(column).append(",");
        }
        if (columnPart.length() > 0) {
            columnPart.delete(columnPart.length()-1, columnPart.length());
        }
        int idx = sql.indexOf("*");
        sql.replace(idx, idx + 1, columnPart.toString());
        return sql.toString();
    }


    /**
     * <p>DBVPX̒lݒƎ擾Bean擾B</p>
     *
     * @return dbSequence DBVPX̒lݒƎ擾Bean
     */
    public DBSequence getDbSequence() {
        return dbSequence;
    }


    /**
     * <p>DBVPX̒lݒƎ擾Beanݒ肷B</p>
     *
     * @param dbSequence DBVPX̒lݒƎ擾Bean
     */
    public void setDbSequence(DBSequence dbSequence) {
        this.dbSequence = dbSequence;
    }

}
