/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.service.thin;

import static org.junit.Assert.*;

import java.lang.annotation.Annotation;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

/**
 * 
 */
public class BLogicIOFieldBeanTest {

    /**
     * @throws java.lang.Exception
     */
    @Before
    public void setUp() throws Exception {
    }

    /**
     * @throws java.lang.Exception
     */
    @After
    public void tearDown() throws Exception {
    }

    /**
     * {@link jp.terasoluna.fw.service.thin.BLogicIOFieldBean#BLogicIOFieldBean()} ̂߂̃eXgE\bhB
     */
    @Test
    public void testBLogicIOFieldBean() {
        BLogicIOFieldBean bean = null;
        try {
            bean = new BLogicIOFieldBean();
        } catch (Exception e) {
            fail();
        }
    }

    /**
     * {@link jp.terasoluna.fw.service.thin.BLogicIOFieldBean#BLogicIOFieldBean(jp.terasoluna.fw.service.thin.BLogicIOField)}
     * ̂߂̃eXgE\bhB
     */
    @Test
    public void testBLogicIOFieldBeanBLogicIOField001() {
        BLogicIOFieldBean bean = null;
        BLogicIOField blogicIOField = null;

        try {
            bean = new BLogicIOFieldBean(blogicIOField);
        } catch (Exception e) {
            fail();
        }
    }

    /**
     * {@link jp.terasoluna.fw.service.thin.BLogicIOFieldBean#BLogicIOFieldBean(jp.terasoluna.fw.service.thin.BLogicIOField)}
     * ̂߂̃eXgE\bhB
     */
    @Test
    public void testBLogicIOFieldBeanBLogicIOField002() {
        BLogicIOFieldBean bean = null;
        BLogicIOField blogicIOField = new BLogicIOField() {

            public String property() {
                return null;
            }

            public BLogicIOTarget target() {
                return null;
            }

            public Class<? extends Annotation> annotationType() {
                return null;
            }
        };

        try {
            bean = new BLogicIOFieldBean(blogicIOField);
        } catch (Exception e) {
            fail();
        }
    }

    /**
     * {@link jp.terasoluna.fw.service.thin.BLogicIOFieldBean#BLogicIOFieldBean(jp.terasoluna.fw.service.thin.BLogicParamField)}
     * ̂߂̃eXgE\bhB
     */
    @Test
    public void testBLogicIOFieldBeanBLogicParamField001() {
        BLogicIOFieldBean bean = null;
        BLogicParamField blogicIOField = null;

        try {
            bean = new BLogicIOFieldBean(blogicIOField);
        } catch (Exception e) {
            fail();
        }
    }

    /**
     * {@link jp.terasoluna.fw.service.thin.BLogicIOFieldBean#BLogicIOFieldBean(jp.terasoluna.fw.service.thin.BLogicParamField)}
     * ̂߂̃eXgE\bhB
     */
    @Test
    public void testBLogicIOFieldBeanBLogicParamField002() {
        BLogicIOFieldBean bean = null;
        BLogicParamField blogicIOField = new BLogicParamField() {

            public String property() {
                return null;
            }

            public BLogicIOTarget target() {
                return null;
            }

            public Class<? extends Annotation> annotationType() {
                return null;
            }
        };

        try {
            bean = new BLogicIOFieldBean(blogicIOField);
        } catch (Exception e) {
            fail();
        }
    }

    /**
     * {@link jp.terasoluna.fw.service.thin.BLogicIOFieldBean#BLogicIOFieldBean(jp.terasoluna.fw.service.thin.BLogicResultField)}
     * ̂߂̃eXgE\bhB
     */
    @Test
    public void testBLogicIOFieldBeanBLogicResultField001() {
        BLogicIOFieldBean bean = null;
        BLogicResultField blogicIOField = null;

        try {
            bean = new BLogicIOFieldBean(blogicIOField);
        } catch (Exception e) {
            fail();
        }
    }

    /**
     * {@link jp.terasoluna.fw.service.thin.BLogicIOFieldBean#BLogicIOFieldBean(jp.terasoluna.fw.service.thin.BLogicResultField)}
     * ̂߂̃eXgE\bhB
     */
    @Test
    public void testBLogicIOFieldBeanBLogicResultField002() {
        BLogicIOFieldBean bean = null;
        BLogicResultField blogicIOField = new BLogicResultField() {

            public String property() {
                return null;
            }

            public BLogicIOTarget target() {
                return null;
            }

            public Class<? extends Annotation> annotationType() {
                return null;
            }
        };

        try {
            bean = new BLogicIOFieldBean(blogicIOField);
        } catch (Exception e) {
            fail();
        }
    }

    /**
     * {@link jp.terasoluna.fw.service.thin.BLogicIOFieldBean#getTarget()} ̂߂̃eXgE\bhB
     */
    @Test
    public void testGetTarget001() {
        BLogicIOFieldBean bean = null;
        final BLogicIOTarget blogicIOTarget = BLogicIOTarget.APPLICATION;
        BLogicIOField blogicIOField = new BLogicIOField() {

            public String property() {
                return null;
            }

            public BLogicIOTarget target() {
                return blogicIOTarget;
            }

            public Class<? extends Annotation> annotationType() {
                return null;
            }
        };

        try {
            bean = new BLogicIOFieldBean(blogicIOField);
        } catch (Exception e) {
            fail();
        }

        BLogicIOTarget target = bean.getTarget();

        assertNotNull(target);
        assertEquals(blogicIOTarget, target);
    }

    /**
     * {@link jp.terasoluna.fw.service.thin.BLogicIOFieldBean#setTarget(jp.terasoluna.fw.service.thin.BLogicIOTarget)}
     * ̂߂̃eXgE\bhB
     */
    @Test
    public void testSetTarget001() {
        BLogicIOFieldBean bean = null;
        final BLogicIOTarget blogicIOTarget = BLogicIOTarget.APPLICATION;
        BLogicIOField blogicIOField = null;

        try {
            bean = new BLogicIOFieldBean(blogicIOField);
        } catch (Exception e) {
            fail();
        }

        bean.setTarget(blogicIOTarget);

        BLogicIOTarget target = bean.getTarget();
        assertNotNull(target);
        assertEquals(blogicIOTarget, target);
    }

    /**
     * {@link jp.terasoluna.fw.service.thin.BLogicIOFieldBean#getProperty()} ̂߂̃eXgE\bhB
     */
    @Test
    public void testGetProperty001() {
        BLogicIOFieldBean bean = null;
        final String prop = "prop";
        BLogicIOField blogicIOField = new BLogicIOField() {

            public String property() {
                return prop;
            }

            public BLogicIOTarget target() {
                return null;
            }

            public Class<? extends Annotation> annotationType() {
                return null;
            }
        };

        try {
            bean = new BLogicIOFieldBean(blogicIOField);
        } catch (Exception e) {
            fail();
        }

        String property = bean.getProperty();

        assertNotNull(property);
        assertEquals(prop, property);
    }

    /**
     * {@link jp.terasoluna.fw.service.thin.BLogicIOFieldBean#setProperty(java.lang.String)} ̂߂̃eXgE\bhB
     */
    @Test
    public void testSetProperty001() {
        BLogicIOFieldBean bean = null;
        final String prop = "prop";
        BLogicIOField blogicIOField = null;

        try {
            bean = new BLogicIOFieldBean(blogicIOField);
        } catch (Exception e) {
            fail();
        }

        bean.setProperty(prop);

        String property = bean.getProperty();
        assertNotNull(property);
        assertEquals(prop, property);
    }

}
