/*
 * Copyright (c) 2012 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.ex.aop.log;

import static org.junit.Assert.*;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import org.junit.Test;

/**
 * BLogicNXsÕfobOOo͂邽߂
 * C^Zv^̃eXgP[XNX
 * @version 1.0.0
 */
public class BLogicLogInterceptorTest {

    /**
     * testCheckException01()<br>
     * OXgɂȂOꍇA\bhsʂ
     * trueƂȂ邱ƂmF<br>
     * <p>
     * Xg̗OFRuntimeException<br>
     * ̗OFSQLException<br>
     * </p>
     * @throws Exception eXgtry-catchȂ߂ɋLq
     */
    @Test
    public void testCheckException01() throws Exception{
        
        //OXg̃CX^X
        List<Class> exceptionList = new ArrayList<Class>();

        //eXgp̗Oݒ
        exceptionList.add(RuntimeException.class);

        //eXgΏۃNXCX^X
        BLogicLogInterceptor target = new BLogicLogInterceptor();

        //eXgΏۃNXs
        target.setNoErrorLogExceptionLists(exceptionList);
        boolean result = target.checkException(new SQLException());

        //eXgʂ̌
        assertEquals(true, result);
    }
    
    /**
     * testCheckException02()<br>
     * OXgɂOꍇA\bhsʂ
     * falseƂȂ邱ƂmF<br>
     * <p>
     * Xg̗OFSQLException<br>
     * ̗OFSQLException<br>
     * </p>
     * 
     * @throws Exception eXgtry-catchȂ߂ɋLq
     */
    @Test
    public void testCheckException02() throws Exception{

        //OXg̃CX^X
        List<Class> exceptionList = new ArrayList<Class>();

        //eXgp̗Oݒ
        exceptionList.add(SQLException.class);

        //eXgΏۃNXCX^X
        BLogicLogInterceptor target = new BLogicLogInterceptor();

        //eXgΏۃNXs
        target.setNoErrorLogExceptionLists(exceptionList);
        boolean result = target.checkException(new SQLException());

        //eXgʂ̌
        assertEquals(false, result);
    }

    /**
     * testCheckException03()<br>
     * OXgɂÕTuNXꍇA
     * \bhsʂfalseƂȂ邱ƂmF<br>
     * <p>
     * Xg̗OFException<br>
     * ̗OFSQLException<br>
     * </p>
     * 
     * @throws Exception eXgtry-catchȂ߂ɋLq
     */
    @Test
    public void testCheckException03() throws Exception{

        //OXg̃CX^X
        List<Class> exceptionList = new ArrayList<Class>();

        //eXgp̗Oݒ
        exceptionList.add(Exception.class);

        //eXgΏۃNXCX^X
        BLogicLogInterceptor target = new BLogicLogInterceptor();

        //eXgΏۃNXs
        target.setNoErrorLogExceptionLists(exceptionList);
        boolean result = target.checkException(new SQLException());

        //eXgʂ̌
        assertEquals(false, result);
    }

    /**
     * testCheckException04()<br>
     * OXgɂÕTuNXꍇA
     * \bhsʂfalseƂȂ邱ƂmF<br>
     * <p>
     * Xg̗OFException<br>
     * ̗OFRuntimeException<br>
     * </p>
     * 
     * @throws Exception eXgtry-catchȂ߂ɋLq
     */
    @Test
    public void testCheckException04() throws Exception{

        //OXg̃CX^X
        List<Class> exceptionList = new ArrayList<Class>();

        //eXgp̗Oݒ
        exceptionList.add(Exception.class);

        //eXgΏۃNXCX^X
        BLogicLogInterceptor target = new BLogicLogInterceptor();

        //eXgΏۃNXs
        target.setNoErrorLogExceptionLists(exceptionList);
        boolean result = target.checkException(new RuntimeException());

        //eXgʂ̌
        assertEquals(false, result);
    }
    
    /**
     * testCheckException05()<br>
     * OXgijɂȂOꍇA
     * \bhsʂtrueƂȂ邱ƂmF<br>
     * <p>
     * Xg̗OFSQLException, RuntimeException<br>
     * ̗OFException<br>
     * </p>
     * 
     * @throws Exception eXgtry-catchȂ߂ɋLq
     */
    @Test
    public void testCheckException05() throws Exception{

        //OXg̃CX^X
        List<Class> exceptionList = new ArrayList<Class>();

        //eXgp̗Oݒ
        exceptionList.add(SQLException.class);
        exceptionList.add(RuntimeException.class);

        //eXgΏۃNXCX^X
        BLogicLogInterceptor target = new BLogicLogInterceptor();

        //eXgΏۃNXs
        target.setNoErrorLogExceptionLists(exceptionList);
        boolean result = target.checkException(new Exception());

        //eXgʂ̌
        assertEquals(true, result);
    }    
    
    /**
     * testCheckException06()<br>
     * OXgijɂOꍇA
     * \bhsʂfalseƂȂ邱ƂmF<br>
     * <p>
     * Xg̗OFSQLException, RuntimeException<br>
     * ̗OFRuntimeException<br>
     * </p>
     * 
     * @throws Exception eXgtry-catchȂ߂ɋLq
     */
    @Test
    public void testCheckException06() throws Exception{

        //OXg̃CX^X
        List<Class> exceptionList = new ArrayList<Class>();

        //eXgp̗Oݒ
        exceptionList.add(SQLException.class);
        exceptionList.add(RuntimeException.class);

        //eXgΏۃNXCX^X
        BLogicLogInterceptor target = new BLogicLogInterceptor();

        //eXgΏۃNXs
        target.setNoErrorLogExceptionLists(exceptionList);
        boolean result = target.checkException(new RuntimeException());

        //eXgʂ̌
        assertEquals(false, result);
    }        

    /**
     * testCheckException07()<br>
     * OXgijɂÕTuNXꍇA
     * \bhsʂfalseƂȂ邱ƂmF<br>
     * <p>
     * Xg̗OFSQLException, RuntimeException<br>
     * ̗OFArithmeticException<br>
     * </p>
     * 
     * @throws Exception eXgtry-catchȂ߂ɋLq
     */
    @Test
    public void testCheckException07() throws Exception{

        //OXg̃CX^X
        List<Class> exceptionList = new ArrayList<Class>();

        //eXgp̗Oݒ
        exceptionList.add(SQLException.class);
        exceptionList.add(RuntimeException.class);

        //eXgΏۃNXCX^X
        BLogicLogInterceptor target = new BLogicLogInterceptor();

        //eXgΏۃNXs
        target.setNoErrorLogExceptionLists(exceptionList);
        boolean result = target.checkException(new ArithmeticException());

        //eXgʂ̌
        assertEquals(false, result);
    }        
    

    /**
     * testCheckException08()<br>
     * OXgɉݒ肳ꂸAOꍇA
     * \bhsʂtrueƂȂ邱ƂmF<br>
     * <p>
     * Xg̗OF<br>
     * ̗OFRuntimeException<br>
     * </p>
     * 
     * @throws Exception eXgtry-catchȂ߂ɋLq
     */
    @Test
    public void testCheckException08() throws Exception{

        //OXg̃CX^X
        List<Class> exceptionList = new ArrayList<Class>();

        //eXgΏۃNXCX^X
        BLogicLogInterceptor target = new BLogicLogInterceptor();

        //eXgΏۃNXs
        target.setNoErrorLogExceptionLists(exceptionList);
        boolean result = target.checkException(new RuntimeException());

        //eXgʂ̌
        assertEquals(true, result);
    }        

    /**
     * testCheckException09()<br>
     * OXglnullłAOꍇA
     * \bhsʂtrueƂȂ邱ƂmF<br>
     * <p>
     * Xg̗OFnull<br>
     * ̗OFRuntimeException<br>
     * </p>
     * 
     * @throws Exception eXgtry-catchȂ߂ɋLq
     */
    @Test
    public void testCheckException09() throws Exception{

        //OXg̃CX^X
        List<Class> exceptionList = null;

        //eXgΏۃNXCX^X
        BLogicLogInterceptor target = new BLogicLogInterceptor();

        //eXgΏۃNXs
        target.setNoErrorLogExceptionLists(exceptionList);
        boolean result = target.checkException(new RuntimeException());

        //eXgʂ̌
        assertEquals(true, result);
    }        

    
}
