/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.terasoluna.fw.ex.unit.mock.file;

import java.util.ArrayList;
import java.util.List;

import jp.terasoluna.fw.ex.unit.mock.AbstractMockDao;
import jp.terasoluna.fw.file.dao.FileLineIterator;

/**
 * {@link FileLineIterator}̃bNNXłB
 * 
 * <p>
 * {@link FileLineIterator#next()}̕Ԃl
 * {@link MockFileLineIterator#addResult(Object)}1ݒ肵܂B<br>
 * <code>addResult</code>̈{@link RuntimeException}pNXݒ肵ꍇA
 * {@link FileLineIterator#next()}sɂX[܂B <br>
 * ܂A{@link FileLineIterator#getHeader()}A{@link FileLineIterator#getTrailer()}
 * ̌ʂꂼ{@link MockFileLineIterator#setHeaderLine(List)}A
 * {@link MockFileLineIterator#setTrailerLine(List)}ɂĐݒł܂B
 * </p>
 * @param <T> sIuWFNgNX
 */
public class MockFileLineIterator<T> extends AbstractMockDao implements
        FileLineIterator<T> {

    /**
     * wb_[
     */
    private List<String> headerLine = new ArrayList<String>();

    /**
     * g[
     */
    private List<String> trailerLine = new ArrayList<String>();

    /**
     * <p>
     * FileLineIterator#getHeader() ̃bN\bhB
     * </p>
     * headerLine ԋp܂B
     * 
     * @param headerLine wb_
     */
    public List<String> getHeader() {
        return this.headerLine;
    }

    /**
     * <p>
     * FileLineIterator#getTrailer() ̃bN\bhB
     * </p>
     * trailerLine ԋp܂B
     * 
     * @param trailerLine wb_
     */
    public List<String> getTrailer() {
        return this.trailerLine;
    }

    /**
     * <p>
     * FileLineIterator#hasNext() ̃bN\bhB
     * </p>
     * ̃f[^IuWFNgf[^擾ł邩𔻒f܂B
     * 
     * @param 擾łꍇtrue A擾łȂꍇfalseB
     */
    public boolean hasNext() {
        return (results.peek() != null);
    }

    /**
     * <p>
     * FileLineIterator#next() ̃bN\bhB
     * </p>
     * ̃f[^IuWFNgf[^擾ĕԋp܂B
     * 
     * @param 擾łꍇtrue A擾łȂꍇfalseB
     */
    @SuppressWarnings("unchecked")
    public T next() {
        return (T) poll();
    }

    /**
     * <p>
     * FileLineIterator#skip() ̃bN\bhB
     * </p>
     * 
     * @param ǂݔ΂s
     */
    public void skip(int skipLines) {
        for (int i = 0; i < skipLines; i++) {
            remove();
        }
    }

    /**
     * <p>
     * FileLineIterator#closeFile() ̃bN\bhB
     * </p>
     * wb_Ag[Af[^NA܂B
     * 
     */
    public void closeFile() {
        super.clear();
        this.headerLine.clear();
        this.trailerLine.clear();
    }

    /**
     * <p>
     * FileLineIterator#remove() ̃bN\bhB
     * </p>
     * ݂̃J[\ʒuf[^IuWFNg폜܂B
     * 
     * @see java.util.Iterator#remove()
     * 
     */
    public void remove() {
        if (results.isEmpty()) {
            throw new IllegalStateException(
                    "remove() has been called after the last call to the next()");
        }
        poll();
    }

    /**
     * wb_ݒ肵܂B
     * 
     * @param header wb_
     */
    public void setHeaderLine(List<String> header) {
        this.headerLine.addAll(header);
    }

    /**
     * g[ݒ肵܂B
     * 
     * @param trailer g[
     */
    public void setTrailerLine(List<String> trailer) {
        this.trailerLine.addAll(trailer);
    }
}
