/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.util.common;

import com.mockrunner.base.NestedApplicationException;
import com.mockrunner.util.common.StringUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;

public class MethodUtil {
    public static Object invoke(Object object, String string) {
        try {
            Method method = object.getClass().getMethod(string, null);
            return method.invoke(object, null);
        }
        catch (Exception exception) {
            throw new NestedApplicationException(exception);
        }
    }

    public static Object invoke(Object object, String string, Object object2) {
        try {
            Method method = object.getClass().getMethod(string, object2.getClass());
            return method.invoke(object, object2);
        }
        catch (Exception exception) {
            throw new NestedApplicationException(exception);
        }
    }

    public static boolean areMethodsEqual(Method method, Method method2) {
        if (method.equals(method2)) {
            return true;
        }
        if (!method2.getName().equals(method.getName())) {
            return false;
        }
        if (!method.getReturnType().equals(method2.getReturnType())) {
            return false;
        }
        return Arrays.equals(method.getParameterTypes(), method2.getParameterTypes());
    }

    public static Method[] getMatchingDeclaredMethods(Class clazz, String string) {
        Method[] methodArray = clazz.getDeclaredMethods();
        ArrayList<Method> arrayList = new ArrayList<Method>();
        for (int i = 0; i < methodArray.length; ++i) {
            if (!StringUtil.matchesPerl5(methodArray[i].getName(), string, true)) continue;
            arrayList.add(methodArray[i]);
        }
        return arrayList.toArray(new Method[arrayList.size()]);
    }
}

